/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.test.system;

import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.Configuration;
import net.runeduniverse.lib.rogm.lang.Language;
import net.runeduniverse.lib.rogm.modules.Module;
import net.runeduniverse.lib.rogm.parser.Parser;
import net.runeduniverse.lib.rogm.querying.IFNode;
import net.runeduniverse.lib.rogm.querying.IFRelation;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;
import net.runeduniverse.lib.rogm.test.AQueryBuilderTest;
import net.runeduniverse.lib.rogm.test.ConsoleLogger;
import net.runeduniverse.lib.rogm.test.dummies.DummyLanguage;
import net.runeduniverse.lib.rogm.test.dummies.DummyModule;
import net.runeduniverse.lib.rogm.test.dummies.DummyParser;
import net.runeduniverse.lib.rogm.test.model.Company;
import net.runeduniverse.lib.rogm.test.model.Inventory;
import net.runeduniverse.lib.rogm.test.model.Item;
import net.runeduniverse.lib.rogm.test.model.relations.Slot;
import net.runeduniverse.lib.rogm.test.system.TestEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public class QueryBuilderTest
extends AQueryBuilderTest {
    public QueryBuilderTest() {
        super(new Configuration((Parser)new DummyParser(), (Language)new DummyLanguage(), (Module)new DummyModule(), "localhost"), new ConsoleLogger(Logger.getLogger(QueryBuilderTest.class.getName())));
    }

    @Test
    @Tag(value="system")
    public void test() {
        this.qryBuilder.node().where(Company.class);
    }

    @Test
    @Tag(value="system")
    public void nodeToNode() {
        AQueryBuilderTest.DebugRelationQueryBuilder slotRelQryBuilder = (AQueryBuilderTest.DebugRelationQueryBuilder)((QueryBuilder.RelationQueryBuilder)this.qryBuilder.relation().where(Slot.class)).whereParam("slot", (Object)0);
        AQueryBuilderTest.DebugNodeQueryBuilder itemNodeQryBuilder = (AQueryBuilderTest.DebugNodeQueryBuilder)this.qryBuilder.node().where(Item.class);
        AQueryBuilderTest.DebugNodeQueryBuilder inventoryNodeQryBuilder = (AQueryBuilderTest.DebugNodeQueryBuilder)((QueryBuilder.NodeQueryBuilder)this.qryBuilder.node().where(Inventory.class)).addRelationTo((QueryBuilder.RelationQueryBuilder)slotRelQryBuilder, (QueryBuilder.NodeQueryBuilder)itemNodeQryBuilder).asRead();
        TestEntity.infoTesting(this.logger, (Object)inventoryNodeQryBuilder);
        Assertions.assertFalse((boolean)inventoryNodeQryBuilder.getRelationBuilders().isEmpty(), (String)"NodeQueryBuilder: Inventory.relations is empty");
        Assertions.assertFalse((boolean)itemNodeQryBuilder.getRelationBuilders().isEmpty(), (String)"NodeQueryBuilder: Item.relations is empty");
        Assertions.assertTrue((boolean)inventoryNodeQryBuilder.getRelationBuilders().contains((Object)slotRelQryBuilder), (String)"NodeQueryBuilder: Inventory.relations is missing ref to Slot");
        Assertions.assertTrue((boolean)itemNodeQryBuilder.getRelationBuilders().contains((Object)slotRelQryBuilder), (String)"NodeQueryBuilder: Item.relations is missing ref to Slot");
        Assertions.assertNotNull((Object)slotRelQryBuilder.getStart(), (String)"NodeQueryBuilder: Slot.start == null");
        Assertions.assertTrue((inventoryNodeQryBuilder == slotRelQryBuilder.getStart() ? 1 : 0) != 0, (String)"NodeQueryBuilder: Slot.start != inventory");
        Assertions.assertNotNull((Object)slotRelQryBuilder.getTarget(), (String)"NodeQueryBuilder: Slot.target == null");
        Assertions.assertTrue((itemNodeQryBuilder == slotRelQryBuilder.getTarget() ? 1 : 0) != 0, (String)"NodeQueryBuilder: Slot.target != item");
        IFNode inventory = (IFNode)inventoryNodeQryBuilder.getResult();
        IFRelation slot = (IFRelation)slotRelQryBuilder.getResult();
        IFNode item = (IFNode)itemNodeQryBuilder.getResult();
        Assertions.assertNotNull((Object)inventory, (String)"Inventory is null");
        Assertions.assertNotNull((Object)slot, (String)"Slot is null");
        Assertions.assertNotNull((Object)item, (String)"Item is null");
        Assertions.assertFalse((boolean)inventory.getRelations().isEmpty(), (String)"Inventory.relations is empty");
        Assertions.assertFalse((boolean)item.getRelations().isEmpty(), (String)"Item.relations is empty");
        Assertions.assertTrue((boolean)inventory.getRelations().contains(slot), (String)"Inventory.relations is missing ref to Slot");
        Assertions.assertTrue((boolean)item.getRelations().contains(slot), (String)"Item.relations is missing ref to Slot");
        Assertions.assertNotNull((Object)slot.getStart(), (String)"Slot.start == null");
        Assertions.assertTrue((inventory == slot.getStart() ? 1 : 0) != 0, (String)"Slot.start != inventory");
        Assertions.assertNotNull((Object)slot.getTarget(), (String)"Slot.target == null");
        Assertions.assertTrue((item == slot.getTarget() ? 1 : 0) != 0, (String)"Slot.target != item");
    }
}

