/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.test.system;

import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.Configuration;
import net.runeduniverse.lib.rogm.Session;
import net.runeduniverse.lib.rogm.lang.Language;
import net.runeduniverse.lib.rogm.modules.Module;
import net.runeduniverse.lib.rogm.parser.Parser;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.pipeline.APipelineFactory;
import net.runeduniverse.lib.rogm.pipeline.DatabasePipelineFactory;
import net.runeduniverse.lib.rogm.pipeline.Pipeline;
import net.runeduniverse.lib.rogm.test.dummies.DummyLanguage;
import net.runeduniverse.lib.rogm.test.dummies.DummyModule;
import net.runeduniverse.lib.rogm.test.dummies.DummyParser;
import net.runeduniverse.lib.utils.logging.DebugLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public class PipelineTest {
    public static final String MODEL_PKG_PATH = "net.runeduniverse.lib.rogm.test.model";
    public static final String RELATIONS_PKG_PATH = "net.runeduniverse.lib.rogm.test.model.relations";
    protected final Configuration cnf = new Configuration((Parser)new DummyParser(), (Language)new DummyLanguage(), (Module)new DummyModule(), null).addClassLoader(this.getClass().getClassLoader());
    protected final DatabasePipelineFactory databasePipelineFactory;

    public PipelineTest() {
        this.cnf.setLogger((Logger)new DebugLogger(Logger.getLogger(PipelineTest.class.getName())));
        this.cnf.addPackage(MODEL_PKG_PATH);
        this.cnf.addPackage(RELATIONS_PKG_PATH);
        this.databasePipelineFactory = new DatabasePipelineFactory(this.cnf);
    }

    @Test
    @Tag(value="system")
    public void setupDatabasePipeline() throws Exception {
        Pipeline pipeline = new Pipeline((APipelineFactory)this.databasePipelineFactory);
        Session session = pipeline.buildSession();
        Assertions.assertNotNull((Object)session, (String)"Database Session wasn't built!");
    }

    static {
        Archive.PACKAGE_SCANNER_DEBUG_MODE = true;
    }
}

