/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.test.system;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.runeduniverse.lib.rogm.pattern.APattern;
import net.runeduniverse.lib.rogm.pattern.FieldPattern;
import net.runeduniverse.lib.rogm.pattern.IBaseQueryPattern;
import net.runeduniverse.lib.rogm.test.AArchiveTest;
import net.runeduniverse.lib.rogm.test.model.Artist;
import net.runeduniverse.lib.rogm.test.model.Game;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public class PatternTest
extends AArchiveTest {
    public static Class<APattern> UNLOCKED_APATTERN_CLASS = APattern.class;
    public static Field UNLOCKED_APATTERN_ID_FIELD;
    public static final String APATTERN_ID_FIELD_NAME = "idFieldPattern";

    @BeforeAll
    @Tag(value="system")
    public static void prepare() throws Exception {
        for (Class<APattern> clazz = UNLOCKED_APATTERN_CLASS; clazz != Object.class; clazz = clazz.getSuperclass()) {
            PatternTest.unlockClass(clazz);
        }
        Assertions.assertNotNull((Object)UNLOCKED_APATTERN_ID_FIELD, (String)"Field of name: \"idFieldPattern\" could not be collected from Class<APattern>");
        Assertions.assertTrue((boolean)FieldPattern.class.isAssignableFrom(UNLOCKED_APATTERN_ID_FIELD.getType()), (String)"collected Field of name: \"idFieldPattern\" is not of Class<FieldPattern>");
    }

    private static void unlockClass(Class<?> clazz) throws Exception {
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(APATTERN_ID_FIELD_NAME)) continue;
            UNLOCKED_APATTERN_ID_FIELD = field;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            ((Method)accessibleObject).setAccessible(true);
        }
    }

    @Test
    @Tag(value="system")
    public void existenceCheckArtist() throws Exception {
        IBaseQueryPattern pattern = (IBaseQueryPattern)this.archive.getPattern(Artist.class, IBaseQueryPattern.class);
        if (pattern instanceof APattern) {
            Assertions.assertTrue((boolean)((APattern)pattern).isValid(), (String)("Object of Class<" + pattern.getClass().getSimpleName() + "> NEVER got validated!"));
            FieldPattern fieldPattern = (FieldPattern)UNLOCKED_APATTERN_ID_FIELD.get(pattern);
            Assertions.assertNotNull((Object)fieldPattern, (String)("Field APattern<?>.idFieldPattern is NULL in Object of Class<" + pattern.getClass().getSimpleName() + ">"));
        }
    }

    @Test
    @Tag(value="system")
    public void existenceCheckGame() throws Exception {
        IBaseQueryPattern pattern = (IBaseQueryPattern)this.archive.getPattern(Game.class, IBaseQueryPattern.class);
        if (pattern instanceof APattern) {
            Assertions.assertTrue((boolean)((APattern)pattern).isValid(), (String)("Object of Class<" + pattern.getClass().getSimpleName() + "> NEVER got validated!"));
            FieldPattern fieldPattern = (FieldPattern)UNLOCKED_APATTERN_ID_FIELD.get(pattern);
            Assertions.assertNotNull((Object)fieldPattern, (String)("Field APattern<?>.idFieldPattern is NULL in Object of Class<" + pattern.getClass().getSimpleName() + ">"));
        }
    }
}

