/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.test.model;

import java.util.UUID;
import net.runeduniverse.lib.rogm.annotations.Converter;
import net.runeduniverse.lib.rogm.annotations.Direction;
import net.runeduniverse.lib.rogm.annotations.IConverter;
import net.runeduniverse.lib.rogm.annotations.Id;
import net.runeduniverse.lib.rogm.annotations.NodeEntity;
import net.runeduniverse.lib.rogm.annotations.PostDelete;
import net.runeduniverse.lib.rogm.annotations.PostLoad;
import net.runeduniverse.lib.rogm.annotations.PostSave;
import net.runeduniverse.lib.rogm.annotations.PreDelete;
import net.runeduniverse.lib.rogm.annotations.PreSave;
import net.runeduniverse.lib.rogm.annotations.Relationship;
import net.runeduniverse.lib.rogm.test.model.Inventory;

@NodeEntity
public class Player {
    @Id
    @Converter(converter=IConverter.UUIDConverter.class)
    private UUID uuid;
    private String name;
    @Relationship(label="PLAYER_INV", direction=Direction.OUTGOING)
    private Inventory inventory;

    @PreSave
    private void preSave() {
        System.out.println("[PRE-SAVE] " + this.toString());
    }

    @PostSave
    private void postSave() {
        System.out.println("[POST-SAVE] " + this.toString());
    }

    @PostLoad
    private void postLoad() {
        System.out.println("[POST-LOAD] " + this.toString());
    }

    @PreDelete
    public void preDelete() {
        System.out.println("[PRE-DELETE] " + this.toString());
    }

    @PostDelete
    public void postDelete() {
        System.out.println("[POST-DELETE] " + this.toString());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Player() {
    }

    public Player(UUID uuid, String name, Inventory inventory) {
        this.uuid = uuid;
        this.name = name;
        this.inventory = inventory;
    }

    public String toString() {
        return "Player(uuid=" + this.getUuid() + ", name=" + this.getName() + ", inventory=" + this.getInventory() + ")";
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }
}

