/*
 * Decompiled with CFR 0.152.
 */
package net.runeduniverse.lib.rogm.test;

import java.util.logging.Logger;
import net.runeduniverse.lib.rogm.Configuration;
import net.runeduniverse.lib.rogm.errors.ScannerException;
import net.runeduniverse.lib.rogm.lang.Language;
import net.runeduniverse.lib.rogm.modules.IdTypeResolver;
import net.runeduniverse.lib.rogm.modules.Module;
import net.runeduniverse.lib.rogm.modules.PassiveModule;
import net.runeduniverse.lib.rogm.parser.Parser;
import net.runeduniverse.lib.rogm.pattern.Archive;
import net.runeduniverse.lib.rogm.querying.IFilter;
import net.runeduniverse.lib.rogm.querying.QueryBuilder;
import net.runeduniverse.lib.rogm.test.AConfigTest;
import net.runeduniverse.lib.rogm.test.ConsoleLogger;
import net.runeduniverse.lib.rogm.test.dummies.DummyLanguage;
import net.runeduniverse.lib.rogm.test.dummies.DummyModule;
import net.runeduniverse.lib.rogm.test.dummies.DummyParser;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;

public abstract class AArchiveTest
extends AConfigTest {
    protected final Archive archive;
    protected final QueryBuilder qryBuilder;

    public AArchiveTest(Configuration cnf) {
        super(cnf);
        this.archive = new Archive(this.cnf.getPackageInfo(), (IdTypeResolver)this.cnf.getModule());
        this.qryBuilder = this.archive.getQueryBuilder();
    }

    public AArchiveTest(Configuration cnf, Logger logger) {
        this(cnf.setLogger(logger).addClassLoader(AArchiveTest.class.getClassLoader()).addPackage("net.runeduniverse.lib.rogm.test.model").addPackage("net.runeduniverse.lib.rogm.test.model.relations"));
    }

    public AArchiveTest() {
        this(new Configuration((Parser)new DummyParser(), (Language)new DummyLanguage(), (Module)new DummyModule(), "localhost"), new ConsoleLogger(Logger.getLogger(AArchiveTest.class.getName())));
    }

    @BeforeEach
    @Tag(value="system")
    public void scanModels() throws ScannerException {
        for (PassiveModule module : this.cnf.getPassiveModules()) {
            module.configure(this.archive);
        }
    }

    protected String printQuery(Class<?> clazz, IFilter filter) throws Exception {
        this.archive.logPatterns(this.logger);
        return "[QUERY][" + clazz.getSimpleName() + "]\n" + this.iLanguage.load(filter) + '\n';
    }

    protected String printSave(Object entity, int depth) throws Exception {
        this.archive.logPatterns(this.logger);
        return "[SAVE][" + entity.getClass().getSimpleName() + "]\n" + this.iLanguage.save(this.archive.save(entity.getClass(), entity, Integer.valueOf(depth)).getDataContainer(), null).qry() + '\n';
    }
}

