/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.message.codec.incoming;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ClientProt;
import net.rsprot.protocol.ProtRepository;
import net.rsprot.protocol.message.IncomingMessage;
import net.rsprot.protocol.message.codec.MessageDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003BS\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\b0\u0007\u0012(\u0010\t\u001a$\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\f0\b0\u000b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0014\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\f0\b0\u000bJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011R0\u0010\t\u001a$\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\f0\b0\u000b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/rsprot/protocol/message/codec/incoming/MessageDecoderRepository;", "P", "Lnet/rsprot/protocol/ClientProt;", "", "protRepository", "Lnet/rsprot/protocol/ProtRepository;", "decoders", "", "Lnet/rsprot/protocol/message/codec/MessageDecoder;", "decoderToMessageClassMap", "", "Ljava/lang/Class;", "Lnet/rsprot/protocol/message/IncomingMessage;", "(Lnet/rsprot/protocol/ProtRepository;[Lnet/rsprot/protocol/message/codec/MessageDecoder;Ljava/util/Map;)V", "[Lnet/rsprot/protocol/message/codec/MessageDecoder;", "getDecoder", "opcode", "", "getDecoderOrNull", "getMessageClass", "decoderClazz", "getSize", "protocol"})
public final class MessageDecoderRepository<P extends ClientProt> {
    @NotNull
    private final ProtRepository<P> protRepository;
    @NotNull
    private final MessageDecoder<?>[] decoders;
    @NotNull
    private final Map<Class<? extends MessageDecoder<IncomingMessage>>, Class<? extends IncomingMessage>> decoderToMessageClassMap;

    public MessageDecoderRepository(@NotNull ProtRepository<P> protRepository, @NotNull MessageDecoder<?>[] decoders, @NotNull Map<Class<? extends MessageDecoder<IncomingMessage>>, ? extends Class<? extends IncomingMessage>> decoderToMessageClassMap) {
        Intrinsics.checkNotNullParameter(protRepository, (String)"protRepository");
        Intrinsics.checkNotNullParameter(decoders, (String)"decoders");
        Intrinsics.checkNotNullParameter(decoderToMessageClassMap, (String)"decoderToMessageClassMap");
        this.protRepository = protRepository;
        this.decoders = decoders;
        this.decoderToMessageClassMap = decoderToMessageClassMap;
    }

    @NotNull
    public final MessageDecoder<?> getDecoder(int opcode) {
        MessageDecoder<?> messageDecoder = this.decoders[opcode];
        if (messageDecoder == null) {
            throw new IllegalArgumentException("Opcode " + opcode + " is not registered.");
        }
        return messageDecoder;
    }

    @Nullable
    public final MessageDecoder<?> getDecoderOrNull(int opcode) {
        return this.decoders[opcode];
    }

    @NotNull
    public final Class<? extends IncomingMessage> getMessageClass(@NotNull Class<? extends MessageDecoder<? extends IncomingMessage>> decoderClazz) {
        Intrinsics.checkNotNullParameter(decoderClazz, (String)"decoderClazz");
        Class<? extends IncomingMessage> clazz = this.decoderToMessageClassMap.get(decoderClazz);
        if (clazz == null) {
            boolean bl = false;
            String string = "Message class does not exist for " + decoderClazz;
            throw new IllegalArgumentException(string.toString());
        }
        return clazz;
    }

    public final int getSize(int opcode) {
        return this.protRepository.getSize(opcode);
    }
}

