/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.metrics.impl;

import java.net.InetAddress;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.rsprot.protocol.metrics.NetworkTrafficMonitor;
import net.rsprot.protocol.metrics.channel.impl.GameChannelTrafficMonitor;
import net.rsprot.protocol.metrics.channel.impl.Js5ChannelTrafficMonitor;
import net.rsprot.protocol.metrics.channel.impl.LoginChannelTrafficMonitor;
import net.rsprot.protocol.metrics.impl.ConcurrentNetworkTrafficMonitor;
import net.rsprot.protocol.metrics.lock.TrafficMonitorLock;
import net.rsprot.protocol.metrics.snapshots.impl.ConcurrentNetworkTrafficSnapshot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0016J\b\u0010&\u001a\u00020\u001dH\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnet/rsprot/protocol/metrics/impl/ConcurrentNetworkTrafficMonitor;", "LoginBlock", "Lnet/rsprot/protocol/metrics/NetworkTrafficMonitor;", "lock", "Lnet/rsprot/protocol/metrics/lock/TrafficMonitorLock;", "loginChannelTrafficMonitor", "Lnet/rsprot/protocol/metrics/channel/impl/LoginChannelTrafficMonitor;", "js5ChannelTrafficMonitor", "Lnet/rsprot/protocol/metrics/channel/impl/Js5ChannelTrafficMonitor;", "gameChannelTrafficMonitor", "Lnet/rsprot/protocol/metrics/channel/impl/GameChannelTrafficMonitor;", "startDateTime", "Ljava/time/LocalDateTime;", "(Lnet/rsprot/protocol/metrics/lock/TrafficMonitorLock;Lnet/rsprot/protocol/metrics/channel/impl/LoginChannelTrafficMonitor;Lnet/rsprot/protocol/metrics/channel/impl/Js5ChannelTrafficMonitor;Lnet/rsprot/protocol/metrics/channel/impl/GameChannelTrafficMonitor;Ljava/time/LocalDateTime;)V", "connections", "Ljava/util/concurrent/atomic/AtomicInteger;", "frozen", "", "getGameChannelTrafficMonitor", "()Lnet/rsprot/protocol/metrics/channel/impl/GameChannelTrafficMonitor;", "getJs5ChannelTrafficMonitor", "()Lnet/rsprot/protocol/metrics/channel/impl/Js5ChannelTrafficMonitor;", "loginBlocks", "", "Ljava/net/InetAddress;", "Ljava/util/Queue;", "getLoginChannelTrafficMonitor", "()Lnet/rsprot/protocol/metrics/channel/impl/LoginChannelTrafficMonitor;", "addLoginBlock", "", "inetAddress", "block", "(Ljava/net/InetAddress;Ljava/lang/Object;)V", "freeze", "incrementConnections", "resetTransient", "Lnet/rsprot/protocol/metrics/snapshots/impl/ConcurrentNetworkTrafficSnapshot;", "snapshot", "unfreeze", "protocol"})
@SourceDebugExtension(value={"SMAP\nConcurrentNetworkTrafficMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentNetworkTrafficMonitor.kt\nnet/rsprot/protocol/metrics/impl/ConcurrentNetworkTrafficMonitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TrafficMonitorLock.kt\nnet/rsprot/protocol/metrics/lock/TrafficMonitorLock\n*L\n1#1,131:1\n1179#2,2:132\n1253#2,4:134\n1179#2,2:151\n1253#2,4:153\n27#3,13:138\n*S KotlinDebug\n*F\n+ 1 ConcurrentNetworkTrafficMonitor.kt\nnet/rsprot/protocol/metrics/impl/ConcurrentNetworkTrafficMonitor\n*L\n76#1:132,2\n76#1:134,4\n103#1:151,2\n103#1:153,4\n94#1:138,13\n*E\n"})
public final class ConcurrentNetworkTrafficMonitor<LoginBlock>
implements NetworkTrafficMonitor<LoginBlock> {
    @NotNull
    private final TrafficMonitorLock lock;
    @NotNull
    private final LoginChannelTrafficMonitor loginChannelTrafficMonitor;
    @NotNull
    private final Js5ChannelTrafficMonitor js5ChannelTrafficMonitor;
    @NotNull
    private final GameChannelTrafficMonitor gameChannelTrafficMonitor;
    @NotNull
    private LocalDateTime startDateTime;
    @NotNull
    private AtomicInteger connections;
    @NotNull
    private Map<InetAddress, Queue<LoginBlock>> loginBlocks;
    private volatile boolean frozen;

    public ConcurrentNetworkTrafficMonitor(@NotNull TrafficMonitorLock lock, @NotNull LoginChannelTrafficMonitor loginChannelTrafficMonitor, @NotNull Js5ChannelTrafficMonitor js5ChannelTrafficMonitor, @NotNull GameChannelTrafficMonitor gameChannelTrafficMonitor, @NotNull LocalDateTime startDateTime) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)loginChannelTrafficMonitor, (String)"loginChannelTrafficMonitor");
        Intrinsics.checkNotNullParameter((Object)js5ChannelTrafficMonitor, (String)"js5ChannelTrafficMonitor");
        Intrinsics.checkNotNullParameter((Object)gameChannelTrafficMonitor, (String)"gameChannelTrafficMonitor");
        Intrinsics.checkNotNullParameter((Object)startDateTime, (String)"startDateTime");
        this.lock = lock;
        this.loginChannelTrafficMonitor = loginChannelTrafficMonitor;
        this.js5ChannelTrafficMonitor = js5ChannelTrafficMonitor;
        this.gameChannelTrafficMonitor = gameChannelTrafficMonitor;
        this.startDateTime = startDateTime;
        this.connections = new AtomicInteger(0);
        this.loginBlocks = new ConcurrentHashMap();
    }

    public /* synthetic */ ConcurrentNetworkTrafficMonitor(TrafficMonitorLock trafficMonitorLock, LoginChannelTrafficMonitor loginChannelTrafficMonitor, Js5ChannelTrafficMonitor js5ChannelTrafficMonitor, GameChannelTrafficMonitor gameChannelTrafficMonitor, LocalDateTime localDateTime, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            LocalDateTime localDateTime2 = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"now(...)");
            localDateTime = localDateTime2;
        }
        this(trafficMonitorLock, loginChannelTrafficMonitor, js5ChannelTrafficMonitor, gameChannelTrafficMonitor, localDateTime);
    }

    @Override
    @NotNull
    public LoginChannelTrafficMonitor getLoginChannelTrafficMonitor() {
        return this.loginChannelTrafficMonitor;
    }

    @Override
    @NotNull
    public Js5ChannelTrafficMonitor getJs5ChannelTrafficMonitor() {
        return this.js5ChannelTrafficMonitor;
    }

    @Override
    @NotNull
    public GameChannelTrafficMonitor getGameChannelTrafficMonitor() {
        return this.gameChannelTrafficMonitor;
    }

    @Override
    public void incrementConnections() {
        this.connections.incrementAndGet();
    }

    @Override
    public void addLoginBlock(@NotNull InetAddress inetAddress, LoginBlock block) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        if (this.frozen) {
            return;
        }
        Queue queue2 = this.loginBlocks.computeIfAbsent(inetAddress, arg_0 -> ConcurrentNetworkTrafficMonitor.addLoginBlock$lambda$0(addLoginBlock.queue.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)queue2, (String)"computeIfAbsent(...)");
        Queue queue3 = queue2;
        queue3.add(block);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConcurrentNetworkTrafficSnapshot<LoginBlock> snapshot() {
        void $this$associateTo$iv$iv;
        LocalDateTime newStart = LocalDateTime.now();
        Iterable $this$associate$iv = this.loginBlocks.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), (Object)CollectionsKt.toList((Iterable)((Iterable)it.getValue())));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map loginBlocks = destination$iv$iv;
        Intrinsics.checkNotNull((Object)newStart);
        return new ConcurrentNetworkTrafficSnapshot(this.startDateTime, newStart, this.connections.get(), loginBlocks, this.getLoginChannelTrafficMonitor().snapshot(), this.getJs5ChannelTrafficMonitor().snapshot(), this.getGameChannelTrafficMonitor().snapshot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConcurrentNetworkTrafficSnapshot<LoginBlock> resetTransient() {
        void $this$associateTo$iv$iv;
        Object $i$a$-synchronized-TrafficMonitorLock$transfer$2$iv22;
        LocalDateTime oldStart = null;
        AtomicInteger oldConnections = null;
        Map<InetAddress, Queue<LoginBlock>> oldLoginBlocks = null;
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$transfer = false;
        Object lock$iv = new Object();
        this_$iv.setLock(lock$iv);
        Object object = lock$iv;
        synchronized (object) {
            boolean $i$a$-synchronized-TrafficMonitorLock$transfer$2$iv22 = false;
            try {
                boolean bl = false;
                oldStart = this.startDateTime;
                oldConnections = this.connections;
                oldLoginBlocks = this.loginBlocks;
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
                this.startDateTime = localDateTime;
                this.connections = new AtomicInteger(0);
                this.loginBlocks = new ConcurrentHashMap();
            }
            finally {
                this_$iv.setLock(null);
            }
            $i$a$-synchronized-TrafficMonitorLock$transfer$2$iv22 = Unit.INSTANCE;
        }
        Iterable $this$associate$iv = oldLoginBlocks.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $i$a$-synchronized-TrafficMonitorLock$transfer$2$iv22 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), (Object)CollectionsKt.toList((Iterable)((Iterable)it.getValue())));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map loginBlocks = destination$iv$iv;
        return new ConcurrentNetworkTrafficSnapshot(oldStart, this.startDateTime, oldConnections.get(), loginBlocks, this.getLoginChannelTrafficMonitor().resetTransient(), this.getJs5ChannelTrafficMonitor().resetTransient(), this.getGameChannelTrafficMonitor().resetTransient());
    }

    @Override
    public void freeze() {
        this.frozen = true;
        this.getLoginChannelTrafficMonitor().freeze();
        this.getJs5ChannelTrafficMonitor().freeze();
        this.getGameChannelTrafficMonitor().freeze();
    }

    @Override
    public void unfreeze() {
        this.frozen = false;
        this.getLoginChannelTrafficMonitor().unfreeze();
        this.getJs5ChannelTrafficMonitor().unfreeze();
        this.getGameChannelTrafficMonitor().unfreeze();
    }

    private static final Queue addLoginBlock$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Queue)$tmp0.invoke(p0);
    }
}

