/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.metrics.channel.snapshots.util;

import java.util.EnumMap;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.rsprot.protocol.ClientProt;
import net.rsprot.protocol.ServerProt;
import net.rsprot.protocol.metrics.channel.snapshots.InetAddressSnapshot;
import net.rsprot.protocol.metrics.channel.snapshots.util.PacketSnapshot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u0012\b\u0001\u0010\u0004*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u0003*\u000e\b\u0002\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00032\u00020\u0007B5\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00020\t\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0018J\u0016\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018J\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020 R\u0018\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/rsprot/protocol/metrics/channel/snapshots/util/InetAddressTrafficMonitor;", "CP", "Lnet/rsprot/protocol/ClientProt;", "", "SP", "Lnet/rsprot/protocol/ServerProt;", "DC", "", "clientProts", "", "serverProts", "disconnectionReasons", "([Ljava/lang/Enum;[Ljava/lang/Enum;[Ljava/lang/Enum;)V", "[Ljava/lang/Enum;", "disconnectionsByReason", "Ljava/util/concurrent/atomic/AtomicIntegerArray;", "incomingPackets", "Ljava/util/concurrent/atomic/AtomicLongArray;", "outgoingPackets", "trafficByIncomingPackets", "trafficByOutgoingPackets", "addDisconnectionReason", "", "reason", "", "incrementIncomingPackets", "opcode", "payloadSize", "incrementOutgoingPacketOpcode", "incrementOutgoingPacketPayload", "incrementOutgoingPackets", "snapshot", "Lnet/rsprot/protocol/metrics/channel/snapshots/InetAddressSnapshot;", "protocol"})
@SourceDebugExtension(value={"SMAP\nInetAddressTrafficMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InetAddressTrafficMonitor.kt\nnet/rsprot/protocol/metrics/channel/snapshots/util/InetAddressTrafficMonitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public final class InetAddressTrafficMonitor<CP extends Enum<CP>, SP extends Enum<SP>, DC extends Enum<DC>> {
    @NotNull
    private final CP[] clientProts;
    @NotNull
    private final SP[] serverProts;
    @NotNull
    private final DC[] disconnectionReasons;
    @NotNull
    private volatile AtomicIntegerArray disconnectionsByReason;
    @NotNull
    private volatile AtomicLongArray incomingPackets;
    @NotNull
    private volatile AtomicLongArray trafficByIncomingPackets;
    @NotNull
    private volatile AtomicLongArray outgoingPackets;
    @NotNull
    private volatile AtomicLongArray trafficByOutgoingPackets;

    public InetAddressTrafficMonitor(@NotNull CP[] clientProts, @NotNull SP[] serverProts, @NotNull DC[] disconnectionReasons) {
        int it32;
        int n;
        Intrinsics.checkNotNullParameter(clientProts, (String)"clientProts");
        Intrinsics.checkNotNullParameter(serverProts, (String)"serverProts");
        Intrinsics.checkNotNullParameter(disconnectionReasons, (String)"disconnectionReasons");
        this.clientProts = clientProts;
        this.serverProts = serverProts;
        this.disconnectionReasons = disconnectionReasons;
        this.disconnectionsByReason = new AtomicIntegerArray(this.disconnectionReasons.length);
        Object[] objectArray = this.clientProts;
        InetAddressTrafficMonitor inetAddressTrafficMonitor = this;
        if (objectArray.length == 0) {
            throw new NoSuchElementException();
        }
        CP it22 = objectArray[0];
        boolean $i$a$-maxOf-InetAddressTrafficMonitor$incomingPackets$22 = false;
        int it22 = ((ClientProt)it22).getOpcode();
        IntIterator $i$a$-maxOf-InetAddressTrafficMonitor$incomingPackets$22 = new IntRange(1, ArraysKt.getLastIndex((Object[])objectArray)).iterator();
        while ($i$a$-maxOf-InetAddressTrafficMonitor$incomingPackets$22.hasNext()) {
            n = $i$a$-maxOf-InetAddressTrafficMonitor$incomingPackets$22.nextInt();
            Object it32 = objectArray[n];
            boolean bl = false;
            it32 = ((ClientProt)it32).getOpcode();
            if (it22 >= it32) continue;
            it22 = it32;
        }
        int n2 = it22;
        int n3 = n2 + 1;
        inetAddressTrafficMonitor.incomingPackets = new AtomicLongArray(n3);
        objectArray = this.clientProts;
        inetAddressTrafficMonitor = this;
        if (objectArray.length == 0) {
            throw new NoSuchElementException();
        }
        Object it42 = objectArray[0];
        boolean $i$a$-maxOf-InetAddressTrafficMonitor$trafficByIncomingPackets$22 = false;
        int it42 = ((ClientProt)it42).getOpcode();
        IntIterator $i$a$-maxOf-InetAddressTrafficMonitor$trafficByIncomingPackets$22 = new IntRange(1, ArraysKt.getLastIndex((Object[])objectArray)).iterator();
        while ($i$a$-maxOf-InetAddressTrafficMonitor$trafficByIncomingPackets$22.hasNext()) {
            n = $i$a$-maxOf-InetAddressTrafficMonitor$trafficByIncomingPackets$22.nextInt();
            Object it = objectArray[n];
            boolean bl = false;
            it32 = ((ClientProt)it).getOpcode();
            if (it42 >= it32) continue;
            it42 = it32;
        }
        n2 = it42;
        int n4 = n2 + 1;
        inetAddressTrafficMonitor.trafficByIncomingPackets = new AtomicLongArray(n4);
        objectArray = this.serverProts;
        inetAddressTrafficMonitor = this;
        if (objectArray.length == 0) {
            throw new NoSuchElementException();
        }
        Object it52 = objectArray[0];
        boolean $i$a$-maxOf-InetAddressTrafficMonitor$outgoingPackets$22 = false;
        int it52 = ((ServerProt)it52).getOpcode();
        IntIterator $i$a$-maxOf-InetAddressTrafficMonitor$outgoingPackets$22 = new IntRange(1, ArraysKt.getLastIndex((Object[])objectArray)).iterator();
        while ($i$a$-maxOf-InetAddressTrafficMonitor$outgoingPackets$22.hasNext()) {
            n = $i$a$-maxOf-InetAddressTrafficMonitor$outgoingPackets$22.nextInt();
            Object it = objectArray[n];
            boolean bl = false;
            it32 = ((ServerProt)it).getOpcode();
            if (it52 >= it32) continue;
            it52 = it32;
        }
        n2 = it52;
        int n5 = n2 + 1;
        inetAddressTrafficMonitor.outgoingPackets = new AtomicLongArray(n5);
        objectArray = this.serverProts;
        inetAddressTrafficMonitor = this;
        if (objectArray.length == 0) {
            throw new NoSuchElementException();
        }
        Object it = objectArray[0];
        boolean bl = false;
        int n6 = ((ServerProt)it).getOpcode();
        IntIterator intIterator = new IntRange(1, ArraysKt.getLastIndex((Object[])objectArray)).iterator();
        while (intIterator.hasNext()) {
            n = intIterator.nextInt();
            Object it6 = objectArray[n];
            $i$a$-maxOf-InetAddressTrafficMonitor$trafficByOutgoingPackets$1 = false;
            int n7 = ((ServerProt)it6).getOpcode();
            if (n6 >= n7) continue;
            n6 = n7;
        }
        n2 = n6;
        int n8 = n2 + 1;
        inetAddressTrafficMonitor.trafficByOutgoingPackets = new AtomicLongArray(n8);
    }

    public final void addDisconnectionReason(int reason) {
        this.disconnectionsByReason.incrementAndGet(reason);
    }

    public final void incrementIncomingPackets(int opcode, int payloadSize) {
        this.incomingPackets.incrementAndGet(opcode);
        this.trafficByIncomingPackets.addAndGet(opcode, payloadSize);
    }

    public final void incrementOutgoingPackets(int opcode, int payloadSize) {
        this.outgoingPackets.incrementAndGet(opcode);
        this.trafficByOutgoingPackets.addAndGet(opcode, payloadSize);
    }

    public final void incrementOutgoingPacketPayload(int opcode, int payloadSize) {
        this.trafficByOutgoingPackets.addAndGet(opcode, payloadSize);
    }

    public final void incrementOutgoingPacketOpcode(int opcode) {
        this.outgoingPackets.incrementAndGet(opcode);
    }

    @NotNull
    public final InetAddressSnapshot<CP, SP, DC> snapshot() {
        AtomicIntegerArray oldDisconnectionsByReason = this.disconnectionsByReason;
        AtomicLongArray oldIncomingPackets = this.incomingPackets;
        AtomicLongArray oldTrafficByIncomingPackets = this.trafficByIncomingPackets;
        AtomicLongArray oldOutgoingPackets = this.outgoingPackets;
        AtomicLongArray oldTrafficByOutgoingPackets = this.trafficByOutgoingPackets;
        this.disconnectionsByReason = new AtomicIntegerArray(oldDisconnectionsByReason.length());
        this.incomingPackets = new AtomicLongArray(oldIncomingPackets.length());
        this.trafficByIncomingPackets = new AtomicLongArray(oldTrafficByIncomingPackets.length());
        this.outgoingPackets = new AtomicLongArray(oldOutgoingPackets.length());
        this.trafficByOutgoingPackets = new AtomicLongArray(oldTrafficByOutgoingPackets.length());
        EnumMap disconnectionsByReason = new EnumMap(this.disconnectionReasons[0].getClass());
        int n = this.disconnectionReasons.length;
        for (int i = 0; i < n; ++i) {
            disconnectionsByReason.put(this.disconnectionReasons[i], oldDisconnectionsByReason.get(i));
        }
        EnumMap incomingPackets = new EnumMap(this.clientProts[0].getClass());
        CP[] CPArray = this.clientProts;
        int n2 = CPArray.length;
        for (int i = 0; i < n2; ++i) {
            CP prot = CPArray[i];
            incomingPackets.put(prot, new PacketSnapshot(oldIncomingPackets.get(((ClientProt)prot).getOpcode()), oldTrafficByIncomingPackets.get(((ClientProt)prot).getOpcode())));
        }
        EnumMap outgoingPackets = new EnumMap(this.serverProts[0].getClass());
        for (SP prot : this.serverProts) {
            outgoingPackets.put(prot, new PacketSnapshot(oldOutgoingPackets.get(((ServerProt)prot).getOpcode()), oldTrafficByOutgoingPackets.get(((ServerProt)prot).getOpcode())));
        }
        return new InetAddressSnapshot(disconnectionsByReason, incomingPackets, outgoingPackets);
    }
}

