/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.message.codec.outgoing;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ProtRepository;
import net.rsprot.protocol.ServerProt;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003BE\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\b0\u0007\u0012\u001a\u0010\t\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\rJ&\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\b\"\b\b\u0001\u0010\u0010*\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00100\u000bJ\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00022\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0002J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013R\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\"\u0010\t\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "P", "Lnet/rsprot/protocol/ServerProt;", "", "protRepository", "Lnet/rsprot/protocol/ProtRepository;", "encoders", "", "Lnet/rsprot/protocol/message/codec/MessageEncoder;", "messageClassToServerProtMap", "", "Ljava/lang/Class;", "Lnet/rsprot/protocol/message/OutgoingMessage;", "(Lnet/rsprot/protocol/ProtRepository;[Lnet/rsprot/protocol/message/codec/MessageEncoder;Ljava/util/Map;)V", "[Lnet/rsprot/protocol/message/codec/MessageEncoder;", "getEncoder", "Type", "clazz", "opcode", "", "getServerProt", "getSize", "protocol"})
public final class MessageEncoderRepository<P extends ServerProt> {
    @NotNull
    private final ProtRepository<P> protRepository;
    @NotNull
    private final MessageEncoder<?>[] encoders;
    @NotNull
    private final Map<Class<? extends OutgoingMessage>, ServerProt> messageClassToServerProtMap;

    public MessageEncoderRepository(@NotNull ProtRepository<P> protRepository, @NotNull MessageEncoder<?>[] encoders, @NotNull Map<Class<? extends OutgoingMessage>, ? extends ServerProt> messageClassToServerProtMap) {
        Intrinsics.checkNotNullParameter(protRepository, (String)"protRepository");
        Intrinsics.checkNotNullParameter(encoders, (String)"encoders");
        Intrinsics.checkNotNullParameter(messageClassToServerProtMap, (String)"messageClassToServerProtMap");
        this.protRepository = protRepository;
        this.encoders = encoders;
        this.messageClassToServerProtMap = messageClassToServerProtMap;
    }

    private final MessageEncoder<?> getEncoder(int opcode) {
        MessageEncoder<?> messageEncoder = this.encoders[opcode];
        if (messageEncoder == null) {
            throw new IllegalArgumentException("Opcode " + opcode + " is not registered.");
        }
        return messageEncoder;
    }

    @NotNull
    public final <Type extends OutgoingMessage> MessageEncoder<Type> getEncoder(@NotNull Class<? extends Type> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        ServerProt prot = this.getServerProt(clazz);
        MessageEncoder<?> messageEncoder = this.getEncoder(prot.getOpcode());
        Intrinsics.checkNotNull(messageEncoder, (String)"null cannot be cast to non-null type net.rsprot.protocol.message.codec.MessageEncoder<Type of net.rsprot.protocol.message.codec.outgoing.MessageEncoderRepository.getEncoder>");
        return messageEncoder;
    }

    private final ServerProt getServerProt(Class<? extends OutgoingMessage> clazz) {
        ServerProt serverProt = this.messageClassToServerProtMap.get(clazz);
        if (serverProt == null) {
            boolean bl = false;
            String string = "Encoder not registered for " + clazz + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return serverProt;
    }

    public final int getSize(int opcode) {
        return this.protRepository.getSize(opcode);
    }
}

