/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.message.codec.outgoing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ProtRepository;
import net.rsprot.protocol.ServerProt;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.outgoing.MessageEncoderRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u000f\u001a\u00020\u0010\"\b\b\u0001\u0010\u0011*\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\r2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\t2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J#\u0010\u000f\u001a\u00020\u0010\"\n\b\u0001\u0010\u0011\u0018\u0001*\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\tH\u0086\bJL\u0010\u0016\u001a\u00020\u0010\"\n\b\u0001\u0010\u0011\u0018\u0001*\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\t2\"\u0010\u0017\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\b\"\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0086\b\u00a2\u0006\u0002\u0010\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aR\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\"\u0010\u000b\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepositoryBuilder;", "P", "Lnet/rsprot/protocol/ServerProt;", "", "protRepository", "Lnet/rsprot/protocol/ProtRepository;", "(Lnet/rsprot/protocol/ProtRepository;)V", "encoders", "", "Lnet/rsprot/protocol/message/codec/MessageEncoder;", "[Lnet/rsprot/protocol/message/codec/MessageEncoder;", "messageClassToServerProtMap", "", "Ljava/lang/Class;", "Lnet/rsprot/protocol/message/OutgoingMessage;", "bind", "", "T", "messageClass", "encoder", "check", "", "bindWithAlts", "alternativeClasses", "(Lnet/rsprot/protocol/message/codec/MessageEncoder;[Ljava/lang/Class;)V", "build", "Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "protocol"})
public final class MessageEncoderRepositoryBuilder<P extends ServerProt> {
    @NotNull
    private final ProtRepository<P> protRepository;
    @NotNull
    private final MessageEncoder<?>[] encoders;
    @NotNull
    private final Map<Class<? extends OutgoingMessage>, ServerProt> messageClassToServerProtMap;

    public MessageEncoderRepositoryBuilder(@NotNull ProtRepository<P> protRepository) {
        Intrinsics.checkNotNullParameter(protRepository, (String)"protRepository");
        this.protRepository = protRepository;
        this.encoders = new MessageEncoder[this.protRepository.capacity()];
        this.messageClassToServerProtMap = new HashMap();
    }

    public final /* synthetic */ <T extends OutgoingMessage> void bind(MessageEncoder<? super T> encoder) {
        Intrinsics.checkNotNullParameter(encoder, (String)"encoder");
        boolean $i$f$bind = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        MessageEncoderRepositoryBuilder.bind$default(this, OutgoingMessage.class, encoder, false, 4, null);
    }

    public final /* synthetic */ <T extends OutgoingMessage> void bindWithAlts(MessageEncoder<? super T> encoder, Class<? extends OutgoingMessage> ... alternativeClasses) {
        Intrinsics.checkNotNullParameter(encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(alternativeClasses, (String)"alternativeClasses");
        boolean $i$f$bindWithAlts = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        MessageEncoderRepositoryBuilder.bind$default(this, OutgoingMessage.class, encoder, false, 4, null);
        for (Class<? extends OutgoingMessage> clazz : alternativeClasses) {
            this.bind(clazz, encoder, false);
        }
    }

    public final <T extends OutgoingMessage> void bind(@NotNull Class<T> messageClass, @NotNull MessageEncoder<?> encoder, boolean check) {
        Intrinsics.checkNotNullParameter(messageClass, (String)"messageClass");
        Intrinsics.checkNotNullParameter(encoder, (String)"encoder");
        ServerProt prot = encoder.getProt();
        if (check && !(this.encoders[prot.getOpcode()] == null)) {
            boolean bl = false;
            String string = "Encoder for prot " + prot + " is already bound.";
            throw new IllegalArgumentException(string.toString());
        }
        this.encoders[prot.getOpcode()] = encoder;
        this.messageClassToServerProtMap.put(messageClass, prot);
    }

    public static /* synthetic */ void bind$default(MessageEncoderRepositoryBuilder messageEncoderRepositoryBuilder, Class clazz, MessageEncoder messageEncoder, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        messageEncoderRepositoryBuilder.bind(clazz, messageEncoder, bl);
    }

    @NotNull
    public final MessageEncoderRepository<P> build() {
        MessageEncoder<?>[] messageEncoderArray = Arrays.copyOf(this.encoders, this.encoders.length);
        Intrinsics.checkNotNullExpressionValue(messageEncoderArray, (String)"copyOf(...)");
        return new MessageEncoderRepository<P>(this.protRepository, messageEncoderArray, this.messageClassToServerProtMap);
    }
}

