/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.metrics.snapshots.impl;

import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.rsprot.protocol.metrics.channel.snapshots.ChannelTrafficSnapshot;
import net.rsprot.protocol.metrics.snapshots.NetworkTrafficSnapshot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0096\u0002J\b\u0010'\u001a\u00020\u0007H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u00148F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006*"}, d2={"Lnet/rsprot/protocol/metrics/snapshots/impl/ConcurrentNetworkTrafficSnapshot;", "LoginBlock", "Lnet/rsprot/protocol/metrics/snapshots/NetworkTrafficSnapshot;", "startDateTime", "Ljava/time/LocalDateTime;", "endDateTime", "connectionRequests", "", "loginBlocks", "", "Ljava/net/InetAddress;", "", "loginSnapshot", "Lnet/rsprot/protocol/metrics/channel/snapshots/ChannelTrafficSnapshot;", "js5Snapshot", "gameSnapshot", "(Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;ILjava/util/Map;Lnet/rsprot/protocol/metrics/channel/snapshots/ChannelTrafficSnapshot;Lnet/rsprot/protocol/metrics/channel/snapshots/ChannelTrafficSnapshot;Lnet/rsprot/protocol/metrics/channel/snapshots/ChannelTrafficSnapshot;)V", "getConnectionRequests", "()I", "elapsed", "Lkotlin/time/Duration;", "getElapsed-UwyO8pc", "()J", "elapsedMillis", "", "getElapsedMillis", "getEndDateTime", "()Ljava/time/LocalDateTime;", "getGameSnapshot", "()Lnet/rsprot/protocol/metrics/channel/snapshots/ChannelTrafficSnapshot;", "getJs5Snapshot", "getLoginBlocks", "()Ljava/util/Map;", "getLoginSnapshot", "getStartDateTime", "equals", "", "other", "", "hashCode", "toString", "", "protocol"})
public final class ConcurrentNetworkTrafficSnapshot<LoginBlock>
implements NetworkTrafficSnapshot {
    @NotNull
    private final LocalDateTime startDateTime;
    @NotNull
    private final LocalDateTime endDateTime;
    private final int connectionRequests;
    @NotNull
    private final Map<InetAddress, List<LoginBlock>> loginBlocks;
    @NotNull
    private final ChannelTrafficSnapshot loginSnapshot;
    @NotNull
    private final ChannelTrafficSnapshot js5Snapshot;
    @NotNull
    private final ChannelTrafficSnapshot gameSnapshot;

    public ConcurrentNetworkTrafficSnapshot(@NotNull LocalDateTime startDateTime, @NotNull LocalDateTime endDateTime, int connectionRequests, @NotNull Map<InetAddress, ? extends List<? extends LoginBlock>> loginBlocks, @NotNull ChannelTrafficSnapshot loginSnapshot, @NotNull ChannelTrafficSnapshot js5Snapshot, @NotNull ChannelTrafficSnapshot gameSnapshot) {
        Intrinsics.checkNotNullParameter((Object)startDateTime, (String)"startDateTime");
        Intrinsics.checkNotNullParameter((Object)endDateTime, (String)"endDateTime");
        Intrinsics.checkNotNullParameter(loginBlocks, (String)"loginBlocks");
        Intrinsics.checkNotNullParameter((Object)loginSnapshot, (String)"loginSnapshot");
        Intrinsics.checkNotNullParameter((Object)js5Snapshot, (String)"js5Snapshot");
        Intrinsics.checkNotNullParameter((Object)gameSnapshot, (String)"gameSnapshot");
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.connectionRequests = connectionRequests;
        this.loginBlocks = loginBlocks;
        this.loginSnapshot = loginSnapshot;
        this.js5Snapshot = js5Snapshot;
        this.gameSnapshot = gameSnapshot;
    }

    @NotNull
    public final LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    @NotNull
    public final LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public final int getConnectionRequests() {
        return this.connectionRequests;
    }

    @NotNull
    public final Map<InetAddress, List<LoginBlock>> getLoginBlocks() {
        return this.loginBlocks;
    }

    @NotNull
    public final ChannelTrafficSnapshot getLoginSnapshot() {
        return this.loginSnapshot;
    }

    @NotNull
    public final ChannelTrafficSnapshot getJs5Snapshot() {
        return this.js5Snapshot;
    }

    @NotNull
    public final ChannelTrafficSnapshot getGameSnapshot() {
        return this.gameSnapshot;
    }

    public final long getElapsedMillis() {
        return ChronoUnit.MILLIS.between(this.startDateTime, this.endDateTime);
    }

    public final long getElapsed-UwyO8pc() {
        return DurationKt.toDuration((long)this.getElapsedMillis(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.metrics.snapshots.impl.ConcurrentNetworkTrafficSnapshot<*>");
        ConcurrentNetworkTrafficSnapshot cfr_ignored_0 = (ConcurrentNetworkTrafficSnapshot)other;
        if (!Intrinsics.areEqual((Object)this.startDateTime, (Object)((ConcurrentNetworkTrafficSnapshot)other).startDateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endDateTime, (Object)((ConcurrentNetworkTrafficSnapshot)other).endDateTime)) {
            return false;
        }
        if (this.connectionRequests != ((ConcurrentNetworkTrafficSnapshot)other).connectionRequests) {
            return false;
        }
        if (!Intrinsics.areEqual(this.loginBlocks, ((ConcurrentNetworkTrafficSnapshot)other).loginBlocks)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.loginSnapshot, (Object)((ConcurrentNetworkTrafficSnapshot)other).loginSnapshot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.js5Snapshot, (Object)((ConcurrentNetworkTrafficSnapshot)other).js5Snapshot)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.gameSnapshot, (Object)((ConcurrentNetworkTrafficSnapshot)other).gameSnapshot);
    }

    public int hashCode() {
        int result = this.startDateTime.hashCode();
        result = 31 * result + this.endDateTime.hashCode();
        result = 31 * result + this.connectionRequests;
        result = 31 * result + ((Object)this.loginBlocks).hashCode();
        result = 31 * result + this.loginSnapshot.hashCode();
        result = 31 * result + this.js5Snapshot.hashCode();
        result = 31 * result + this.gameSnapshot.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "ConcurrentNetworkTrafficSnapshot(startDateTime=" + this.startDateTime + ", endDateTime=" + this.endDateTime + ", connectionRequests=" + this.connectionRequests + ", loginBlocks=" + this.loginBlocks + ", loginSnapshot=" + this.loginSnapshot + ", js5Snapshot=" + this.js5Snapshot + ", gameSnapshot=" + this.gameSnapshot + ", elapsedMillis=" + this.getElapsedMillis() + ", elapsed=" + Duration.toString-impl((long)this.getElapsed-UwyO8pc()) + ")";
    }
}

