/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.metrics.channel.snapshots.impl;

import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.rsprot.protocol.metrics.channel.snapshots.ChannelTrafficSnapshot;
import net.rsprot.protocol.metrics.channel.snapshots.InetAddressSnapshot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u0012\b\u0001\u0010\u0004*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u0003*\u000e\b\u0002\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00032\u00020\u0007BO\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012$\u0010\u000f\u001a \u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00100\f\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020\u000eH\u0016J\b\u0010$\u001a\u00020%H\u0016R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\u00020\u00158F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR/\u0010\u000f\u001a \u0012\u0004\u0012\u00020\r\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00100\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001c\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006&"}, d2={"Lnet/rsprot/protocol/metrics/channel/snapshots/impl/ConcurrentChannelTrafficSnapshot;", "CP", "Lnet/rsprot/protocol/ClientProt;", "", "SP", "Lnet/rsprot/protocol/ServerProt;", "DC", "Lnet/rsprot/protocol/metrics/channel/snapshots/ChannelTrafficSnapshot;", "startDateTime", "Ljava/time/LocalDateTime;", "endDateTime", "activeConnectionsByAddress", "", "Ljava/net/InetAddress;", "", "inetAddressSnapshots", "Lnet/rsprot/protocol/metrics/channel/snapshots/InetAddressSnapshot;", "(Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;Ljava/util/Map;Ljava/util/Map;)V", "getActiveConnectionsByAddress", "()Ljava/util/Map;", "elapsed", "Lkotlin/time/Duration;", "getElapsed-UwyO8pc", "()J", "elapsedMillis", "", "getElapsedMillis", "getEndDateTime", "()Ljava/time/LocalDateTime;", "getInetAddressSnapshots", "getStartDateTime", "equals", "", "other", "", "hashCode", "toString", "", "protocol"})
public final class ConcurrentChannelTrafficSnapshot<CP extends Enum<CP>, SP extends Enum<SP>, DC extends Enum<DC>>
implements ChannelTrafficSnapshot {
    @NotNull
    private final LocalDateTime startDateTime;
    @NotNull
    private final LocalDateTime endDateTime;
    @NotNull
    private final Map<InetAddress, Integer> activeConnectionsByAddress;
    @NotNull
    private final Map<InetAddress, InetAddressSnapshot<CP, SP, DC>> inetAddressSnapshots;

    public ConcurrentChannelTrafficSnapshot(@NotNull LocalDateTime startDateTime, @NotNull LocalDateTime endDateTime, @NotNull Map<InetAddress, Integer> activeConnectionsByAddress, @NotNull Map<InetAddress, InetAddressSnapshot<CP, SP, DC>> inetAddressSnapshots) {
        Intrinsics.checkNotNullParameter((Object)startDateTime, (String)"startDateTime");
        Intrinsics.checkNotNullParameter((Object)endDateTime, (String)"endDateTime");
        Intrinsics.checkNotNullParameter(activeConnectionsByAddress, (String)"activeConnectionsByAddress");
        Intrinsics.checkNotNullParameter(inetAddressSnapshots, (String)"inetAddressSnapshots");
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.activeConnectionsByAddress = activeConnectionsByAddress;
        this.inetAddressSnapshots = inetAddressSnapshots;
    }

    @NotNull
    public final LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    @NotNull
    public final LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    @NotNull
    public final Map<InetAddress, Integer> getActiveConnectionsByAddress() {
        return this.activeConnectionsByAddress;
    }

    @NotNull
    public final Map<InetAddress, InetAddressSnapshot<CP, SP, DC>> getInetAddressSnapshots() {
        return this.inetAddressSnapshots;
    }

    public final long getElapsedMillis() {
        return ChronoUnit.MILLIS.between(this.startDateTime, this.endDateTime);
    }

    public final long getElapsed-UwyO8pc() {
        return DurationKt.toDuration((long)this.getElapsedMillis(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.metrics.channel.snapshots.impl.ConcurrentChannelTrafficSnapshot<*, *, *>");
        ConcurrentChannelTrafficSnapshot cfr_ignored_0 = (ConcurrentChannelTrafficSnapshot)other;
        if (!Intrinsics.areEqual((Object)this.startDateTime, (Object)((ConcurrentChannelTrafficSnapshot)other).startDateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endDateTime, (Object)((ConcurrentChannelTrafficSnapshot)other).endDateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.activeConnectionsByAddress, ((ConcurrentChannelTrafficSnapshot)other).activeConnectionsByAddress)) {
            return false;
        }
        return Intrinsics.areEqual(this.inetAddressSnapshots, ((ConcurrentChannelTrafficSnapshot)other).inetAddressSnapshots);
    }

    public int hashCode() {
        int result = this.startDateTime.hashCode();
        result = 31 * result + this.endDateTime.hashCode();
        result = 31 * result + ((Object)this.activeConnectionsByAddress).hashCode();
        result = 31 * result + ((Object)this.inetAddressSnapshots).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "ConcurrentChannelTrafficSnapshot(startDateTime=" + this.startDateTime + ", endDateTime=" + this.endDateTime + ", activeConnectionsByAddress=" + this.activeConnectionsByAddress + ", inetAddressSnapshots=" + this.inetAddressSnapshots + ")";
    }
}

