/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.message.codec.incoming;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ClientProt;
import net.rsprot.protocol.ProtRepository;
import net.rsprot.protocol.message.IncomingMessage;
import net.rsprot.protocol.message.codec.MessageDecoder;
import net.rsprot.protocol.message.codec.incoming.MessageDecoderRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000f\u001a\u00020\u0010\"\b\b\u0001\u0010\u0011*\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\nJ#\u0010\u000f\u001a\u00020\u0010\"\n\b\u0001\u0010\u0011\u0018\u0001*\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\nH\u0086\bJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016R0\u0010\u0007\u001a$\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/protocol/message/codec/incoming/MessageDecoderRepositoryBuilder;", "P", "Lnet/rsprot/protocol/ClientProt;", "", "protRepository", "Lnet/rsprot/protocol/ProtRepository;", "(Lnet/rsprot/protocol/ProtRepository;)V", "decoderClassToMessageClassMap", "", "Ljava/lang/Class;", "Lnet/rsprot/protocol/message/codec/MessageDecoder;", "Lnet/rsprot/protocol/message/IncomingMessage;", "decoders", "", "[Lnet/rsprot/protocol/message/codec/MessageDecoder;", "bind", "", "T", "messageClass", "decoder", "encoder", "build", "Lnet/rsprot/protocol/message/codec/incoming/MessageDecoderRepository;", "protocol"})
public final class MessageDecoderRepositoryBuilder<P extends ClientProt> {
    @NotNull
    private final ProtRepository<P> protRepository;
    @NotNull
    private final MessageDecoder<?>[] decoders;
    @NotNull
    private final Map<Class<? extends MessageDecoder<IncomingMessage>>, Class<? extends IncomingMessage>> decoderClassToMessageClassMap;

    public MessageDecoderRepositoryBuilder(@NotNull ProtRepository<P> protRepository) {
        Intrinsics.checkNotNullParameter(protRepository, (String)"protRepository");
        this.protRepository = protRepository;
        this.decoders = new MessageDecoder[this.protRepository.capacity()];
        this.decoderClassToMessageClassMap = new HashMap();
    }

    public final /* synthetic */ <T extends IncomingMessage> void bind(MessageDecoder<? extends T> encoder) {
        Intrinsics.checkNotNullParameter(encoder, (String)"encoder");
        boolean $i$f$bind = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        this.bind(IncomingMessage.class, encoder);
    }

    public final <T extends IncomingMessage> void bind(@NotNull Class<T> messageClass, @NotNull MessageDecoder<? extends T> decoder) {
        Intrinsics.checkNotNullParameter(messageClass, (String)"messageClass");
        Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
        ClientProt clientProt = decoder.getProt();
        if (this.decoders[clientProt.getOpcode()] == null) {
            // empty if block
        }
        this.decoders[clientProt.getOpcode()] = decoder;
        this.decoderClassToMessageClassMap.put(decoder.getClass(), messageClass);
    }

    @NotNull
    public final MessageDecoderRepository<P> build() {
        MessageDecoder<?>[] messageDecoderArray = Arrays.copyOf(this.decoders, this.decoders.length);
        Intrinsics.checkNotNullExpressionValue(messageDecoderArray, (String)"copyOf(...)");
        return new MessageDecoderRepository<P>(this.protRepository, messageDecoderArray, MapsKt.toMap(this.decoderClassToMessageClassMap));
    }
}

