/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.metrics.channel.impl;

import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.rsprot.protocol.metrics.channel.ChannelTrafficMonitor;
import net.rsprot.protocol.metrics.channel.impl.ConcurrentChannelTrafficMonitor;
import net.rsprot.protocol.metrics.channel.snapshots.InetAddressSnapshot;
import net.rsprot.protocol.metrics.channel.snapshots.impl.ConcurrentChannelTrafficSnapshot;
import net.rsprot.protocol.metrics.channel.snapshots.util.InetAddressTrafficMonitor;
import net.rsprot.protocol.metrics.lock.TrafficMonitorLock;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u0012\b\u0001\u0010\u0004*\u00020\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u0003*\u000e\b\u0002\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00032\u00020\u0007BG\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u000b\u0012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0015\u0010\u001f\u001a\u00020 H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\"J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001bH\u0016J\"\u0010&\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J \u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0016J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0014H\u0016J \u0010,\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0016J \u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0014H\u0016J\u001a\u0010.\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020/H\u0016J\u001a\u00100\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020/H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u00101\u001a\u00020\u001bH\u0016R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0018\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0018\u001a \u0012\u0004\u0012\u00020\u0013\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00190\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00062"}, d2={"Lnet/rsprot/protocol/metrics/channel/impl/ConcurrentChannelTrafficMonitor;", "CP", "Lnet/rsprot/protocol/ClientProt;", "", "SP", "Lnet/rsprot/protocol/ServerProt;", "DC", "Lnet/rsprot/protocol/metrics/channel/ChannelTrafficMonitor;", "lock", "Lnet/rsprot/protocol/metrics/lock/TrafficMonitorLock;", "clientProts", "", "serverProts", "disconnectionReasons", "startDateTime", "Ljava/time/LocalDateTime;", "(Lnet/rsprot/protocol/metrics/lock/TrafficMonitorLock;[Ljava/lang/Enum;[Ljava/lang/Enum;[Ljava/lang/Enum;Ljava/time/LocalDateTime;)V", "activeConnectionsByAddress", "", "Ljava/net/InetAddress;", "", "[Ljava/lang/Enum;", "frozen", "", "inetAddressTrafficMonitors", "Lnet/rsprot/protocol/metrics/channel/snapshots/util/InetAddressTrafficMonitor;", "addDisconnectionReason", "", "inetAddress", "reason", "decrementConnections", "elapsed", "Lkotlin/time/Duration;", "elapsed-UwyO8pc", "()J", "elapsedMillis", "", "freeze", "getTrafficCounter", "incrementConnections", "incrementIncomingPackets", "opcode", "payloadSize", "incrementOutgoingPacketOpcode", "incrementOutgoingPacketPayload", "incrementOutgoingPackets", "resetTransient", "Lnet/rsprot/protocol/metrics/channel/snapshots/impl/ConcurrentChannelTrafficSnapshot;", "snapshot", "unfreeze", "protocol"})
@SourceDebugExtension(value={"SMAP\nConcurrentChannelTrafficMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentChannelTrafficMonitor.kt\nnet/rsprot/protocol/metrics/channel/impl/ConcurrentChannelTrafficMonitor\n+ 2 TrafficMonitorLock.kt\nnet/rsprot/protocol/metrics/lock/TrafficMonitorLock\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n48#2,9:207\n48#2,9:216\n48#2,9:225\n48#2,9:234\n48#2,9:243\n48#2,9:252\n48#2,9:261\n48#2,9:270\n48#2,9:279\n48#2,6:288\n55#2,2:300\n27#2,13:302\n453#3:294\n403#3:295\n453#3:315\n403#3:316\n1238#4,4:296\n1238#4,4:317\n*S KotlinDebug\n*F\n+ 1 ConcurrentChannelTrafficMonitor.kt\nnet/rsprot/protocol/metrics/channel/impl/ConcurrentChannelTrafficMonitor\n*L\n46#1:207,9\n54#1:216,9\n76#1:225,9\n90#1:234,9\n104#1:243,9\n118#1:252,9\n131#1:261,9\n139#1:270,9\n144#1:279,9\n149#1:288,6\n149#1:300,2\n178#1:302,13\n157#1:294\n157#1:295\n187#1:315\n187#1:316\n157#1:296,4\n187#1:317,4\n*E\n"})
public final class ConcurrentChannelTrafficMonitor<CP extends Enum<CP>, SP extends Enum<SP>, DC extends Enum<DC>>
implements ChannelTrafficMonitor {
    @NotNull
    private final TrafficMonitorLock lock;
    @NotNull
    private final CP[] clientProts;
    @NotNull
    private final SP[] serverProts;
    @NotNull
    private final DC[] disconnectionReasons;
    @NotNull
    private LocalDateTime startDateTime;
    @NotNull
    private final Map<InetAddress, Integer> activeConnectionsByAddress;
    @NotNull
    private Map<InetAddress, InetAddressTrafficMonitor<CP, SP, DC>> inetAddressTrafficMonitors;
    private volatile boolean frozen;

    public ConcurrentChannelTrafficMonitor(@NotNull TrafficMonitorLock lock, @NotNull CP[] clientProts, @NotNull SP[] serverProts, @NotNull DC[] disconnectionReasons, @NotNull LocalDateTime startDateTime) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter(clientProts, (String)"clientProts");
        Intrinsics.checkNotNullParameter(serverProts, (String)"serverProts");
        Intrinsics.checkNotNullParameter(disconnectionReasons, (String)"disconnectionReasons");
        Intrinsics.checkNotNullParameter((Object)startDateTime, (String)"startDateTime");
        this.lock = lock;
        this.clientProts = clientProts;
        this.serverProts = serverProts;
        this.disconnectionReasons = disconnectionReasons;
        this.startDateTime = startDateTime;
        this.activeConnectionsByAddress = new ConcurrentHashMap();
        this.inetAddressTrafficMonitors = new ConcurrentHashMap();
    }

    public /* synthetic */ ConcurrentChannelTrafficMonitor(TrafficMonitorLock trafficMonitorLock, Enum[] enumArray, Enum[] enumArray2, Enum[] enumArray3, LocalDateTime localDateTime, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            LocalDateTime localDateTime2 = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"now(...)");
            localDateTime = localDateTime2;
        }
        this(trafficMonitorLock, enumArray, enumArray2, enumArray3, localDateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementConnections(@NotNull InetAddress inetAddress) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            this.activeConnectionsByAddress.compute(inetAddress, (arg_0, arg_1) -> ConcurrentChannelTrafficMonitor.incrementConnections$lambda$1$lambda$0(incrementConnections.1.1.INSTANCE, arg_0, arg_1));
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = false;
                Integer n = this.activeConnectionsByAddress.compute(inetAddress, (arg_0, arg_1) -> ConcurrentChannelTrafficMonitor.incrementConnections$lambda$1$lambda$0(incrementConnections.1.1.INSTANCE, arg_0, arg_1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementConnections(@NotNull InetAddress inetAddress) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            this.activeConnectionsByAddress.compute(inetAddress, (arg_0, arg_1) -> ConcurrentChannelTrafficMonitor.decrementConnections$lambda$3$lambda$2(decrementConnections.1.1.INSTANCE, arg_0, arg_1));
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = false;
                Integer n = this.activeConnectionsByAddress.compute(inetAddress, (arg_0, arg_1) -> ConcurrentChannelTrafficMonitor.decrementConnections$lambda$3$lambda$2(decrementConnections.1.1.INSTANCE, arg_0, arg_1));
            }
        }
    }

    private final InetAddressTrafficMonitor<CP, SP, DC> getTrafficCounter(InetAddress inetAddress) {
        InetAddressTrafficMonitor inetAddressTrafficMonitor = this.inetAddressTrafficMonitors.computeIfAbsent(inetAddress, arg_0 -> ConcurrentChannelTrafficMonitor.getTrafficCounter$lambda$4((Function1)new Function1<InetAddress, InetAddressTrafficMonitor<CP, SP, DC>>(this){
            final /* synthetic */ ConcurrentChannelTrafficMonitor<CP, SP, DC> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final InetAddressTrafficMonitor<CP, SP, DC> invoke(@NotNull InetAddress it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new InetAddressTrafficMonitor(ConcurrentChannelTrafficMonitor.access$getClientProts$p(this.this$0), ConcurrentChannelTrafficMonitor.access$getServerProts$p(this.this$0), ConcurrentChannelTrafficMonitor.access$getDisconnectionReasons$p(this.this$0));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)inetAddressTrafficMonitor, (String)"computeIfAbsent(...)");
        return inetAddressTrafficMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDisconnectionReason(@NotNull InetAddress inetAddress, int reason) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        if (this.frozen) {
            return;
        }
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            boolean bl2 = 0 <= reason ? reason < this.disconnectionReasons.length : false;
            if (bl2) {
                InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                trafficCounter.addDisconnectionReason(reason);
            }
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl3 = false;
                boolean bl4 = 0 <= reason ? reason < this.disconnectionReasons.length : false;
                if (bl4) {
                    InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                    trafficCounter.addDisconnectionReason(reason);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementIncomingPackets(@NotNull InetAddress inetAddress, int opcode, int payloadSize) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        if (this.frozen) {
            return;
        }
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            boolean bl2 = 0 <= opcode ? opcode < this.clientProts.length : false;
            if (bl2) {
                InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                trafficCounter.incrementIncomingPackets(opcode, payloadSize);
            }
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl3 = false;
                boolean bl4 = 0 <= opcode ? opcode < this.clientProts.length : false;
                if (bl4) {
                    InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                    trafficCounter.incrementIncomingPackets(opcode, payloadSize);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementOutgoingPackets(@NotNull InetAddress inetAddress, int opcode, int payloadSize) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        if (this.frozen) {
            return;
        }
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            boolean bl2 = 0 <= opcode ? opcode < this.serverProts.length : false;
            if (bl2) {
                InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                trafficCounter.incrementOutgoingPackets(opcode, payloadSize);
            }
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl3 = false;
                boolean bl4 = 0 <= opcode ? opcode < this.serverProts.length : false;
                if (bl4) {
                    InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                    trafficCounter.incrementOutgoingPackets(opcode, payloadSize);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementOutgoingPacketPayload(@NotNull InetAddress inetAddress, int opcode, int payloadSize) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        if (this.frozen) {
            return;
        }
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            boolean bl2 = 0 <= opcode ? opcode < this.serverProts.length : false;
            if (bl2) {
                InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                trafficCounter.incrementOutgoingPacketPayload(opcode, payloadSize);
            }
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl3 = false;
                boolean bl4 = 0 <= opcode ? opcode < this.serverProts.length : false;
                if (bl4) {
                    InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                    trafficCounter.incrementOutgoingPacketPayload(opcode, payloadSize);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementOutgoingPacketOpcode(@NotNull InetAddress inetAddress, int opcode) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        if (this.frozen) {
            return;
        }
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            boolean bl2 = 0 <= opcode ? opcode < this.serverProts.length : false;
            if (bl2) {
                InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                trafficCounter.incrementOutgoingPacketOpcode(opcode);
            }
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl3 = false;
                boolean bl4 = 0 <= opcode ? opcode < this.serverProts.length : false;
                if (bl4) {
                    InetAddressTrafficMonitor<CP, SP, DC> trafficCounter = this.getTrafficCounter(inetAddress);
                    trafficCounter.incrementOutgoingPacketOpcode(opcode);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LocalDateTime startDateTime() {
        LocalDateTime localDateTime;
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            localDateTime = this.startDateTime;
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = false;
                LocalDateTime localDateTime2 = this.startDateTime;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var5_6
                localDateTime = localDateTime2;
            }
        }
        return localDateTime;
    }

    @Override
    public long elapsed-UwyO8pc() {
        return DurationKt.toDuration((long)this.elapsedMillis(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long elapsedMillis() {
        long l;
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            boolean bl = false;
            l = ChronoUnit.MILLIS.between(LocalDateTime.now(), this.startDateTime);
        } else {
            Object object = lock$iv;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = false;
                long l2 = ChronoUnit.MILLIS.between(LocalDateTime.now(), this.startDateTime);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var5_6
                l = l2;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConcurrentChannelTrafficSnapshot<CP, SP, DC> snapshot() {
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$use = false;
        Object lock$iv = this_$iv.getLock();
        if (lock$iv == null) {
            void $this$mapValuesTo$iv$iv;
            Map inetAddressTrafficMonitors;
            boolean bl = false;
            LocalDateTime now = LocalDateTime.now();
            Map activeConnectionsByAddress = MapsKt.toMap(this.activeConnectionsByAddress);
            Map $this$mapValues$iv = inetAddressTrafficMonitors = MapsKt.toMap(this.inetAddressTrafficMonitors);
            boolean $i$f$mapValues = false;
            Map map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void entry;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl3 = false;
                InetAddressSnapshot inetAddressSnapshot = ((InetAddressTrafficMonitor)entry.getValue()).snapshot();
                map3.put(k, inetAddressSnapshot);
            }
            Map inetAddressSnapshots = destination$iv$iv;
            Intrinsics.checkNotNull((Object)now);
            return new ConcurrentChannelTrafficSnapshot(this.startDateTime, now, activeConnectionsByAddress, inetAddressSnapshots);
        }
        Object object = lock$iv;
        synchronized (object) {
            Map inetAddressTrafficMonitors;
            boolean bl = false;
            boolean bl4 = false;
            LocalDateTime now = LocalDateTime.now();
            Map activeConnectionsByAddress = MapsKt.toMap(this.activeConnectionsByAddress);
            Map $this$mapValues$iv = inetAddressTrafficMonitors = MapsKt.toMap(this.inetAddressTrafficMonitors);
            boolean $i$f$mapValues = false;
            Map $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry it$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl5 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map;
                boolean bl6 = false;
                InetAddressSnapshot inetAddressSnapshot = ((InetAddressTrafficMonitor)entry.getValue()).snapshot();
                map4.put(k, inetAddressSnapshot);
            }
            Map inetAddressSnapshots = destination$iv$iv;
            Intrinsics.checkNotNull((Object)now);
            ConcurrentChannelTrafficSnapshot concurrentChannelTrafficSnapshot = new ConcurrentChannelTrafficSnapshot(this.startDateTime, now, activeConnectionsByAddress, inetAddressSnapshots);
            return concurrentChannelTrafficSnapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConcurrentChannelTrafficSnapshot<CP, SP, DC> resetTransient() {
        void $this$mapValuesTo$iv$iv;
        LocalDateTime oldStart = null;
        LocalDateTime newStart = null;
        Map activeConnectionsByAddress = null;
        Map inetAddressTrafficMonitors = null;
        TrafficMonitorLock this_$iv = this.lock;
        boolean $i$f$transfer = false;
        Object lock$iv = new Object();
        this_$iv.setLock(lock$iv);
        Object object = lock$iv;
        synchronized (object) {
            boolean $i$a$-synchronized-TrafficMonitorLock$transfer$2$iv22 = false;
            try {
                boolean bl = false;
                oldStart = this.startDateTime;
                activeConnectionsByAddress = MapsKt.toMap(this.activeConnectionsByAddress);
                inetAddressTrafficMonitors = MapsKt.toMap(this.inetAddressTrafficMonitors);
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
                this.startDateTime = newStart = localDateTime;
                this.inetAddressTrafficMonitors = new ConcurrentHashMap();
            }
            finally {
                this_$iv.setLock(null);
            }
            Unit $i$a$-synchronized-TrafficMonitorLock$transfer$2$iv22 = Unit.INSTANCE;
        }
        Map $this$mapValues$iv = inetAddressTrafficMonitors;
        boolean $i$f$mapValues = false;
        object = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            InetAddressSnapshot inetAddressSnapshot = ((InetAddressTrafficMonitor)entry.getValue()).snapshot();
            map2.put(k, inetAddressSnapshot);
        }
        Map inetAddressSnapshots = destination$iv$iv;
        return new ConcurrentChannelTrafficSnapshot(oldStart, newStart, activeConnectionsByAddress, inetAddressSnapshots);
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public void unfreeze() {
        this.frozen = false;
    }

    private static final Integer incrementConnections$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer decrementConnections$lambda$3$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final InetAddressTrafficMonitor getTrafficCounter$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (InetAddressTrafficMonitor)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Enum[] access$getClientProts$p(ConcurrentChannelTrafficMonitor $this) {
        return $this.clientProts;
    }

    public static final /* synthetic */ Enum[] access$getServerProts$p(ConcurrentChannelTrafficMonitor $this) {
        return $this.serverProts;
    }

    public static final /* synthetic */ Enum[] access$getDisconnectionReasons$p(ConcurrentChannelTrafficMonitor $this) {
        return $this.disconnectionReasons;
    }
}

