/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.internal;

import com.github.michaelbull.logging.InlineLogger;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.threads.IllegalThreadAccessException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"communicationThread", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Thread;", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "warnOnError", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkCommunicationThread", "", "setCommunicationThread", "thread", "warn", "", "osrs-232-internal"})
@SourceDebugExtension(value={"SMAP\nRSProtThreadSafety.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RSProtThreadSafety.kt\nnet/rsprot/protocol/internal/RSProtThreadSafetyKt\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,59:1\n110#2,4:60\n11#3,2:64\n*S KotlinDebug\n*F\n+ 1 RSProtThreadSafety.kt\nnet/rsprot/protocol/internal/RSProtThreadSafetyKt\n*L\n35#1:60,4\n18#1:64,2\n*E\n"})
public final class RSProtThreadSafetyKt {
    @NotNull
    private static final AtomicReference<Thread> communicationThread = new AtomicReference();
    @NotNull
    private static final AtomicBoolean warnOnError = new AtomicBoolean(true);
    @NotNull
    private static final Logger logger;

    public static final void checkCommunicationThread() {
        Thread thread = communicationThread.get();
        if (thread == null) {
            return;
        }
        Thread thread2 = thread;
        if (Thread.currentThread() == thread2) {
            return;
        }
        IllegalThreadAccessException exception = new IllegalThreadAccessException("Invalid access from thread " + Thread.currentThread() + ", only " + thread2 + " allowed.");
        if (warnOnError.get()) {
            Logger arg0$iv = logger;
            boolean bl = false;
            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.warn(String.valueOf("Thread violation error"), (Throwable)exception);
            }
        } else {
            throw exception;
        }
    }

    public static final void setCommunicationThread(@Nullable Thread thread, boolean warn) {
        communicationThread.set(thread);
        warnOnError.set(warn);
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }
}

