/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.js5.Js5ChannelHandler;
import net.rsprot.protocol.api.js5.Js5MessageDecoder;
import net.rsprot.protocol.api.js5.Js5MessageEncoder;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginDisconnectionReason;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.api.metrics.ChannelTrafficHandlerExtensionsKt;
import net.rsprot.protocol.channel.ChannelExtensions;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.InitGameConnection;
import net.rsprot.protocol.loginprot.incoming.InitJs5RemoteConnection;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.IncomingLoginMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingLoginMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "channelReadComplete", "exceptionCaught", "cause", "", "handleInitGameConnection", "handleInitJs5RemoteConnection", "revision", "", "seed", "", "handlerAdded", "handlerRemoved", "userEventTriggered", "evt", "", "Companion", "osrs-232-api"})
@SourceDebugExtension(value={"SMAP\nLoginChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 ChannelExtensions.kt\nnet/rsprot/protocol/channel/ChannelExtensions\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,281:1\n20#2:282\n44#2,6:283\n52#2:293\n55#2:298\n58#2:303\n61#2:308\n64#2:313\n21#2:314\n20#2:315\n44#2,6:316\n52#2:326\n55#2:331\n58#2:336\n61#2:341\n64#2:346\n21#2:347\n20#2:348\n44#2,6:349\n52#2:359\n55#2:364\n58#2:369\n61#2:374\n64#2:379\n21#2:380\n20#2:381\n44#2,6:382\n52#2:392\n55#2:397\n58#2:402\n61#2:407\n64#2:412\n21#2:413\n20#2:414\n44#2,6:415\n52#2:425\n55#2:430\n58#2:435\n61#2:440\n64#2:445\n21#2:446\n20#2:447\n44#2,6:448\n52#2:458\n55#2:463\n58#2:468\n61#2:473\n64#2:478\n21#2:479\n20#2:480\n44#2,6:481\n52#2:491\n55#2:496\n58#2:501\n61#2:506\n64#2:511\n21#2:512\n20#2:513\n44#2,6:514\n52#2:524\n55#2:529\n58#2:534\n61#2:539\n64#2:544\n21#2:545\n20#2:546\n44#2,6:547\n52#2:557\n55#2:562\n58#2:567\n61#2:572\n64#2:577\n21#2:578\n20#2:581\n44#2,6:582\n52#2:592\n55#2:597\n58#2:602\n61#2:607\n64#2:612\n21#2:613\n20#2:614\n44#2,6:615\n52#2:625\n55#2:630\n58#2:635\n61#2:640\n64#2:645\n21#2:646\n32#3,4:289\n56#3,4:294\n80#3,4:299\n104#3,4:304\n128#3,4:309\n32#3,4:322\n56#3,4:327\n80#3,4:332\n104#3,4:337\n128#3,4:342\n32#3,4:355\n56#3,4:360\n80#3,4:365\n104#3,4:370\n128#3,4:375\n32#3,4:388\n56#3,4:393\n80#3,4:398\n104#3,4:403\n128#3,4:408\n32#3,4:421\n56#3,4:426\n80#3,4:431\n104#3,4:436\n128#3,4:441\n32#3,4:454\n56#3,4:459\n80#3,4:464\n104#3,4:469\n128#3,4:474\n32#3,4:487\n56#3,4:492\n80#3,4:497\n104#3,4:502\n128#3,4:507\n32#3,4:520\n56#3,4:525\n80#3,4:530\n104#3,4:535\n128#3,4:540\n32#3,4:553\n56#3,4:558\n80#3,4:563\n104#3,4:568\n128#3,4:573\n32#3,4:588\n56#3,4:593\n80#3,4:598\n104#3,4:603\n128#3,4:608\n32#3,4:621\n56#3,4:626\n80#3,4:631\n104#3,4:636\n128#3,4:641\n25#4:579\n25#4:580\n25#4:647\n25#4:648\n25#4:649\n25#4:650\n11#5,2:651\n*S KotlinDebug\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n*L\n48#1:282\n48#1:283,6\n48#1:293\n48#1:298\n48#1:303\n48#1:308\n48#1:313\n48#1:314\n58#1:315\n58#1:316,6\n58#1:326\n58#1:331\n58#1:336\n58#1:341\n58#1:346\n58#1:347\n96#1:348\n96#1:349,6\n96#1:359\n96#1:364\n96#1:369\n96#1:374\n96#1:379\n96#1:380\n116#1:381\n116#1:382,6\n116#1:392\n116#1:397\n116#1:402\n116#1:407\n116#1:412\n116#1:413\n156#1:414\n156#1:415,6\n156#1:425\n156#1:430\n156#1:435\n156#1:440\n156#1:445\n156#1:446\n183#1:447\n183#1:448,6\n183#1:458\n183#1:463\n183#1:468\n183#1:473\n183#1:478\n183#1:479\n262#1:480\n262#1:481,6\n262#1:491\n262#1:496\n262#1:501\n262#1:506\n262#1:511\n262#1:512\n124#1:513\n124#1:514,6\n124#1:524\n124#1:529\n124#1:534\n124#1:539\n124#1:544\n124#1:545\n133#1:546\n133#1:547,6\n133#1:557\n133#1:562\n133#1:567\n133#1:572\n133#1:577\n133#1:578\n203#1:581\n203#1:582,6\n203#1:592\n203#1:597\n203#1:602\n203#1:607\n203#1:612\n203#1:613\n212#1:614\n212#1:615,6\n212#1:625\n212#1:630\n212#1:635\n212#1:640\n212#1:645\n212#1:646\n48#1:289,4\n48#1:294,4\n48#1:299,4\n48#1:304,4\n48#1:309,4\n58#1:322,4\n58#1:327,4\n58#1:332,4\n58#1:337,4\n58#1:342,4\n96#1:355,4\n96#1:360,4\n96#1:365,4\n96#1:370,4\n96#1:375,4\n116#1:388,4\n116#1:393,4\n116#1:398,4\n116#1:403,4\n116#1:408,4\n156#1:421,4\n156#1:426,4\n156#1:431,4\n156#1:436,4\n156#1:441,4\n183#1:454,4\n183#1:459,4\n183#1:464,4\n183#1:469,4\n183#1:474,4\n262#1:487,4\n262#1:492,4\n262#1:497,4\n262#1:502,4\n262#1:507,4\n124#1:520,4\n124#1:525,4\n124#1:530,4\n124#1:535,4\n124#1:540,4\n133#1:553,4\n133#1:558,4\n133#1:563,4\n133#1:568,4\n133#1:573,4\n203#1:588,4\n203#1:593,4\n203#1:598,4\n203#1:603,4\n203#1:608,4\n212#1:621,4\n212#1:626,4\n212#1:631,4\n212#1:636,4\n212#1:641,4\n142#1:579\n143#1:580\n221#1:647\n222#1:648\n223#1:649\n224#1:650\n278#1:651,2\n*E\n"})
public final class LoginChannelHandler
extends SimpleChannelInboundHandler<IncomingLoginMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private static final Logger logger;

    public LoginChannelHandler(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingLoginMessage.class);
        this.networkService = networkService;
    }

    @NotNull
    public final NetworkService<?> getNetworkService() {
        return this.networkService;
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor().incrementConnections(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
    }

    public void handlerRemoved(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor().decrementConnections(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
        }
        ctx.fireChannelActive();
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingLoginMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
        }
        IncomingLoginMessage incomingLoginMessage = msg;
        if (Intrinsics.areEqual((Object)incomingLoginMessage, (Object)InitGameConnection.INSTANCE)) {
            this.handleInitGameConnection(ctx);
        } else if (incomingLoginMessage instanceof InitJs5RemoteConnection) {
            this.handleInitJs5RemoteConnection(ctx, ((InitJs5RemoteConnection)msg).getRevision(), ((InitJs5RemoteConnection)msg).getSeed());
        } else {
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), LoginDisconnectionReason.CHANNEL_UNKNOWN_PACKET);
            throw new IllegalStateException("Unknown login channel message: " + msg);
        }
    }

    private final void handleInitGameConnection(ChannelHandlerContext ctx) {
        String address;
        block26: {
            address = ChannelExtensions.hostAddress((ChannelHandlerContext)ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_232_api().getGameInetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_232_api().getInetAddressValidator().acceptGameConnection(address, count);
            if (accepted) break block26;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.writeAndFlush((Object)LoginResponse.TooManyAttempts.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), LoginDisconnectionReason.CHANNEL_IP_LIMIT);
            return;
        }
        long sessionId = this.networkService.getLoginHandlers$osrs_232_api().getSessionIdGenerator().generate(address);
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl13 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl14 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl15 = false;
                    logger.trace(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 3: {
                boolean bl16 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl17 = false;
                    logger.debug(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 4: {
                boolean bl18 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl19 = false;
                    logger.info(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 5: {
                boolean bl20 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl21 = false;
                    logger.warn(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 6: {
                boolean bl22 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl23 = false;
                    logger.error(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
        }
        ctx.writeAndFlush((Object)new LoginResponse.Successful(Long.valueOf(sessionId))).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitGameConnection$lambda$6(ctx, this, address, sessionId, arg_0)));
    }

    private final void handleInitJs5RemoteConnection(ChannelHandlerContext ctx, int revision, int[] seed) {
        String address;
        block28: {
            block26: {
                if (revision == 232) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                }
                ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), LoginDisconnectionReason.CHANNEL_OUT_OF_DATE);
                ctx.writeAndFlush((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            address = ChannelExtensions.hostAddress((ChannelHandlerContext)ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_232_api().getJs5InetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_232_api().getInetAddressValidator().acceptJs5Connection(address, count, seed);
            if (accepted) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.writeAndFlush((Object)LoginResponse.IPLimit.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), LoginDisconnectionReason.CHANNEL_IP_LIMIT);
            return;
        }
        ctx.writeAndFlush((Object)new LoginResponse.Successful(null)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitJs5RemoteConnection$lambda$11(ctx, this, address, arg_0)));
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_232_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), LoginDisconnectionReason.CHANNEL_EXCEPTION);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), LoginDisconnectionReason.CHANNEL_IDLE);
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }

    private static final void handleInitGameConnection$lambda$6(ChannelHandlerContext $ctx, LoginChannelHandler this$0, String $address, long $sessionId, ChannelFuture future) {
        ChannelPipeline $this$replace$iv;
        block28: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                if (future.isSuccess()) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                }
                future.channel().pipeline().fireExceptionCaught(future.cause());
                future.channel().close();
                return;
            }
            if (!$ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Tracking game INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Tracking game INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Tracking game INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Tracking game INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Tracking game INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_232_api().getGameInetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = future.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new LoginConnectionHandler(this$0.networkService, $sessionId);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)this$0.networkService.getIdleStateHandlerSuppliers().getLoginSupplier().supply();
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    private static final void handleInitJs5RemoteConnection$lambda$11(ChannelHandlerContext $ctx, LoginChannelHandler this$0, String $address, ChannelFuture future) {
        ChannelPipeline $this$replace$iv;
        block28: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                if (future.isSuccess()) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                }
                future.channel().pipeline().fireExceptionCaught(future.cause());
                future.channel().close();
                return;
            }
            if (!$ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Tracking JS5 INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Tracking JS5 INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Tracking JS5 INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Tracking JS5 INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Tracking JS5 INetAddress for channel '" + future.channel() + "': " + $address));
                    }
                    break;
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_232_api().getJs5InetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = $ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new Js5MessageDecoder(this$0.networkService);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5MessageEncoder(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5ChannelHandler(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)this$0.networkService.getIdleStateHandlerSuppliers().getJs5Supplier().supply();
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-232-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

