/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.js5.Js5Authorizer;
import net.rsprot.protocol.api.js5.Js5Client;
import net.rsprot.protocol.api.js5.Js5Configuration;
import net.rsprot.protocol.api.js5.Js5GroupProvider;
import net.rsprot.protocol.api.js5.util.UniqueQueue;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.js5.incoming.Js5GroupRequest;
import net.rsprot.protocol.js5.outgoing.Js5GroupResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011J\u0015\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u0001H\u0002J\u0016\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011J\b\u0010&\u001a\u00020\u001bH\u0016J \u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0015H\u0002J\u0006\u0010+\u001a\u00020\u001bJ\u001a\u0010,\u001a\u00020\u001b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0.H\u0081\b\u00f8\u0001\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u00020\f8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00060"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Service;", "Ljava/lang/Runnable;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "configuration", "Lnet/rsprot/protocol/api/js5/Js5Configuration;", "provider", "Lnet/rsprot/protocol/api/js5/Js5GroupProvider;", "authorizer", "Lnet/rsprot/protocol/api/js5/Js5Authorizer;", "(Lnet/rsprot/protocol/api/NetworkService;Lnet/rsprot/protocol/api/js5/Js5Configuration;Lnet/rsprot/protocol/api/js5/Js5GroupProvider;Lnet/rsprot/protocol/api/js5/Js5Authorizer;)V", "clientLock", "Ljava/lang/Object;", "getClientLock$annotations", "()V", "clients", "Lnet/rsprot/protocol/api/js5/util/UniqueQueue;", "Lnet/rsprot/protocol/api/js5/Js5Client;", "connectedClients", "Lkotlin/collections/ArrayDeque;", "isRunning", "", "lock", "getLock$annotations", "getLock", "()Ljava/lang/Object;", "notifyIfNotEmpty", "", "client", "onClientConnected", "onClientConnected$osrs_232_api", "onClientDisconnected", "onClientDisconnected$osrs_232_api", "prefetch", "push", "request", "Lnet/rsprot/protocol/js5/incoming/Js5GroupRequest;", "readIfNotFull", "run", "serveClient", "response", "Lnet/rsprot/protocol/js5/outgoing/Js5GroupResponse;", "flush", "triggerShutdown", "use", "block", "Lkotlin/Function0;", "Companion", "osrs-232-api"})
@SourceDebugExtension(value={"SMAP\nJs5Service.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,347:1\n110#2,4:348\n134#2,4:352\n134#2,4:356\n32#2,4:374\n56#2,4:379\n80#2,4:384\n104#2,4:389\n128#2,4:394\n32#2,4:413\n56#2,4:418\n80#2,4:423\n104#2,4:428\n128#2,4:433\n32#2,4:453\n56#2,4:458\n80#2,4:463\n104#2,4:468\n128#2,4:473\n32#2,4:493\n56#2,4:498\n80#2,4:503\n104#2,4:508\n128#2,4:513\n32#2,4:533\n56#2,4:538\n80#2,4:543\n104#2,4:548\n128#2,4:553\n32#2,4:573\n56#2,4:578\n80#2,4:583\n104#2,4:588\n128#2,4:593\n32#2,4:613\n56#2,4:618\n80#2,4:623\n104#2,4:628\n128#2,4:633\n36#3,14:360\n52#3:378\n55#3:383\n58#3:388\n61#3:393\n64#3:398\n36#3,14:399\n52#3:417\n55#3:422\n58#3:427\n61#3:432\n64#3:437\n37#3:438\n36#3,14:439\n52#3:457\n55#3:462\n58#3:467\n61#3:472\n64#3:477\n37#3:478\n36#3,14:479\n52#3:497\n55#3:502\n58#3:507\n61#3:512\n64#3:517\n37#3:518\n36#3,14:519\n52#3:537\n55#3:542\n58#3:547\n61#3:552\n64#3:557\n37#3:558\n36#3,14:559\n52#3:577\n55#3:582\n58#3:587\n61#3:592\n64#3:597\n37#3:598\n36#3,14:599\n52#3:617\n55#3:622\n58#3:627\n61#3:632\n64#3:637\n37#3:638\n11#4,2:639\n*S KotlinDebug\n*F\n+ 1 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n*L\n79#1:348,4\n100#1:352,4\n106#1:356,4\n164#1:374,4\n164#1:379,4\n164#1:384,4\n164#1:389,4\n164#1:394,4\n168#1:413,4\n168#1:418,4\n168#1:423,4\n168#1:428,4\n168#1:433,4\n175#1:453,4\n175#1:458,4\n175#1:463,4\n175#1:468,4\n175#1:473,4\n180#1:493,4\n180#1:498,4\n180#1:503,4\n180#1:508,4\n180#1:513,4\n189#1:533,4\n189#1:538,4\n189#1:543,4\n189#1:548,4\n189#1:553,4\n225#1:573,4\n225#1:578,4\n225#1:583,4\n225#1:588,4\n225#1:593,4\n240#1:613,4\n240#1:618,4\n240#1:623,4\n240#1:628,4\n240#1:633,4\n164#1:360,14\n164#1:378\n164#1:383\n164#1:388\n164#1:393\n164#1:398\n168#1:399,14\n168#1:417\n168#1:422\n168#1:427\n168#1:432\n168#1:437\n168#1:438\n175#1:439,14\n175#1:457\n175#1:462\n175#1:467\n175#1:472\n175#1:477\n175#1:478\n180#1:479,14\n180#1:497\n180#1:502\n180#1:507\n180#1:512\n180#1:517\n180#1:518\n189#1:519,14\n189#1:537\n189#1:542\n189#1:547\n189#1:552\n189#1:557\n189#1:558\n225#1:559,14\n225#1:577\n225#1:582\n225#1:587\n225#1:592\n225#1:597\n225#1:598\n240#1:599,14\n240#1:617\n240#1:622\n240#1:627\n240#1:632\n240#1:637\n240#1:638\n274#1:639,2\n*E\n"})
public final class Js5Service
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private final Js5Configuration configuration;
    @NotNull
    private final Js5GroupProvider provider;
    @NotNull
    private final Js5Authorizer authorizer;
    @NotNull
    private final UniqueQueue<Js5Client> clients;
    @NotNull
    private final ArrayDeque<Js5Client> connectedClients;
    @NotNull
    private final Object lock;
    @NotNull
    private final Object clientLock;
    private volatile boolean isRunning;
    public static final int BLOCK_LENGTH = 512;
    @NotNull
    private static final Logger logger;

    public Js5Service(@NotNull NetworkService<?> networkService, @NotNull Js5Configuration configuration, @NotNull Js5GroupProvider provider, @NotNull Js5Authorizer authorizer) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)authorizer, (String)"authorizer");
        this.networkService = networkService;
        this.configuration = configuration;
        this.provider = provider;
        this.authorizer = authorizer;
        this.clients = new UniqueQueue();
        this.connectedClients = new ArrayDeque();
        this.lock = new Object();
        this.clientLock = new Object();
        this.isRunning = true;
    }

    @NotNull
    public final Object getLock() {
        return this.lock;
    }

    @PublishedApi
    public static /* synthetic */ void getLock$annotations() {
    }

    private static /* synthetic */ void getClientLock$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Logger logger;
            try {
                Js5Client client = null;
                Js5GroupResponse response = null;
                boolean flush = false;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl = false;
                    while (true) {
                        if (!this.isRunning) {
                            return;
                        }
                        Js5Client next = this.clients.removeFirstOrNull();
                        if (next == null) {
                            this.lock.wait();
                            continue;
                        }
                        client = next;
                        if (!client.getCtx().channel().isActive()) continue;
                        Js5Client.ClientPriority priority = client.getPriority();
                        int ratio = priority == Js5Client.ClientPriority.HIGH ? this.configuration.getPriorityRatio() : 1;
                        try {
                            Js5GroupResponse js5GroupResponse = client.getNextBlock(this.networkService, this.authorizer, this.configuration.getMissingGroupBehaviour(), this.provider, this.configuration.getBlockSizeInBytes() * ratio);
                            if (js5GroupResponse == null) continue;
                            response = js5GroupResponse;
                        }
                        catch (Throwable t) {
                            Logger arg0$iv = Js5Service.logger;
                            boolean bl2 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                Logger logger2 = arg0$iv;
                                boolean bl3 = false;
                                logger2.warn(String.valueOf("Unable to serve channel '" + client.getCtx().channel() + "', dropping connection."), t);
                            }
                            client.getCtx().close();
                            continue;
                        }
                        break;
                    }
                    flush = client.needsFlushing(this.configuration.getFlushThresholdInBytes(), this.configuration.getFlushThresholdInRequests());
                    if (flush) {
                        client.resetTracker();
                    }
                    Unit $i$a$-synchronized-Js5Service$run$2 = Unit.INSTANCE;
                }
                try {
                    this.serveClient(client, response, flush);
                }
                catch (Throwable t) {
                    Logger arg0$iv = Js5Service.logger;
                    boolean bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                        logger = arg0$iv;
                        boolean bl4 = false;
                        logger.error(String.valueOf("Unable to serve channel " + client.getCtx().channel() + ", dropping connection."), t);
                    }
                    client.getCtx().close();
                }
            }
            catch (Throwable t) {
                Logger arg0$iv = Js5Service.logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    logger = arg0$iv;
                    boolean bl5 = false;
                    logger.error(String.valueOf("Error in JS5 service processing - JS5 service has been killed."), t);
                }
                throw t;
            }
        }
    }

    private final Runnable prefetch() {
        return () -> Js5Service.prefetch$lambda$6(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onClientConnected$osrs_232_api(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.connectedClients).add(client);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onClientDisconnected$osrs_232_api(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.connectedClients).remove(client);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void serveClient(Js5Client client, Js5GroupResponse response, boolean flush) {
        ChannelHandlerContext ctx;
        block70: {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            Logger logger;
            boolean bl5;
            ctx = client.getCtx();
            ctx.write((Object)response);
            Logger logger$iv = Js5Service.logger;
            boolean bl6 = false;
            LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
            boolean bl7 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl8;
                    bl5 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.trace(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
                case 3: {
                    boolean bl8;
                    bl4 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.debug(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
                case 4: {
                    boolean bl8;
                    bl3 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.info(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
                case 5: {
                    boolean bl8;
                    bl2 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.warn(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
                case 6: {
                    boolean bl8;
                    bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl8 = false;
                        logger.error(String.valueOf("Serving channel '" + ctx.channel() + "' with response: " + response));
                    }
                    break;
                }
            }
            if (!flush) break block70;
            logger$iv = Js5Service.logger;
            bl6 = false;
            level$iv$iv = RSProtFlags.getJs5Logging();
            bl7 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl9;
                    bl5 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.trace(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl9;
                    bl4 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.debug(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl9;
                    bl3 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.info(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9;
                    bl2 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.warn(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl9;
                    bl = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        bl9 = false;
                        logger.error(String.valueOf("Flushing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.flush();
        }
        Object object = this.lock;
        synchronized (object) {
            Logger logger;
            block74: {
                boolean bl;
                boolean bl10;
                boolean bl11;
                boolean bl12;
                boolean bl13;
                boolean bl14;
                boolean bl15;
                Logger logger$iv;
                block72: {
                    boolean bl16 = false;
                    if (flush && !client.isReady()) break block72;
                    logger$iv = Js5Service.logger;
                    bl15 = false;
                    LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                    bl14 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl17;
                            bl13 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.trace(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl17;
                            bl12 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.debug(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl17;
                            bl11 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.info(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl17;
                            bl10 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.warn(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl17;
                            bl = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                logger = logger$iv;
                                bl17 = false;
                                logger.error(String.valueOf("Continuing to serve channel " + ctx.channel()));
                            }
                            break;
                        }
                    }
                    this.clients.add(client);
                    break block74;
                }
                logger$iv = Js5Service.logger;
                bl15 = false;
                LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                bl14 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl18;
                        bl13 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.trace(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl18;
                        bl12 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.debug(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl18;
                        bl11 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.info(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl18;
                        bl10 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.warn(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl18;
                        bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            logger = logger$iv;
                            bl18 = false;
                            logger.error(String.valueOf("No longer serving channel " + ctx.channel()));
                        }
                        break;
                    }
                }
            }
            boolean notFull = client.isNotFull();
            if (notFull) {
                ctx.read();
            }
            Logger logger$iv = Js5Service.logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
            boolean bl19 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl20 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl21 = false;
                        logger.trace(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl22 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl23 = false;
                        logger.debug(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl24 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl25 = false;
                        logger.info(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl26 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl27 = false;
                        logger.warn(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl28 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl29 = false;
                        logger.error(String.valueOf("Reading further JS5 requests from channel " + ctx.channel()));
                    }
                    break;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void push(@NotNull Js5Client client, @NotNull Js5GroupRequest request) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            client.push(request);
            if (client.isReady()) {
                this.clients.add(client);
                this.lock.notifyAll();
            }
            if (client.isNotFull()) {
                client.getCtx().read();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readIfNotFull(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.lock;
        synchronized (object) {
            block16: {
                boolean bl = false;
                if (!client.isNotFull()) break block16;
                Logger logger$iv = logger;
                boolean bl2 = false;
                LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                boolean bl3 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl4 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl5 = false;
                            logger.trace(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl6 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl7 = false;
                            logger.debug(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl8 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl9 = false;
                            logger.info(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl10 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl11 = false;
                            logger.warn(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl12 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl13 = false;
                            logger.error(String.valueOf("Reading further JS5 requests from channel " + client.getCtx().channel()));
                        }
                        break;
                    }
                }
                client.getCtx().read();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyIfNotEmpty(@NotNull Js5Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object object = this.lock;
        synchronized (object) {
            block16: {
                boolean bl = false;
                if (!client.isNotEmpty()) break block16;
                Logger logger$iv = logger;
                boolean bl2 = false;
                LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                boolean bl3 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl4 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl5 = false;
                            logger.trace(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl6 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl7 = false;
                            logger.debug(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl8 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl9 = false;
                            logger.info(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl10 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl11 = false;
                            logger.warn(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl12 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl13 = false;
                            logger.error(String.valueOf("Channel '" + client.getCtx().channel() + "' is now writable, continuing to serve JS5 requests."));
                        }
                        break;
                    }
                }
                this.clients.add(client);
                this.lock.notifyAll();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublishedApi
    public final void use(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$use = false;
        Object object = this.getLock();
        synchronized (object) {
            try {
                boolean bl = false;
                block.invoke();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                InlineMarker.finallyEnd((int)1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void triggerShutdown() {
        this.isRunning = false;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void prefetch$lambda$6(Js5Service this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.clientLock;
        synchronized (object) {
            boolean bl = false;
            for (Js5Client client : this$0.connectedClients) {
                Object object2 = this$0.lock;
                synchronized (object2) {
                    boolean bl2 = false;
                    if (client.transferPrefetch$osrs_232_api(this$0.provider, this$0.configuration.getPrefetchTransferThresholdInBytes())) {
                        this$0.clients.add(client);
                        this$0.lock.notifyAll();
                        if (client.isNotFull()) {
                            client.getCtx().read();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Service$Companion;", "", "()V", "BLOCK_LENGTH", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "ensureCorrectlySliced", "", "buffer", "Lio/netty/buffer/ByteBuf;", "ensureCorrectlySliced$osrs_232_api", "prepareJs5Buffer", "", "archive", "group", "input", "output", "startPrefetching", "Ljava/util/concurrent/ScheduledExecutorService;", "service", "Lnet/rsprot/protocol/api/js5/Js5Service;", "osrs-232-api"})
    public static final class Companion {
        private Companion() {
        }

        public final void prepareJs5Buffer(int archive, int group, @NotNull ByteBuf input, @NotNull ByteBuf output) {
            int nextBlockLength;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            int readableBytes = input.readableBytes();
            output.writeByte(archive);
            output.writeShort(group);
            int len = Math.min(readableBytes, 509);
            output.writeBytes(input, 0, len);
            for (int offset = len; offset < readableBytes; offset += nextBlockLength) {
                output.writeByte(255);
                nextBlockLength = Math.min(readableBytes - offset, 511);
                output.writeBytes(input, offset, nextBlockLength);
            }
        }

        public final boolean ensureCorrectlySliced$osrs_232_api(@NotNull ByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int cap = buffer.readableBytes();
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)512, (int)cap)), (int)512);
            int i = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                while (true) {
                    if ((buffer.getByte(i) & 0xFF) != 255) {
                        return false;
                    }
                    if (i == n) break;
                    i += n2;
                }
            }
            return true;
        }

        @NotNull
        public final ScheduledExecutorService startPrefetching(@NotNull Js5Service service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            ScheduledExecutorService executor2 = Executors.newSingleThreadScheduledExecutor(Companion::startPrefetching$lambda$0);
            executor2.scheduleWithFixedDelay(service.prefetch(), 200L, 200L, TimeUnit.MILLISECONDS);
            Intrinsics.checkNotNull((Object)executor2);
            return executor2;
        }

        private static final Thread startPrefetching$lambda$0(Runnable block) {
            return ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Js5 Executor Service (prefetch)", (int)0, (Function0)((Function0)new Function0<Unit>(block){
                final /* synthetic */ Runnable $block;
                {
                    this.$block = $block;
                    super(0);
                }

                public final void invoke() {
                    this.$block.run();
                }
            }), (int)22, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

