/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.incoming.events;

import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ClientProtCategory;
import net.rsprot.protocol.game.incoming.GameClientProtCategory;
import net.rsprot.protocol.message.IncomingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/protocol/game/incoming/events/EventKeyboard;", "Lnet/rsprot/protocol/message/IncomingGameMessage;", "lastTransmittedKeyPress", "", "keysPressed", "Lnet/rsprot/protocol/game/incoming/events/EventKeyboard$KeySequence;", "(ILnet/rsprot/protocol/game/incoming/events/EventKeyboard$KeySequence;)V", "category", "Lnet/rsprot/protocol/ClientProtCategory;", "getCategory", "()Lnet/rsprot/protocol/ClientProtCategory;", "getKeysPressed", "()Lnet/rsprot/protocol/game/incoming/events/EventKeyboard$KeySequence;", "getLastTransmittedKeyPress", "()I", "equals", "", "other", "", "hashCode", "toString", "", "KeySequence", "osrs-231-model"})
public final class EventKeyboard
implements IncomingGameMessage {
    private final int lastTransmittedKeyPress;
    @NotNull
    private final KeySequence keysPressed;

    public EventKeyboard(int lastTransmittedKeyPress, @NotNull KeySequence keysPressed) {
        Intrinsics.checkNotNullParameter((Object)keysPressed, (String)"keysPressed");
        this.lastTransmittedKeyPress = lastTransmittedKeyPress;
        this.keysPressed = keysPressed;
    }

    public final int getLastTransmittedKeyPress() {
        return this.lastTransmittedKeyPress;
    }

    @NotNull
    public final KeySequence getKeysPressed() {
        return this.keysPressed;
    }

    @NotNull
    public ClientProtCategory getCategory() {
        return GameClientProtCategory.CLIENT_EVENT;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.events.EventKeyboard");
        EventKeyboard cfr_ignored_0 = (EventKeyboard)other;
        if (this.lastTransmittedKeyPress != ((EventKeyboard)other).lastTransmittedKeyPress) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keysPressed, (Object)((EventKeyboard)other).keysPressed);
    }

    public int hashCode() {
        int result = this.lastTransmittedKeyPress;
        result = 31 * result + this.keysPressed.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "EventKeyboard(lastTransmittedKeyPress=" + this.lastTransmittedKeyPress + ", keysPressed=" + this.keysPressed + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lnet/rsprot/protocol/game/incoming/events/EventKeyboard$KeySequence;", "", "array", "", "([B)V", "length", "", "getLength", "()I", "asByteArray", "getAwtKey", "index", "getAwtKeyText", "", "getJagexKey", "toAwtKeyCodeIntArray", "", "toIntArray", "Companion", "osrs-231-model"})
    public static final class KeySequence {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] array;
        @NotNull
        private static final int[] awtToJagexKeyCodes;
        @NotNull
        private static final int[] jagexToAwtKeyCodes;

        public KeySequence(@NotNull byte[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.array = array;
        }

        public final int getLength() {
            return this.array.length;
        }

        @NotNull
        public final byte[] asByteArray() {
            return this.array;
        }

        @NotNull
        public final int[] toIntArray() {
            int n = 0;
            int n2 = this.getLength();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = this.getJagexKey(n3);
            }
            return nArray;
        }

        @NotNull
        public final int[] toAwtKeyCodeIntArray() {
            int n = 0;
            int n2 = this.getLength();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = this.getAwtKey(n3);
            }
            return nArray;
        }

        public final int getJagexKey(int index) throws ArrayIndexOutOfBoundsException {
            int code = this.array[index] & 0xFF;
            return code == 255 ? -1 : code;
        }

        public final int getAwtKey(int index) throws ArrayIndexOutOfBoundsException {
            int jagexKey = this.getJagexKey(index);
            return jagexKey == -1 ? -1 : jagexToAwtKeyCodes[jagexKey];
        }

        @Nullable
        public final String getAwtKeyText(int index) throws ArrayIndexOutOfBoundsException {
            int keyCode = this.getAwtKey(index);
            return keyCode == -1 ? null : KeyEvent.getKeyText(keyCode);
        }

        static {
            int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 85, 80, 84, -1, 91, -1, -1, -1, 81, 82, 86, -1, -1, -1, -1, -1, -1, -1, -1, 13, -1, -1, -1, -1, 83, 104, 105, 103, 102, 96, 98, 97, 99, -1, -1, -1, -1, -1, -1, -1, 25, 16, 17, 18, 19, 20, 21, 22, 23, 24, -1, -1, -1, -1, -1, -1, -1, 48, 68, 66, 50, 34, 51, 52, 53, 39, 54, 55, 56, 70, 69, 40, 41, 32, 35, 49, 36, 38, 67, 33, 65, 37, 64, -1, -1, -1, -1, -1, 228, 231, 227, 233, 224, 219, 225, 230, 226, 232, 89, 87, -1, 88, 229, 90, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, -1, -1, -1, 101, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 100, -1, 87};
            awtToJagexKeyCodes = nArray;
            jagexToAwtKeyCodes = KeySequence.Companion.buildJagexToAwtKeyCodesArray();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/rsprot/protocol/game/incoming/events/EventKeyboard$KeySequence$Companion;", "", "()V", "awtToJagexKeyCodes", "", "jagexToAwtKeyCodes", "buildJagexToAwtKeyCodesArray", "osrs-231-model"})
        private static final class Companion {
            private Companion() {
            }

            private final int[] buildJagexToAwtKeyCodesArray() {
                int n;
                int n2 = 0;
                int[] nArray = new int[256];
                while (n2 < 256) {
                    n = n2++;
                    nArray[n] = -1;
                }
                int[] keys = nArray;
                int[] nArray2 = awtToJagexKeyCodes;
                n = nArray2.length;
                for (int i = 0; i < n; ++i) {
                    int index = i;
                    int keycode = nArray2[i];
                    if (keycode == -1) continue;
                    keys[keycode] = index;
                }
                return keys;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

