/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.bootstrap;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;
import java.lang.invoke.MethodHandles;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.bootstrap.BootstrapBuilder;
import net.rsprot.protocol.api.handlers.OutgoingMessageSizeEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 42\u00020\u0001:\u0003345B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ-\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006J\b\u0010\u001f\u001a\u00020\u0006H\u0002J\b\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"H\u0002J\u001f\u0010\t\u001a\u00020\u00002\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020)2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010+H\u0002J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0006J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0010J\u0016\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u00066"}, d2={"Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder;", "", "()V", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "bossThreadCount", "", "Ljava/lang/Integer;", "childThreadCount", "eventLoopGroupTypes", "", "Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$EventLoopGroupType;", "[Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$EventLoopGroupType;", "soRcvBufSize", "soSndBufSize", "tcpNoDelay", "", "Ljava/lang/Boolean;", "writeBufferWatermarkHigh", "writeBufferWatermarkLow", "alloc", "threadCount", "build", "Lio/netty/bootstrap/ServerBootstrap;", "estimator", "Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;", "build$osrs_230_api", "buildEventLoopGroups", "Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$BuildEventLoopGroupsResult;", "groupTypes", "(II[Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$EventLoopGroupType;)Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$BuildEventLoopGroupsResult;", "determineBossThreadCount", "determineChildThreadCount", "determineSocketChannel", "Ljava/lang/Class;", "Lio/netty/channel/ServerChannel;", "types", "([Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$EventLoopGroupType;)Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder;", "getEventLoopGroupTypes", "()[Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$EventLoopGroupType;", "log", "", "msg", "Lkotlin/Function0;", "socketReceiveBufferSize", "numBytes", "socketSendBufferSize", "value", "writeBufferWatermark", "numLowBytes", "numHighBytes", "BuildEventLoopGroupsResult", "Companion", "EventLoopGroupType", "osrs-230-api"})
@SourceDebugExtension(value={"SMAP\nBootstrapBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BootstrapBuilder.kt\nnet/rsprot/protocol/api/bootstrap/BootstrapBuilder\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,357:1\n134#2,4:358\n56#2,4:362\n11#3,2:366\n*S KotlinDebug\n*F\n+ 1 BootstrapBuilder.kt\nnet/rsprot/protocol/api/bootstrap/BootstrapBuilder\n*L\n279#1:358,4\n350#1:362,4\n354#1:366,2\n*E\n"})
public final class BootstrapBuilder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private ByteBufAllocator allocator;
    @Nullable
    private Integer bossThreadCount;
    @Nullable
    private Integer childThreadCount;
    @Nullable
    private Integer soRcvBufSize;
    @Nullable
    private Integer soSndBufSize;
    @Nullable
    private Integer writeBufferWatermarkLow;
    @Nullable
    private Integer writeBufferWatermarkHigh;
    @Nullable
    private Boolean tcpNoDelay;
    @Nullable
    private EventLoopGroupType[] eventLoopGroupTypes;
    @NotNull
    private static final Logger logger;

    @NotNull
    public final BootstrapBuilder allocator(@NotNull ByteBufAllocator alloc) {
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        this.allocator = alloc;
        return this;
    }

    @NotNull
    public final BootstrapBuilder bossThreadCount(int threadCount) {
        this.bossThreadCount = threadCount;
        return this;
    }

    @NotNull
    public final BootstrapBuilder childThreadCount(int threadCount) {
        this.childThreadCount = threadCount;
        return this;
    }

    @NotNull
    public final BootstrapBuilder socketReceiveBufferSize(int numBytes) {
        this.soRcvBufSize = numBytes;
        return this;
    }

    @NotNull
    public final BootstrapBuilder socketSendBufferSize(int numBytes) {
        this.soSndBufSize = numBytes;
        return this;
    }

    @NotNull
    public final BootstrapBuilder writeBufferWatermark(int numLowBytes, int numHighBytes) {
        this.writeBufferWatermarkLow = numLowBytes;
        this.writeBufferWatermarkHigh = numHighBytes;
        return this;
    }

    @NotNull
    public final BootstrapBuilder tcpNoDelay(boolean value) {
        this.tcpNoDelay = value;
        return this;
    }

    @NotNull
    public final BootstrapBuilder eventLoopGroupTypes(EventLoopGroupType ... types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        this.eventLoopGroupTypes = types;
        return this;
    }

    private final EventLoopGroupType[] getEventLoopGroupTypes() {
        EventLoopGroupType[] types = this.eventLoopGroupTypes;
        if (types != null) {
            return types;
        }
        EventLoopGroupType[] eventLoopGroupTypeArray = new EventLoopGroupType[]{EventLoopGroupType.IOURING, EventLoopGroupType.EPOLL, EventLoopGroupType.KQUEUE, EventLoopGroupType.NIO};
        return eventLoopGroupTypeArray;
    }

    private final int determineBossThreadCount() {
        Integer n = this.bossThreadCount;
        return n != null ? n : 1;
    }

    private final int determineChildThreadCount() {
        Integer overwrittenCount = this.childThreadCount;
        if (overwrittenCount != null) {
            return overwrittenCount;
        }
        int cores = Runtime.getRuntime().availableProcessors();
        int physicalThreads = cores * 2;
        return Math.max(1, physicalThreads - 2);
    }

    private final BuildEventLoopGroupsResult buildEventLoopGroups(int bossThreadCount, int childThreadCount, EventLoopGroupType[] groupTypes) {
        int n = groupTypes.length;
        block8: for (int i = 0; i < n; ++i) {
            EventLoopGroupType type = groupTypes[i];
            try {
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        if (!IoUring.isAvailable()) continue block8;
                        IoHandlerFactory factory = IoUringIoHandler.newFactory();
                        MultiThreadIoEventLoopGroup boss = new MultiThreadIoEventLoopGroup(bossThreadCount, factory);
                        MultiThreadIoEventLoopGroup child = new MultiThreadIoEventLoopGroup(childThreadCount, factory);
                        Intrinsics.checkNotNull((Object)factory);
                        return new BuildEventLoopGroupsResult(factory, (EventLoopGroup)boss, (EventLoopGroup)child);
                    }
                    case 2: {
                        if (!Epoll.isAvailable()) continue block8;
                        IoHandlerFactory factory = EpollIoHandler.newFactory();
                        MultiThreadIoEventLoopGroup boss = new MultiThreadIoEventLoopGroup(bossThreadCount, factory);
                        MultiThreadIoEventLoopGroup child = new MultiThreadIoEventLoopGroup(childThreadCount, factory);
                        Intrinsics.checkNotNull((Object)factory);
                        return new BuildEventLoopGroupsResult(factory, (EventLoopGroup)boss, (EventLoopGroup)child);
                    }
                    case 3: {
                        if (!KQueue.isAvailable()) continue block8;
                        IoHandlerFactory factory = KQueueIoHandler.newFactory();
                        MultiThreadIoEventLoopGroup boss = new MultiThreadIoEventLoopGroup(bossThreadCount, factory);
                        MultiThreadIoEventLoopGroup child = new MultiThreadIoEventLoopGroup(childThreadCount, factory);
                        Intrinsics.checkNotNull((Object)factory);
                        return new BuildEventLoopGroupsResult(factory, (EventLoopGroup)boss, (EventLoopGroup)child);
                    }
                    case 4: {
                        IoHandlerFactory factory = NioIoHandler.newFactory();
                        MultiThreadIoEventLoopGroup boss = new MultiThreadIoEventLoopGroup(bossThreadCount, factory);
                        MultiThreadIoEventLoopGroup child = new MultiThreadIoEventLoopGroup(childThreadCount, factory);
                        Intrinsics.checkNotNull((Object)factory);
                        return new BuildEventLoopGroupsResult(factory, (EventLoopGroup)boss, (EventLoopGroup)child);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (!InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) continue;
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.error(String.valueOf("Unable to create " + type + " event group type."), t);
            }
        }
        EventLoopGroupType[] eventLoopGroupTypeArray = groupTypes;
        throw new IllegalStateException("No event loop groups are available in " + ArraysKt.contentDeepToString((Object[])eventLoopGroupTypeArray));
    }

    private final Class<? extends ServerChannel> determineSocketChannel() {
        return IoUring.isAvailable() ? IoUringServerSocketChannel.class : (Epoll.isAvailable() ? EpollServerSocketChannel.class : (KQueue.isAvailable() ? KQueueServerSocketChannel.class : NioServerSocketChannel.class));
    }

    @NotNull
    public final ServerBootstrap build$osrs_230_api(@NotNull OutgoingMessageSizeEstimator estimator) {
        Intrinsics.checkNotNullParameter((Object)estimator, (String)"estimator");
        ServerBootstrap bootstrap = new ServerBootstrap();
        EventLoopGroupType[] groupTypes = this.getEventLoopGroupTypes();
        int bossThreadCount = this.determineBossThreadCount();
        int childThreadCount = this.determineChildThreadCount();
        BuildEventLoopGroupsResult buildEventLoopGroupsResult = this.buildEventLoopGroups(bossThreadCount, childThreadCount, groupTypes);
        IoHandlerFactory factory = buildEventLoopGroupsResult.component1();
        EventLoopGroup bossGroup = buildEventLoopGroupsResult.component2();
        EventLoopGroup childGroup = buildEventLoopGroupsResult.component3();
        Class<? extends ServerChannel> channel = this.determineSocketChannel();
        this.log((Function0<? extends Object>)((Function0)new Function0<Object>(factory, bossThreadCount, childThreadCount){
            final /* synthetic */ IoHandlerFactory $factory;
            final /* synthetic */ int $bossThreadCount;
            final /* synthetic */ int $childThreadCount;
            {
                this.$factory = $factory;
                this.$bossThreadCount = $bossThreadCount;
                this.$childThreadCount = $childThreadCount;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Using IO handler factory: " + this.$factory.getClass().getSimpleName() + " (bossThreads: " + this.$bossThreadCount + ", childThreads: " + this.$childThreadCount + ")";
            }
        }));
        bootstrap.group(bossGroup, childGroup);
        bootstrap.channel(channel);
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        ByteBufAllocator byteBufAllocator = this.allocator;
        if (byteBufAllocator == null) {
            byteBufAllocator = ByteBufAllocator.DEFAULT;
        }
        ByteBufAllocator allocator = byteBufAllocator;
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)allocator);
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        allocator.isDirectBufferPooled();
        this.log((Function0<? extends Object>)((Function0)new Function0<Object>(allocator){
            final /* synthetic */ ByteBufAllocator $allocator;
            {
                this.$allocator = $allocator;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Using byte buffer allocator: " + this.$allocator;
            }
        }));
        bootstrap.childOption(ChannelOption.AUTO_READ, (Object)false);
        this.log((Function0<? extends Object>)((Function0)build.3.INSTANCE));
        Integer n = this.soRcvBufSize;
        int soRcvBufSize = n != null ? n : 65536;
        bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)soRcvBufSize);
        this.log((Function0<? extends Object>)((Function0)new Function0<Object>(formatter, soRcvBufSize){
            final /* synthetic */ NumberFormat $formatter;
            final /* synthetic */ int $soRcvBufSize;
            {
                this.$formatter = $formatter;
                this.$soRcvBufSize = $soRcvBufSize;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Socket receive buffer size: " + this.$formatter.format((Object)this.$soRcvBufSize);
            }
        }));
        Integer n2 = this.soSndBufSize;
        int soSndBufSize = n2 != null ? n2 : 65536;
        bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)soSndBufSize);
        this.log((Function0<? extends Object>)((Function0)new Function0<Object>(formatter, soSndBufSize){
            final /* synthetic */ NumberFormat $formatter;
            final /* synthetic */ int $soSndBufSize;
            {
                this.$formatter = $formatter;
                this.$soSndBufSize = $soSndBufSize;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Socket send buffer size: " + this.$formatter.format((Object)this.$soSndBufSize);
            }
        }));
        Integer n3 = this.writeBufferWatermarkLow;
        int lowWatermark = n3 != null ? n3 : 524288;
        Integer n4 = this.writeBufferWatermarkHigh;
        int highWatermark = n4 != null ? n4 : 0x200000;
        bootstrap.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(lowWatermark, highWatermark));
        this.log((Function0<? extends Object>)((Function0)new Function0<Object>(formatter, lowWatermark, highWatermark){
            final /* synthetic */ NumberFormat $formatter;
            final /* synthetic */ int $lowWatermark;
            final /* synthetic */ int $highWatermark;
            {
                this.$formatter = $formatter;
                this.$lowWatermark = $lowWatermark;
                this.$highWatermark = $highWatermark;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Write buffer watermarks: " + this.$formatter.format((Object)this.$lowWatermark) + "/" + this.$formatter.format((Object)this.$highWatermark);
            }
        }));
        boolean tcpNoDelay = !Intrinsics.areEqual((Object)this.tcpNoDelay, (Object)false);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)tcpNoDelay);
        this.log((Function0<? extends Object>)((Function0)new Function0<Object>(tcpNoDelay){
            final /* synthetic */ boolean $tcpNoDelay;
            {
                this.$tcpNoDelay = $tcpNoDelay;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Nagle's algorithm (TCP no delay): " + (this.$tcpNoDelay ? "disabled" : "enabled");
            }
        }));
        bootstrap.childOption(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)estimator);
        return bootstrap;
    }

    private final void log(Function0<? extends Object> msg) {
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
            arg0$iv.debug(String.valueOf(msg.invoke()));
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$BuildEventLoopGroupsResult;", "", "factory", "Lio/netty/channel/IoHandlerFactory;", "bossGroup", "Lio/netty/channel/EventLoopGroup;", "childGroup", "(Lio/netty/channel/IoHandlerFactory;Lio/netty/channel/EventLoopGroup;Lio/netty/channel/EventLoopGroup;)V", "getBossGroup", "()Lio/netty/channel/EventLoopGroup;", "getChildGroup", "getFactory", "()Lio/netty/channel/IoHandlerFactory;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "osrs-230-api"})
    private static final class BuildEventLoopGroupsResult {
        @NotNull
        private final IoHandlerFactory factory;
        @NotNull
        private final EventLoopGroup bossGroup;
        @NotNull
        private final EventLoopGroup childGroup;

        public BuildEventLoopGroupsResult(@NotNull IoHandlerFactory factory, @NotNull EventLoopGroup bossGroup, @NotNull EventLoopGroup childGroup) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)bossGroup, (String)"bossGroup");
            Intrinsics.checkNotNullParameter((Object)childGroup, (String)"childGroup");
            this.factory = factory;
            this.bossGroup = bossGroup;
            this.childGroup = childGroup;
        }

        @NotNull
        public final IoHandlerFactory getFactory() {
            return this.factory;
        }

        @NotNull
        public final EventLoopGroup getBossGroup() {
            return this.bossGroup;
        }

        @NotNull
        public final EventLoopGroup getChildGroup() {
            return this.childGroup;
        }

        @NotNull
        public final IoHandlerFactory component1() {
            return this.factory;
        }

        @NotNull
        public final EventLoopGroup component2() {
            return this.bossGroup;
        }

        @NotNull
        public final EventLoopGroup component3() {
            return this.childGroup;
        }

        @NotNull
        public final BuildEventLoopGroupsResult copy(@NotNull IoHandlerFactory factory, @NotNull EventLoopGroup bossGroup, @NotNull EventLoopGroup childGroup) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)bossGroup, (String)"bossGroup");
            Intrinsics.checkNotNullParameter((Object)childGroup, (String)"childGroup");
            return new BuildEventLoopGroupsResult(factory, bossGroup, childGroup);
        }

        public static /* synthetic */ BuildEventLoopGroupsResult copy$default(BuildEventLoopGroupsResult buildEventLoopGroupsResult, IoHandlerFactory ioHandlerFactory, EventLoopGroup eventLoopGroup, EventLoopGroup eventLoopGroup2, int n, Object object) {
            if ((n & 1) != 0) {
                ioHandlerFactory = buildEventLoopGroupsResult.factory;
            }
            if ((n & 2) != 0) {
                eventLoopGroup = buildEventLoopGroupsResult.bossGroup;
            }
            if ((n & 4) != 0) {
                eventLoopGroup2 = buildEventLoopGroupsResult.childGroup;
            }
            return buildEventLoopGroupsResult.copy(ioHandlerFactory, eventLoopGroup, eventLoopGroup2);
        }

        @NotNull
        public String toString() {
            return "BuildEventLoopGroupsResult(factory=" + this.factory + ", bossGroup=" + this.bossGroup + ", childGroup=" + this.childGroup + ")";
        }

        public int hashCode() {
            int result = this.factory.hashCode();
            result = result * 31 + this.bossGroup.hashCode();
            result = result * 31 + this.childGroup.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BuildEventLoopGroupsResult)) {
                return false;
            }
            BuildEventLoopGroupsResult buildEventLoopGroupsResult = (BuildEventLoopGroupsResult)other;
            if (!Intrinsics.areEqual((Object)this.factory, (Object)buildEventLoopGroupsResult.factory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bossGroup, (Object)buildEventLoopGroupsResult.bossGroup)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.childGroup, (Object)buildEventLoopGroupsResult.childGroup);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-230-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder$EventLoopGroupType;", "", "(Ljava/lang/String;I)V", "IOURING", "EPOLL", "KQUEUE", "NIO", "osrs-230-api"})
    public static final class EventLoopGroupType
    extends Enum<EventLoopGroupType> {
        public static final /* enum */ EventLoopGroupType IOURING = new EventLoopGroupType();
        public static final /* enum */ EventLoopGroupType EPOLL = new EventLoopGroupType();
        public static final /* enum */ EventLoopGroupType KQUEUE = new EventLoopGroupType();
        public static final /* enum */ EventLoopGroupType NIO = new EventLoopGroupType();
        private static final /* synthetic */ EventLoopGroupType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EventLoopGroupType[] values() {
            return (EventLoopGroupType[])$VALUES.clone();
        }

        public static EventLoopGroupType valueOf(String value) {
            return Enum.valueOf(EventLoopGroupType.class, value);
        }

        @NotNull
        public static EnumEntries<EventLoopGroupType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = eventLoopGroupTypeArray = new EventLoopGroupType[]{EventLoopGroupType.IOURING, EventLoopGroupType.EPOLL, EventLoopGroupType.KQUEUE, EventLoopGroupType.NIO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventLoopGroupType.values().length];
            try {
                nArray[EventLoopGroupType.IOURING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventLoopGroupType.EPOLL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventLoopGroupType.KQUEUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventLoopGroupType.NIO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

