/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.protocol.ClientProt;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.decoder.DecoderState;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.message.codec.MessageDecoder;
import net.rsprot.protocol.message.codec.incoming.MessageDecoderRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/rsprot/protocol/api/login/LoginMessageDecoder;", "Lio/netty/handler/codec/ByteToMessageDecoder;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "decoder", "Lnet/rsprot/protocol/message/codec/MessageDecoder;", "decoders", "Lnet/rsprot/protocol/message/codec/incoming/MessageDecoderRepository;", "Lnet/rsprot/protocol/ClientProt;", "length", "", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "opcode", "state", "Lnet/rsprot/protocol/api/decoder/DecoderState;", "decode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "input", "Lio/netty/buffer/ByteBuf;", "out", "", "", "Companion", "osrs-230-api"})
@SourceDebugExtension(value={"SMAP\nLoginMessageDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginMessageDecoder.kt\nnet/rsprot/protocol/api/login/LoginMessageDecoder\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,125:1\n20#2:126\n44#2,6:127\n52#2:137\n55#2:142\n58#2:147\n61#2:152\n64#2:157\n21#2:158\n32#3,4:133\n56#3,4:138\n80#3,4:143\n104#3,4:148\n128#3,4:153\n11#4,2:159\n*S KotlinDebug\n*F\n+ 1 LoginMessageDecoder.kt\nnet/rsprot/protocol/api/login/LoginMessageDecoder\n*L\n50#1:126\n50#1:127,6\n50#1:137\n50#1:142\n50#1:147\n50#1:152\n50#1:157\n50#1:158\n50#1:133,4\n50#1:138,4\n50#1:143,4\n50#1:148,4\n50#1:153,4\n122#1:159,2\n*E\n"})
public final class LoginMessageDecoder
extends ByteToMessageDecoder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private final MessageDecoderRepository<ClientProt> decoders;
    @NotNull
    private DecoderState state;
    private MessageDecoder<?> decoder;
    private int opcode;
    private int length;
    @NotNull
    private static final Logger logger;

    public LoginMessageDecoder(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        this.networkService = networkService;
        this.decoders = this.networkService.getDecoderRepositories$osrs_230_api().getLoginMessageDecoderRepository();
        this.state = DecoderState.READ_OPCODE;
        this.opcode = -1;
    }

    @NotNull
    public final NetworkService<?> getNetworkService() {
        return this.networkService;
    }

    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf input, @NotNull List<Object> out) {
        block28: {
            block29: {
                MessageDecoder decoder;
                block30: {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                    Intrinsics.checkNotNullParameter(out, (String)"out");
                    if (this.state != DecoderState.READ_OPCODE) break block28;
                    if (!input.isReadable()) {
                        return;
                    }
                    if (!this.networkService.getLoginHandlers$osrs_230_api().getSuppressInvalidLoginProts()) break block29;
                    this.opcode = JagexByteBufExtensionsKt.g1((ByteBuf)input) & 0xFF;
                    decoder = this.decoders.getDecoderOrNull(this.opcode);
                    if (decoder != null) break block30;
                    Logger logger$iv = logger;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl2 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl3 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl4 = false;
                                logger.trace(String.valueOf("Invalid login packet from channel " + ctx.channel() + "': " + this.opcode));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl5 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl6 = false;
                                logger.debug(String.valueOf("Invalid login packet from channel " + ctx.channel() + "': " + this.opcode));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl7 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl8 = false;
                                logger.info(String.valueOf("Invalid login packet from channel " + ctx.channel() + "': " + this.opcode));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl9 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl10 = false;
                                logger.warn(String.valueOf("Invalid login packet from channel " + ctx.channel() + "': " + this.opcode));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl11 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl12 = false;
                                logger.error(String.valueOf("Invalid login packet from channel " + ctx.channel() + "': " + this.opcode));
                            }
                            break;
                        }
                    }
                    ctx.close();
                    return;
                }
                this.decoder = decoder;
                MessageDecoder<?> messageDecoder = this.decoder;
                if (messageDecoder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                    messageDecoder = null;
                }
                this.length = messageDecoder.getProt().getSize();
                this.state = this.length >= 0 ? DecoderState.READ_PAYLOAD : DecoderState.READ_LENGTH;
                break block28;
            }
            this.opcode = JagexByteBufExtensionsKt.g1((ByteBuf)input) & 0xFF;
            this.decoder = this.decoders.getDecoder(this.opcode);
            MessageDecoder<?> messageDecoder = this.decoder;
            if (messageDecoder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                messageDecoder = null;
            }
            this.length = messageDecoder.getProt().getSize();
            DecoderState decoderState = this.state = this.length >= 0 ? DecoderState.READ_PAYLOAD : DecoderState.READ_LENGTH;
        }
        if (this.state == DecoderState.READ_LENGTH) {
            switch (this.length) {
                case -1: {
                    if (!input.isReadable(1)) {
                        return;
                    }
                    this.length = JagexByteBufExtensionsKt.g1((ByteBuf)input);
                    break;
                }
                case -2: {
                    if (!input.isReadable(2)) {
                        return;
                    }
                    this.length = JagexByteBufExtensionsKt.g2((ByteBuf)input);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid length: " + this.length + " for opcode " + this.opcode);
                }
            }
            this.state = DecoderState.READ_PAYLOAD;
        }
        if (this.state == DecoderState.READ_PAYLOAD) {
            if (!input.isReadable(this.length)) {
                return;
            }
            ByteBuf payload = input.readSlice(this.length);
            Collection collection = out;
            MessageDecoder<?> messageDecoder = this.decoder;
            if (messageDecoder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                messageDecoder = null;
            }
            Intrinsics.checkNotNull((Object)payload);
            collection.add(messageDecoder.decode-lwEbYT4(JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)payload)));
            if (payload.isReadable()) {
                MessageDecoder<?> messageDecoder2 = this.decoder;
                if (messageDecoder2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                    messageDecoder2 = null;
                }
                throw new DecoderException("Decoder " + messageDecoder2.getClass() + " did not read entire payload of opcode " + this.opcode + ": " + payload.readableBytes());
            }
            this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor().incrementIncomingPackets(ChannelExtensionsKt.inetAddress(ctx), this.opcode, this.length);
            this.state = DecoderState.READ_OPCODE;
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginMessageDecoder$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-230-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

