/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.crypto.cipher.StreamCipherPair;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.Session;
import net.rsprot.protocol.api.StreamCipherProvider;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.game.GameMessageDecoder;
import net.rsprot.protocol.api.game.GameMessageEncoder;
import net.rsprot.protocol.api.game.GameMessageHandler;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginDisconnectionReason;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.api.metrics.ChannelTrafficHandlerExtensionsKt;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.incoming.GameMessageConsumerRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J:\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u001d\u001a\u00020 2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u001d\u001a\u00020!2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler;", "R", "", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "(Lnet/rsprot/protocol/api/NetworkService;Lio/netty/channel/ChannelHandlerContext;)V", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "createSession", "Lnet/rsprot/protocol/api/Session;", "loginBlock", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "pipeline", "Lio/netty/channel/ChannelPipeline;", "decodingCipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "encodingCipher", "createStreamCipherPair", "Lnet/rsprot/crypto/cipher/StreamCipherPair;", "validateNewConnection", "", "writeFailedResponse", "", "response", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse;", "writeSuccessfulResponse", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$Ok;", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$ReconnectOk;", "Companion", "osrs-230-api"})
@SourceDebugExtension(value={"SMAP\nGameLoginResponseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n+ 2 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 5 ChannelExtensions.kt\nnet/rsprot/protocol/api/channel/ChannelExtensionsKt\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,242:1\n160#2,2:243\n20#3:245\n44#3,6:246\n52#3:256\n55#3:261\n58#3:266\n61#3:271\n64#3:276\n21#3:277\n20#3:278\n44#3,6:279\n52#3:289\n55#3:294\n58#3:299\n61#3:304\n64#3:309\n21#3:310\n20#3:315\n44#3,6:316\n52#3:326\n55#3:331\n58#3:336\n61#3:341\n64#3:346\n21#3:347\n20#3:348\n44#3,6:349\n52#3:359\n55#3:364\n58#3:369\n61#3:374\n64#3:379\n21#3:380\n32#4,4:252\n56#4,4:257\n80#4,4:262\n104#4,4:267\n128#4,4:272\n32#4,4:285\n56#4,4:290\n80#4,4:295\n104#4,4:300\n128#4,4:305\n32#4,4:322\n56#4,4:327\n80#4,4:332\n104#4,4:337\n128#4,4:342\n32#4,4:355\n56#4,4:360\n80#4,4:365\n104#4,4:370\n128#4,4:375\n36#5:311\n36#5:312\n36#5:313\n36#5:314\n11#6,2:381\n*S KotlinDebug\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n*L\n83#1:243,2\n94#1:245\n94#1:246,6\n94#1:256\n94#1:261\n94#1:266\n94#1:271\n94#1:276\n94#1:277\n119#1:278\n119#1:279,6\n119#1:289\n119#1:294\n119#1:299\n119#1:304\n119#1:309\n119#1:310\n212#1:315\n212#1:316,6\n212#1:326\n212#1:331\n212#1:336\n212#1:341\n212#1:346\n212#1:347\n221#1:348\n221#1:349,6\n221#1:359\n221#1:364\n221#1:369\n221#1:374\n221#1:379\n221#1:380\n94#1:252,4\n94#1:257,4\n94#1:262,4\n94#1:267,4\n94#1:272,4\n119#1:285,4\n119#1:290,4\n119#1:295,4\n119#1:300,4\n119#1:305,4\n212#1:322,4\n212#1:327,4\n212#1:332,4\n212#1:337,4\n212#1:342,4\n221#1:355,4\n221#1:360,4\n221#1:365,4\n221#1:370,4\n221#1:375,4\n172#1:311\n180#1:312\n183#1:313\n184#1:314\n239#1:381,2\n*E\n"})
public final class GameLoginResponseHandler<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private final ChannelHandlerContext ctx;
    private static final int DECODE_SEED_OFFSET = 50;
    @NotNull
    private static final Logger logger;

    public GameLoginResponseHandler(@NotNull NetworkService<R> networkService, @NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService = networkService;
        this.ctx = ctx;
    }

    @NotNull
    public final NetworkService<R> getNetworkService() {
        return this.networkService;
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public final boolean validateNewConnection() {
        InetAddress address = ChannelExtensionsKt.inetAddress(this.ctx);
        int count = this.networkService.getINetAddressHandlers$osrs_230_api().getGameInetAddressTracker().getCount(address);
        return this.networkService.getINetAddressHandlers$osrs_230_api().getInetAddressValidator().acceptGameConnection(address, count);
    }

    @NotNull
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.Ok response, @NotNull LoginBlock<?> loginBlock) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        OldSchoolClientType oldSchoolClientType = loginBlock.getClientType().toOldSchoolClientType();
        if (oldSchoolClientType == null) {
            boolean $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22 = false;
            String $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22 = "Login client type cannot be null";
            throw new IllegalStateException($i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22.toString());
        }
        OldSchoolClientType oldSchoolClientType2 = oldSchoolClientType;
        StreamCipherPair cipher = this.createStreamCipherPair(loginBlock);
        if (this.networkService.getBetaWorld$osrs_230_api()) {
            MessageEncoder encoder = this.networkService.getEncoderRepositories$osrs_230_api().getLoginMessageEncoderRepository().getEncoder(response.getClass());
            ByteBuf byteBuf = this.ctx.alloc().buffer(38);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
            ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)byteBuf);
            int value$iv = 37;
            boolean bl = false;
            JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
            encoder.encode-WFbGaZ8(cipher.getEncoderCipher(), buffer, (OutgoingMessage)response);
            this.ctx.writeAndFlush((Object)buffer);
        } else {
            this.ctx.writeAndFlush((Object)response);
        }
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, cipher.getDecodeCipher(), oldSchoolClientType2, cipher.getEncoderCipher());
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
        }
        return session;
    }

    @NotNull
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.ReconnectOk response, @NotNull LoginBlock<?> loginBlock) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        OldSchoolClientType oldSchoolClientType = loginBlock.getClientType().toOldSchoolClientType();
        if (oldSchoolClientType == null) {
            boolean $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32 = false;
            String $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32 = "Login client type cannot be null";
            throw new IllegalStateException($i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32.toString());
        }
        OldSchoolClientType oldSchoolClientType2 = oldSchoolClientType;
        StreamCipherPair streamCipherPair = this.createStreamCipherPair(loginBlock);
        StreamCipher encodingCipher = streamCipherPair.component1();
        StreamCipher decodingCipher = streamCipherPair.component2();
        this.ctx.write((Object)response, this.ctx.voidPromise());
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, decodingCipher, oldSchoolClientType2, encodingCipher);
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
        }
        return session;
    }

    private final StreamCipherPair createStreamCipherPair(LoginBlock<?> loginBlock) {
        int[] encodeSeed = loginBlock.getSeed();
        int n = 0;
        int n2 = encodeSeed.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = encodeSeed[n3] + 50;
        }
        int[] decodeSeed = nArray;
        StreamCipherProvider provider = this.networkService.getLoginHandlers$osrs_230_api().getStreamCipherProvider();
        StreamCipher encodingCipher = provider.provide(decodeSeed);
        StreamCipher decodingCipher = provider.provide(encodeSeed);
        return new StreamCipherPair(encodingCipher, decodingCipher);
    }

    private final Session<R> createSession(LoginBlock<?> loginBlock, ChannelPipeline pipeline, StreamCipher decodingCipher, OldSchoolClientType oldSchoolClientType, StreamCipher encodingCipher) {
        ChannelHandler newHandler$iv;
        ChannelPipeline $this$replace$iv;
        GameMessageConsumerRepository gameMessageConsumerRepository = this.networkService.getGameMessageConsumerRepositoryProvider().provide();
        Session<R> session = new Session<R>(this.networkService.getTrafficMonitor(), this.ctx, this.networkService.getGameMessageHandlers$osrs_230_api().getIncomingGameMessageQueueProvider().provide(), this.networkService.getGameMessageHandlers$osrs_230_api().getOutgoingGameMessageQueueProvider(), this.networkService.getGameMessageHandlers$osrs_230_api().getGameMessageCounterProvider().provide(), gameMessageConsumerRepository.getConsumers(), gameMessageConsumerRepository.getGlobalConsumers(), loginBlock, this.networkService.getExceptionHandlers$osrs_230_api().getIncomingGameMessageConsumerExceptionHandler());
        ChannelPipeline channelPipeline = pipeline;
        ChannelHandler channelHandler = (ChannelHandler)new GameMessageDecoder<R>(this.networkService, session, decodingCipher, oldSchoolClientType);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageEncoder(this.networkService, encodingCipher, oldSchoolClientType);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageHandler<R>(this.networkService, session);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginConnectionHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 15L, 15L, 15L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        return session;
    }

    public final void writeFailedResponse(@NotNull LoginResponse response) {
        block29: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (response instanceof LoginResponse.ProofOfWork) {
                throw new IllegalStateException("Proof of Work is handled at the engine level.");
            }
            if (response instanceof LoginResponse.Successful) {
                throw new IllegalStateException("Successful login response is handled at the engine level.");
            }
            if (this.ctx.channel().isActive()) break block29;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), LoginDisconnectionReason.GAME_CHANNEL_INACTIVE);
            return;
        }
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl13 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl14 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl15 = false;
                    logger.trace(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 3: {
                boolean bl16 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl17 = false;
                    logger.debug(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 4: {
                boolean bl18 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl19 = false;
                    logger.info(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 5: {
                boolean bl20 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl21 = false;
                    logger.warn(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 6: {
                boolean bl22 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl23 = false;
                    logger.error(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
        }
        this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        LoginDisconnectionReason disconnectReason = LoginDisconnectionReason.Companion.getResponseToReasonMap$osrs_230_api().get(response);
        if (disconnectReason != null) {
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), disconnectReason);
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler$Companion;", "", "()V", "DECODE_SEED_OFFSET", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-230-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

