/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.ServerProtCategory;
import net.rsprot.protocol.game.outgoing.GameServerProtCategory;
import net.rsprot.protocol.game.outgoing.map.util.RebuildRegionZone;
import net.rsprot.protocol.message.OutgoingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB'\b\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006 "}, d2={"Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntityV2;", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "baseX", "", "baseZ", "sizeX", "sizeZ", "zoneProvider", "Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntityV2$RebuildWorldEntityZoneProvider;", "(IIIILnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntityV2$RebuildWorldEntityZoneProvider;)V", "_baseX", "Lkotlin/UShort;", "_baseZ", "zones", "", "Lnet/rsprot/protocol/game/outgoing/map/util/RebuildRegionZone;", "(SSLjava/util/List;)V", "S", "getBaseX", "()I", "getBaseZ", "category", "Lnet/rsprot/protocol/ServerProtCategory;", "getCategory", "()Lnet/rsprot/protocol/ServerProtCategory;", "getZones", "()Ljava/util/List;", "estimateSize", "toString", "", "Companion", "RebuildWorldEntityZoneProvider", "osrs-229-model"})
@SourceDebugExtension(value={"SMAP\nRebuildWorldEntityV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RebuildWorldEntityV2.kt\nnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntityV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1774#2,4:153\n*S KotlinDebug\n*F\n+ 1 RebuildWorldEntityV2.kt\nnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntityV2\n*L\n59#1:153,4\n*E\n"})
public final class RebuildWorldEntityV2
implements OutgoingGameMessage {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final short _baseX;
    private final short _baseZ;
    @NotNull
    private final List<RebuildRegionZone> zones;

    private RebuildWorldEntityV2(short _baseX, short _baseZ, List<RebuildRegionZone> zones) {
        this._baseX = _baseX;
        this._baseZ = _baseZ;
        this.zones = zones;
    }

    @NotNull
    public final List<RebuildRegionZone> getZones() {
        return this.zones;
    }

    public RebuildWorldEntityV2(int baseX, int baseZ, int sizeX, int sizeZ, @NotNull RebuildWorldEntityZoneProvider zoneProvider) {
        Intrinsics.checkNotNullParameter((Object)zoneProvider, (String)"zoneProvider");
        this(UShort.constructor-impl((short)((short)baseX)), UShort.constructor-impl((short)((short)baseZ)), RebuildWorldEntityV2.Companion.buildRebuildWorldEntityZones(sizeX, sizeZ, zoneProvider));
        if (!(0 <= sizeX ? sizeX < 13 : false)) {
            boolean $i$a$-require-RebuildWorldEntityV2$52 = false;
            String $i$a$-require-RebuildWorldEntityV2$52 = "Size x must be in range of 0..<13: " + sizeX;
            throw new IllegalArgumentException($i$a$-require-RebuildWorldEntityV2$52.toString());
        }
        if (!(0 <= sizeZ ? sizeZ < 13 : false)) {
            boolean $i$a$-require-RebuildWorldEntityV2$62 = false;
            String $i$a$-require-RebuildWorldEntityV2$62 = "Size z must be in range of 0..<13: " + sizeZ;
            throw new IllegalArgumentException($i$a$-require-RebuildWorldEntityV2$62.toString());
        }
        if (!(0 <= baseX ? baseX < 16384 : false)) {
            boolean $i$a$-require-RebuildWorldEntityV2$72 = false;
            String $i$a$-require-RebuildWorldEntityV2$72 = "Base x must be in range of 0..<16384";
            throw new IllegalArgumentException($i$a$-require-RebuildWorldEntityV2$72.toString());
        }
        if (!(0 <= baseZ ? baseZ < 16384 : false)) {
            boolean bl = false;
            String string = "Base z must be in range of 0..<16384";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getBaseX() {
        return this._baseX & 0xFFFF;
    }

    public final int getBaseZ() {
        return this._baseZ & 0xFFFF;
    }

    @NotNull
    public ServerProtCategory getCategory() {
        return GameServerProtCategory.HIGH_PRIORITY_PROT;
    }

    public int estimateSize() {
        int n;
        int header = 5;
        Iterable $this$count$iv = this.zones;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RebuildRegionZone zone = (RebuildRegionZone)element$iv;
                boolean bl = false;
                if (!(zone != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int notNullCount = n;
        int bitCount = 27 * notNullCount + (this.zones.size() - notNullCount);
        int bitBufByteCount = bitCount + 7 >>> 3;
        int xteaSize = notNullCount * 16;
        return header + 2 + bitBufByteCount + xteaSize;
    }

    @NotNull
    public String toString() {
        return "RebuildWorldEntityV2(zones=" + this.zones + ", baseX=" + this.getBaseX() + ", baseZ=" + this.getBaseZ() + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntityV2$Companion;", "", "()V", "buildRebuildWorldEntityZones", "", "Lnet/rsprot/protocol/game/outgoing/map/util/RebuildRegionZone;", "sizeX", "", "sizeZ", "zoneProvider", "Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntityV2$RebuildWorldEntityZoneProvider;", "osrs-229-model"})
    private static final class Companion {
        private Companion() {
        }

        private final List<RebuildRegionZone> buildRebuildWorldEntityZones(int sizeX, int sizeZ, RebuildWorldEntityZoneProvider zoneProvider) {
            ArrayList zones = new ArrayList(4 * sizeX * sizeZ);
            for (int level = 0; level < 4; ++level) {
                for (int zoneX = 0; zoneX < sizeX; ++zoneX) {
                    for (int zoneZ = 0; zoneZ < sizeZ; ++zoneZ) {
                        ((Collection)zones).add(zoneProvider.provide(zoneX, zoneZ, level));
                    }
                }
            }
            return zones;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0016J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lnet/rsprot/protocol/game/outgoing/map/RebuildWorldEntityV2$RebuildWorldEntityZoneProvider;", "", "getMapsquareId", "", "zoneX", "zoneZ", "provide", "Lnet/rsprot/protocol/game/outgoing/map/util/RebuildRegionZone;", "level", "osrs-229-model"})
    public static interface RebuildWorldEntityZoneProvider {
        @Nullable
        public RebuildRegionZone provide(int var1, int var2, int var3);

        default public int getMapsquareId(int zoneX, int zoneZ) {
            return (zoneX & 0x7FF) >>> 3 << 8 | (zoneZ & 0x7FF) >>> 3;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static int getMapsquareId(@NotNull RebuildWorldEntityZoneProvider $this, int zoneX, int zoneZ) {
                return $this.getMapsquareId(zoneX, zoneZ);
            }
        }
    }
}

