/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.crypto.cipher.StreamCipherPair;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.Session;
import net.rsprot.protocol.api.StreamCipherProvider;
import net.rsprot.protocol.api.game.GameMessageDecoder;
import net.rsprot.protocol.api.game.GameMessageEncoder;
import net.rsprot.protocol.api.game.GameMessageHandler;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginDisconnectionReason;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.api.metrics.ChannelTrafficHandlerExtensionsKt;
import net.rsprot.protocol.channel.ChannelExtensions;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.incoming.GameMessageConsumerRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J:\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u001d\u001a\u00020 2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u001d\u001a\u00020!2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler;", "R", "", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "(Lnet/rsprot/protocol/api/NetworkService;Lio/netty/channel/ChannelHandlerContext;)V", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "createSession", "Lnet/rsprot/protocol/api/Session;", "loginBlock", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "pipeline", "Lio/netty/channel/ChannelPipeline;", "decodingCipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "encodingCipher", "createStreamCipherPair", "Lnet/rsprot/crypto/cipher/StreamCipherPair;", "validateNewConnection", "", "writeFailedResponse", "", "response", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse;", "writeSuccessfulResponse", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$Ok;", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$ReconnectOk;", "Companion", "osrs-229-api"})
@SourceDebugExtension(value={"SMAP\nGameLoginResponseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n+ 2 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 3 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 5 ChannelExtensions.kt\nnet/rsprot/protocol/channel/ChannelExtensions\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,288:1\n164#2,2:289\n164#2,2:291\n164#2,2:326\n136#2:328\n216#2,2:329\n136#2:331\n136#2:332\n140#2,2:333\n216#2,2:335\n140#2,2:337\n20#3:293\n44#3,6:294\n52#3:304\n55#3:309\n58#3:314\n61#3:319\n64#3:324\n21#3:325\n20#3:339\n44#3,6:340\n52#3:350\n55#3:355\n58#3:360\n61#3:365\n64#3:370\n21#3:371\n20#3:376\n44#3,6:377\n52#3:387\n55#3:392\n58#3:397\n61#3:402\n64#3:407\n21#3:408\n20#3:409\n44#3,6:410\n52#3:420\n55#3:425\n58#3:430\n61#3:435\n64#3:440\n21#3:441\n32#4,4:300\n56#4,4:305\n80#4,4:310\n104#4,4:315\n128#4,4:320\n32#4,4:346\n56#4,4:351\n80#4,4:356\n104#4,4:361\n128#4,4:366\n32#4,4:383\n56#4,4:388\n80#4,4:393\n104#4,4:398\n128#4,4:403\n32#4,4:416\n56#4,4:421\n80#4,4:426\n104#4,4:431\n128#4,4:436\n25#5:372\n25#5:373\n25#5:374\n25#5:375\n11#6,2:442\n*S KotlinDebug\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n*L\n96#1:289,2\n100#1:291,2\n139#1:326,2\n142#1:328\n143#1:329,2\n146#1:331\n148#1:332\n152#1:333,2\n153#1:335,2\n154#1:337,2\n112#1:293\n112#1:294,6\n112#1:304\n112#1:309\n112#1:314\n112#1:319\n112#1:324\n112#1:325\n165#1:339\n165#1:340,6\n165#1:350\n165#1:355\n165#1:360\n165#1:365\n165#1:370\n165#1:371\n258#1:376\n258#1:377,6\n258#1:387\n258#1:392\n258#1:397\n258#1:402\n258#1:407\n258#1:408\n267#1:409\n267#1:410,6\n267#1:420\n267#1:425\n267#1:430\n267#1:435\n267#1:440\n267#1:441\n112#1:300,4\n112#1:305,4\n112#1:310,4\n112#1:315,4\n112#1:320,4\n165#1:346,4\n165#1:351,4\n165#1:356,4\n165#1:361,4\n165#1:366,4\n258#1:383,4\n258#1:388,4\n258#1:393,4\n258#1:398,4\n258#1:403,4\n267#1:416,4\n267#1:421,4\n267#1:426,4\n267#1:431,4\n267#1:436,4\n218#1:372\n226#1:373\n229#1:374\n230#1:375\n285#1:442,2\n*E\n"})
public final class GameLoginResponseHandler<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private final ChannelHandlerContext ctx;
    private static final int DECODE_SEED_OFFSET = 50;
    @NotNull
    private static final Logger logger;

    public GameLoginResponseHandler(@NotNull NetworkService<R> networkService, @NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService = networkService;
        this.ctx = ctx;
    }

    @NotNull
    public final NetworkService<R> getNetworkService() {
        return this.networkService;
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public final boolean validateNewConnection() {
        String address = ChannelExtensions.hostAddress((ChannelHandlerContext)this.ctx);
        int count = this.networkService.getINetAddressHandlers$osrs_229_api().getGameInetAddressTracker().getCount(address);
        return this.networkService.getINetAddressHandlers$osrs_229_api().getInetAddressValidator().acceptGameConnection(address, count);
    }

    @NotNull
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.Ok response, @NotNull LoginBlock<?> loginBlock) {
        boolean bl;
        int value$iv;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        OldSchoolClientType oldSchoolClientType = loginBlock.getClientType().toOldSchoolClientType();
        if (oldSchoolClientType == null) {
            boolean $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22 = false;
            String $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22 = "Login client type cannot be null";
            throw new IllegalStateException($i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$22.toString());
        }
        OldSchoolClientType oldSchoolClientType2 = oldSchoolClientType;
        StreamCipherPair cipher = this.createStreamCipherPair(loginBlock);
        MessageEncoder encoder = this.networkService.getEncoderRepositories().getLoginMessageEncoderRepository().getEncoder(response.getClass());
        ByteBuf byteBuf = this.ctx.alloc().buffer(37);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
        ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)byteBuf);
        if (!this.networkService.getBetaWorld()) {
            value$iv = encoder.getProt().getOpcode();
            bl = false;
            JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
        }
        value$iv = 37;
        bl = false;
        JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
        encoder.encode-WFbGaZ8(cipher.getEncoderCipher(), buffer, (OutgoingMessage)response);
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, cipher.getDecodeCipher(), oldSchoolClientType2, cipher.getEncoderCipher());
        this.networkService.getJs5Authorizer().authorize(ChannelExtensions.hostAddress((ChannelHandlerContext)this.ctx));
        this.ctx.executor().submit(() -> GameLoginResponseHandler.writeSuccessfulResponse$lambda$1(this, buffer, session));
        Logger logger$iv = logger;
        boolean bl2 = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl3 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl4 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl5 = false;
                    logger.trace(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 3: {
                boolean bl6 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl7 = false;
                    logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 4: {
                boolean bl8 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl9 = false;
                    logger.info(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 5: {
                boolean bl10 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl11 = false;
                    logger.warn(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 6: {
                boolean bl12 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl13 = false;
                    logger.error(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
        }
        return session;
    }

    @NotNull
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.ReconnectOk response, @NotNull LoginBlock<?> loginBlock) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
        OldSchoolClientType oldSchoolClientType = loginBlock.getClientType().toOldSchoolClientType();
        if (oldSchoolClientType == null) {
            boolean $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32 = false;
            String $i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32 = "Login client type cannot be null";
            throw new IllegalStateException($i$a$-checkNotNull-GameLoginResponseHandler$writeSuccessfulResponse$oldSchoolClientType$32.toString());
        }
        OldSchoolClientType oldSchoolClientType2 = oldSchoolClientType;
        StreamCipherPair streamCipherPair = this.createStreamCipherPair(loginBlock);
        StreamCipher encodingCipher = streamCipherPair.component1();
        StreamCipher decodingCipher = streamCipherPair.component2();
        MessageEncoder encoder = this.networkService.getEncoderRepositories().getLoginMessageEncoderRepository().getEncoder(response.getClass());
        int bufLength = 3 + response.content().readableBytes();
        ByteBuf byteBuf = this.ctx.alloc().buffer(bufLength);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
        ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)byteBuf);
        int value$iv = encoder.getProt().getOpcode();
        boolean bl = false;
        JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
        boolean bl2 = false;
        int lengthPos = buffer.writerIndex();
        int value$iv2 = 0;
        boolean bl3 = false;
        JagexByteBufExtensionsKt.p2((ByteBuf)buffer, (int)value$iv2);
        $i$f$writerIndex-impl = false;
        int start2 = buffer.writerIndex();
        encoder.encode-WFbGaZ8(encodingCipher, buffer, (OutgoingMessage)response);
        $i$f$writerIndex-impl = false;
        int end = buffer.writerIndex();
        int written = end - start2;
        boolean bl4 = false;
        buffer.writerIndex(lengthPos);
        $i$f$p2-JhZ6y6I = false;
        JagexByteBufExtensionsKt.p2((ByteBuf)buffer, (int)written);
        bl4 = false;
        buffer.writerIndex(end);
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, decodingCipher, oldSchoolClientType2, encodingCipher);
        this.networkService.getJs5Authorizer().authorize(ChannelExtensions.hostAddress((ChannelHandlerContext)this.ctx));
        this.ctx.executor().submit(() -> GameLoginResponseHandler.writeSuccessfulResponse$lambda$4(this, buffer, session));
        Logger logger$iv = logger;
        boolean bl5 = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl6 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl7 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.trace(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 3: {
                boolean bl9 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 4: {
                boolean bl11 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.info(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 5: {
                boolean bl13 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl14 = false;
                    logger.warn(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 6: {
                boolean bl15 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl16 = false;
                    logger.error(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
        }
        return session;
    }

    private final StreamCipherPair createStreamCipherPair(LoginBlock<?> loginBlock) {
        int[] encodeSeed = loginBlock.getSeed();
        int n = 0;
        int n2 = encodeSeed.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = encodeSeed[n3] + 50;
        }
        int[] decodeSeed = nArray;
        StreamCipherProvider provider = this.networkService.getLoginHandlers$osrs_229_api().getStreamCipherProvider();
        StreamCipher encodingCipher = provider.provide(decodeSeed);
        StreamCipher decodingCipher = provider.provide(encodeSeed);
        return new StreamCipherPair(encodingCipher, decodingCipher);
    }

    private final Session<R> createSession(LoginBlock<?> loginBlock, ChannelPipeline pipeline, StreamCipher decodingCipher, OldSchoolClientType oldSchoolClientType, StreamCipher encodingCipher) {
        ChannelHandler newHandler$iv;
        ChannelPipeline $this$replace$iv;
        GameMessageConsumerRepository gameMessageConsumerRepository = this.networkService.getGameMessageConsumerRepositoryProvider().provide();
        Session<R> session = new Session<R>(this.networkService.getTrafficMonitor(), this.ctx, this.networkService.getGameMessageHandlers$osrs_229_api().getIncomingGameMessageQueueProvider().provide(), this.networkService.getGameMessageHandlers$osrs_229_api().getOutgoingGameMessageQueueProvider(), this.networkService.getGameMessageHandlers$osrs_229_api().getGameMessageCounterProvider().provide(), gameMessageConsumerRepository.getConsumers(), gameMessageConsumerRepository.getGlobalConsumers(), loginBlock, this.networkService.getExceptionHandlers$osrs_229_api().getIncomingGameMessageConsumerExceptionHandler());
        ChannelPipeline channelPipeline = pipeline;
        ChannelHandler channelHandler = (ChannelHandler)new GameMessageDecoder<R>(this.networkService, session, decodingCipher, oldSchoolClientType);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageEncoder(this.networkService, encodingCipher, oldSchoolClientType);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageHandler<R>(this.networkService, session);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginConnectionHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 15L, 15L, 15L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        return session;
    }

    public final void writeFailedResponse(@NotNull LoginResponse response) {
        block29: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (response instanceof LoginResponse.ProofOfWork) {
                throw new IllegalStateException("Proof of Work is handled at the engine level.");
            }
            if (response instanceof LoginResponse.Successful) {
                throw new IllegalStateException("Successful login response is handled at the engine level.");
            }
            if (this.ctx.channel().isActive()) break block29;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)this.ctx), LoginDisconnectionReason.GAME_CHANNEL_INACTIVE);
            return;
        }
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl13 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl14 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl15 = false;
                    logger.trace(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 3: {
                boolean bl16 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl17 = false;
                    logger.debug(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 4: {
                boolean bl18 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl19 = false;
                    logger.info(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 5: {
                boolean bl20 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl21 = false;
                    logger.warn(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 6: {
                boolean bl22 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl23 = false;
                    logger.error(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
        }
        this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        LoginDisconnectionReason disconnectReason = LoginDisconnectionReason.Companion.getResponseToReasonMap$osrs_229_api().get(response);
        if (disconnectReason != null) {
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)this.ctx), disconnectReason);
        }
    }

    private static final void writeSuccessfulResponse$lambda$1(GameLoginResponseHandler this$0, ByteBuf $buffer, Session $session) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        this$0.ctx.write((Object)$buffer);
        $session.onLoginTransitionComplete$osrs_229_api();
    }

    private static final void writeSuccessfulResponse$lambda$4(GameLoginResponseHandler this$0, ByteBuf $buffer, Session $session) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        this$0.ctx.write((Object)$buffer);
        $session.onLoginTransitionComplete$osrs_229_api();
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler$Companion;", "", "()V", "DECODE_SEED_OFFSET", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-229-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

