/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.util;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.util.ZonePartialEnclosedCacheBuffer;
import net.rsprot.protocol.client.ClientType;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.game.outgoing.codec.zone.header.DesktopUpdateZonePartialEnclosedEncoder;
import net.rsprot.protocol.internal.client.ClientTypeMap;
import net.rsprot.protocol.message.ZoneProt;
import net.rsprot.protocol.message.codec.UpdateZonePartialEnclosedCache;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 22\u00020\u0001:\u00012BE\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0 \"\b\b\u0000\u0010!*\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$H\u0002J\b\u0010%\u001a\u00020&H\u0002J*\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0 \"\b\b\u0000\u0010!*\u00020\"2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H!0$J&\u0010)\u001a\u00020\t\"\b\b\u0000\u0010!*\u00020\"2\u0006\u0010*\u001a\u00020\u00042\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H!0$J\b\u0010+\u001a\u00020&H\u0002J\b\u0010,\u001a\u00020&H\u0002J\u0006\u0010-\u001a\u00020&J\b\u0010.\u001a\u00020&H\u0002J\b\u0010/\u001a\u00020&H\u0002J\b\u00100\u001a\u00020&H\u0002J\b\u00101\u001a\u00020&H\u0002R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013\u00a8\u00063"}, d2={"Lnet/rsprot/protocol/api/util/ZonePartialEnclosedCacheBuffer;", "", "supportedClients", "", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "byteBufAllocator", "Lio/netty/buffer/ByteBufAllocator;", "activeCachedBuffers", "Ljava/util/LinkedList;", "Lio/netty/buffer/ByteBuf;", "zoneCountBeforeLeakWarning", "", "bufRetentionCountBeforeRelease", "(Ljava/util/List;Lio/netty/buffer/ByteBufAllocator;Ljava/util/LinkedList;II)V", "getActiveCachedBuffers$osrs_229_api", "()Ljava/util/LinkedList;", "setActiveCachedBuffers$osrs_229_api", "(Ljava/util/LinkedList;)V", "getBufRetentionCountBeforeRelease", "()I", "currentZoneComputationCount", "getCurrentZoneComputationCount$osrs_229_api", "setCurrentZoneComputationCount$osrs_229_api", "(I)V", "retainedBufferReferences", "Lkotlin/collections/ArrayDeque;", "getRetainedBufferReferences$osrs_229_api", "()Lkotlin/collections/ArrayDeque;", "getSupportedClients", "()Ljava/util/List;", "getZoneCountBeforeLeakWarning", "buildZoneProtBuffers", "Ljava/util/EnumMap;", "T", "Lnet/rsprot/protocol/message/ZoneProt;", "protList", "", "clearEmptyRetainedBuffers", "", "computeZone", "pendingTickProtList", "computeZoneForClient", "client", "incrementZoneComputationCount", "logPossibleLeak", "releaseBuffers", "releaseBuffersOnThreshold", "releaseRetainedBuffers", "resetComputationCount", "retainActiveBufferReferences", "Companion", "osrs-229-api"})
@SourceDebugExtension(value={"SMAP\nZonePartialEnclosedCacheBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZonePartialEnclosedCacheBuffer.kt\nnet/rsprot/protocol/api/util/ZonePartialEnclosedCacheBuffer\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,215:1\n104#2,4:216\n11#3,2:220\n*S KotlinDebug\n*F\n+ 1 ZonePartialEnclosedCacheBuffer.kt\nnet/rsprot/protocol/api/util/ZonePartialEnclosedCacheBuffer\n*L\n106#1:216,4\n174#1:220,2\n*E\n"})
public final class ZonePartialEnclosedCacheBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<OldSchoolClientType> supportedClients;
    @NotNull
    private final ByteBufAllocator byteBufAllocator;
    @NotNull
    private LinkedList<ByteBuf> activeCachedBuffers;
    private final int zoneCountBeforeLeakWarning;
    private final int bufRetentionCountBeforeRelease;
    @NotNull
    private final ArrayDeque<LinkedList<ByteBuf>> retainedBufferReferences;
    private int currentZoneComputationCount;
    private static final int DEFAULT_ZONE_COUNT_BEFORE_LEAK_WARNING = 25000;
    public static final int DEFAULT_BUF_RETENTION_COUNT_BEFORE_RELEASE = 100;
    @NotNull
    private static final ClientTypeMap<UpdateZonePartialEnclosedCache> supportedEncoders = Companion.createEncoderMap$osrs_229_api();
    @NotNull
    private static final Logger logger;

    @JvmOverloads
    public ZonePartialEnclosedCacheBuffer(@NotNull List<? extends OldSchoolClientType> supportedClients, @NotNull ByteBufAllocator byteBufAllocator, @NotNull LinkedList<ByteBuf> activeCachedBuffers, int zoneCountBeforeLeakWarning, int bufRetentionCountBeforeRelease) {
        Intrinsics.checkNotNullParameter(supportedClients, (String)"supportedClients");
        Intrinsics.checkNotNullParameter((Object)byteBufAllocator, (String)"byteBufAllocator");
        Intrinsics.checkNotNullParameter(activeCachedBuffers, (String)"activeCachedBuffers");
        this.supportedClients = supportedClients;
        this.byteBufAllocator = byteBufAllocator;
        this.activeCachedBuffers = activeCachedBuffers;
        this.zoneCountBeforeLeakWarning = zoneCountBeforeLeakWarning;
        this.bufRetentionCountBeforeRelease = bufRetentionCountBeforeRelease;
        this.retainedBufferReferences = new ArrayDeque();
    }

    public /* synthetic */ ZonePartialEnclosedCacheBuffer(List list, ByteBufAllocator byteBufAllocator, LinkedList linkedList, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            list = (List)EntriesMappings.entries$0;
        }
        if ((n3 & 2) != 0) {
            PooledByteBufAllocator pooledByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)pooledByteBufAllocator, (String)"DEFAULT");
            byteBufAllocator = (ByteBufAllocator)pooledByteBufAllocator;
        }
        if ((n3 & 4) != 0) {
            linkedList = new LinkedList<ByteBuf>();
        }
        if ((n3 & 8) != 0) {
            n = 25000;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 100;
        }
        this(list, byteBufAllocator, linkedList, n, n2);
    }

    @NotNull
    public final List<OldSchoolClientType> getSupportedClients() {
        return this.supportedClients;
    }

    @NotNull
    public final LinkedList<ByteBuf> getActiveCachedBuffers$osrs_229_api() {
        return this.activeCachedBuffers;
    }

    public final void setActiveCachedBuffers$osrs_229_api(@NotNull LinkedList<ByteBuf> linkedList) {
        Intrinsics.checkNotNullParameter(linkedList, (String)"<set-?>");
        this.activeCachedBuffers = linkedList;
    }

    public final int getZoneCountBeforeLeakWarning() {
        return this.zoneCountBeforeLeakWarning;
    }

    public final int getBufRetentionCountBeforeRelease() {
        return this.bufRetentionCountBeforeRelease;
    }

    @NotNull
    public final ArrayDeque<LinkedList<ByteBuf>> getRetainedBufferReferences$osrs_229_api() {
        return this.retainedBufferReferences;
    }

    public final int getCurrentZoneComputationCount$osrs_229_api() {
        return this.currentZoneComputationCount;
    }

    public final void setCurrentZoneComputationCount$osrs_229_api(int n) {
        this.currentZoneComputationCount = n;
    }

    @NotNull
    public final <T extends ZoneProt> EnumMap<OldSchoolClientType, ByteBuf> computeZone(@NotNull Collection<? extends T> pendingTickProtList) {
        Intrinsics.checkNotNullParameter(pendingTickProtList, (String)"pendingTickProtList");
        EnumMap<OldSchoolClientType, ByteBuf> clientBuffers = this.buildZoneProtBuffers(pendingTickProtList);
        Collection collection = this.activeCachedBuffers;
        Collection<ByteBuf> collection2 = clientBuffers.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        CollectionsKt.addAll((Collection)collection, (Iterable)collection2);
        this.incrementZoneComputationCount();
        return clientBuffers;
    }

    @NotNull
    public final <T extends ZoneProt> ByteBuf computeZoneForClient(@NotNull OldSchoolClientType client, @NotNull Collection<? extends T> pendingTickProtList) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(pendingTickProtList, (String)"pendingTickProtList");
        UpdateZonePartialEnclosedCache encoder = (UpdateZonePartialEnclosedCache)supportedEncoders.get((ClientType)client);
        ByteBuf buffer = encoder.buildCache(this.byteBufAllocator, pendingTickProtList);
        this.activeCachedBuffers.add(buffer);
        this.incrementZoneComputationCount();
        return buffer;
    }

    private final <T extends ZoneProt> EnumMap<OldSchoolClientType, ByteBuf> buildZoneProtBuffers(Collection<? extends T> protList) {
        EnumMap map = ZonePartialEnclosedCacheBuffer.Companion.createClientBufferEnumMap();
        for (OldSchoolClientType client : this.supportedClients) {
            UpdateZonePartialEnclosedCache encoder;
            if ((UpdateZonePartialEnclosedCache)supportedEncoders.getOrNull((ClientType)client) == null) continue;
            ByteBuf buffer = encoder.buildCache(this.byteBufAllocator, protList);
            ((Map)map).put(client, buffer);
        }
        return map;
    }

    private final void incrementZoneComputationCount() {
        int n = this.currentZoneComputationCount;
        this.currentZoneComputationCount = n + 1;
        this.logPossibleLeak();
    }

    private final void logPossibleLeak() {
        if (this.currentZoneComputationCount < this.zoneCountBeforeLeakWarning) {
            return;
        }
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.warn(String.valueOf("Update zone partial enclosed buffers have not been correctly released!"));
        }
    }

    public final void releaseBuffers() {
        this.resetComputationCount();
        this.releaseBuffersOnThreshold();
        this.retainActiveBufferReferences();
        this.releaseRetainedBuffers();
        this.clearEmptyRetainedBuffers();
    }

    private final void resetComputationCount() {
        this.currentZoneComputationCount = 0;
    }

    private final void releaseBuffersOnThreshold() {
        if (this.retainedBufferReferences.size() >= this.bufRetentionCountBeforeRelease) {
            LinkedList releaseTarget = (LinkedList)this.retainedBufferReferences.removeFirst();
            ZonePartialEnclosedCacheBuffer.Companion.releaseBuffers(releaseTarget, true);
        }
    }

    private final void retainActiveBufferReferences() {
        if (!((Collection)this.activeCachedBuffers).isEmpty()) {
            this.retainedBufferReferences.addLast(this.activeCachedBuffers);
            this.activeCachedBuffers = new LinkedList();
        }
    }

    private final void releaseRetainedBuffers() {
        for (LinkedList buffers : this.retainedBufferReferences) {
            ZonePartialEnclosedCacheBuffer.Companion.releaseBuffers(buffers, false);
        }
    }

    private final void clearEmptyRetainedBuffers() {
        this.retainedBufferReferences.removeIf(arg_0 -> ZonePartialEnclosedCacheBuffer.clearEmptyRetainedBuffers$lambda$1(clearEmptyRetainedBuffers.1.INSTANCE, arg_0));
    }

    @JvmOverloads
    public ZonePartialEnclosedCacheBuffer(@NotNull List<? extends OldSchoolClientType> supportedClients, @NotNull ByteBufAllocator byteBufAllocator, @NotNull LinkedList<ByteBuf> activeCachedBuffers, int zoneCountBeforeLeakWarning) {
        Intrinsics.checkNotNullParameter(supportedClients, (String)"supportedClients");
        Intrinsics.checkNotNullParameter((Object)byteBufAllocator, (String)"byteBufAllocator");
        Intrinsics.checkNotNullParameter(activeCachedBuffers, (String)"activeCachedBuffers");
        this(supportedClients, byteBufAllocator, activeCachedBuffers, zoneCountBeforeLeakWarning, 0, 16, null);
    }

    @JvmOverloads
    public ZonePartialEnclosedCacheBuffer(@NotNull List<? extends OldSchoolClientType> supportedClients, @NotNull ByteBufAllocator byteBufAllocator, @NotNull LinkedList<ByteBuf> activeCachedBuffers) {
        Intrinsics.checkNotNullParameter(supportedClients, (String)"supportedClients");
        Intrinsics.checkNotNullParameter((Object)byteBufAllocator, (String)"byteBufAllocator");
        Intrinsics.checkNotNullParameter(activeCachedBuffers, (String)"activeCachedBuffers");
        this(supportedClients, byteBufAllocator, activeCachedBuffers, 0, 0, 24, null);
    }

    @JvmOverloads
    public ZonePartialEnclosedCacheBuffer(@NotNull List<? extends OldSchoolClientType> supportedClients, @NotNull ByteBufAllocator byteBufAllocator) {
        Intrinsics.checkNotNullParameter(supportedClients, (String)"supportedClients");
        Intrinsics.checkNotNullParameter((Object)byteBufAllocator, (String)"byteBufAllocator");
        this(supportedClients, byteBufAllocator, null, 0, 0, 28, null);
    }

    @JvmOverloads
    public ZonePartialEnclosedCacheBuffer(@NotNull List<? extends OldSchoolClientType> supportedClients) {
        Intrinsics.checkNotNullParameter(supportedClients, (String)"supportedClients");
        this(supportedClients, null, null, 0, 0, 30, null);
    }

    @JvmOverloads
    public ZonePartialEnclosedCacheBuffer() {
        this(null, null, null, 0, 0, 31, null);
    }

    private static final boolean clearEmptyRetainedBuffers$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0018"}, d2={"Lnet/rsprot/protocol/api/util/ZonePartialEnclosedCacheBuffer$Companion;", "", "()V", "DEFAULT_BUF_RETENTION_COUNT_BEFORE_RELEASE", "", "DEFAULT_ZONE_COUNT_BEFORE_LEAK_WARNING", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "supportedEncoders", "Lnet/rsprot/protocol/internal/client/ClientTypeMap;", "Lnet/rsprot/protocol/message/codec/UpdateZonePartialEnclosedCache;", "createClientBufferEnumMap", "Ljava/util/EnumMap;", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "Lio/netty/buffer/ByteBuf;", "createEncoderMap", "createEncoderMap$osrs_229_api", "releaseBuffers", "", "buffers", "Ljava/util/LinkedList;", "forceRelease", "", "osrs-229-api"})
    @SourceDebugExtension(value={"SMAP\nZonePartialEnclosedCacheBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZonePartialEnclosedCacheBuffer.kt\nnet/rsprot/protocol/api/util/ZonePartialEnclosedCacheBuffer$Companion\n+ 2 ClientTypeMap.kt\nnet/rsprot/protocol/internal/client/ClientTypeMap$Companion\n*L\n1#1,215:1\n48#2,8:216\n*S KotlinDebug\n*F\n+ 1 ZonePartialEnclosedCacheBuffer.kt\nnet/rsprot/protocol/api/util/ZonePartialEnclosedCacheBuffer$Companion\n*L\n182#1:216,8\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final EnumMap<OldSchoolClientType, ByteBuf> createClientBufferEnumMap() {
            return new EnumMap<OldSchoolClientType, ByteBuf>(OldSchoolClientType.class);
        }

        @NotNull
        public final ClientTypeMap<UpdateZonePartialEnclosedCache> createEncoderMap$osrs_229_api() {
            List list = new ArrayList();
            ((Collection)list).add(TuplesKt.to((Object)OldSchoolClientType.DESKTOP, (Object)DesktopUpdateZonePartialEnclosedEncoder.Companion));
            ClientTypeMap.Companion companion = ClientTypeMap.Companion;
            int clientCapacity$iv = 3;
            boolean $i$f$of = false;
            Object[] array$iv = new UpdateZonePartialEnclosedCache[clientCapacity$iv];
            for (Pair pair : list) {
                ClientType clientType$iv = (ClientType)pair.component1();
                Object element$iv = pair.component2();
                if (!(array$iv[clientType$iv.getId()] == null)) {
                    boolean bl = false;
                    String string = "A client is registered more than once: " + list;
                    throw new IllegalStateException(string.toString());
                }
                array$iv[clientType$iv.getId()] = element$iv;
            }
            return new ClientTypeMap(array$iv);
        }

        private final void releaseBuffers(LinkedList<ByteBuf> buffers, boolean forceRelease) {
            if (buffers.isEmpty()) {
                return;
            }
            Iterator iterator = buffers.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                ByteBuf next = (ByteBuf)e;
                int refCount = next.refCnt();
                if (forceRelease) {
                    if (refCount <= 0) continue;
                    next.release(refCount);
                    continue;
                }
                if (refCount > 1) continue;
                if (refCount == 1) {
                    next.release();
                }
                iterator2.remove();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<OldSchoolClientType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])OldSchoolClientType.values()));
        }
    }
}

