/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.ExperimentalStdlibApi;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import net.rsprot.compression.provider.HuffmanCodecProvider;
import net.rsprot.crypto.rsa.RsaKeyPair;
import net.rsprot.protocol.api.EntityInfoProtocols;
import net.rsprot.protocol.api.GameConnectionHandler;
import net.rsprot.protocol.api.LoginChannelInitializer;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.bootstrap.BootstrapBuilder;
import net.rsprot.protocol.api.config.NetworkConfiguration;
import net.rsprot.protocol.api.handlers.ExceptionHandlers;
import net.rsprot.protocol.api.handlers.GameMessageHandlers;
import net.rsprot.protocol.api.handlers.INetAddressHandlers;
import net.rsprot.protocol.api.handlers.LoginHandlers;
import net.rsprot.protocol.api.handlers.OutgoingMessageSizeEstimator;
import net.rsprot.protocol.api.js5.Js5Configuration;
import net.rsprot.protocol.api.js5.Js5GroupProvider;
import net.rsprot.protocol.api.js5.Js5Service;
import net.rsprot.protocol.api.repositories.MessageDecoderRepositories;
import net.rsprot.protocol.api.repositories.MessageEncoderRepositories;
import net.rsprot.protocol.api.util.FutureExtensionsKt;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarFactory;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoProtocol;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerInfoProtocol;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatarFactory;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityProtocol;
import net.rsprot.protocol.internal.RSProtThreadSafetyKt;
import net.rsprot.protocol.message.codec.incoming.provider.GameMessageConsumerRepositoryProvider;
import net.rsprot.protocol.metrics.NetworkTrafficMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0087\u0001*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0087\u0001B\u00c3\u0001\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!\u0012\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u0012\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010*J\u000e\u0010u\u001a\u00020\u000b2\u0006\u0010v\u001a\u00020\u0011J\u001c\u0010w\u001a\u00020x2\b\u0010y\u001a\u0004\u0018\u00010W2\b\b\u0002\u0010z\u001a\u00020\u000bH\u0007J/\u0010{\u001a\b\u0012\u0004\u0012\u00020}0|2\b\b\u0002\u0010~\u001a\u00020\u007f2\t\b\u0002\u0010\u0080\u0001\u001a\u00020\u007f2\n\b\u0002\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0007J(\u0010\u0083\u0001\u001a\u00020x2\b\b\u0002\u0010~\u001a\u00020\u007f2\t\b\u0002\u0010\u0080\u0001\u001a\u00020\u007f2\n\b\u0002\u0010\u0081\u0001\u001a\u00030\u0082\u0001J\t\u0010\u0084\u0001\u001a\u00020xH\u0007J!\u0010\u0085\u0001\u001a\u00020x*\u00030\u0086\u00012\u0007\u0010\u0080\u0001\u001a\u00020\u007f2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000202X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u000209X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u000e\u0010P\u001a\u00020QX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010R\u001a\u00020SX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010UR\u000e\u0010V\u001a\u00020WX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010YR\u0011\u0010Z\u001a\u00020[\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010]R\u0011\u0010^\u001a\u00020_8F\u00a2\u0006\u0006\u001a\u0004\b`\u0010aR\u0011\u0010b\u001a\u00020c8F\u00a2\u0006\u0006\u001a\u0004\bd\u0010eR\u0011\u0010f\u001a\u00020g8F\u00a2\u0006\u0006\u001a\u0004\bh\u0010iR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u00105R\u0015\u0010\"\u001a\u0006\u0012\u0002\b\u00030#\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010lR\u0011\u0010m\u001a\u00020n8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010pR\u0011\u0010q\u001a\u00020r8F\u00a2\u0006\u0006\u001a\u0004\bs\u0010t\u00a8\u0006\u0088\u0001"}, d2={"Lnet/rsprot/protocol/api/NetworkService;", "R", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "host", "", "ports", "", "", "betaWorld", "", "bootstrapBuilder", "Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder;", "entityInfoProtocols", "Lnet/rsprot/protocol/api/EntityInfoProtocols;", "clientTypes", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "gameConnectionHandler", "Lnet/rsprot/protocol/api/GameConnectionHandler;", "exceptionHandlers", "Lnet/rsprot/protocol/api/handlers/ExceptionHandlers;", "iNetAddressHandlers", "Lnet/rsprot/protocol/api/handlers/INetAddressHandlers;", "gameMessageHandlers", "Lnet/rsprot/protocol/api/handlers/GameMessageHandlers;", "loginHandlers", "Lnet/rsprot/protocol/api/handlers/LoginHandlers;", "configuration", "Lnet/rsprot/protocol/api/config/NetworkConfiguration;", "huffmanCodecProvider", "Lnet/rsprot/compression/provider/HuffmanCodecProvider;", "gameMessageConsumerRepositoryProvider", "Lnet/rsprot/protocol/message/codec/incoming/provider/GameMessageConsumerRepositoryProvider;", "trafficMonitor", "Lnet/rsprot/protocol/metrics/NetworkTrafficMonitor;", "rsaKeyPair", "Lnet/rsprot/crypto/rsa/RsaKeyPair;", "js5Configuration", "Lnet/rsprot/protocol/api/js5/Js5Configuration;", "js5GroupProvider", "Lnet/rsprot/protocol/api/js5/Js5GroupProvider;", "(Lio/netty/buffer/ByteBufAllocator;Ljava/lang/String;Ljava/util/List;ZLnet/rsprot/protocol/api/bootstrap/BootstrapBuilder;Lnet/rsprot/protocol/api/EntityInfoProtocols;Ljava/util/List;Lnet/rsprot/protocol/api/GameConnectionHandler;Lnet/rsprot/protocol/api/handlers/ExceptionHandlers;Lnet/rsprot/protocol/api/handlers/INetAddressHandlers;Lnet/rsprot/protocol/api/handlers/GameMessageHandlers;Lnet/rsprot/protocol/api/handlers/LoginHandlers;Lnet/rsprot/protocol/api/config/NetworkConfiguration;Lnet/rsprot/compression/provider/HuffmanCodecProvider;Lnet/rsprot/protocol/message/codec/incoming/provider/GameMessageConsumerRepositoryProvider;Lnet/rsprot/protocol/metrics/NetworkTrafficMonitor;Lnet/rsprot/crypto/rsa/RsaKeyPair;Lnet/rsprot/protocol/api/js5/Js5Configuration;Lnet/rsprot/protocol/api/js5/Js5GroupProvider;)V", "getAllocator$osrs_229_api", "()Lio/netty/buffer/ByteBufAllocator;", "getBetaWorld$osrs_229_api", "()Z", "getBootstrapBuilder$osrs_229_api", "()Lnet/rsprot/protocol/api/bootstrap/BootstrapBuilder;", "bossGroup", "Lio/netty/channel/EventLoopGroup;", "childGroup", "getClientTypes$osrs_229_api", "()Ljava/util/List;", "getConfiguration$osrs_229_api", "()Lnet/rsprot/protocol/api/config/NetworkConfiguration;", "decoderRepositories", "Lnet/rsprot/protocol/api/repositories/MessageDecoderRepositories;", "getDecoderRepositories$osrs_229_api", "()Lnet/rsprot/protocol/api/repositories/MessageDecoderRepositories;", "encoderRepositories", "Lnet/rsprot/protocol/api/repositories/MessageEncoderRepositories;", "getEncoderRepositories$osrs_229_api", "()Lnet/rsprot/protocol/api/repositories/MessageEncoderRepositories;", "getEntityInfoProtocols$osrs_229_api", "()Lnet/rsprot/protocol/api/EntityInfoProtocols;", "getExceptionHandlers$osrs_229_api", "()Lnet/rsprot/protocol/api/handlers/ExceptionHandlers;", "getGameConnectionHandler$osrs_229_api", "()Lnet/rsprot/protocol/api/GameConnectionHandler;", "getGameMessageConsumerRepositoryProvider", "()Lnet/rsprot/protocol/message/codec/incoming/provider/GameMessageConsumerRepositoryProvider;", "getGameMessageHandlers$osrs_229_api", "()Lnet/rsprot/protocol/api/handlers/GameMessageHandlers;", "getHost$osrs_229_api", "()Ljava/lang/String;", "getHuffmanCodecProvider", "()Lnet/rsprot/compression/provider/HuffmanCodecProvider;", "getINetAddressHandlers$osrs_229_api", "()Lnet/rsprot/protocol/api/handlers/INetAddressHandlers;", "js5PrefetchService", "Ljava/util/concurrent/ScheduledExecutorService;", "js5Service", "Lnet/rsprot/protocol/api/js5/Js5Service;", "getJs5Service$osrs_229_api", "()Lnet/rsprot/protocol/api/js5/Js5Service;", "js5ServiceExecutor", "Ljava/lang/Thread;", "getLoginHandlers$osrs_229_api", "()Lnet/rsprot/protocol/api/handlers/LoginHandlers;", "messageSizeEstimator", "Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;", "getMessageSizeEstimator", "()Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;", "npcAvatarFactory", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFactory;", "getNpcAvatarFactory", "()Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFactory;", "npcInfoProtocol", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol;", "getNpcInfoProtocol", "()Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol;", "playerInfoProtocol", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol;", "getPlayerInfoProtocol", "()Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol;", "getPorts$osrs_229_api", "getTrafficMonitor", "()Lnet/rsprot/protocol/metrics/NetworkTrafficMonitor;", "worldEntityAvatarFactory", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarFactory;", "getWorldEntityAvatarFactory", "()Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarFactory;", "worldEntityInfoProtocol", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityProtocol;", "getWorldEntityInfoProtocol", "()Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityProtocol;", "isSupported", "clientType", "setCommunicationThread", "", "thread", "warnOnError", "shutdown", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "quietPeriod", "", "timeout", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "shutdownNow", "start", "safeShutdown", "Ljava/util/concurrent/ExecutorService;", "Companion", "osrs-229-api"})
@SourceDebugExtension(value={"SMAP\nNetworkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkService.kt\nnet/rsprot/protocol/api/NetworkService\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,287:1\n18#2,4:288\n50#2,6:292\n56#2:308\n1549#3:298\n1620#3,3:299\n1549#3:302\n1620#3,3:303\n37#4,2:306\n80#5,4:309\n80#5,4:313\n80#5,4:317\n80#5,4:321\n134#5,4:325\n134#5,4:329\n11#6,2:333\n*S KotlinDebug\n*F\n+ 1 NetworkService.kt\nnet/rsprot/protocol/api/NetworkService\n*L\n146#1:288,4\n146#1:292,6\n146#1:308\n157#1:298\n157#1:299,3\n158#1:302\n158#1:303,3\n159#1:306,2\n164#1:309,4\n165#1:313,4\n166#1:317,4\n171#1:321,4\n194#1:325,4\n198#1:329,4\n284#1:333,2\n*E\n"})
public final class NetworkService<R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @Nullable
    private final String host;
    @NotNull
    private final List<Integer> ports;
    private final boolean betaWorld;
    @NotNull
    private final BootstrapBuilder bootstrapBuilder;
    @NotNull
    private final EntityInfoProtocols entityInfoProtocols;
    @NotNull
    private final List<OldSchoolClientType> clientTypes;
    @NotNull
    private final GameConnectionHandler<R> gameConnectionHandler;
    @NotNull
    private final ExceptionHandlers<R> exceptionHandlers;
    @NotNull
    private final INetAddressHandlers iNetAddressHandlers;
    @NotNull
    private final GameMessageHandlers gameMessageHandlers;
    @NotNull
    private final LoginHandlers loginHandlers;
    @NotNull
    private final NetworkConfiguration configuration;
    @NotNull
    private final HuffmanCodecProvider huffmanCodecProvider;
    @NotNull
    private final GameMessageConsumerRepositoryProvider<R> gameMessageConsumerRepositoryProvider;
    @NotNull
    private final NetworkTrafficMonitor<?> trafficMonitor;
    @NotNull
    private final MessageEncoderRepositories encoderRepositories;
    @NotNull
    private final Js5Service js5Service;
    @NotNull
    private final Thread js5ServiceExecutor;
    @NotNull
    private final MessageDecoderRepositories decoderRepositories;
    @NotNull
    private final OutgoingMessageSizeEstimator messageSizeEstimator;
    private EventLoopGroup bossGroup;
    private EventLoopGroup childGroup;
    private ScheduledExecutorService js5PrefetchService;
    public static final long INITIAL_TIMEOUT_SECONDS = 30L;
    public static final long LOGIN_TIMEOUT_SECONDS = 40L;
    public static final long GAME_TIMEOUT_SECONDS = 15L;
    public static final long JS5_TIMEOUT_SECONDS = 30L;
    @NotNull
    private static final Logger logger;

    public NetworkService(@NotNull ByteBufAllocator allocator, @Nullable String host, @NotNull List<Integer> ports, boolean betaWorld, @NotNull BootstrapBuilder bootstrapBuilder, @NotNull EntityInfoProtocols entityInfoProtocols, @NotNull List<? extends OldSchoolClientType> clientTypes, @NotNull GameConnectionHandler<R> gameConnectionHandler, @NotNull ExceptionHandlers<R> exceptionHandlers, @NotNull INetAddressHandlers iNetAddressHandlers, @NotNull GameMessageHandlers gameMessageHandlers, @NotNull LoginHandlers loginHandlers, @NotNull NetworkConfiguration configuration, @NotNull HuffmanCodecProvider huffmanCodecProvider, @NotNull GameMessageConsumerRepositoryProvider<R> gameMessageConsumerRepositoryProvider, @NotNull NetworkTrafficMonitor<?> trafficMonitor, @NotNull RsaKeyPair rsaKeyPair, @NotNull Js5Configuration js5Configuration, @NotNull Js5GroupProvider js5GroupProvider) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter(ports, (String)"ports");
        Intrinsics.checkNotNullParameter((Object)bootstrapBuilder, (String)"bootstrapBuilder");
        Intrinsics.checkNotNullParameter((Object)entityInfoProtocols, (String)"entityInfoProtocols");
        Intrinsics.checkNotNullParameter(clientTypes, (String)"clientTypes");
        Intrinsics.checkNotNullParameter(gameConnectionHandler, (String)"gameConnectionHandler");
        Intrinsics.checkNotNullParameter(exceptionHandlers, (String)"exceptionHandlers");
        Intrinsics.checkNotNullParameter((Object)iNetAddressHandlers, (String)"iNetAddressHandlers");
        Intrinsics.checkNotNullParameter((Object)gameMessageHandlers, (String)"gameMessageHandlers");
        Intrinsics.checkNotNullParameter((Object)loginHandlers, (String)"loginHandlers");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)huffmanCodecProvider, (String)"huffmanCodecProvider");
        Intrinsics.checkNotNullParameter(gameMessageConsumerRepositoryProvider, (String)"gameMessageConsumerRepositoryProvider");
        Intrinsics.checkNotNullParameter(trafficMonitor, (String)"trafficMonitor");
        Intrinsics.checkNotNullParameter((Object)rsaKeyPair, (String)"rsaKeyPair");
        Intrinsics.checkNotNullParameter((Object)js5Configuration, (String)"js5Configuration");
        Intrinsics.checkNotNullParameter((Object)js5GroupProvider, (String)"js5GroupProvider");
        this.allocator = allocator;
        this.host = host;
        this.ports = ports;
        this.betaWorld = betaWorld;
        this.bootstrapBuilder = bootstrapBuilder;
        this.entityInfoProtocols = entityInfoProtocols;
        this.clientTypes = clientTypes;
        this.gameConnectionHandler = gameConnectionHandler;
        this.exceptionHandlers = exceptionHandlers;
        this.iNetAddressHandlers = iNetAddressHandlers;
        this.gameMessageHandlers = gameMessageHandlers;
        this.loginHandlers = loginHandlers;
        this.configuration = configuration;
        this.huffmanCodecProvider = huffmanCodecProvider;
        this.gameMessageConsumerRepositoryProvider = gameMessageConsumerRepositoryProvider;
        this.trafficMonitor = trafficMonitor;
        this.encoderRepositories = new MessageEncoderRepositories(this.huffmanCodecProvider);
        this.js5Service = new Js5Service(this, js5Configuration, js5GroupProvider);
        this.js5ServiceExecutor = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Js5 Service", (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ NetworkService<R> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getJs5Service$osrs_229_api().run();
            }
        }), (int)22, null);
        this.decoderRepositories = MessageDecoderRepositories.Companion.initialize(this.clientTypes, rsaKeyPair, this.huffmanCodecProvider);
        this.messageSizeEstimator = new OutgoingMessageSizeEstimator(this.encoderRepositories);
    }

    @NotNull
    public final ByteBufAllocator getAllocator$osrs_229_api() {
        return this.allocator;
    }

    @Nullable
    public final String getHost$osrs_229_api() {
        return this.host;
    }

    @NotNull
    public final List<Integer> getPorts$osrs_229_api() {
        return this.ports;
    }

    public final boolean getBetaWorld$osrs_229_api() {
        return this.betaWorld;
    }

    @NotNull
    public final BootstrapBuilder getBootstrapBuilder$osrs_229_api() {
        return this.bootstrapBuilder;
    }

    @NotNull
    public final EntityInfoProtocols getEntityInfoProtocols$osrs_229_api() {
        return this.entityInfoProtocols;
    }

    @NotNull
    public final List<OldSchoolClientType> getClientTypes$osrs_229_api() {
        return this.clientTypes;
    }

    @NotNull
    public final GameConnectionHandler<R> getGameConnectionHandler$osrs_229_api() {
        return this.gameConnectionHandler;
    }

    @NotNull
    public final ExceptionHandlers<R> getExceptionHandlers$osrs_229_api() {
        return this.exceptionHandlers;
    }

    @NotNull
    public final INetAddressHandlers getINetAddressHandlers$osrs_229_api() {
        return this.iNetAddressHandlers;
    }

    @NotNull
    public final GameMessageHandlers getGameMessageHandlers$osrs_229_api() {
        return this.gameMessageHandlers;
    }

    @NotNull
    public final LoginHandlers getLoginHandlers$osrs_229_api() {
        return this.loginHandlers;
    }

    @NotNull
    public final NetworkConfiguration getConfiguration$osrs_229_api() {
        return this.configuration;
    }

    @NotNull
    public final HuffmanCodecProvider getHuffmanCodecProvider() {
        return this.huffmanCodecProvider;
    }

    @NotNull
    public final GameMessageConsumerRepositoryProvider<R> getGameMessageConsumerRepositoryProvider() {
        return this.gameMessageConsumerRepositoryProvider;
    }

    @NotNull
    public final NetworkTrafficMonitor<?> getTrafficMonitor() {
        return this.trafficMonitor;
    }

    @NotNull
    public final MessageEncoderRepositories getEncoderRepositories$osrs_229_api() {
        return this.encoderRepositories;
    }

    @NotNull
    public final Js5Service getJs5Service$osrs_229_api() {
        return this.js5Service;
    }

    @NotNull
    public final MessageDecoderRepositories getDecoderRepositories$osrs_229_api() {
        return this.decoderRepositories;
    }

    @NotNull
    public final PlayerInfoProtocol getPlayerInfoProtocol() {
        return this.entityInfoProtocols.getPlayerInfoProtocol();
    }

    @NotNull
    public final NpcAvatarFactory getNpcAvatarFactory() {
        return this.entityInfoProtocols.getNpcAvatarFactory();
    }

    @NotNull
    public final NpcInfoProtocol getNpcInfoProtocol() {
        return this.entityInfoProtocols.getNpcInfoProtocol();
    }

    @NotNull
    public final WorldEntityAvatarFactory getWorldEntityAvatarFactory() {
        return this.entityInfoProtocols.getWorldEntityAvatarFactory();
    }

    @NotNull
    public final WorldEntityProtocol getWorldEntityInfoProtocol() {
        return this.entityInfoProtocols.getWorldEntityInfoProtocol();
    }

    @NotNull
    public final OutgoingMessageSizeEstimator getMessageSizeEstimator() {
        return this.messageSizeEstimator;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalUnsignedTypes
    @ExperimentalStdlibApi
    public final void start() {
        Logger logger;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        ServerBootstrap bootstrap = this.bootstrapBuilder.build$osrs_229_api(this.messageSizeEstimator);
        ServerBootstrap initializer = bootstrap.childHandler((ChannelHandler)new LoginChannelInitializer(this));
        EventLoopGroup eventLoopGroup = initializer.config().group();
        Intrinsics.checkNotNullExpressionValue((Object)eventLoopGroup, (String)"group(...)");
        this.bossGroup = eventLoopGroup;
        EventLoopGroup eventLoopGroup2 = initializer.config().childGroup();
        Intrinsics.checkNotNullExpressionValue((Object)eventLoopGroup2, (String)"childGroup(...)");
        this.childGroup = eventLoopGroup2;
        String host = this.host;
        Iterable iterable = this.ports;
        boolean $i$f$map = false;
        void var14_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = host;
            collection.add(string != null ? initializer.bind(string, (int)it) : initializer.bind((int)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChannelFuture it = (ChannelFuture)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(FutureExtensionsKt.asCompletableFuture((Future)p0));
        }
        List futures = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> future = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        this.js5ServiceExecutor.start();
        this.js5PrefetchService = Js5Service.Companion.startPrefetching(this.js5Service);
        future.join();
        long time = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        Logger arg0$iv = NetworkService.logger;
        boolean bl4 = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl5 = false;
            logger.info(String.valueOf("Started in: " + Duration.toString-impl((long)time)));
        }
        arg0$iv = NetworkService.logger;
        bl4 = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl6 = false;
            logger.info(String.valueOf("Bound to ports: " + CollectionsKt.joinToString$default((Iterable)this.ports, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
        }
        arg0$iv = NetworkService.logger;
        bl4 = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl7 = false;
            logger.info(String.valueOf("Revision: 229"));
        }
        String clientTypeNames2 = CollectionsKt.joinToString$default((Iterable)this.clientTypes, (CharSequence)", ", null, null, (int)0, null, (Function1)start.clientTypeNames.1.INSTANCE, (int)30, null);
        Logger arg0$iv2 = NetworkService.logger;
        $i$f$info-impl = false;
        if (InlineLogger.isInfoEnabled-impl((Logger)arg0$iv2)) {
            logger = arg0$iv2;
            boolean bl8 = false;
            logger.info(String.valueOf("Supported client types: " + clientTypeNames2));
        }
    }

    public final void shutdownNow(long quietPeriod, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        CompletableFuture<Void> future = this.shutdown(quietPeriod, timeout, timeUnit);
        try {
            future.join();
        }
        catch (Exception e) {
            Logger arg0$iv = logger;
            boolean bl = false;
            if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.error(String.valueOf("Network service may have not successfully shut down."), (Throwable)e);
            }
        }
        catch (Throwable t) {
            Logger arg0$iv = logger;
            boolean bl = false;
            if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl3 = false;
                logger.error(String.valueOf("Network service may have not successfully shut down."), t);
            }
            throw t;
        }
    }

    public static /* synthetic */ void shutdownNow$default(NetworkService networkService, long l, long l2, TimeUnit timeUnit, int n, Object object) {
        if ((n & 1) != 0) {
            l = 2L;
        }
        if ((n & 2) != 0) {
            l2 = 15L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        networkService.shutdownNow(l, l2, timeUnit);
    }

    @JvmOverloads
    @NotNull
    public final CompletableFuture<Void> shutdown(long quietPeriod, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        CompletableFuture[] completableFutureArray = new CompletableFuture[]{CompletableFuture.runAsync(() -> NetworkService.shutdown$lambda$8(this, timeUnit, timeout)), CompletableFuture.runAsync(() -> NetworkService.shutdown$lambda$9(this, timeout, timeUnit)), CompletableFuture.runAsync(() -> NetworkService.shutdown$lambda$10(this, quietPeriod, timeout, timeUnit)), CompletableFuture.runAsync(() -> NetworkService.shutdown$lambda$11(this, quietPeriod, timeout, timeUnit))};
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(completableFutureArray);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"allOf(...)");
        return completableFuture;
    }

    public static /* synthetic */ CompletableFuture shutdown$default(NetworkService networkService, long l, long l2, TimeUnit timeUnit, int n, Object object) {
        if ((n & 1) != 0) {
            l = 2L;
        }
        if ((n & 2) != 0) {
            l2 = 15L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return networkService.shutdown(l, l2, timeUnit);
    }

    private final void safeShutdown(ExecutorService $this$safeShutdown, long timeout, TimeUnit timeUnit) {
        $this$safeShutdown.shutdown();
        try {
            if (!$this$safeShutdown.awaitTermination(timeout, timeUnit)) {
                $this$safeShutdown.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            $this$safeShutdown.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @JvmOverloads
    public final void setCommunicationThread(@Nullable Thread thread, boolean warnOnError) {
        RSProtThreadSafetyKt.setCommunicationThread((Thread)thread, (boolean)warnOnError);
    }

    public static /* synthetic */ void setCommunicationThread$default(NetworkService networkService, Thread thread, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        networkService.setCommunicationThread(thread, bl);
    }

    public final boolean isSupported(@NotNull OldSchoolClientType clientType) {
        Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
        return this.clientTypes.contains(clientType);
    }

    @JvmOverloads
    @NotNull
    public final CompletableFuture<Void> shutdown(long quietPeriod, long timeout) {
        return NetworkService.shutdown$default(this, quietPeriod, timeout, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final CompletableFuture<Void> shutdown(long quietPeriod) {
        return NetworkService.shutdown$default(this, quietPeriod, 0L, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final CompletableFuture<Void> shutdown() {
        return NetworkService.shutdown$default(this, 0L, 0L, null, 7, null);
    }

    @JvmOverloads
    public final void setCommunicationThread(@Nullable Thread thread) {
        NetworkService.setCommunicationThread$default(this, thread, false, 2, null);
    }

    private static final void shutdown$lambda$8(NetworkService this$0, TimeUnit $timeUnit, long $timeout) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$timeUnit), (String)"$timeUnit");
        this$0.js5Service.triggerShutdown();
        this$0.js5ServiceExecutor.join($timeUnit.toMillis($timeout));
    }

    private static final void shutdown$lambda$9(NetworkService this$0, long $timeout, TimeUnit $timeUnit) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$timeUnit), (String)"$timeUnit");
        if (this$0.js5PrefetchService != null) {
            ScheduledExecutorService scheduledExecutorService = this$0.js5PrefetchService;
            if (scheduledExecutorService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"js5PrefetchService");
                scheduledExecutorService = null;
            }
            this$0.safeShutdown(scheduledExecutorService, $timeout, $timeUnit);
        }
    }

    private static final void shutdown$lambda$10(NetworkService this$0, long $quietPeriod, long $timeout, TimeUnit $timeUnit) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$timeUnit), (String)"$timeUnit");
        if (this$0.bossGroup != null) {
            EventLoopGroup eventLoopGroup = this$0.bossGroup;
            if (eventLoopGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bossGroup");
                eventLoopGroup = null;
            }
            eventLoopGroup.shutdownGracefully($quietPeriod, $timeout, $timeUnit);
        }
    }

    private static final void shutdown$lambda$11(NetworkService this$0, long $quietPeriod, long $timeout, TimeUnit $timeUnit) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$timeUnit), (String)"$timeUnit");
        if (this$0.childGroup != null) {
            EventLoopGroup eventLoopGroup = this$0.childGroup;
            if (eventLoopGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"childGroup");
                eventLoopGroup = null;
            }
            eventLoopGroup.shutdownGracefully($quietPeriod, $timeout, $timeUnit);
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\tX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\n\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/api/NetworkService$Companion;", "", "()V", "GAME_TIMEOUT_SECONDS", "", "INITIAL_TIMEOUT_SECONDS", "JS5_TIMEOUT_SECONDS", "LOGIN_TIMEOUT_SECONDS", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-229-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

