/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.js5.Js5Client;
import net.rsprot.protocol.api.js5.Js5DisconnectionReason;
import net.rsprot.protocol.api.js5.Js5Service;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.metrics.ChannelTrafficHandlerExtensionsKt;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.js5.incoming.Js5GroupRequest;
import net.rsprot.protocol.js5.incoming.PriorityChangeHigh;
import net.rsprot.protocol.js5.incoming.PriorityChangeLow;
import net.rsprot.protocol.js5.incoming.XorChange;
import net.rsprot.protocol.message.IncomingJs5Message;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lnet/rsprot/protocol/api/js5/Js5ChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingJs5Message;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "client", "Lnet/rsprot/protocol/api/js5/Js5Client;", "service", "Lnet/rsprot/protocol/api/js5/Js5Service;", "getService", "()Lnet/rsprot/protocol/api/js5/Js5Service;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelReadComplete", "channelWritabilityChanged", "exceptionCaught", "cause", "", "handlerAdded", "handlerRemoved", "userEventTriggered", "evt", "", "Companion", "osrs-229-api"})
@SourceDebugExtension(value={"SMAP\nJs5ChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Js5ChannelHandler.kt\nnet/rsprot/protocol/api/js5/Js5ChannelHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,165:1\n20#2:166\n44#2,6:167\n52#2:177\n55#2:182\n58#2:187\n61#2:192\n64#2:197\n21#2:198\n20#2:199\n44#2,6:200\n52#2:210\n55#2:215\n58#2:220\n61#2:225\n64#2:230\n21#2:231\n36#2,14:232\n52#2:250\n55#2:255\n58#2:260\n61#2:265\n64#2:270\n37#2:271\n36#2,14:272\n52#2:290\n55#2:295\n58#2:300\n61#2:305\n64#2:310\n37#2:311\n36#2,14:312\n52#2:330\n55#2:335\n58#2:340\n61#2:345\n64#2:350\n37#2:351\n36#2,14:352\n52#2:370\n55#2:375\n58#2:380\n61#2:385\n64#2:390\n37#2:391\n20#2:396\n44#2,6:397\n52#2:407\n55#2:412\n58#2:417\n61#2:422\n64#2:427\n21#2:428\n32#3,4:173\n56#3,4:178\n80#3,4:183\n104#3,4:188\n128#3,4:193\n32#3,4:206\n56#3,4:211\n80#3,4:216\n104#3,4:221\n128#3,4:226\n32#3,4:246\n56#3,4:251\n80#3,4:256\n104#3,4:261\n128#3,4:266\n32#3,4:286\n56#3,4:291\n80#3,4:296\n104#3,4:301\n128#3,4:306\n32#3,4:326\n56#3,4:331\n80#3,4:336\n104#3,4:341\n128#3,4:346\n32#3,4:366\n56#3,4:371\n80#3,4:376\n104#3,4:381\n128#3,4:386\n32#3,4:403\n56#3,4:408\n80#3,4:413\n104#3,4:418\n128#3,4:423\n249#4,4:392\n11#5,2:429\n*S KotlinDebug\n*F\n+ 1 Js5ChannelHandler.kt\nnet/rsprot/protocol/api/js5/Js5ChannelHandler\n*L\n33#1:166\n33#1:167,6\n33#1:177\n33#1:182\n33#1:187\n33#1:192\n33#1:197\n33#1:198\n43#1:199\n43#1:200,6\n43#1:210\n43#1:215\n43#1:220\n43#1:225\n43#1:230\n43#1:231\n74#1:232,14\n74#1:250\n74#1:255\n74#1:260\n74#1:265\n74#1:270\n74#1:271\n80#1:272,14\n80#1:290\n80#1:295\n80#1:300\n80#1:305\n80#1:310\n80#1:311\n89#1:312,14\n89#1:330\n89#1:335\n89#1:340\n89#1:345\n89#1:350\n89#1:351\n96#1:352,14\n96#1:370\n96#1:375\n96#1:380\n96#1:385\n96#1:390\n96#1:391\n147#1:396\n147#1:397,6\n147#1:407\n147#1:412\n147#1:417\n147#1:422\n147#1:427\n147#1:428\n33#1:173,4\n33#1:178,4\n33#1:183,4\n33#1:188,4\n33#1:193,4\n43#1:206,4\n43#1:211,4\n43#1:216,4\n43#1:221,4\n43#1:226,4\n74#1:246,4\n74#1:251,4\n74#1:256,4\n74#1:261,4\n74#1:266,4\n80#1:286,4\n80#1:291,4\n80#1:296,4\n80#1:301,4\n80#1:306,4\n89#1:326,4\n89#1:331,4\n89#1:336,4\n89#1:341,4\n89#1:346,4\n96#1:366,4\n96#1:371,4\n96#1:376,4\n96#1:381,4\n96#1:386,4\n147#1:403,4\n147#1:408,4\n147#1:413,4\n147#1:418,4\n147#1:423,4\n99#1:392,4\n162#1:429,2\n*E\n"})
public final class Js5ChannelHandler
extends SimpleChannelInboundHandler<IncomingJs5Message> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    private Js5Client client;
    @NotNull
    private static final Logger logger;

    public Js5ChannelHandler(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingJs5Message.class);
        this.networkService = networkService;
    }

    private final Js5Service getService() {
        return this.networkService.getJs5Service$osrs_229_api();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_229_api().getJs5InetAddressTracker().register(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_229_api().getJs5InetAddressTracker().deregister(ChannelExtensionsKt.inetAddress(ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
        }
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ChannelHandlerContext channelHandlerContext = ctx.read();
        Intrinsics.checkNotNullExpressionValue((Object)channelHandlerContext, (String)"read(...)");
        this.client = new Js5Client(channelHandlerContext);
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.onClientConnected$osrs_229_api(js5Client);
        this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor().incrementConnections(ChannelExtensionsKt.inetAddress(ctx));
    }

    public void handlerRemoved(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.onClientDisconnected$osrs_229_api(js5Client);
        this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor().decrementConnections(ChannelExtensionsKt.inetAddress(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingJs5Message msg) {
        block65: {
            block70: {
                IncomingJs5Message incomingJs5Message;
                block68: {
                    Js5Client js5Client;
                    block66: {
                        Js5Client js5Client2;
                        block63: {
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                            incomingJs5Message = msg;
                            if (!(incomingJs5Message instanceof Js5GroupRequest)) break block63;
                            Logger logger$iv = logger;
                            boolean bl = false;
                            LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                            boolean bl2 = false;
                            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    boolean bl3 = false;
                                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl4 = false;
                                        logger.trace(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                                case 3: {
                                    boolean bl5 = false;
                                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl6 = false;
                                        logger.debug(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                                case 4: {
                                    boolean bl7 = false;
                                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl8 = false;
                                        logger.info(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                                case 5: {
                                    boolean bl9 = false;
                                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl10 = false;
                                        logger.warn(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                                case 6: {
                                    boolean bl11 = false;
                                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl12 = false;
                                        logger.error(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                            }
                            Js5Service js5Service = this.getService();
                            Js5Client js5Client3 = this.client;
                            if (js5Client3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                                js5Client3 = null;
                            }
                            js5Service.push(js5Client3, (Js5GroupRequest)msg);
                            break block65;
                        }
                        if (!Intrinsics.areEqual((Object)incomingJs5Message, (Object)PriorityChangeLow.INSTANCE)) break block66;
                        Logger logger$iv = logger;
                        boolean bl = false;
                        LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                        boolean bl13 = false;
                        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                boolean bl14 = false;
                                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl15 = false;
                                    logger.trace(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                            case 3: {
                                boolean bl16 = false;
                                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl17 = false;
                                    logger.debug(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                            case 4: {
                                boolean bl18 = false;
                                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl19 = false;
                                    logger.info(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                            case 5: {
                                boolean bl20 = false;
                                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl21 = false;
                                    logger.warn(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                            case 6: {
                                boolean bl22 = false;
                                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl23 = false;
                                    logger.error(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                        }
                        if ((js5Client2 = this.client) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            js5Client2 = null;
                        }
                        js5Client2.setLowPriority();
                        Js5Service js5Service = this.getService();
                        Js5Client js5Client4 = this.client;
                        if (js5Client4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            js5Client4 = null;
                        }
                        js5Service.readIfNotFull(js5Client4);
                        Js5Service js5Service2 = this.getService();
                        Js5Client js5Client5 = this.client;
                        if (js5Client5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            js5Client5 = null;
                        }
                        js5Service2.notifyIfNotEmpty(js5Client5);
                        break block65;
                    }
                    if (!Intrinsics.areEqual((Object)incomingJs5Message, (Object)PriorityChangeHigh.INSTANCE)) break block68;
                    Logger logger$iv = logger;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                    boolean bl24 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl25 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl26 = false;
                                logger.trace(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl27 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl28 = false;
                                logger.debug(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl29 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl30 = false;
                                logger.info(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl31 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl32 = false;
                                logger.warn(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl33 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl34 = false;
                                logger.error(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                    }
                    if ((js5Client = this.client) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        js5Client = null;
                    }
                    js5Client.setHighPriority();
                    Js5Service js5Service = this.getService();
                    Js5Client js5Client6 = this.client;
                    if (js5Client6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        js5Client6 = null;
                    }
                    js5Service.readIfNotFull(js5Client6);
                    break block65;
                }
                if (!(incomingJs5Message instanceof XorChange)) break block70;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                boolean bl35 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl36 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl37 = false;
                            logger.trace(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl38 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl39 = false;
                            logger.debug(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl40 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl41 = false;
                            logger.info(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl42 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl43 = false;
                            logger.warn(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl44 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl45 = false;
                            logger.error(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                }
                Js5Service this_$iv = this.getService();
                boolean $i$f$use = false;
                Object object = this_$iv.getLock();
                synchronized (object) {
                    boolean bl46 = false;
                    boolean bl47 = false;
                    Js5Client js5Client = this.client;
                    if (js5Client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        js5Client = null;
                    }
                    js5Client.setXorKey(((XorChange)msg).getKey());
                    Js5Service js5Service = this.getService();
                    Js5Client js5Client7 = this.client;
                    if (js5Client7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        js5Client7 = null;
                    }
                    js5Service.readIfNotFull(js5Client7);
                    Unit unit = Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("Unknown JS5 message: " + msg);
        }
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.readIfNotFull(js5Client);
    }

    public void channelWritabilityChanged(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.channel().isWritable()) {
            Js5Service js5Service = this.getService();
            Js5Client js5Client = this.client;
            if (js5Client == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client = null;
            }
            js5Service.notifyIfNotEmpty(js5Client);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_229_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), Js5DisconnectionReason.EXCEPTION);
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), Js5DisconnectionReason.IDLE);
            ctx.close();
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/js5/Js5ChannelHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-229-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

