/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.social;

import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ServerProtCategory;
import net.rsprot.protocol.game.outgoing.GameServerProtCategory;
import net.rsprot.protocol.message.OutgoingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList;", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "friends", "", "Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$Friend;", "(Ljava/util/List;)V", "category", "Lnet/rsprot/protocol/ServerProtCategory;", "getCategory", "()Lnet/rsprot/protocol/ServerProtCategory;", "getFriends", "()Ljava/util/List;", "equals", "", "other", "", "estimateSize", "", "hashCode", "toString", "", "Companion", "Friend", "OfflineFriend", "OnlineFriend", "osrs-228-model"})
public final class UpdateFriendList
implements OutgoingGameMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Friend> friends;
    public static final int PROPERTY_REFERRED = 1;
    public static final int PROPERTY_REFERRER = 2;

    public UpdateFriendList(@NotNull List<? extends Friend> friends) {
        Intrinsics.checkNotNullParameter(friends, (String)"friends");
        this.friends = friends;
    }

    @NotNull
    public final List<Friend> getFriends() {
        return this.friends;
    }

    @NotNull
    public ServerProtCategory getCategory() {
        return GameServerProtCategory.LOW_PRIORITY_PROT;
    }

    public int estimateSize() {
        int sizePerFriend = 38;
        return this.friends.size() * sizePerFriend;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.outgoing.social.UpdateFriendList");
        UpdateFriendList cfr_ignored_0 = (UpdateFriendList)other;
        return Intrinsics.areEqual(this.friends, ((UpdateFriendList)other).friends);
    }

    public int hashCode() {
        return ((Object)this.friends).hashCode();
    }

    @NotNull
    public String toString() {
        return "UpdateFriendList(friends=" + this.friends + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$Companion;", "", "()V", "PROPERTY_REFERRED", "", "PROPERTY_REFERRER", "osrs-228-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0012\u0010\u0014\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\u0082\u0001\u0002\u0016\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$Friend;", "", "added", "", "getAdded", "()Z", "name", "", "getName", "()Ljava/lang/String;", "notes", "getNotes", "previousName", "getPreviousName", "properties", "", "getProperties", "()I", "rank", "getRank", "worldId", "getWorldId", "Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$OfflineFriend;", "Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$OnlineFriend;", "osrs-228-model"})
    public static interface Friend {
        public boolean getAdded();

        @NotNull
        public String getName();

        @Nullable
        public String getPreviousName();

        public int getWorldId();

        public int getRank();

        public int getProperties();

        @NotNull
        public String getNotes();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\u0005H\u0016R\u0016\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\f\u001a\u00020\rX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$OfflineFriend;", "Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$Friend;", "added", "", "name", "", "previousName", "rank", "", "properties", "notes", "(ZLjava/lang/String;Ljava/lang/String;IILjava/lang/String;)V", "_rank", "Lkotlin/UByte;", "_properties", "(ZLjava/lang/String;Ljava/lang/String;BBLjava/lang/String;)V", "B", "getAdded", "()Z", "getName", "()Ljava/lang/String;", "getNotes", "getPreviousName", "getProperties", "()I", "getRank", "worldId", "getWorldId", "equals", "other", "", "hashCode", "toString", "osrs-228-model"})
    public static final class OfflineFriend
    implements Friend {
        private final boolean added;
        @NotNull
        private final String name;
        @Nullable
        private final String previousName;
        private final byte _rank;
        private final byte _properties;
        @NotNull
        private final String notes;

        private OfflineFriend(boolean added, String name, String previousName, byte _rank, byte _properties, String notes) {
            this.added = added;
            this.name = name;
            this.previousName = previousName;
            this._rank = _rank;
            this._properties = _properties;
            this.notes = notes;
        }

        @Override
        public boolean getAdded() {
            return this.added;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getPreviousName() {
            return this.previousName;
        }

        @Override
        @NotNull
        public String getNotes() {
            return this.notes;
        }

        public OfflineFriend(boolean added, @NotNull String name, @Nullable String previousName, int rank, int properties, @NotNull String notes) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)notes, (String)"notes");
            this(added, name, previousName, UByte.constructor-impl((byte)((byte)rank)), UByte.constructor-impl((byte)((byte)properties)), notes);
        }

        @Override
        public int getRank() {
            return this._rank & 0xFF;
        }

        @Override
        public int getProperties() {
            return this._properties & 0xFF;
        }

        @Override
        public int getWorldId() {
            return 0;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.outgoing.social.UpdateFriendList.OfflineFriend");
            OfflineFriend cfr_ignored_0 = (OfflineFriend)other;
            if (this.getAdded() != ((OfflineFriend)other).getAdded()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getName(), (Object)((OfflineFriend)other).getName())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getPreviousName(), (Object)((OfflineFriend)other).getPreviousName())) {
                return false;
            }
            if (this._rank != ((OfflineFriend)other)._rank) {
                return false;
            }
            if (this._properties != ((OfflineFriend)other)._properties) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.getNotes(), (Object)((OfflineFriend)other).getNotes());
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.getAdded());
            result = 31 * result + this.getName().hashCode();
            String string = this.getPreviousName();
            result = 31 * result + (string != null ? string.hashCode() : 0);
            result = 31 * result + UByte.hashCode-impl((byte)this._rank);
            result = 31 * result + UByte.hashCode-impl((byte)this._properties);
            result = 31 * result + this.getNotes().hashCode();
            return result;
        }

        @NotNull
        public String toString() {
            return "OfflineFriend(added=" + this.getAdded() + ", name='" + this.getName() + "', previousName=" + this.getPreviousName() + ", rank=" + this.getRank() + ", properties=" + this.getProperties() + ", notes='" + this.getNotes() + "')";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001BY\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fBY\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\u0015\u001a\u00020\u0013\u0012\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020\u0005H\u0016R\u0016\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u000b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001fR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001c\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006+"}, d2={"Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$OnlineFriend;", "Lnet/rsprot/protocol/game/outgoing/social/UpdateFriendList$Friend;", "added", "", "name", "", "previousName", "worldId", "", "rank", "properties", "notes", "worldName", "platform", "worldFlags", "(ZLjava/lang/String;Ljava/lang/String;IIILjava/lang/String;Ljava/lang/String;II)V", "_worldId", "Lkotlin/UShort;", "_rank", "Lkotlin/UByte;", "_properties", "_platform", "(ZLjava/lang/String;Ljava/lang/String;SBBLjava/lang/String;Ljava/lang/String;BI)V", "B", "S", "getAdded", "()Z", "getName", "()Ljava/lang/String;", "getNotes", "getPlatform", "()I", "getPreviousName", "getProperties", "getRank", "getWorldFlags", "getWorldId", "getWorldName", "equals", "other", "", "hashCode", "toString", "osrs-228-model"})
    public static final class OnlineFriend
    implements Friend {
        private final boolean added;
        @NotNull
        private final String name;
        @Nullable
        private final String previousName;
        private final short _worldId;
        private final byte _rank;
        private final byte _properties;
        @NotNull
        private final String notes;
        @NotNull
        private final String worldName;
        private final byte _platform;
        private final int worldFlags;

        private OnlineFriend(boolean added, String name, String previousName, short _worldId, byte _rank, byte _properties, String notes, String worldName, byte _platform, int worldFlags) {
            this.added = added;
            this.name = name;
            this.previousName = previousName;
            this._worldId = _worldId;
            this._rank = _rank;
            this._properties = _properties;
            this.notes = notes;
            this.worldName = worldName;
            this._platform = _platform;
            this.worldFlags = worldFlags;
        }

        @Override
        public boolean getAdded() {
            return this.added;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getPreviousName() {
            return this.previousName;
        }

        @Override
        @NotNull
        public String getNotes() {
            return this.notes;
        }

        @NotNull
        public final String getWorldName() {
            return this.worldName;
        }

        public final int getWorldFlags() {
            return this.worldFlags;
        }

        public OnlineFriend(boolean added, @NotNull String name, @Nullable String previousName, int worldId, int rank, int properties, @NotNull String notes, @NotNull String worldName, int platform, int worldFlags) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)notes, (String)"notes");
            Intrinsics.checkNotNullParameter((Object)worldName, (String)"worldName");
            this(added, name, previousName, UShort.constructor-impl((short)((short)worldId)), UByte.constructor-impl((byte)((byte)rank)), UByte.constructor-impl((byte)((byte)properties)), notes, worldName, UByte.constructor-impl((byte)((byte)platform)), worldFlags);
            if (!(worldId > 0)) {
                boolean bl = false;
                String string = "World id must be greater than 0 for online friends";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        public int getWorldId() {
            return this._worldId & 0xFFFF;
        }

        @Override
        public int getRank() {
            return this._rank & 0xFF;
        }

        @Override
        public int getProperties() {
            return this._properties & 0xFF;
        }

        public final int getPlatform() {
            return this._platform & 0xFF;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.outgoing.social.UpdateFriendList.OnlineFriend");
            OnlineFriend cfr_ignored_0 = (OnlineFriend)other;
            if (this.getAdded() != ((OnlineFriend)other).getAdded()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getName(), (Object)((OnlineFriend)other).getName())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getPreviousName(), (Object)((OnlineFriend)other).getPreviousName())) {
                return false;
            }
            if (this._worldId != ((OnlineFriend)other)._worldId) {
                return false;
            }
            if (this._rank != ((OnlineFriend)other)._rank) {
                return false;
            }
            if (this._properties != ((OnlineFriend)other)._properties) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getNotes(), (Object)((OnlineFriend)other).getNotes())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.worldName, (Object)((OnlineFriend)other).worldName)) {
                return false;
            }
            if (this._platform != ((OnlineFriend)other)._platform) {
                return false;
            }
            return this.worldFlags == ((OnlineFriend)other).worldFlags;
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.getAdded());
            result = 31 * result + this.getName().hashCode();
            String string = this.getPreviousName();
            result = 31 * result + (string != null ? string.hashCode() : 0);
            result = 31 * result + UShort.hashCode-impl((short)this._worldId);
            result = 31 * result + UByte.hashCode-impl((byte)this._rank);
            result = 31 * result + UByte.hashCode-impl((byte)this._properties);
            result = 31 * result + this.getNotes().hashCode();
            result = 31 * result + this.worldName.hashCode();
            result = 31 * result + UByte.hashCode-impl((byte)this._platform);
            result = 31 * result + this.worldFlags;
            return result;
        }

        @NotNull
        public String toString() {
            return "OnlineFriend(added=" + this.getAdded() + ", name='" + this.getName() + "', previousName=" + this.getPreviousName() + ", worldId=" + this.getWorldId() + ", rank=" + this.getRank() + ", properties=" + this.getProperties() + ", worldName='" + this.worldName + "', platform=" + this.getPlatform() + ", worldFlags=" + this.worldFlags + ", notes='" + this.getNotes() + "')";
        }
    }
}

