/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.worldentityinfo;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.common.RSProtThreadSafetyKt;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.common.game.outgoing.info.util.ZoneIndexStorage;
import net.rsprot.protocol.game.outgoing.info.ByteBufRecycler;
import net.rsprot.protocol.game.outgoing.info.worker.DefaultProtocolWorker;
import net.rsprot.protocol.game.outgoing.info.worker.ProtocolWorker;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatar;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatarExceptionHandler;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatarFactory;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatarRepository;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityInfo;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityInfoRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0001,B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001a2\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0018J$\u0010$\u001a\u00020\u00122\u0019\b\u0004\u0010%\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120&\u00a2\u0006\u0002\b'H\u0082\bJ\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u0012H\u0002J\u0006\u0010*\u001a\u00020\u0012J\b\u0010+\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityProtocol;", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "exceptionHandler", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarExceptionHandler;", "factory", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarFactory;", "worker", "Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;", "zoneIndexStorage", "Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarExceptionHandler;Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarFactory;Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;)V", "avatarRepository", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository;", "callables", "", "Ljava/util/concurrent/Callable;", "", "recycler", "Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;", "worldEntityInfoRepository", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfoRepository;", "alloc", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo;", "idx", "", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "catchException", "index", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "dealloc", "info", "execute", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "postUpdate", "prepareHighResolutionBuffers", "update", "updateInfos", "Companion", "osrs-228-model"})
@SourceDebugExtension(value={"SMAP\nWorldEntityProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldEntityProtocol.kt\nnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityProtocol\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,211:1\n151#1,3:216\n167#1,3:219\n151#1,3:226\n167#1,3:229\n134#2,4:212\n134#2,4:222\n11#3,2:232\n*S KotlinDebug\n*F\n+ 1 WorldEntityProtocol.kt\nnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityProtocol\n*L\n117#1:216,3\n117#1:219,3\n140#1:226,3\n140#1:229,3\n105#1:212,4\n133#1:222,4\n195#1:232,2\n*E\n"})
public final class WorldEntityProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final WorldEntityAvatarExceptionHandler exceptionHandler;
    @NotNull
    private final ProtocolWorker worker;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final ByteBufRecycler recycler;
    @NotNull
    private final WorldEntityAvatarRepository avatarRepository;
    @NotNull
    private final WorldEntityInfoRepository worldEntityInfoRepository;
    @NotNull
    private final List<Callable<Unit>> callables;
    public static final int CAPACITY = 2048;
    @NotNull
    private static final Logger logger;
    private static int cycleCount;

    public WorldEntityProtocol(@NotNull ByteBufAllocator allocator, @NotNull WorldEntityAvatarExceptionHandler exceptionHandler, @NotNull WorldEntityAvatarFactory factory, @NotNull ProtocolWorker worker, @NotNull ZoneIndexStorage zoneIndexStorage) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        this.allocator = allocator;
        this.exceptionHandler = exceptionHandler;
        this.worker = worker;
        this.zoneIndexStorage = zoneIndexStorage;
        this.recycler = new ByteBufRecycler(0, 1, null);
        this.avatarRepository = factory.getAvatarRepository$osrs_228_model();
        this.worldEntityInfoRepository = new WorldEntityInfoRepository((Function2<? super Integer, ? super OldSchoolClientType, WorldEntityInfo>)((Function2)new Function2<Integer, OldSchoolClientType, WorldEntityInfo>(this, factory){
            final /* synthetic */ WorldEntityProtocol this$0;
            final /* synthetic */ WorldEntityAvatarFactory $factory;
            {
                this.this$0 = $receiver;
                this.$factory = $factory;
                super(2);
            }

            @NotNull
            public final WorldEntityInfo invoke(int localIndex, @NotNull OldSchoolClientType clientType) {
                Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
                return new WorldEntityInfo(localIndex, WorldEntityProtocol.access$getAllocator$p(this.this$0), clientType, this.$factory.getAvatarRepository$osrs_228_model(), WorldEntityProtocol.access$getZoneIndexStorage$p(this.this$0), WorldEntityProtocol.access$getRecycler$p(this.this$0));
            }
        }));
        this.callables = new ArrayList(2048);
    }

    public /* synthetic */ WorldEntityProtocol(ByteBufAllocator byteBufAllocator, WorldEntityAvatarExceptionHandler worldEntityAvatarExceptionHandler, WorldEntityAvatarFactory worldEntityAvatarFactory, ProtocolWorker protocolWorker, ZoneIndexStorage zoneIndexStorage, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            protocolWorker = new DefaultProtocolWorker();
        }
        this(byteBufAllocator, worldEntityAvatarExceptionHandler, worldEntityAvatarFactory, protocolWorker, zoneIndexStorage);
    }

    @NotNull
    public final WorldEntityInfo alloc(int idx, @NotNull OldSchoolClientType oldSchoolClientType) {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        RSProtThreadSafetyKt.checkCommunicationThread();
        return (WorldEntityInfo)this.worldEntityInfoRepository.alloc(idx, oldSchoolClientType);
    }

    public final void dealloc(@NotNull WorldEntityInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (info.isDestroyed()) {
            return;
        }
        this.worldEntityInfoRepository.dealloc(info.getLocalIndex$osrs_228_model());
    }

    public final void update() {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.prepareHighResolutionBuffers();
        this.updateInfos();
        this.postUpdate();
        this.recycler.cycle();
        int n = cycleCount;
        cycleCount = n + 1;
    }

    private final void prepareHighResolutionBuffers() {
        for (int i = 0; i < 2048; ++i) {
            if (this.avatarRepository.getOrNull(i) == null) continue;
            try {
                WorldEntityAvatar avatar;
                avatar.precompute$osrs_228_model();
                continue;
            }
            catch (Exception e) {
                this.exceptionHandler.exceptionCaught(i, e);
                continue;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Error during worldentity avatar computation"), t);
                }
                throw t;
            }
        }
    }

    private final void updateInfos() {
        WorldEntityProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            WorldEntityInfo info$iv;
            if ((WorldEntityInfo)this_$iv.worldEntityInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ WorldEntityInfo $info;
                final /* synthetic */ WorldEntityProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        WorldEntityInfo $this$updateInfos_u24lambda_u241 = this.$info;
                        boolean bl = false;
                        $this$updateInfos_u24lambda_u241.updateWorldEntities$osrs_228_model();
                    }
                    catch (Exception e) {
                        WorldEntityProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = WorldEntityProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during worldentity updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void postUpdate() {
        for (int i = 0; i < 2048; ++i) {
            if (this.avatarRepository.getOrNull(i) == null) continue;
            try {
                WorldEntityAvatar avatar;
                avatar.postUpdate();
                continue;
            }
            catch (Exception e) {
                this.exceptionHandler.exceptionCaught(i, e);
                continue;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Error during worldentity avatar computation"), t);
                }
                throw t;
            }
        }
        WorldEntityProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            WorldEntityInfo info$iv;
            if ((WorldEntityInfo)this_$iv.worldEntityInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ WorldEntityInfo $info;
                final /* synthetic */ WorldEntityProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        WorldEntityInfo $this$postUpdate_u24lambda_u243 = this.$info;
                        boolean bl = false;
                        $this$postUpdate_u24lambda_u243.postUpdate$osrs_228_model();
                    }
                    catch (Exception e) {
                        WorldEntityProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = WorldEntityProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during worldentity updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void execute(Function1<? super WorldEntityInfo, Unit> block) {
        boolean $i$f$execute = false;
        for (int i = 1; i < 2048; ++i) {
            WorldEntityInfo info;
            if ((WorldEntityInfo)this.worldEntityInfoRepository.getOrNull(i) == null) continue;
            ((Collection)this.callables).add(new Callable(block, info, this, i){
                final /* synthetic */ Function1<WorldEntityInfo, Unit> $block;
                final /* synthetic */ WorldEntityInfo $info;
                final /* synthetic */ WorldEntityProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$block = $block;
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        this.$block.invoke((Object)this.$info);
                    }
                    catch (Exception e) {
                        WorldEntityProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = WorldEntityProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during worldentity updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this.worker.execute(this.callables);
        this.callables.clear();
    }

    private final void catchException(int index, Exception exception) {
        WorldEntityInfo worldEntityInfo = (WorldEntityInfo)this.worldEntityInfoRepository.getOrNull(index);
        if (worldEntityInfo == null) {
            return;
        }
        WorldEntityInfo info = worldEntityInfo;
        this.worldEntityInfoRepository.destroy(index);
        info.setException$osrs_228_model(exception);
    }

    public static final /* synthetic */ void access$catchException(WorldEntityProtocol $this, int index, Exception exception) {
        $this.catchException(index, exception);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ByteBufAllocator access$getAllocator$p(WorldEntityProtocol $this) {
        return $this.allocator;
    }

    public static final /* synthetic */ ZoneIndexStorage access$getZoneIndexStorage$p(WorldEntityProtocol $this) {
        return $this.zoneIndexStorage;
    }

    public static final /* synthetic */ ByteBufRecycler access$getRecycler$p(WorldEntityProtocol $this) {
        return $this.recycler;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityProtocol$Companion;", "", "()V", "CAPACITY", "", "cycleCount", "getCycleCount$osrs_228_model", "()I", "setCycleCount$osrs_228_model", "(I)V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-228-model"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCycleCount$osrs_228_model() {
            return cycleCount;
        }

        public final void setCycleCount$osrs_228_model(int n) {
            cycleCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

