/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.loginprot.incoming.pow.challenges.sha256;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.ChallengeGenerator;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.sha256.Sha256Challenge;
import net.rsprot.protocol.loginprot.incoming.pow.challenges.sha256.Sha256MetaData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00072\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/sha256/DefaultSha256ChallengeGenerator;", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/ChallengeGenerator;", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/sha256/Sha256MetaData;", "Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/sha256/Sha256Challenge;", "()V", "generate", "input", "Companion", "osrs-228-model"})
public final class DefaultSha256ChallengeGenerator
implements ChallengeGenerator<Sha256MetaData, Sha256Challenge> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final int RANDOM_DATA_LENGTH = 495;
    private static final int HEX_RADIX = 16;

    @Override
    @NotNull
    public Sha256Challenge generate(@NotNull Sha256MetaData input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] randomData = Random.Default.nextBytes(495);
        String hexSalt = new BigInteger(randomData).toString(16);
        String salt = Long.toHexString(input.getEpochTimeMillis()) + Integer.toHexString(input.getWorld()) + hexSalt;
        return new Sha256Challenge(input.getVersion(), input.getDifficulty(), salt);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/loginprot/incoming/pow/challenges/sha256/DefaultSha256ChallengeGenerator$Companion;", "", "()V", "HEX_RADIX", "", "RANDOM_DATA_LENGTH", "osrs-228-model"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

