/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.js5.Js5ChannelHandler;
import net.rsprot.protocol.api.js5.Js5MessageDecoder;
import net.rsprot.protocol.api.js5.Js5MessageEncoder;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginDisconnectionReason;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.api.metrics.ChannelTrafficHandlerExtensionsKt;
import net.rsprot.protocol.common.LogLevel;
import net.rsprot.protocol.common.RSProtFlags;
import net.rsprot.protocol.loginprot.incoming.InitGameConnection;
import net.rsprot.protocol.loginprot.incoming.InitJs5RemoteConnection;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.IncomingLoginMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingLoginMessage;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "channelReadComplete", "exceptionCaught", "cause", "", "handleInitGameConnection", "handleInitJs5RemoteConnection", "revision", "", "seed", "", "handlerAdded", "handlerRemoved", "userEventTriggered", "evt", "", "Companion", "osrs-228-api"})
@SourceDebugExtension(value={"SMAP\nLoginChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 ChannelExtensions.kt\nnet/rsprot/protocol/api/channel/ChannelExtensionsKt\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,289:1\n20#2:290\n44#2,6:291\n52#2:301\n55#2:306\n58#2:311\n61#2:316\n64#2:321\n21#2:322\n20#2:323\n44#2,6:324\n52#2:334\n55#2:339\n58#2:344\n61#2:349\n64#2:354\n21#2:355\n20#2:356\n44#2,6:357\n52#2:367\n55#2:372\n58#2:377\n61#2:382\n64#2:387\n21#2:388\n20#2:389\n44#2,6:390\n52#2:400\n55#2:405\n58#2:410\n61#2:415\n64#2:420\n21#2:421\n20#2:422\n44#2,6:423\n52#2:433\n55#2:438\n58#2:443\n61#2:448\n64#2:453\n21#2:454\n20#2:455\n44#2,6:456\n52#2:466\n55#2:471\n58#2:476\n61#2:481\n64#2:486\n21#2:487\n20#2:488\n44#2,6:489\n52#2:499\n55#2:504\n58#2:509\n61#2:514\n64#2:519\n21#2:520\n20#2:521\n44#2,6:522\n52#2:532\n55#2:537\n58#2:542\n61#2:547\n64#2:552\n21#2:553\n20#2:554\n44#2,6:555\n52#2:565\n55#2:570\n58#2:575\n61#2:580\n64#2:585\n21#2:586\n20#2:589\n44#2,6:590\n52#2:600\n55#2:605\n58#2:610\n61#2:615\n64#2:620\n21#2:621\n20#2:622\n44#2,6:623\n52#2:633\n55#2:638\n58#2:643\n61#2:648\n64#2:653\n21#2:654\n32#3,4:297\n56#3,4:302\n80#3,4:307\n104#3,4:312\n128#3,4:317\n32#3,4:330\n56#3,4:335\n80#3,4:340\n104#3,4:345\n128#3,4:350\n32#3,4:363\n56#3,4:368\n80#3,4:373\n104#3,4:378\n128#3,4:383\n32#3,4:396\n56#3,4:401\n80#3,4:406\n104#3,4:411\n128#3,4:416\n32#3,4:429\n56#3,4:434\n80#3,4:439\n104#3,4:444\n128#3,4:449\n32#3,4:462\n56#3,4:467\n80#3,4:472\n104#3,4:477\n128#3,4:482\n32#3,4:495\n56#3,4:500\n80#3,4:505\n104#3,4:510\n128#3,4:515\n32#3,4:528\n56#3,4:533\n80#3,4:538\n104#3,4:543\n128#3,4:548\n32#3,4:561\n56#3,4:566\n80#3,4:571\n104#3,4:576\n128#3,4:581\n32#3,4:596\n56#3,4:601\n80#3,4:606\n104#3,4:611\n128#3,4:616\n32#3,4:629\n56#3,4:634\n80#3,4:639\n104#3,4:644\n128#3,4:649\n36#4:587\n36#4:588\n36#4:655\n36#4:656\n36#4:657\n36#4:658\n11#5,2:659\n*S KotlinDebug\n*F\n+ 1 LoginChannelHandler.kt\nnet/rsprot/protocol/api/login/LoginChannelHandler\n*L\n49#1:290\n49#1:291,6\n49#1:301\n49#1:306\n49#1:311\n49#1:316\n49#1:321\n49#1:322\n59#1:323\n59#1:324,6\n59#1:334\n59#1:339\n59#1:344\n59#1:349\n59#1:354\n59#1:355\n96#1:356\n96#1:357,6\n96#1:367\n96#1:372\n96#1:377\n96#1:382\n96#1:387\n96#1:388\n116#1:389\n116#1:390,6\n116#1:400\n116#1:405\n116#1:410\n116#1:415\n116#1:420\n116#1:421\n162#1:422\n162#1:423,6\n162#1:433\n162#1:438\n162#1:443\n162#1:448\n162#1:453\n162#1:454\n189#1:455\n189#1:456,6\n189#1:466\n189#1:471\n189#1:476\n189#1:481\n189#1:486\n189#1:487\n270#1:488\n270#1:489,6\n270#1:499\n270#1:504\n270#1:509\n270#1:514\n270#1:519\n270#1:520\n124#1:521\n124#1:522,6\n124#1:532\n124#1:537\n124#1:542\n124#1:547\n124#1:552\n124#1:553\n133#1:554\n133#1:555,6\n133#1:565\n133#1:570\n133#1:575\n133#1:580\n133#1:585\n133#1:586\n209#1:589\n209#1:590,6\n209#1:600\n209#1:605\n209#1:610\n209#1:615\n209#1:620\n209#1:621\n218#1:622\n218#1:623,6\n218#1:633\n218#1:638\n218#1:643\n218#1:648\n218#1:653\n218#1:654\n49#1:297,4\n49#1:302,4\n49#1:307,4\n49#1:312,4\n49#1:317,4\n59#1:330,4\n59#1:335,4\n59#1:340,4\n59#1:345,4\n59#1:350,4\n96#1:363,4\n96#1:368,4\n96#1:373,4\n96#1:378,4\n96#1:383,4\n116#1:396,4\n116#1:401,4\n116#1:406,4\n116#1:411,4\n116#1:416,4\n162#1:429,4\n162#1:434,4\n162#1:439,4\n162#1:444,4\n162#1:449,4\n189#1:462,4\n189#1:467,4\n189#1:472,4\n189#1:477,4\n189#1:482,4\n270#1:495,4\n270#1:500,4\n270#1:505,4\n270#1:510,4\n270#1:515,4\n124#1:528,4\n124#1:533,4\n124#1:538,4\n124#1:543,4\n124#1:548,4\n133#1:561,4\n133#1:566,4\n133#1:571,4\n133#1:576,4\n133#1:581,4\n209#1:596,4\n209#1:601,4\n209#1:606,4\n209#1:611,4\n209#1:616,4\n218#1:629,4\n218#1:634,4\n218#1:639,4\n218#1:644,4\n218#1:649,4\n142#1:587\n143#1:588\n227#1:655\n228#1:656\n229#1:657\n230#1:658\n286#1:659,2\n*E\n"})
public final class LoginChannelHandler
extends SimpleChannelInboundHandler<IncomingLoginMessage> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private static final Logger logger;

    public LoginChannelHandler(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingLoginMessage.class);
        this.networkService = networkService;
    }

    @NotNull
    public final NetworkService<?> getNetworkService() {
        return this.networkService;
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor().incrementConnections(ChannelExtensionsKt.inetAddress(ctx));
    }

    public void handlerRemoved(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor().decrementConnections(ChannelExtensionsKt.inetAddress(ctx));
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel is now active: " + ctx.channel()));
                }
                break;
            }
        }
        ctx.fireChannelActive();
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingLoginMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Login channel message in channel '" + ctx.channel() + "': " + msg));
                }
                break;
            }
        }
        IncomingLoginMessage incomingLoginMessage = msg;
        if (Intrinsics.areEqual((Object)incomingLoginMessage, (Object)InitGameConnection.INSTANCE)) {
            this.handleInitGameConnection(ctx);
        } else if (incomingLoginMessage instanceof InitJs5RemoteConnection) {
            this.handleInitJs5RemoteConnection(ctx, ((InitJs5RemoteConnection)msg).getRevision(), ((InitJs5RemoteConnection)msg).getSeed());
        } else {
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), LoginDisconnectionReason.CHANNEL_UNKNOWN_PACKET);
            throw new IllegalStateException("Unknown login channel message: " + msg);
        }
    }

    private final void handleInitGameConnection(ChannelHandlerContext ctx) {
        InetAddress address;
        block26: {
            address = ChannelExtensionsKt.inetAddress(ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_228_api().getGameInetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_228_api().getInetAddressValidator().acceptGameConnection(address, count);
            if (accepted) break block26;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected game connection for channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.write((Object)LoginResponse.TooManyAttempts.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), LoginDisconnectionReason.CHANNEL_IP_LIMIT);
            return;
        }
        long sessionId = this.networkService.getLoginHandlers$osrs_228_api().getSessionIdGenerator().generate(address);
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl13 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl14 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl15 = false;
                    logger.trace(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 3: {
                boolean bl16 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl17 = false;
                    logger.debug(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 4: {
                boolean bl18 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl19 = false;
                    logger.info(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 5: {
                boolean bl20 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl21 = false;
                    logger.warn(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
            case 6: {
                boolean bl22 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl23 = false;
                    logger.error(String.valueOf("Game connection accepted with session id: " + NumberFormat.getNumberInstance().format(sessionId)));
                }
                break;
            }
        }
        ctx.write((Object)new LoginResponse.Successful(Long.valueOf(sessionId))).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitGameConnection$lambda$6(ctx, this, address, sessionId, arg_0)));
    }

    private final void handleInitJs5RemoteConnection(ChannelHandlerContext ctx, int revision, int[] seed) {
        InetAddress address;
        block28: {
            block26: {
                if (revision == 228) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Invalid JS5 revision received from channel '" + ctx.channel() + "': " + revision));
                        }
                        break;
                    }
                }
                ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), LoginDisconnectionReason.CHANNEL_OUT_OF_DATE);
                ctx.write((Object)LoginResponse.ClientOutOfDate.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            address = ChannelExtensionsKt.inetAddress(ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_228_api().getJs5InetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_228_api().getInetAddressValidator().acceptJs5Connection(address, count, seed);
            if (accepted) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected JS5 connection for channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ctx.write((Object)LoginResponse.IPLimit.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), LoginDisconnectionReason.CHANNEL_IP_LIMIT);
            return;
        }
        ctx.write((Object)new LoginResponse.Successful(null)).addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> LoginChannelHandler.handleInitJs5RemoteConnection$lambda$11(ctx, this, address, arg_0)));
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_228_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), LoginDisconnectionReason.CHANNEL_EXCEPTION);
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Login channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(ctx), LoginDisconnectionReason.CHANNEL_IDLE);
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }

    private static final void handleInitGameConnection$lambda$6(ChannelHandlerContext $ctx, LoginChannelHandler this$0, InetAddress $address, long $sessionId, ChannelFuture future2) {
        ChannelPipeline $this$replace$iv;
        block28: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                if (future2.isSuccess()) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Failed to write a successful game connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                }
                future2.channel().pipeline().fireExceptionCaught(future2.cause());
                future2.channel().close();
                return;
            }
            if (!$ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Tracking game INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_228_api().getGameInetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = future2.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new LoginConnectionHandler(this$0.networkService, $sessionId);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 40L, 40L, 40L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    private static final void handleInitJs5RemoteConnection$lambda$11(ChannelHandlerContext $ctx, LoginChannelHandler this$0, InetAddress $address, ChannelFuture future2) {
        ChannelPipeline $this$replace$iv;
        block28: {
            block26: {
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
                if (future2.isSuccess()) break block26;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Failed to write a successful JS5 connection response to channel " + $ctx.channel()));
                        }
                        break;
                    }
                }
                future2.channel().pipeline().fireExceptionCaught(future2.cause());
                future2.channel().close();
                return;
            }
            if (!$ctx.channel().isActive()) break block28;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Tracking JS5 INetAddress for channel '" + future2.channel() + "': " + $address));
                    }
                    break;
                }
            }
            this$0.networkService.getINetAddressHandlers$osrs_228_api().getJs5InetAddressTracker().register($address);
        }
        ChannelPipeline pipeline = $ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        ChannelPipeline bl = pipeline;
        ChannelHandler newHandler$iv = (ChannelHandler)new Js5MessageDecoder(this$0.networkService);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5MessageEncoder(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new Js5ChannelHandler(this$0.networkService);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginChannelHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 30L, 30L, 30L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/login/LoginChannelHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-228-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

