/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.login;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.crypto.cipher.StreamCipherPair;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.Session;
import net.rsprot.protocol.api.StreamCipherProvider;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.game.GameMessageDecoder;
import net.rsprot.protocol.api.game.GameMessageEncoder;
import net.rsprot.protocol.api.game.GameMessageHandler;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginConnectionHandler;
import net.rsprot.protocol.api.login.LoginDisconnectionReason;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.api.metrics.ChannelTrafficHandlerExtensionsKt;
import net.rsprot.protocol.common.LogLevel;
import net.rsprot.protocol.common.RSProtFlags;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.loginprot.incoming.util.LoginClientType;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.incoming.GameMessageConsumerRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001!B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J:\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00152\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u001f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\"\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020 2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler;", "R", "", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "(Lnet/rsprot/protocol/api/NetworkService;Lio/netty/channel/ChannelHandlerContext;)V", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "createSession", "Lnet/rsprot/protocol/api/Session;", "loginBlock", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "pipeline", "Lio/netty/channel/ChannelPipeline;", "decodingCipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "encodingCipher", "createStreamCipherPair", "Lnet/rsprot/crypto/cipher/StreamCipherPair;", "getOldSchoolClientType", "writeFailedResponse", "", "response", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse;", "writeSuccessfulResponse", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$Ok;", "Lnet/rsprot/protocol/loginprot/outgoing/LoginResponse$ReconnectOk;", "Companion", "osrs-228-api"})
@SourceDebugExtension(value={"SMAP\nGameLoginResponseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 5 ChannelExtensions.kt\nnet/rsprot/protocol/api/channel/ChannelExtensionsKt\n+ 6 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,299:1\n20#2:300\n44#2,6:301\n52#2:311\n55#2:316\n58#2:321\n61#2:326\n64#2:331\n21#2:332\n20#2:333\n44#2,6:334\n52#2:344\n55#2:349\n58#2:354\n61#2:359\n64#2:364\n21#2:365\n20#2:366\n44#2,6:367\n52#2:377\n55#2:382\n58#2:387\n61#2:392\n64#2:397\n21#2:398\n20#2:401\n44#2,6:402\n52#2:412\n55#2:417\n58#2:422\n61#2:427\n64#2:432\n21#2:433\n20#2:434\n44#2,6:435\n52#2:445\n55#2:450\n58#2:455\n61#2:460\n64#2:465\n21#2:466\n20#2:467\n44#2,6:468\n52#2:478\n55#2:483\n58#2:488\n61#2:493\n64#2:498\n21#2:499\n20#2:500\n44#2,6:501\n52#2:511\n55#2:516\n58#2:521\n61#2:526\n64#2:531\n21#2:532\n20#2:537\n44#2,6:538\n52#2:548\n55#2:553\n58#2:558\n61#2:563\n64#2:568\n21#2:569\n20#2:570\n44#2,6:571\n52#2:581\n55#2:586\n58#2:591\n61#2:596\n64#2:601\n21#2:602\n32#3,4:307\n56#3,4:312\n80#3,4:317\n104#3,4:322\n128#3,4:327\n32#3,4:340\n56#3,4:345\n80#3,4:350\n104#3,4:355\n128#3,4:360\n32#3,4:373\n56#3,4:378\n80#3,4:383\n104#3,4:388\n128#3,4:393\n32#3,4:408\n56#3,4:413\n80#3,4:418\n104#3,4:423\n128#3,4:428\n32#3,4:441\n56#3,4:446\n80#3,4:451\n104#3,4:456\n128#3,4:461\n32#3,4:474\n56#3,4:479\n80#3,4:484\n104#3,4:489\n128#3,4:494\n32#3,4:507\n56#3,4:512\n80#3,4:517\n104#3,4:522\n128#3,4:527\n32#3,4:544\n56#3,4:549\n80#3,4:554\n104#3,4:559\n128#3,4:564\n32#3,4:577\n56#3,4:582\n80#3,4:587\n104#3,4:592\n128#3,4:597\n158#4,2:399\n36#5:533\n36#5:534\n36#5:535\n36#5:536\n11#6,2:603\n*S KotlinDebug\n*F\n+ 1 GameLoginResponseHandler.kt\nnet/rsprot/protocol/api/login/GameLoginResponseHandler\n*L\n51#1:300\n51#1:301,6\n51#1:311\n51#1:316\n51#1:321\n51#1:326\n51#1:331\n51#1:332\n65#1:333\n65#1:334,6\n65#1:344\n65#1:349\n65#1:354\n65#1:359\n65#1:364\n65#1:365\n87#1:366\n87#1:367,6\n87#1:377\n87#1:382\n87#1:387\n87#1:392\n87#1:397\n87#1:398\n119#1:401\n119#1:402,6\n119#1:412\n119#1:417\n119#1:422\n119#1:427\n119#1:432\n119#1:433\n132#1:434\n132#1:435,6\n132#1:445\n132#1:450\n132#1:455\n132#1:460\n132#1:465\n132#1:466\n144#1:467\n144#1:468,6\n144#1:478\n144#1:483\n144#1:488\n144#1:493\n144#1:498\n144#1:499\n162#1:500\n162#1:501,6\n162#1:511\n162#1:516\n162#1:521\n162#1:526\n162#1:531\n162#1:532\n269#1:537\n269#1:538,6\n269#1:548\n269#1:553\n269#1:558\n269#1:563\n269#1:568\n269#1:569\n278#1:570\n278#1:571,6\n278#1:581\n278#1:586\n278#1:591\n278#1:596\n278#1:601\n278#1:602\n51#1:307,4\n51#1:312,4\n51#1:317,4\n51#1:322,4\n51#1:327,4\n65#1:340,4\n65#1:345,4\n65#1:350,4\n65#1:355,4\n65#1:360,4\n87#1:373,4\n87#1:378,4\n87#1:383,4\n87#1:388,4\n87#1:393,4\n119#1:408,4\n119#1:413,4\n119#1:418,4\n119#1:423,4\n119#1:428,4\n132#1:441,4\n132#1:446,4\n132#1:451,4\n132#1:456,4\n132#1:461,4\n144#1:474,4\n144#1:479,4\n144#1:484,4\n144#1:489,4\n144#1:494,4\n162#1:507,4\n162#1:512,4\n162#1:517,4\n162#1:522,4\n162#1:527,4\n269#1:544,4\n269#1:549,4\n269#1:554,4\n269#1:559,4\n269#1:564,4\n278#1:577,4\n278#1:582,4\n278#1:587,4\n278#1:592,4\n278#1:597,4\n108#1:399,2\n229#1:533\n237#1:534\n240#1:535\n241#1:536\n296#1:603,2\n*E\n"})
public final class GameLoginResponseHandler<R> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private final ChannelHandlerContext ctx;
    private static final int DECODE_SEED_OFFSET = 50;
    @NotNull
    private static final Logger logger;

    public GameLoginResponseHandler(@NotNull NetworkService<R> networkService, @NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService = networkService;
        this.ctx = ctx;
    }

    @NotNull
    public final NetworkService<R> getNetworkService() {
        return this.networkService;
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.Ok response, @NotNull LoginBlock<?> loginBlock) {
        OldSchoolClientType oldSchoolClientType;
        block58: {
            block56: {
                block54: {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
                    oldSchoolClientType = this.getOldSchoolClientType(loginBlock);
                    if (oldSchoolClientType != null && this.networkService.isSupported(oldSchoolClientType)) break block54;
                    Logger logger$iv = logger;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                    boolean bl2 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl3 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl4 = false;
                                logger.trace(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl5 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl6 = false;
                                logger.debug(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl7 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl8 = false;
                                logger.info(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl9 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl10 = false;
                                logger.warn(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl11 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl12 = false;
                                logger.error(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                            }
                            break;
                        }
                    }
                    this.ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), LoginDisconnectionReason.GAME_INVALID_LOGIN_PACKET);
                    return null;
                }
                if (this.ctx.channel().isActive()) break block56;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl13 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl14 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl15 = false;
                            logger.trace(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl16 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl17 = false;
                            logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl18 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl19 = false;
                            logger.info(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl20 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl21 = false;
                            logger.warn(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl22 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl23 = false;
                            logger.error(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                        }
                        break;
                    }
                }
                ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), LoginDisconnectionReason.GAME_CHANNEL_INACTIVE);
                return null;
            }
            InetAddress address = ChannelExtensionsKt.inetAddress(this.ctx);
            int count = this.networkService.getINetAddressHandlers$osrs_228_api().getGameInetAddressTracker().getCount(address);
            boolean accepted = this.networkService.getINetAddressHandlers$osrs_228_api().getInetAddressValidator().acceptGameConnection(address, count);
            if (accepted) break block58;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl24 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl25 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl26 = false;
                        logger.trace(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl27 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl28 = false;
                        logger.debug(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl29 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl30 = false;
                        logger.info(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl31 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl32 = false;
                        logger.warn(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl33 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl34 = false;
                        logger.error(String.valueOf("INetAddressValidator rejected game login for channel " + this.ctx.channel()));
                    }
                    break;
                }
            }
            this.ctx.writeAndFlush((Object)LoginResponse.TooManyAttempts.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), LoginDisconnectionReason.GAME_TOO_MANY_ATTEMPTS);
            return null;
        }
        StreamCipherPair cipher = this.createStreamCipherPair(loginBlock);
        if (this.networkService.getBetaWorld$osrs_228_api()) {
            MessageEncoder encoder = this.networkService.getEncoderRepositories$osrs_228_api().getLoginMessageEncoderRepository().getEncoder(response.getClass());
            ByteBuf byteBuf = this.ctx.alloc().buffer(38);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
            ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)byteBuf);
            int value$iv = 37;
            boolean bl = false;
            JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
            encoder.encode-WFbGaZ8(cipher.getEncoderCipher(), buffer, (OutgoingMessage)response);
            this.ctx.writeAndFlush((Object)buffer);
        } else {
            this.ctx.writeAndFlush((Object)response);
        }
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, cipher.getDecodeCipher(), oldSchoolClientType, cipher.getEncoderCipher());
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl35 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl36 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl37 = false;
                    logger.trace(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 3: {
                boolean bl38 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl39 = false;
                    logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 4: {
                boolean bl40 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl41 = false;
                    logger.info(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 5: {
                boolean bl42 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl43 = false;
                    logger.warn(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 6: {
                boolean bl44 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl45 = false;
                    logger.error(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
        }
        return session;
    }

    @Nullable
    public final Session<R> writeSuccessfulResponse(@NotNull LoginResponse.ReconnectOk response, @NotNull LoginBlock<?> loginBlock) {
        OldSchoolClientType oldSchoolClientType;
        block41: {
            block39: {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter(loginBlock, (String)"loginBlock");
                oldSchoolClientType = this.getOldSchoolClientType(loginBlock);
                if (oldSchoolClientType != null && this.networkService.isSupported(oldSchoolClientType)) break block39;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
                boolean bl2 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl3 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl4 = false;
                            logger.trace(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl6 = false;
                            logger.debug(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl7 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl8 = false;
                            logger.info(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl9 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl10 = false;
                            logger.warn(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl11 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl12 = false;
                            logger.error(String.valueOf("Unsupported client type received from channel '" + this.ctx.channel() + "': " + oldSchoolClientType + ", login block: " + loginBlock));
                        }
                        break;
                    }
                }
                this.ctx.writeAndFlush((Object)LoginResponse.InvalidLoginPacket.INSTANCE);
                ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), LoginDisconnectionReason.GAME_INVALID_LOGIN_PACKET);
                return null;
            }
            if (this.ctx.channel().isActive()) break block41;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl13 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl14 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl15 = false;
                        logger.trace(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
                case 3: {
                    boolean bl16 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl17 = false;
                        logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
                case 4: {
                    boolean bl18 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl19 = false;
                        logger.info(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
                case 5: {
                    boolean bl20 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl21 = false;
                        logger.warn(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
                case 6: {
                    boolean bl22 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl23 = false;
                        logger.error(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive; login block: " + loginBlock));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), LoginDisconnectionReason.GAME_CHANNEL_INACTIVE);
            return null;
        }
        StreamCipherPair streamCipherPair = this.createStreamCipherPair(loginBlock);
        StreamCipher encodingCipher = streamCipherPair.component1();
        StreamCipher decodingCipher = streamCipherPair.component2();
        this.ctx.write((Object)response, this.ctx.voidPromise());
        ChannelPipeline pipeline = this.ctx.channel().pipeline();
        Intrinsics.checkNotNull((Object)pipeline);
        Session<R> session = this.createSession(loginBlock, pipeline, decodingCipher, oldSchoolClientType, encodingCipher);
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl24 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl25 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl26 = false;
                    logger.trace(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 3: {
                boolean bl27 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl28 = false;
                    logger.debug(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 4: {
                boolean bl29 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl30 = false;
                    logger.info(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 5: {
                boolean bl31 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl32 = false;
                    logger.warn(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
            case 6: {
                boolean bl33 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl34 = false;
                    logger.error(String.valueOf("Successful game login from channel '" + this.ctx.channel() + "': " + loginBlock));
                }
                break;
            }
        }
        return session;
    }

    private final StreamCipherPair createStreamCipherPair(LoginBlock<?> loginBlock) {
        int[] encodeSeed = loginBlock.getSeed();
        int n = 0;
        int n2 = encodeSeed.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = encodeSeed[n3] + 50;
        }
        int[] decodeSeed = nArray;
        StreamCipherProvider provider = this.networkService.getLoginHandlers$osrs_228_api().getStreamCipherProvider();
        StreamCipher encodingCipher = provider.provide(decodeSeed);
        StreamCipher decodingCipher = provider.provide(encodeSeed);
        return new StreamCipherPair(encodingCipher, decodingCipher);
    }

    private final OldSchoolClientType getOldSchoolClientType(LoginBlock<?> loginBlock) {
        OldSchoolClientType oldSchoolClientType;
        switch (WhenMappings.$EnumSwitchMapping$0[loginBlock.getClientType().ordinal()]) {
            case 1: {
                oldSchoolClientType = OldSchoolClientType.DESKTOP;
                break;
            }
            case 2: {
                oldSchoolClientType = OldSchoolClientType.DESKTOP;
                break;
            }
            case 3: {
                oldSchoolClientType = OldSchoolClientType.DESKTOP;
                break;
            }
            case 4: {
                oldSchoolClientType = OldSchoolClientType.DESKTOP;
                break;
            }
            case 5: {
                oldSchoolClientType = OldSchoolClientType.ANDROID;
                break;
            }
            case 6: {
                oldSchoolClientType = OldSchoolClientType.IOS;
                break;
            }
            default: {
                oldSchoolClientType = null;
            }
        }
        OldSchoolClientType oldSchoolClientType2 = oldSchoolClientType;
        return oldSchoolClientType2;
    }

    private final Session<R> createSession(LoginBlock<?> loginBlock, ChannelPipeline pipeline, StreamCipher decodingCipher, OldSchoolClientType oldSchoolClientType, StreamCipher encodingCipher) {
        ChannelHandler newHandler$iv;
        ChannelPipeline $this$replace$iv;
        GameMessageConsumerRepository gameMessageConsumerRepository = this.networkService.getGameMessageConsumerRepositoryProvider().provide();
        Session<R> session = new Session<R>(this.networkService.getTrafficMonitor(), this.ctx, this.networkService.getGameMessageHandlers$osrs_228_api().getIncomingGameMessageQueueProvider().provide(), this.networkService.getGameMessageHandlers$osrs_228_api().getOutgoingGameMessageQueueProvider(), this.networkService.getGameMessageHandlers$osrs_228_api().getGameMessageCounterProvider().provide(), gameMessageConsumerRepository.getConsumers(), gameMessageConsumerRepository.getGlobalConsumers(), loginBlock, this.networkService.getExceptionHandlers$osrs_228_api().getIncomingGameMessageConsumerExceptionHandler());
        ChannelPipeline channelPipeline = pipeline;
        ChannelHandler channelHandler = (ChannelHandler)new GameMessageDecoder<R>(this.networkService, session, decodingCipher, oldSchoolClientType);
        boolean $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageDecoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageEncoder(this.networkService, encodingCipher, oldSchoolClientType);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginMessageEncoder.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new GameMessageHandler<R>(this.networkService, session);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(LoginConnectionHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        $this$replace$iv = pipeline;
        newHandler$iv = (ChannelHandler)new IdleStateHandler(true, 15L, 15L, 15L, TimeUnit.SECONDS);
        $i$f$replace = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$replace$iv.replace(IdleStateHandler.class, Reflection.getOrCreateKotlinClass(newHandler$iv.getClass()).getQualifiedName(), newHandler$iv), (String)"replace(...)");
        return session;
    }

    public final void writeFailedResponse(@NotNull LoginResponse response) {
        block29: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (response instanceof LoginResponse.ProofOfWork) {
                throw new IllegalStateException("Proof of Work is handled at the engine level.");
            }
            if (response instanceof LoginResponse.Successful) {
                throw new IllegalStateException("Successful login response is handled at the engine level.");
            }
            if (this.ctx.channel().isActive()) break block29;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Channel '" + this.ctx.channel() + "' has gone inactive, skipping failed response."));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), LoginDisconnectionReason.GAME_CHANNEL_INACTIVE);
            return;
        }
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl13 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl14 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl15 = false;
                    logger.trace(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 3: {
                boolean bl16 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl17 = false;
                    logger.debug(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 4: {
                boolean bl18 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl19 = false;
                    logger.info(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 5: {
                boolean bl20 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl21 = false;
                    logger.warn(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
            case 6: {
                boolean bl22 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl23 = false;
                    logger.error(String.valueOf("Writing failed login response to channel '" + this.ctx.channel() + "': " + response));
                }
                break;
            }
        }
        this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        LoginDisconnectionReason disconnectReason = LoginDisconnectionReason.Companion.getResponseToReasonMap$osrs_228_api().get(response);
        if (disconnectReason != null) {
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getLoginChannelTrafficMonitor(), ChannelExtensionsKt.inetAddress(this.ctx), disconnectReason);
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lnet/rsprot/protocol/api/login/GameLoginResponseHandler$Companion;", "", "()V", "DECODE_SEED_OFFSET", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-228-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoginClientType.values().length];
            try {
                nArray[LoginClientType.DESKTOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginClientType.ENHANCED_WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginClientType.ENHANCED_LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginClientType.ENHANCED_MAC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginClientType.ENHANCED_ANDROID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginClientType.ENHANCED_IOS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

