/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.npcinfo;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoProtocol;
import net.rsprot.protocol.internal.RSProtFlags;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\n\u0010\r\u001a\u00060\u0004R\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarTracker;", "", "()V", "cachedSet", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarTracker$AvatarSet;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "observingPlayers", "Ljava/util/concurrent/atomic/AtomicLongArray;", "add", "", "index", "", "getCachedSet", "getObserverCount", "hasObservers", "", "isObservingPlayer", "remove", "reset", "setObservingPlayer", "toString", "", "unsetObservingPlayer", "AvatarSet", "Companion", "osrs-227-model"})
public final class NpcAvatarTracker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger counter = new AtomicInteger(0);
    @NotNull
    private final AtomicLongArray observingPlayers = new AtomicLongArray(!trackIndices ? 0 : 32);
    @NotNull
    private final AvatarSet cachedSet = new AvatarSet();
    private static final int NO_NEXT_CHECKED = -2;
    private static final int NO_NEXT_SET = -1;
    private static final long LONG_MASK = -1L;
    private static final int LONGS_IN_USE = 32;
    private static final boolean trackIndices = RSProtFlags.getNpcPlayerAvatarTracking();

    public final void add(int index) {
        if (!trackIndices) {
            this.counter.incrementAndGet();
            return;
        }
        if (this.setObservingPlayer(index)) {
            this.counter.incrementAndGet();
        }
    }

    public final void remove(int index) {
        if (!trackIndices) {
            this.counter.decrementAndGet();
            return;
        }
        if (this.unsetObservingPlayer(index)) {
            this.counter.decrementAndGet();
        }
    }

    @NotNull
    public final AvatarSet getCachedSet() {
        if (!trackIndices) {
            throw new IllegalAccessException("Player avatar index tracking has been disabled.");
        }
        return this.cachedSet;
    }

    public final void reset() {
        this.counter.set(0);
        if (!trackIndices) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            this.observingPlayers.set(i, 0L);
        }
    }

    public final boolean hasObservers() {
        return this.counter.get() > 0;
    }

    public final int getObserverCount() {
        return this.counter.get();
    }

    private final boolean isObservingPlayer(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        return (this.observingPlayers.get(longIndex) & bit) != 0L;
    }

    private final boolean setObservingPlayer(int index) {
        long cur;
        boolean assigned;
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        AtomicLongArray players = this.observingPlayers;
        while (!(assigned = players.weakCompareAndSetVolatile(longIndex, cur = players.get(longIndex), cur | bit))) {
        }
        return (cur >>> (index & 0x3F) & 1L) == 0L;
    }

    private final boolean unsetObservingPlayer(int index) {
        long cur;
        boolean assigned;
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        AtomicLongArray players = this.observingPlayers;
        while (!(assigned = players.weakCompareAndSetVolatile(longIndex, cur = players.get(longIndex), cur & (bit ^ 0xFFFFFFFFFFFFFFFFL)))) {
        }
        return (cur >>> (index & 0x3F) & 1L) != 0L;
    }

    @NotNull
    public String toString() {
        return "NpcAvatarTracker(counter=" + this.counter + ", observingPlayers=" + this.observingPlayers + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarTracker$AvatarSet;", "", "", "(Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarTracker;)V", "size", "getSize", "()I", "contains", "", "element", "containsAll", "elements", "", "isEmpty", "iterator", "", "toString", "", "AvatarSetIterator", "osrs-227-model"})
    public final class AvatarSet
    implements Set<Integer>,
    KMappedMarker {
        public int getSize() {
            return NpcAvatarTracker.this.counter.get();
        }

        public boolean contains(int element) {
            if (element < 0 || element >= 2048) {
                return false;
            }
            return NpcAvatarTracker.this.isObservingPlayer(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            if (elements.isEmpty()) {
                return true;
            }
            Iterator<? extends Object> iterator = elements.iterator();
            while (iterator.hasNext()) {
                int element = ((Number)iterator.next()).intValue();
                if (this.contains((Object)element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return new AvatarSetIterator(NpcInfoProtocol.Companion.getCycleCount$osrs_227_model());
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append("[");
            Iterator<Integer> iterator = this.iterator();
            while (iterator.hasNext()) {
                int element = ((Number)iterator.next()).intValue();
                $this$toString_u24lambda_u240.append(element).append(", ");
            }
            if (((CharSequence)$this$toString_u24lambda_u240).length() > 0) {
                $this$toString_u24lambda_u240.delete($this$toString_u24lambda_u240.length() - 2, $this$toString_u24lambda_u240.length());
            }
            $this$toString_u24lambda_u240.append("]");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public boolean add(int element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean addAll(Collection<? extends Integer> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean removeAll(Collection<? extends Object> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean retainAll(Collection<? extends Object> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\u000e\u0010\u0005\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarTracker$AvatarSet$AvatarSetIterator;", "", "", "cycle", "(Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarTracker$AvatarSet;I)V", "next", "searchStartIndex", "checkConcurrentModification", "", "hasNext", "", "()Ljava/lang/Integer;", "setNextNodeIndex", "osrs-227-model"})
        private final class AvatarSetIterator
        implements Iterator<Integer>,
        KMappedMarker {
            private final int cycle;
            private int next;
            private int searchStartIndex;

            public AvatarSetIterator(int cycle) {
                this.cycle = cycle;
                this.next = -2;
            }

            @Override
            public boolean hasNext() {
                this.checkConcurrentModification();
                if (this.next == -2) {
                    this.setNextNodeIndex();
                }
                return this.next != -1;
            }

            private final void setNextNodeIndex() {
                int longIndex = this.searchStartIndex >>> 6;
                if (longIndex >= 32) {
                    this.next = -1;
                    return;
                }
                long slice = NpcAvatarTracker.this.observingPlayers.get(longIndex) & -1L << this.searchStartIndex;
                while (true) {
                    if (slice != 0L) {
                        this.next = longIndex * 64 + Long.numberOfTrailingZeros(slice);
                        this.searchStartIndex = this.next + 1;
                        return;
                    }
                    if (++longIndex == 32) {
                        this.next = -1;
                        return;
                    }
                    slice = NpcAvatarTracker.this.observingPlayers.get(longIndex);
                }
            }

            @Override
            @NotNull
            public Integer next() {
                int next;
                this.checkConcurrentModification();
                if (this.next == -2) {
                    this.setNextNodeIndex();
                }
                if ((next = this.next) == -1) {
                    throw new NoSuchElementException();
                }
                this.next = -2;
                return next;
            }

            private final void checkConcurrentModification() {
                if (this.cycle != NpcInfoProtocol.Companion.getCycleCount$osrs_227_model()) {
                    throw new ConcurrentModificationException("Npc avatar iterator cannot be accessed across cycles.");
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarTracker$Companion;", "", "()V", "LONGS_IN_USE", "", "LONG_MASK", "", "NO_NEXT_CHECKED", "NO_NEXT_SET", "trackIndices", "", "osrs-227-model"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

