/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.incoming.messaging;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.ClientProtCategory;
import net.rsprot.protocol.game.incoming.GameClientProtCategory;
import net.rsprot.protocol.message.IncomingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001'B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bB9\b\u0002\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0016\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0016\u0010\f\u001a\u00020\rX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lnet/rsprot/protocol/game/incoming/messaging/MessagePublic;", "Lnet/rsprot/protocol/message/IncomingGameMessage;", "type", "", "colour", "effect", "message", "", "pattern", "Lnet/rsprot/protocol/game/incoming/messaging/MessagePublic$MessageColourPattern;", "clanType", "(IIILjava/lang/String;Lnet/rsprot/protocol/game/incoming/messaging/MessagePublic$MessageColourPattern;I)V", "_type", "Lkotlin/UByte;", "_colour", "_effect", "_clanType", "", "(BBBLjava/lang/String;Lnet/rsprot/protocol/game/incoming/messaging/MessagePublic$MessageColourPattern;B)V", "B", "category", "Lnet/rsprot/protocol/ClientProtCategory;", "getCategory", "()Lnet/rsprot/protocol/ClientProtCategory;", "getClanType", "()I", "getColour", "getEffect", "getMessage", "()Ljava/lang/String;", "getPattern", "()Lnet/rsprot/protocol/game/incoming/messaging/MessagePublic$MessageColourPattern;", "getType", "equals", "", "other", "", "hashCode", "toString", "MessageColourPattern", "osrs-227-model"})
public final class MessagePublic
implements IncomingGameMessage {
    private final byte _type;
    private final byte _colour;
    private final byte _effect;
    @NotNull
    private final String message;
    @Nullable
    private final MessageColourPattern pattern;
    private final byte _clanType;

    private MessagePublic(byte _type, byte _colour, byte _effect, String message, MessageColourPattern pattern, byte _clanType) {
        this._type = _type;
        this._colour = _colour;
        this._effect = _effect;
        this.message = message;
        this.pattern = pattern;
        this._clanType = _clanType;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final MessageColourPattern getPattern() {
        return this.pattern;
    }

    public MessagePublic(int type, int colour, int effect, @NotNull String message, @Nullable MessageColourPattern pattern, int clanType) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(UByte.constructor-impl((byte)((byte)type)), UByte.constructor-impl((byte)((byte)colour)), UByte.constructor-impl((byte)((byte)effect)), message, pattern, (byte)clanType);
    }

    public final int getType() {
        return this._type & 0xFF;
    }

    public final int getColour() {
        return this._colour & 0xFF;
    }

    public final int getEffect() {
        return this._effect & 0xFF;
    }

    public final int getClanType() {
        return this._clanType;
    }

    @NotNull
    public ClientProtCategory getCategory() {
        return GameClientProtCategory.USER_EVENT;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.incoming.messaging.MessagePublic");
        MessagePublic cfr_ignored_0 = (MessagePublic)other;
        if (this._type != ((MessagePublic)other)._type) {
            return false;
        }
        if (this._colour != ((MessagePublic)other)._colour) {
            return false;
        }
        if (this._effect != ((MessagePublic)other)._effect) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)((MessagePublic)other).message)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pattern, (Object)((MessagePublic)other).pattern)) {
            return false;
        }
        return this._clanType == ((MessagePublic)other)._clanType;
    }

    public int hashCode() {
        int result = UByte.hashCode-impl((byte)this._type);
        result = 31 * result + UByte.hashCode-impl((byte)this._colour);
        result = 31 * result + UByte.hashCode-impl((byte)this._effect);
        result = 31 * result + this.message.hashCode();
        MessageColourPattern messageColourPattern = this.pattern;
        result = 31 * result + (messageColourPattern != null ? messageColourPattern.hashCode() : 0);
        result = 31 * result + this._clanType;
        return result;
    }

    @NotNull
    public String toString() {
        return "MessagePublicEvent(message='" + this.message + "', pattern=" + this.pattern + ", type=" + this.getType() + ", colour=" + this.getColour() + ", effect=" + this.getEffect() + ", clanType=" + this.getClanType() + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/game/incoming/messaging/MessagePublic$MessageColourPattern;", "", "bytes", "", "([B)V", "length", "", "getLength", "()I", "asByteArray", "isValid", "", "to24BitRgbOrNull", "", "toByteArray", "toString", "", "Companion", "osrs-227-model"})
    public static final class MessageColourPattern {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] bytes;
        @NotNull
        private static final int[] colourCodes;

        public MessageColourPattern(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.bytes = bytes;
        }

        public final int getLength() {
            return this.bytes.length;
        }

        @NotNull
        public final byte[] asByteArray() {
            return this.bytes;
        }

        @NotNull
        public final byte[] toByteArray() {
            byte[] byArray = Arrays.copyOf(this.bytes, this.bytes.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            return byArray;
        }

        public final boolean isValid() {
            int n = this.getLength();
            if (!(1 <= n ? n < 9 : false)) {
                return false;
            }
            for (byte value : this.bytes) {
                if (value >= 0 && value < colourCodes.length) continue;
                return false;
            }
            return true;
        }

        @Nullable
        public final int[] to24BitRgbOrNull() {
            int n = this.getLength();
            if (!(1 <= n ? n < 9 : false)) {
                return null;
            }
            int[] colours = new int[this.getLength()];
            int n2 = this.bytes.length;
            for (int i = 0; i < n2; ++i) {
                int colourCode;
                Integer n3 = ArraysKt.getOrNull((int[])colourCodes, (int)this.bytes[i]);
                if (n3 == null) {
                    return null;
                }
                colours[i] = colourCode = n3.intValue();
            }
            return colours;
        }

        @NotNull
        public String toString() {
            String string = Arrays.toString(this.bytes);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return "MessageColourPattern(bytes=" + string + ")";
        }

        static {
            int[] nArray = new int[]{0xFFFFFF, 14942979, 16747520, 16772352, 32806, 2375822, 7547266, 16720268, 11884176, 5261772, 0xA3A3A3, 13970688, 15693351, 16577588, 494960, 2208255, 10178454, 16756679, 13722276, 8105443, 16751190, 2543274, 7591918, 10246609, 10021057, 11894492, 0x2C2C2C, 9699842, 6371605, 13680896, 4882723, 14504, 0x800080, 14025328, 10682978, 4004472};
            colourCodes = nArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/rsprot/protocol/game/incoming/messaging/MessagePublic$MessageColourPattern$Companion;", "", "()V", "colourCodes", "", "osrs-227-model"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

