/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.npcinfo;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.UShort;
import kotlin.UShortArray;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.rsprot.buffer.bitbuffer.BitBuf;
import net.rsprot.buffer.bitbuffer.BitBufKt;
import net.rsprot.buffer.bitbuffer.UnsafeLongBackedBitBuf;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.protocol.client.ClientType;
import net.rsprot.protocol.common.RSProtThreadSafetyKt;
import net.rsprot.protocol.common.client.ClientTypeMap;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.common.game.outgoing.info.CoordGrid;
import net.rsprot.protocol.common.game.outgoing.info.npcinfo.encoder.NpcResolutionChangeEncoder;
import net.rsprot.protocol.common.game.outgoing.info.util.ZoneIndexStorage;
import net.rsprot.protocol.game.outgoing.info.ByteBufRecycler;
import net.rsprot.protocol.game.outgoing.info.exceptions.InfoProcessException;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatar;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarRepository;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoLargeV5;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoProtocol;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoSmallV5;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoWorldDetails;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoWorldDetailsStorage;
import net.rsprot.protocol.game.outgoing.info.util.BuildArea;
import net.rsprot.protocol.game.outgoing.info.util.ReferencePooledObject;
import net.rsprot.protocol.message.ConsumableMessage;
import net.rsprot.protocol.message.OutgoingGameMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 x2\u00020\u0001:\u0001xBM\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\r\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\tH\u0002J\u000e\u00100\u001a\u00020+2\u0006\u0010/\u001a\u00020\tJ7\u00101\u001a\u0002H2\"\u000e\b\u0000\u00102*\b\u0012\u0004\u0012\u00020\t032\u0006\u0010/\u001a\u00020\t2\u0006\u00104\u001a\u0002H22\b\b\u0002\u00105\u001a\u000206H\u0007\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020.2\u0006\u0010/\u001a\u00020\tH\u0002J\u0010\u00108\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u0016H\u0002J\u000e\u00109\u001a\u00020+2\u0006\u0010/\u001a\u00020\tJ\u000e\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020<J\u0015\u0010=\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b>J\u000e\u0010?\u001a\u00020+2\u0006\u0010/\u001a\u00020\tJ\u0010\u0010@\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\tH\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010\u00162\u0006\u0010/\u001a\u00020\tH\u0002J\u001e\u0010B\u001a\u0012\u0012\u0004\u0012\u00020\t0Cj\b\u0012\u0004\u0012\u00020\t`D2\u0006\u0010/\u001a\u00020\tJ\"\u0010E\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010Cj\n\u0012\u0004\u0012\u00020\t\u0018\u0001`D2\u0006\u0010/\u001a\u00020\tJ\b\u0010F\u001a\u000206H\u0016J\u0018\u0010G\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\tH\u0002J\u0018\u0010I\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010J\u001a\u0002062\u0006\u0010H\u001a\u00020\tH\u0002J\u0018\u0010K\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\tH\u0002J \u0010L\u001a\u00020+2\u0006\u0010H\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010M\u001a\u000206H\u0016J\b\u0010N\u001a\u00020+H\u0016J\u0006\u0010O\u001a\u00020+J \u0010P\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010Q\u001a\u00020R2\u0006\u0010)\u001a\u00020\tH\u0002J \u0010S\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010Q\u001a\u00020R2\u0006\u0010)\u001a\u00020\tH\u0002J\u0015\u0010T\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\bUJ\u0010\u0010V\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0016H\u0002J3\u0010W\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u00162\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010)\u001a\u00020\tH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0003\u0010\u0002J\u0006\u0010X\u001a\u00020+J\u001e\u0010Y\u001a\u00020+2\u0006\u0010/\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010[\u001a\u00020\tJ\u0010\u0010\\\u001a\u00020+2\u0006\u0010H\u001a\u00020\tH\u0002J\u000e\u0010\\\u001a\u00020+2\u0006\u0010;\u001a\u00020<J\u000e\u0010]\u001a\u00020+2\u0006\u0010^\u001a\u00020\tJ\u0010\u0010_\u001a\u00020`2\u0006\u0010/\u001a\u00020\tH\u0007J\u000e\u0010a\u001a\u00020`2\u0006\u0010/\u001a\u00020\tJ\u0015\u0010b\u001a\u00020+2\u0006\u0010H\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bcJ4\u0010d\u001a\u00020+2\u0006\u0010/\u001a\u00020\t2\u0006\u0010e\u001a\u00020\t2\u0006\u0010f\u001a\u00020\t2\b\b\u0002\u0010g\u001a\u00020\t2\b\b\u0002\u0010h\u001a\u00020\tH\u0007J \u0010d\u001a\u00020+2\u0006\u0010/\u001a\u00020\t2\u0006\u0010i\u001a\u00020j\u00f8\u0001\u0000\u00a2\u0006\u0004\bk\u0010lJ&\u0010m\u001a\u00020+2\u0006\u0010/\u001a\u00020\t2\u0006\u0010n\u001a\u00020\t2\u0006\u0010o\u001a\u00020\t2\u0006\u0010p\u001a\u00020\tJ*\u0010q\u001a\u0002062\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020s2\u0006\u0010u\u001a\u00020\tH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bv\u0010wR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006y"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfo;", "Lnet/rsprot/protocol/game/outgoing/info/util/ReferencePooledObject;", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "repository", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "localPlayerIndex", "", "zoneIndexStorage", "Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;", "lowResolutionToHighResolutionEncoders", "Lnet/rsprot/protocol/common/client/ClientTypeMap;", "Lnet/rsprot/protocol/common/game/outgoing/info/npcinfo/encoder/NpcResolutionChangeEncoder;", "detailsStorage", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoWorldDetailsStorage;", "recycler", "Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository;Lnet/rsprot/protocol/common/client/OldSchoolClientType;ILnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;Lnet/rsprot/protocol/common/client/ClientTypeMap;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoWorldDetailsStorage;Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;)V", "details", "", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoWorldDetails;", "getDetails$osrs_227_model", "()[Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoWorldDetails;", "[Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoWorldDetails;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getException$osrs_227_model", "()Ljava/lang/Exception;", "setException$osrs_227_model", "(Ljava/lang/Exception;)V", "getLocalPlayerIndex$osrs_227_model", "()I", "setLocalPlayerIndex$osrs_227_model", "(I)V", "specificVisible", "", "getSpecificVisible$osrs_227_model", "()[J", "viewDistance", "afterUpdate", "", "afterUpdate$osrs_227_model", "allocBuffer", "Lio/netty/buffer/ByteBuf;", "worldId", "allocateWorld", "appendHighResolutionIndices", "T", "", "collection", "throwExceptionIfNoWorld", "", "(ILjava/util/Collection;Z)Ljava/util/Collection;", "backingBuffer", "clearEntities", "clearSpecific", "avatar", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatar;", "compute", "compute$osrs_227_model", "destroyWorld", "getDetails", "getDetailsOrNull", "getHighResolutionIndices", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getHighResolutionIndicesOrNull", "isDestroyed", "isHighResolution", "index", "isInBuildArea", "isSpecific", "isTooFar", "onAlloc", "newInstance", "onDealloc", "onReconnect", "processHighResolution", "buffer", "Lnet/rsprot/buffer/bitbuffer/BitBuf;", "processLowResolution", "putExtendedInfo", "putExtendedInfo$osrs_227_model", "releaseObservers", "removeHighResolutionNpc", "resetViewDistance", "setPriorityCaps", "lowPriorityCap", "normalPrioritySoftCap", "setSpecific", "setViewDistance", "num", "toNpcInfoPacket", "Lnet/rsprot/protocol/message/OutgoingGameMessage;", "toPacket", "unsetSpecific", "unsetSpecific$osrs_227_model", "updateBuildArea", "zoneX", "zoneZ", "widthInZones", "heightInZones", "buildArea", "Lnet/rsprot/protocol/game/outgoing/info/util/BuildArea;", "updateBuildArea-3qq953o", "(IJ)V", "updateCoord", "level", "x", "z", "withinDistance", "localPlayerCoordGrid", "Lnet/rsprot/protocol/common/game/outgoing/info/CoordGrid;", "coord", "distance", "withinDistance-QbmAAsE", "(III)Z", "Companion", "osrs-227-model"})
@SourceDebugExtension(value={"SMAP\nNpcInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpcInfo.kt\nnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfo\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,976:1\n104#2,4:977\n11#3,2:981\n*S KotlinDebug\n*F\n+ 1 NpcInfo.kt\nnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfo\n*L\n533#1:977,4\n973#1:981,2\n*E\n"})
public final class NpcInfo
implements ReferencePooledObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final NpcAvatarRepository repository;
    @NotNull
    private OldSchoolClientType oldSchoolClientType;
    private int localPlayerIndex;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final ClientTypeMap<NpcResolutionChangeEncoder> lowResolutionToHighResolutionEncoders;
    @NotNull
    private final NpcInfoWorldDetailsStorage detailsStorage;
    @NotNull
    private final ByteBufRecycler recycler;
    private int viewDistance;
    @Nullable
    private volatile Exception exception;
    @NotNull
    private final NpcInfoWorldDetails[] details;
    @NotNull
    private final long[] specificVisible;
    public static final int ROOT_WORLD = -1;
    private static final int WORLD_ENTITY_CAPACITY = 2048;
    private static final int BUF_CAPACITY = 40000;
    private static final int DEFAULT_DISTANCE = 15;
    private static final int MAX_SMALL_PACKET_DISTANCE = 31;
    private static final int MAX_HIGH_RESOLUTION_NPCS = 250;
    private static final short NPC_INDEX_TERMINATOR = -1;
    private static final int NPC_INFO_CAPACITY = 65535;
    private static final int AVATAR_NORMAL_PRIORITY_FLAG = 1;
    @NotNull
    private static final Logger logger;

    public NpcInfo(@NotNull ByteBufAllocator allocator, @NotNull NpcAvatarRepository repository, @NotNull OldSchoolClientType oldSchoolClientType, int localPlayerIndex, @NotNull ZoneIndexStorage zoneIndexStorage, @NotNull ClientTypeMap<? extends NpcResolutionChangeEncoder> lowResolutionToHighResolutionEncoders, @NotNull NpcInfoWorldDetailsStorage detailsStorage, @NotNull ByteBufRecycler recycler) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        Intrinsics.checkNotNullParameter(lowResolutionToHighResolutionEncoders, (String)"lowResolutionToHighResolutionEncoders");
        Intrinsics.checkNotNullParameter((Object)detailsStorage, (String)"detailsStorage");
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        this.allocator = allocator;
        this.repository = repository;
        this.oldSchoolClientType = oldSchoolClientType;
        this.localPlayerIndex = localPlayerIndex;
        this.zoneIndexStorage = zoneIndexStorage;
        this.lowResolutionToHighResolutionEncoders = lowResolutionToHighResolutionEncoders;
        this.detailsStorage = detailsStorage;
        this.recycler = recycler;
        this.viewDistance = 15;
        this.details = new NpcInfoWorldDetails[2049];
        this.specificVisible = new long[1024];
    }

    public final int getLocalPlayerIndex$osrs_227_model() {
        return this.localPlayerIndex;
    }

    public final void setLocalPlayerIndex$osrs_227_model(int n) {
        this.localPlayerIndex = n;
    }

    @Nullable
    public final Exception getException$osrs_227_model() {
        return this.exception;
    }

    public final void setException$osrs_227_model(@Nullable Exception exception) {
        this.exception = exception;
    }

    @NotNull
    public final NpcInfoWorldDetails[] getDetails$osrs_227_model() {
        return this.details;
    }

    @NotNull
    public final long[] getSpecificVisible$osrs_227_model() {
        return this.specificVisible;
    }

    @Override
    public boolean isDestroyed() {
        return this.exception != null;
    }

    /*
     * Unable to fully structure code
     */
    public final void updateBuildArea-3qq953o(int worldId, long buildArea) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (worldId == -1) ** GOTO lbl-1000
        v0 = 0 <= worldId ? worldId < 2048 : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-NpcInfo$updateBuildArea$1 = false;
            var5_4 = "World id must be -1 or in range of 0..<2048";
            throw new IllegalArgumentException(var5_4.toString());
        }
        details = this.getDetails(worldId);
        details.setBuildArea-4IFMqhs$osrs_227_model(buildArea);
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    public final void updateBuildArea(int worldId, int zoneX, int zoneZ, int widthInZones, int heightInZones) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (worldId == -1) ** GOTO lbl-1000
        v0 = 0 <= worldId ? worldId < 2048 : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-NpcInfo$updateBuildArea$2 = false;
            var7_7 = "World id must be -1 or in range of 0..<2048";
            throw new IllegalArgumentException(var7_7.toString());
        }
        details = this.getDetails(worldId);
        details.setBuildArea-4IFMqhs$osrs_227_model(BuildArea.constructor-impl(zoneX, zoneZ, widthInZones, heightInZones));
    }

    public static /* synthetic */ void updateBuildArea$default(NpcInfo npcInfo, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 8) != 0) {
            n4 = 13;
        }
        if ((n6 & 0x10) != 0) {
            n5 = 13;
        }
        npcInfo.updateBuildArea(n, n2, n3, n4, n5);
    }

    public final void allocateWorld(int worldId) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (!(0 <= worldId ? worldId < 2048 : false)) {
            boolean bl = false;
            String string = "World id out of bounds: " + worldId;
            throw new IllegalArgumentException(string.toString());
        }
        NpcInfoWorldDetails existing = this.details[worldId];
        if (!(existing == null)) {
            boolean bl = false;
            String string = "World " + worldId + " already allocated.";
            throw new IllegalArgumentException(string.toString());
        }
        this.details[worldId] = this.detailsStorage.poll$osrs_227_model(worldId);
    }

    public final void destroyWorld(int worldId) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (!(0 <= worldId ? worldId < 2048 : false)) {
            boolean bl = false;
            String string = "World id out of bounds: " + worldId;
            throw new IllegalArgumentException(string.toString());
        }
        NpcInfoWorldDetails existing = this.details[worldId];
        if (!(existing != null)) {
            boolean bl = false;
            String string = "World " + worldId + " does not exist.";
            throw new IllegalArgumentException(string.toString());
        }
        this.releaseObservers(existing);
        this.detailsStorage.push$osrs_227_model(existing);
        this.details[worldId] = null;
    }

    private final NpcInfoWorldDetails getDetails(int worldId) {
        NpcInfoWorldDetails details;
        NpcInfoWorldDetails npcInfoWorldDetails;
        if (worldId == -1) {
            npcInfoWorldDetails = this.details[2048];
        } else {
            if (!(0 <= worldId ? worldId < 2048 : false)) {
                boolean bl = false;
                String string = "World id out of bounds: " + worldId;
                throw new IllegalArgumentException(string.toString());
            }
            npcInfoWorldDetails = this.details[worldId];
        }
        NpcInfoWorldDetails npcInfoWorldDetails2 = details = npcInfoWorldDetails;
        if (npcInfoWorldDetails2 == null) {
            boolean bl = false;
            String string = "World info details not allocated for world " + worldId;
            throw new IllegalStateException(string.toString());
        }
        return npcInfoWorldDetails2;
    }

    private final NpcInfoWorldDetails getDetailsOrNull(int worldId) {
        NpcInfoWorldDetails npcInfoWorldDetails;
        if (worldId == -1) {
            npcInfoWorldDetails = this.details[2048];
        } else {
            if (!(0 <= worldId ? worldId < 2048 : false)) {
                return null;
            }
            npcInfoWorldDetails = this.details[worldId];
        }
        NpcInfoWorldDetails details = npcInfoWorldDetails;
        return details;
    }

    @NotNull
    public final ArrayList<Integer> getHighResolutionIndices(int worldId) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        NpcInfoWorldDetails details = this.getDetails(worldId);
        ArrayList<Integer> collection = new ArrayList<Integer>(details.getHighResolutionNpcIndexCount$osrs_227_model());
        int n = details.getHighResolutionNpcIndexCount$osrs_227_model();
        for (int i = 0; i < n; ++i) {
            int index = UShortArray.get-Mh2AYeg((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF;
            collection.add(index);
        }
        return collection;
    }

    @Nullable
    public final ArrayList<Integer> getHighResolutionIndicesOrNull(int worldId) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        NpcInfoWorldDetails npcInfoWorldDetails = this.getDetailsOrNull(worldId);
        if (npcInfoWorldDetails == null) {
            return null;
        }
        NpcInfoWorldDetails details = npcInfoWorldDetails;
        ArrayList<Integer> collection = new ArrayList<Integer>(details.getHighResolutionNpcIndexCount$osrs_227_model());
        int n = details.getHighResolutionNpcIndexCount$osrs_227_model();
        for (int i = 0; i < n; ++i) {
            int index = UShortArray.get-Mh2AYeg((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF;
            collection.add(index);
        }
        return collection;
    }

    @JvmOverloads
    @NotNull
    public final <T extends Collection<Integer>> T appendHighResolutionIndices(int worldId, @NotNull T collection, boolean throwExceptionIfNoWorld) {
        NpcInfoWorldDetails npcInfoWorldDetails;
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (throwExceptionIfNoWorld) {
            npcInfoWorldDetails = this.getDetails(worldId);
        } else {
            npcInfoWorldDetails = this.getDetailsOrNull(worldId);
            if (npcInfoWorldDetails == null) {
                return collection;
            }
        }
        NpcInfoWorldDetails details = npcInfoWorldDetails;
        int n = details.getHighResolutionNpcIndexCount$osrs_227_model();
        for (int i = 0; i < n; ++i) {
            int index = UShortArray.get-Mh2AYeg((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF;
            collection.add(index);
        }
        return collection;
    }

    public static /* synthetic */ Collection appendHighResolutionIndices$default(NpcInfo npcInfo, int n, Collection collection, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return npcInfo.appendHighResolutionIndices(n, collection, bl);
    }

    private final ByteBuf backingBuffer(int worldId) throws IllegalStateException {
        ByteBuf byteBuf = this.getDetails(worldId).getBuffer$osrs_227_model();
        if (byteBuf == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return byteBuf;
    }

    private final ByteBuf backingBuffer(NpcInfoWorldDetails details) throws IllegalStateException {
        ByteBuf byteBuf = details.getBuffer$osrs_227_model();
        if (byteBuf == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return byteBuf;
    }

    public final void setViewDistance(int num) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.viewDistance = num;
    }

    public final void resetViewDistance() {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.viewDistance = 15;
    }

    public final void setPriorityCaps(int worldId, int lowPriorityCap, int normalPrioritySoftCap) {
        if (!(lowPriorityCap >= 0)) {
            boolean $i$a$-require-NpcInfo$setPriorityCaps$42 = false;
            String $i$a$-require-NpcInfo$setPriorityCaps$42 = "Low priority cap cannot be negative.";
            throw new IllegalArgumentException($i$a$-require-NpcInfo$setPriorityCaps$42.toString());
        }
        if (!(normalPrioritySoftCap >= 0)) {
            boolean $i$a$-require-NpcInfo$setPriorityCaps$52 = false;
            String $i$a$-require-NpcInfo$setPriorityCaps$52 = "Normal priority soft cap cannot be negative.";
            throw new IllegalArgumentException($i$a$-require-NpcInfo$setPriorityCaps$52.toString());
        }
        if (!(lowPriorityCap + normalPrioritySoftCap <= 250)) {
            boolean bl = false;
            String string = "The sum of low priority cap and normal priority soft cap must be 250 or fewer.";
            throw new IllegalArgumentException(string.toString());
        }
        NpcInfoWorldDetails world = this.getDetails(worldId);
        world.setLowPriorityCap$osrs_227_model(lowPriorityCap);
        world.setNormalPrioritySoftCap$osrs_227_model(normalPrioritySoftCap);
    }

    public final void setSpecific(@NotNull NpcAvatar avatar) {
        Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
        if (!avatar.getDetails$osrs_227_model().getSpecific()) {
            boolean bl = false;
            String string = "Only avatars that are marked as specific-only can be marked as specific.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setSpecific(avatar.getDetails$osrs_227_model().getIndex());
    }

    public final void clearSpecific(@NotNull NpcAvatar avatar) {
        Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
        if (!avatar.getDetails$osrs_227_model().getSpecific()) {
            boolean bl = false;
            String string = "Only avatars that are marked as specific-only can be unmarked as specific.";
            throw new IllegalArgumentException(string.toString());
        }
        this.unsetSpecific$osrs_227_model(avatar.getDetails$osrs_227_model().getIndex());
    }

    private final boolean isSpecific(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        return (this.specificVisible[longIndex] & bit) != 0L;
    }

    private final void setSpecific(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        long cur = this.specificVisible[longIndex];
        this.specificVisible[longIndex] = cur | bit;
    }

    public final void unsetSpecific$osrs_227_model(int index) {
        int longIndex = index >>> 6;
        long bit = 1L << (index & 0x3F);
        long cur = this.specificVisible[longIndex];
        this.specificVisible[longIndex] = cur & (bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Deprecated(message="Deprecated. Prefer toPacket(worldId) function instead for consistency.", replaceWith=@ReplaceWith(expression="toPacket(worldId)", imports={}))
    @NotNull
    public final OutgoingGameMessage toNpcInfoPacket(int worldId) {
        return this.toPacket(worldId);
    }

    @NotNull
    public final OutgoingGameMessage toPacket(int worldId) {
        Exception exception = this.exception;
        if (exception != null) {
            throw new InfoProcessException("Exception occurred during npc info processing for index " + this.localPlayerIndex, exception);
        }
        NpcInfoWorldDetails details = this.getDetails(worldId);
        OutgoingGameMessage outgoingGameMessage = details.getPreviousPacket$osrs_227_model();
        if (outgoingGameMessage == null) {
            boolean bl = false;
            String string = "Previous packet has not been calculated.";
            throw new IllegalStateException(string.toString());
        }
        return outgoingGameMessage;
    }

    private final ByteBuf allocBuffer(int worldId) {
        NpcInfoWorldDetails details = this.getDetails(worldId);
        ByteBuf buffer = this.allocator.buffer(40000, 40000);
        details.setBuffer$osrs_227_model(buffer);
        Intrinsics.checkNotNull((Object)buffer);
        this.recycler.plusAssign(buffer);
        return buffer;
    }

    public final void updateCoord(int worldId, int level, int x, int z) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        NpcInfoWorldDetails details = this.getDetails(worldId);
        details.setLocalPlayerCurrentCoord-ah1LTL0$osrs_227_model(CoordGrid.constructor-impl((int)level, (int)x, (int)z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compute$osrs_227_model(@NotNull NpcInfoWorldDetails details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        int viewDistance = this.viewDistance;
        ByteBuf buffer = this.allocBuffer(details.getWorldId$osrs_227_model());
        AutoCloseable autoCloseable = (AutoCloseable)BitBufKt.toBitBuf((ByteBuf)buffer);
        Throwable throwable = null;
        try {
            BitBuf bitBuffer = (BitBuf)autoCloseable;
            boolean bl = false;
            boolean fragmented = this.processHighResolution(details, bitBuffer, viewDistance);
            if (fragmented) {
                details.defragmentIndices$osrs_227_model();
            }
            this.processLowResolution(details, bitBuffer, viewDistance);
            if (details.getExtendedInfoCount$osrs_227_model() > 0) {
                bitBuffer.pBits(16, 65535);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void afterUpdate$osrs_227_model() {
        for (NpcInfoWorldDetails details : this.details) {
            if (details == null) continue;
            details.setLocalPlayerLastCoord-ah1LTL0$osrs_227_model(details.getLocalPlayerCurrentCoord-9LJGAnM$osrs_227_model());
            details.setExtendedInfoCount$osrs_227_model(0);
            details.getObserverExtendedInfoFlags$osrs_227_model().reset();
            OutgoingGameMessage previousPacket = details.getPreviousPacket$osrs_227_model();
            if (previousPacket instanceof ConsumableMessage && !((ConsumableMessage)previousPacket).isConsumed()) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.warn(String.valueOf("Previous npc info packet was calculated but not sent out to the client for world " + details.getWorldId$osrs_227_model() + " for player " + this.localPlayerIndex + "!"));
                }
            }
            details.setPreviousPacket$osrs_227_model(this.viewDistance > 31 ? (OutgoingGameMessage)new NpcInfoLargeV5(this.backingBuffer(details.getWorldId$osrs_227_model())) : (OutgoingGameMessage)new NpcInfoSmallV5(this.backingBuffer(details.getWorldId$osrs_227_model())));
        }
    }

    public final void putExtendedInfo$osrs_227_model(@NotNull NpcInfoWorldDetails details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        ByteBuf jagBuffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)this.backingBuffer(details));
        int n = details.getExtendedInfoCount$osrs_227_model();
        for (int i = 0; i < n; ++i) {
            NpcAvatar other;
            int index = UShortArray.get-Mh2AYeg((short[])details.getExtendedInfoIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF;
            if (this.repository.getOrNull(index) == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            int observerFlag = details.getObserverExtendedInfoFlags$osrs_227_model().getFlag(i);
            other.getExtendedInfo().pExtendedInfo-LP6Zgqo$osrs_227_model(this.oldSchoolClientType, jagBuffer, this.localPlayerIndex, i, details.getExtendedInfoCount$osrs_227_model() - i, observerFlag);
        }
    }

    private final boolean processHighResolution(NpcInfoWorldDetails details, BitBuf buffer, int viewDistance) {
        int npcIndex;
        NpcAvatar avatar;
        if (details.getHighResolutionNpcIndexCount$osrs_227_model() == 0) {
            buffer.pBits(8, 0);
            return false;
        }
        if (this.isTooFar(details, viewDistance)) {
            buffer.pBits(8, 0);
            int n = details.getHighResolutionNpcIndexCount$osrs_227_model();
            for (int i = 0; i < n; ++i) {
                NpcAvatar avatar2;
                int npcIndex2 = UShortArray.get-Mh2AYeg((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF;
                if (this.repository.getOrNull(npcIndex2) == null) continue;
                avatar2.removeObserver$osrs_227_model(this.localPlayerIndex);
            }
            details.setHighResolutionNpcIndexCount$osrs_227_model(0);
            details.clearPriorities$osrs_227_model();
            return false;
        }
        for (int i = details.getHighResolutionNpcIndexCount$osrs_227_model() - 1; -1 < i && this.removeHighResolutionNpc(details, avatar = this.repository.getOrNull(npcIndex = UShortArray.get-Mh2AYeg((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF), viewDistance); --i) {
            int avatar2 = details.getHighResolutionNpcIndexCount$osrs_227_model();
            details.setHighResolutionNpcIndexCount$osrs_227_model(avatar2 + -1);
            NpcAvatar npcAvatar = avatar;
            if (npcAvatar != null) {
                npcAvatar.removeObserver$osrs_227_model(this.localPlayerIndex);
            }
            details.decrementPriority$osrs_227_model(i);
        }
        int processedCount = details.getHighResolutionNpcIndexCount$osrs_227_model();
        buffer.pBits(8, processedCount);
        for (int i = 0; i < processedCount; ++i) {
            UnsafeLongBackedBitBuf movementBuffer;
            int n;
            int npcIndex3 = UShortArray.get-Mh2AYeg((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF;
            NpcAvatar avatar3 = this.repository.getOrNull(npcIndex3);
            if (this.removeHighResolutionNpc(details, avatar3, viewDistance)) {
                buffer.pBits(1, 1);
                buffer.pBits(2, 3);
                UShortArray.set-01HTLdE((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i, (short)-1);
                n = details.getHighResolutionNpcIndexCount$osrs_227_model();
                details.setHighResolutionNpcIndexCount$osrs_227_model(n + -1);
                NpcAvatar npcAvatar = avatar3;
                if (npcAvatar != null) {
                    npcAvatar.removeObserver$osrs_227_model(this.localPlayerIndex);
                }
                details.decrementPriority$osrs_227_model(i);
                continue;
            }
            if (avatar3.getExtendedInfo().getFlags$osrs_227_model() != 0) {
                short[] sArray = details.getExtendedInfoIndices-amswpOA$osrs_227_model();
                n = details.getExtendedInfoCount$osrs_227_model();
                details.setExtendedInfoCount$osrs_227_model(n + 1);
                UShortArray.set-01HTLdE((short[])sArray, (int)n, (short)UShort.constructor-impl((short)((short)npcIndex3)));
            }
            if (avatar3.getHighResMovementBuffer$osrs_227_model() == null) {
                boolean bl = false;
                String string = "High resolution movement buffer is null for " + avatar3;
                throw new IllegalStateException(string.toString());
            }
            buffer.pBits(movementBuffer);
        }
        return processedCount != details.getHighResolutionNpcIndexCount$osrs_227_model();
    }

    private final boolean removeHighResolutionNpc(NpcInfoWorldDetails details, NpcAvatar avatar, int viewDistance) {
        if (avatar == null || avatar.getDetails$osrs_227_model().getInaccessible() || avatar.getDetails$osrs_227_model().isTeleporting() || avatar.getDetails$osrs_227_model().getAllocateCycle() == NpcInfoProtocol.Companion.getCycleCount$osrs_227_model()) {
            return true;
        }
        if (avatar.getDetails$osrs_227_model().getSpecific() && !this.isSpecific(avatar.getDetails$osrs_227_model().getIndex())) {
            return true;
        }
        int coord = avatar.getDetails$osrs_227_model().getCurrentCoord-9LJGAnM();
        if (!this.withinDistance-QbmAAsE(details.getLocalPlayerCurrentCoord-9LJGAnM$osrs_227_model(), coord, viewDistance)) {
            return true;
        }
        long buildArea = details.getBuildArea-RDuwMps$osrs_227_model();
        return !BuildArea.equals-impl0(buildArea, BuildArea.Companion.getINVALID-RDuwMps()) && !BuildArea.contains-ah1LTL0$osrs_227_model(buildArea, coord);
    }

    private final boolean isInBuildArea(NpcInfoWorldDetails details, NpcAvatar avatar) {
        long buildArea = details.getBuildArea-RDuwMps$osrs_227_model();
        return BuildArea.equals-impl0(buildArea, BuildArea.Companion.getINVALID-RDuwMps()) || BuildArea.contains-ah1LTL0$osrs_227_model(buildArea, avatar.getDetails$osrs_227_model().getCurrentCoord-9LJGAnM());
    }

    private final boolean isTooFar(NpcInfoWorldDetails details, int viewDistance) {
        return !this.withinDistance-QbmAAsE(details.getLocalPlayerLastCoord-9LJGAnM$osrs_227_model(), details.getLocalPlayerCurrentCoord-9LJGAnM$osrs_227_model(), viewDistance);
    }

    private final void processLowResolution(NpcInfoWorldDetails details, BitBuf buffer, int viewDistance) {
        int lowCap = details.getLowPriorityCap$osrs_227_model();
        int normalSoftCap = details.getNormalPrioritySoftCap$osrs_227_model();
        if (details.getNormalPriorityCount$osrs_227_model() >= normalSoftCap && details.getLowPriorityCount$osrs_227_model() >= lowCap) {
            return;
        }
        NpcResolutionChangeEncoder encoder = (NpcResolutionChangeEncoder)this.lowResolutionToHighResolutionEncoders.get((ClientType)this.oldSchoolClientType);
        boolean largeDistance = viewDistance > 31;
        int coord = details.getLocalPlayerCurrentCoord-9LJGAnM$osrs_227_model();
        int centerX = CoordGrid.getX-impl((int)coord);
        int centerZ = CoordGrid.getZ-impl((int)coord);
        int level = CoordGrid.getLevel-impl((int)coord);
        int startX = RangesKt.coerceAtLeast((int)(centerX - viewDistance >> 3), (int)0);
        int startZ = RangesKt.coerceAtLeast((int)(centerZ - viewDistance >> 3), (int)0);
        int endX = RangesKt.coerceAtMost((int)(centerX + viewDistance >> 3), (int)2047);
        int endZ = RangesKt.coerceAtMost((int)(centerZ + viewDistance >> 3), (int)2047);
        int x = startX;
        if (x <= endX) {
            block0: while (true) {
                int z;
                if ((z = startZ) <= endZ) {
                    while (true) {
                        if (this.zoneIndexStorage.get(level, x, z) != null) {
                            int index;
                            short[] npcs;
                            int n = npcs.length;
                            for (int k = 0; k < n && (index = npcs[k] & 0xFFFF) != 65535; ++k) {
                                boolean extendedInfo;
                                NpcAvatar avatar;
                                if (this.isHighResolution(details, index) || this.repository.getOrNull(index) == null || avatar.getDetails$osrs_227_model().getInaccessible()) continue;
                                if ((avatar.getDetails$osrs_227_model().getPriorityBitcode() & 1) != 0) {
                                    if (details.getNormalPriorityCount$osrs_227_model() >= normalSoftCap && details.getLowPriorityCount$osrs_227_model() >= lowCap) {
                                        break block0;
                                    }
                                } else if (details.getLowPriorityCount$osrs_227_model() >= lowCap) continue;
                                if (!CoordGrid.inDistance-YdbEnh8((int)coord, (int)avatar.getDetails$osrs_227_model().getCurrentCoord-9LJGAnM(), (int)viewDistance) || !this.isInBuildArea(details, avatar) || avatar.getDetails$osrs_227_model().getSpecific() && !this.isSpecific(index)) continue;
                                avatar.addObserver$osrs_227_model(this.localPlayerIndex);
                                int n2 = details.getHighResolutionNpcIndexCount$osrs_227_model();
                                details.setHighResolutionNpcIndexCount$osrs_227_model(n2 + 1);
                                int i = n2;
                                details.incrementPriority$osrs_227_model(i, (avatar.getDetails$osrs_227_model().getPriorityBitcode() & 1) == 0);
                                UShortArray.set-01HTLdE((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i, (short)UShort.constructor-impl((short)((short)index)));
                                int observerFlags = avatar.getExtendedInfo().getLowToHighResChangeExtendedInfoFlags$osrs_227_model();
                                if (observerFlags != 0) {
                                    details.getObserverExtendedInfoFlags$osrs_227_model().addFlag(details.getExtendedInfoCount$osrs_227_model(), observerFlags);
                                }
                                boolean bl = extendedInfo = (avatar.getExtendedInfo().getFlags$osrs_227_model() | observerFlags) != 0;
                                if (extendedInfo) {
                                    short[] sArray = details.getExtendedInfoIndices-amswpOA$osrs_227_model();
                                    int n3 = details.getExtendedInfoCount$osrs_227_model();
                                    details.setExtendedInfoCount$osrs_227_model(n3 + 1);
                                    UShortArray.set-01HTLdE((short[])sArray, (int)n3, (short)UShort.constructor-impl((short)((short)index)));
                                }
                                encoder.encode-K2cc1tA(buffer, avatar.getDetails$osrs_227_model(), extendedInfo, coord, largeDistance, NpcInfoProtocol.Companion.getCycleCount$osrs_227_model());
                            }
                        }
                        if (z == endZ) break;
                        ++z;
                    }
                }
                if (x == endX) break;
                ++x;
            }
        }
    }

    private final boolean isHighResolution(NpcInfoWorldDetails details, int index) {
        int n = details.getHighResolutionNpcIndexCount$osrs_227_model();
        for (int i = 0; i < n; ++i) {
            if ((UShortArray.get-Mh2AYeg((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF) != index) continue;
            return true;
        }
        return false;
    }

    private final boolean withinDistance-QbmAAsE(int localPlayerCoordGrid, int coord, int distance) {
        return CoordGrid.inDistance-YdbEnh8((int)localPlayerCoordGrid, (int)coord, (int)distance);
    }

    public final void onReconnect() {
        NpcInfoWorldDetails details;
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.onDealloc();
        this.details[2048] = details = this.detailsStorage.poll$osrs_227_model(-1);
    }

    @Override
    public void onAlloc(int index, @NotNull OldSchoolClientType oldSchoolClientType, boolean newInstance) {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.localPlayerIndex = index;
        this.oldSchoolClientType = oldSchoolClientType;
        this.viewDistance = 15;
        this.details[2048] = this.detailsStorage.poll$osrs_227_model(-1);
    }

    @Override
    public void onDealloc() {
        RSProtThreadSafetyKt.checkCommunicationThread();
        int n = this.details.length;
        for (int index = 0; index < n; ++index) {
            NpcInfoWorldDetails details;
            if (this.details[index] == null) continue;
            this.releaseObservers(details);
            this.detailsStorage.push$osrs_227_model(details);
            this.details[index] = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void clearEntities(int worldId) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (worldId == -1) ** GOTO lbl-1000
        v0 = 0 <= worldId ? worldId < 2048 : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-NpcInfo$clearEntities$1 = false;
            var2_3 = "World id must be -1 or in range of 0..<2048";
            throw new IllegalArgumentException(var2_3.toString());
        }
        if (worldId == -1) {
            this.onReconnect();
        } else {
            this.destroyWorld(worldId);
            this.allocateWorld(worldId);
        }
    }

    private final void releaseObservers(NpcInfoWorldDetails details) {
        int n = details.getHighResolutionNpcIndexCount$osrs_227_model();
        for (int i = 0; i < n; ++i) {
            NpcAvatar avatar;
            int npcIndex = UShortArray.get-Mh2AYeg((short[])details.getHighResolutionNpcIndices-amswpOA$osrs_227_model(), (int)i) & 0xFFFF;
            if (this.repository.getOrNull(npcIndex) == null) continue;
            avatar.removeObserver$osrs_227_model(this.localPlayerIndex);
        }
    }

    @JvmOverloads
    public final void updateBuildArea(int worldId, int zoneX, int zoneZ, int widthInZones) {
        NpcInfo.updateBuildArea$default(this, worldId, zoneX, zoneZ, widthInZones, 0, 16, null);
    }

    @JvmOverloads
    public final void updateBuildArea(int worldId, int zoneX, int zoneZ) {
        NpcInfo.updateBuildArea$default(this, worldId, zoneX, zoneZ, 0, 0, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final <T extends Collection<Integer>> T appendHighResolutionIndices(int worldId, @NotNull T collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return (T)NpcInfo.appendHighResolutionIndices$default(this, worldId, collection, false, 4, null);
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\nX\u0082T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0011\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0012"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfo$Companion;", "", "()V", "AVATAR_NORMAL_PRIORITY_FLAG", "", "BUF_CAPACITY", "DEFAULT_DISTANCE", "MAX_HIGH_RESOLUTION_NPCS", "MAX_SMALL_PACKET_DISTANCE", "NPC_INDEX_TERMINATOR", "Lkotlin/UShort;", "S", "NPC_INFO_CAPACITY", "ROOT_WORLD", "WORLD_ENTITY_CAPACITY", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-227-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

