/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.protocol.ClientProt;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.decoder.DecoderState;
import net.rsprot.protocol.message.codec.MessageDecoder;
import net.rsprot.protocol.message.codec.incoming.MessageDecoderRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/rsprot/protocol/api/js5/Js5MessageDecoder;", "Lio/netty/handler/codec/ByteToMessageDecoder;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "decoder", "Lnet/rsprot/protocol/message/codec/MessageDecoder;", "decoders", "Lnet/rsprot/protocol/message/codec/incoming/MessageDecoderRepository;", "Lnet/rsprot/protocol/ClientProt;", "length", "", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "opcode", "state", "Lnet/rsprot/protocol/api/decoder/DecoderState;", "decode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "input", "Lio/netty/buffer/ByteBuf;", "out", "", "", "osrs-227-api"})
public final class Js5MessageDecoder
extends ByteToMessageDecoder {
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private final MessageDecoderRepository<ClientProt> decoders;
    @NotNull
    private DecoderState state;
    private MessageDecoder<?> decoder;
    private int opcode;
    private int length;

    public Js5MessageDecoder(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        this.networkService = networkService;
        this.decoders = this.networkService.getDecoderRepositories().getJs5MessageDecoderRepository();
        this.state = DecoderState.READ_OPCODE;
        this.opcode = -1;
    }

    @NotNull
    public final NetworkService<?> getNetworkService() {
        return this.networkService;
    }

    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf input, @NotNull List<Object> out) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(out, (String)"out");
        if (this.state == DecoderState.READ_OPCODE) {
            if (!input.isReadable()) {
                return;
            }
            this.opcode = JagexByteBufExtensionsKt.g1((ByteBuf)input) & 0xFF;
            this.decoder = this.decoders.getDecoder(this.opcode);
            MessageDecoder<?> messageDecoder = this.decoder;
            if (messageDecoder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                messageDecoder = null;
            }
            this.length = messageDecoder.getProt().getSize();
            DecoderState decoderState = this.state = this.length >= 0 ? DecoderState.READ_PAYLOAD : DecoderState.READ_LENGTH;
        }
        if (this.state == DecoderState.READ_LENGTH) {
            switch (this.length) {
                case -1: {
                    if (!input.isReadable(1)) {
                        return;
                    }
                    this.length = JagexByteBufExtensionsKt.g1((ByteBuf)input);
                    break;
                }
                case -2: {
                    if (!input.isReadable(2)) {
                        return;
                    }
                    this.length = JagexByteBufExtensionsKt.g2((ByteBuf)input);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid length: " + this.length + " of opcode " + this.opcode);
                }
            }
            this.state = DecoderState.READ_PAYLOAD;
        }
        if (this.state == DecoderState.READ_PAYLOAD) {
            if (!input.isReadable(this.length)) {
                return;
            }
            ByteBuf payload = input.readSlice(this.length);
            Collection collection = out;
            MessageDecoder<?> messageDecoder = this.decoder;
            if (messageDecoder == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                messageDecoder = null;
            }
            Intrinsics.checkNotNull((Object)payload);
            collection.add(messageDecoder.decode-lwEbYT4(JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)payload)));
            if (payload.isReadable()) {
                MessageDecoder<?> messageDecoder2 = this.decoder;
                if (messageDecoder2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                    messageDecoder2 = null;
                }
                throw new DecoderException("Decoder " + messageDecoder2.getClass() + " did not read entire payload of opcode " + this.opcode + ": " + payload.readableBytes());
            }
            this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor().incrementIncomingPackets(ChannelExtensionsKt.inetAddress(ctx), this.opcode, this.length);
            this.state = DecoderState.READ_OPCODE;
        }
    }
}

