/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.traffic;

import java.net.InetAddress;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import net.rsprot.protocol.api.traffic.ConcurrentNetworkTrafficWriter;
import net.rsprot.protocol.loginprot.incoming.util.HostPlatformStats;
import net.rsprot.protocol.loginprot.incoming.util.LoginBlock;
import net.rsprot.protocol.metrics.channel.snapshots.ChannelTrafficSnapshot;
import net.rsprot.protocol.metrics.channel.snapshots.InetAddressSnapshot;
import net.rsprot.protocol.metrics.channel.snapshots.impl.ConcurrentChannelTrafficSnapshot;
import net.rsprot.protocol.metrics.channel.snapshots.util.PacketSnapshot;
import net.rsprot.protocol.metrics.snapshots.impl.ConcurrentNetworkTrafficSnapshot;
import net.rsprot.protocol.metrics.writer.NetworkTrafficWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\n\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0010H\u0002J\t\u0010\u0011\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u0014\u0010\u0013\u001a\u00020\u00032\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J,\u0010\u0015\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0012\u0010\u0014\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\"\u0010\u001b\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0010\u0010\u001c\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u000f0\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010!\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0012\u0010\"\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J.\u0010#\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u001c\u0010$\u001a\u0018\u0012\u0004\u0012\u00020%\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&0\u001dH\u0002J*\u0010(\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0006\u0010)\u001a\u00020\u00032\u0010\u0010\u001c\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020*0\u001dH\u0002J\u001e\u0010+\u001a\u00060\u0017j\u0002`\u0018*\u00060\u0017j\u0002`\u00182\b\b\u0002\u0010,\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lnet/rsprot/protocol/api/traffic/ConcurrentNetworkTrafficWriter;", "Lnet/rsprot/protocol/metrics/writer/NetworkTrafficWriter;", "Lnet/rsprot/protocol/metrics/snapshots/impl/ConcurrentNetworkTrafficSnapshot;", "", "()V", "INDENT", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "equals", "", "other", "", "format", "number", "", "", "hashCode", "toString", "write", "snapshot", "appendChannelMetrics", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lnet/rsprot/protocol/metrics/channel/snapshots/impl/ConcurrentChannelTrafficSnapshot;", "title", "appendDisconnectionReasons", "map", "", "appendHostPlatformStats", "stats", "Lnet/rsprot/protocol/loginprot/incoming/util/HostPlatformStats;", "appendInetAddressMetrics", "channelSnapshot", "appendLoginBlocks", "loginBlocks", "Ljava/net/InetAddress;", "", "Lnet/rsprot/protocol/loginprot/incoming/util/LoginBlock;", "appendPacketSnapshots", "prefix", "Lnet/rsprot/protocol/metrics/channel/snapshots/util/PacketSnapshot;", "indent", "count", "osrs-227-api"})
@SourceDebugExtension(value={"SMAP\nConcurrentNetworkTrafficWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentNetworkTrafficWriter.kt\nnet/rsprot/protocol/api/traffic/ConcurrentNetworkTrafficWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,221:1\n766#2:222\n857#2,2:223\n1054#2:239\n551#3:225\n536#3,6:226\n551#3:232\n536#3,6:233\n*S KotlinDebug\n*F\n+ 1 ConcurrentNetworkTrafficWriter.kt\nnet/rsprot/protocol/api/traffic/ConcurrentNetworkTrafficWriter\n*L\n149#1:222\n149#1:223,2\n200#1:239\n174#1:225\n174#1:226,6\n198#1:232\n198#1:233,6\n*E\n"})
public final class ConcurrentNetworkTrafficWriter
implements NetworkTrafficWriter<ConcurrentNetworkTrafficSnapshot<?>, String> {
    @NotNull
    public static final ConcurrentNetworkTrafficWriter INSTANCE = new ConcurrentNetworkTrafficWriter();
    @NotNull
    private static final String INDENT = "  ";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL).withZone(ZoneId.systemDefault());

    private ConcurrentNetworkTrafficWriter() {
    }

    @NotNull
    public String write(@NotNull ConcurrentNetworkTrafficSnapshot<?> snapshot) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        StringBuilder $this$write_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String start2 = dateTimeFormatter.format(snapshot.getStartDateTime());
        String end = dateTimeFormatter.format(snapshot.getEndDateTime());
        StringBuilder stringBuilder2 = $this$write_u24lambda_u240.append("Network Traffic Snapshot");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = ConcurrentNetworkTrafficWriter.indent$default(INSTANCE, $this$write_u24lambda_u240, 0, 1, null).append("Snapshot started on: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        StringBuilder stringBuilder4 = stringBuilder3.append(start2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = ConcurrentNetworkTrafficWriter.indent$default(INSTANCE, $this$write_u24lambda_u240, 0, 1, null).append("Snapshot ended on: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        StringBuilder stringBuilder6 = stringBuilder5.append(end);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = ConcurrentNetworkTrafficWriter.indent$default(INSTANCE, $this$write_u24lambda_u240, 0, 1, null).append("Elapsed duration: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        StringBuilder stringBuilder8 = stringBuilder7;
        StringBuilder stringBuilder9 = stringBuilder8.append(Duration.box-impl((long)snapshot.getElapsed-UwyO8pc()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder10 = ConcurrentNetworkTrafficWriter.indent$default(INSTANCE, $this$write_u24lambda_u240, 0, 1, null).append("Connection requests: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        stringBuilder8 = stringBuilder10;
        StringBuilder stringBuilder11 = stringBuilder8.append(INSTANCE.format(snapshot.getConnectionRequests()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$write_u24lambda_u240.append('\n'), (String)"append(...)");
        ChannelTrafficSnapshot channelTrafficSnapshot = snapshot.getLoginSnapshot();
        Intrinsics.checkNotNull((Object)channelTrafficSnapshot, (String)"null cannot be cast to non-null type net.rsprot.protocol.metrics.channel.snapshots.impl.ConcurrentChannelTrafficSnapshot<*, *, *>");
        INSTANCE.appendChannelMetrics($this$write_u24lambda_u240, (ConcurrentChannelTrafficSnapshot)channelTrafficSnapshot, "Login");
        Intrinsics.checkNotNullExpressionValue((Object)$this$write_u24lambda_u240.append('\n'), (String)"append(...)");
        ChannelTrafficSnapshot channelTrafficSnapshot2 = snapshot.getJs5Snapshot();
        Intrinsics.checkNotNull((Object)channelTrafficSnapshot2, (String)"null cannot be cast to non-null type net.rsprot.protocol.metrics.channel.snapshots.impl.ConcurrentChannelTrafficSnapshot<*, *, *>");
        INSTANCE.appendChannelMetrics($this$write_u24lambda_u240, (ConcurrentChannelTrafficSnapshot)channelTrafficSnapshot2, "JS5");
        Intrinsics.checkNotNullExpressionValue((Object)$this$write_u24lambda_u240.append('\n'), (String)"append(...)");
        ChannelTrafficSnapshot channelTrafficSnapshot3 = snapshot.getGameSnapshot();
        Intrinsics.checkNotNull((Object)channelTrafficSnapshot3, (String)"null cannot be cast to non-null type net.rsprot.protocol.metrics.channel.snapshots.impl.ConcurrentChannelTrafficSnapshot<*, *, *>");
        INSTANCE.appendChannelMetrics($this$write_u24lambda_u240, (ConcurrentChannelTrafficSnapshot)channelTrafficSnapshot3, "Game");
        Intrinsics.checkNotNullExpressionValue((Object)$this$write_u24lambda_u240.append('\n'), (String)"append(...)");
        Map map = snapshot.getLoginBlocks();
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<java.net.InetAddress, kotlin.collections.List<net.rsprot.protocol.loginprot.incoming.util.LoginBlock<*>>>");
        Map loginBlocks = map;
        INSTANCE.appendLoginBlocks($this$write_u24lambda_u240, loginBlocks);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendLoginBlocks(StringBuilder $this$appendLoginBlocks, Map<InetAddress, ? extends List<? extends LoginBlock<?>>> loginBlocks) {
        StringBuilder stringBuilder = $this$appendLoginBlocks.append("Login Blocks");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        for (Map.Entry<InetAddress, List<LoginBlock<?>>> entry : loginBlocks.entrySet()) {
            InetAddress k = entry.getKey();
            List<LoginBlock<?>> v = entry.getValue();
            StringBuilder stringBuilder2 = ConcurrentNetworkTrafficWriter.indent$default(this, $this$appendLoginBlocks, 0, 1, null).append("Inet Address: ");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            StringBuilder stringBuilder3 = stringBuilder2.append(k);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            for (LoginBlock<?> block : v) {
                String string;
                String string2;
                String string22;
                StringBuilder stringBuilder4 = this.indent($this$appendLoginBlocks, 2).append("Login Block");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder5 = this.indent($this$appendLoginBlocks, 3).append("Version: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                StringBuilder stringBuilder6 = stringBuilder5;
                int bl = block.getVersion();
                StringBuilder stringBuilder7 = stringBuilder6.append(bl);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder8 = this.indent($this$appendLoginBlocks, 3).append("Sub Version: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                stringBuilder6 = stringBuilder8;
                int string3 = block.getSubVersion();
                StringBuilder stringBuilder9 = stringBuilder6.append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder10 = this.indent($this$appendLoginBlocks, 3).append("Client Type: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
                stringBuilder6 = stringBuilder10;
                StringBuilder stringBuilder11 = stringBuilder6.append(block.getClientType());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder12 = this.indent($this$appendLoginBlocks, 3).append("Platform Type: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
                stringBuilder6 = stringBuilder12;
                StringBuilder stringBuilder13 = stringBuilder6.append(block.getPlatformType());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder14 = this.indent($this$appendLoginBlocks, 3).append("External Authenticator: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
                stringBuilder6 = stringBuilder14;
                boolean n = block.getHasExternalAuthenticator();
                StringBuilder stringBuilder15 = stringBuilder6.append(n);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder16 = this.indent($this$appendLoginBlocks, 3).append("Seed: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
                stringBuilder6 = stringBuilder16;
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.toString(block.getSeed()), (String)"toString(...)");
                StringBuilder stringBuilder17 = stringBuilder6.append(string22);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder18 = this.indent($this$appendLoginBlocks, 3).append("Session Id: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(...)");
                stringBuilder6 = stringBuilder18;
                StringBuilder stringBuilder19 = stringBuilder6.append(this.format(block.getSessionId()));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder20 = this.indent($this$appendLoginBlocks, 3).append("Username: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20, (String)"append(...)");
                stringBuilder6 = stringBuilder20;
                StringBuilder stringBuilder21 = stringBuilder6.append(block.getUsername());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder22 = this.indent($this$appendLoginBlocks, 3).append("Low Detail: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22, (String)"append(...)");
                stringBuilder6 = stringBuilder22;
                boolean n2 = block.getLowDetail();
                StringBuilder stringBuilder23 = stringBuilder6.append(n2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder24 = this.indent($this$appendLoginBlocks, 3).append("Resizable: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24, (String)"append(...)");
                stringBuilder6 = stringBuilder24;
                boolean bl2 = block.getResizable();
                StringBuilder stringBuilder25 = stringBuilder6.append(bl2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder25, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder25.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder26 = this.indent($this$appendLoginBlocks, 3).append("Width: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder26, (String)"append(...)");
                stringBuilder6 = stringBuilder26;
                int n3 = block.getWidth();
                StringBuilder stringBuilder27 = stringBuilder6.append(n3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder27, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder27.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder28 = this.indent($this$appendLoginBlocks, 3).append("Height: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder28, (String)"append(...)");
                stringBuilder6 = stringBuilder28;
                int n4 = block.getHeight();
                StringBuilder stringBuilder29 = stringBuilder6.append(n4);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder29, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder29.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder30 = this.indent($this$appendLoginBlocks, 3).append("UUID: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder30, (String)"append(...)");
                stringBuilder6 = stringBuilder30;
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.toString(block.getUuid()), (String)"toString(...)");
                StringBuilder stringBuilder31 = stringBuilder6.append(string2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder31, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder31.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder32 = this.indent($this$appendLoginBlocks, 3).append("Site Settings: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder32, (String)"append(...)");
                stringBuilder6 = stringBuilder32;
                StringBuilder stringBuilder33 = stringBuilder6.append(block.getSiteSettings());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder33, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder33.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder34 = this.indent($this$appendLoginBlocks, 3).append("Affiliate: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder34, (String)"append(...)");
                stringBuilder6 = stringBuilder34;
                int n5 = block.getAffiliate();
                StringBuilder stringBuilder35 = stringBuilder6.append(n5);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder35, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder35.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder36 = this.indent($this$appendLoginBlocks, 3).append("Deep Links: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder36, (String)"append(...)");
                stringBuilder6 = stringBuilder36;
                StringBuilder stringBuilder37 = stringBuilder6.append(block.getDeepLinks());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder37, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder37.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder38 = this.indent($this$appendLoginBlocks, 3).append("Reflection Check Const: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder38, (String)"append(...)");
                stringBuilder6 = stringBuilder38;
                int n6 = block.getReflectionCheckerConst();
                StringBuilder stringBuilder39 = stringBuilder6.append(n6);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder39, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder39.append('\n'), (String)"append(...)");
                StringBuilder stringBuilder40 = this.indent($this$appendLoginBlocks, 3).append("CRC: ");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder40, (String)"append(...)");
                stringBuilder6 = stringBuilder40;
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.toString(block.getCrc().toIntArray()), (String)"toString(...)");
                StringBuilder stringBuilder41 = stringBuilder6.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder41, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder41.append('\n'), (String)"append(...)");
                this.appendHostPlatformStats($this$appendLoginBlocks, block.getHostPlatformStats());
            }
        }
    }

    private final void appendHostPlatformStats(StringBuilder $this$appendHostPlatformStats, HostPlatformStats stats) {
        StringBuilder stringBuilder = this.indent($this$appendHostPlatformStats, 3).append("Host Platform Stats");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = this.indent($this$appendHostPlatformStats, 4).append("Version: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        StringBuilder stringBuilder3 = stringBuilder2;
        int n = stats.getVersion();
        StringBuilder stringBuilder4 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = this.indent($this$appendHostPlatformStats, 4).append("OS Type: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        stringBuilder3 = stringBuilder5;
        n = stats.getOsType();
        StringBuilder stringBuilder6 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = this.indent($this$appendHostPlatformStats, 4).append("OS 64 Bit: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        stringBuilder3 = stringBuilder7;
        n = stats.getOs64Bit() ? 1 : 0;
        StringBuilder stringBuilder8 = stringBuilder3.append(n != 0);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder9 = this.indent($this$appendHostPlatformStats, 4).append("OS Version: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
        stringBuilder3 = stringBuilder9;
        n = stats.getOsVersion();
        StringBuilder stringBuilder10 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder11 = this.indent($this$appendHostPlatformStats, 4).append("Java Vendor: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
        stringBuilder3 = stringBuilder11;
        n = stats.getJavaVendor();
        StringBuilder stringBuilder12 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder13 = this.indent($this$appendHostPlatformStats, 4).append("Java: ").append(stats.getJavaVendor()).append(" ").append(stats.getJavaVersionMajor()).append(".").append(stats.getJavaVersionMinor()).append(".");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
        stringBuilder3 = stringBuilder13;
        n = stats.getJavaVersionPatch();
        StringBuilder stringBuilder14 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder15 = this.indent($this$appendHostPlatformStats, 4).append("Applet: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
        stringBuilder3 = stringBuilder15;
        n = stats.getApplet() ? 1 : 0;
        StringBuilder stringBuilder16 = stringBuilder3.append(n != 0);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder17 = this.indent($this$appendHostPlatformStats, 4).append("Java Max Memory (MB): ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
        stringBuilder3 = stringBuilder17;
        n = stats.getJavaMaxMemoryMb();
        StringBuilder stringBuilder18 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder19 = this.indent($this$appendHostPlatformStats, 4).append("Java Available Processors: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append(...)");
        stringBuilder3 = stringBuilder19;
        n = stats.getJavaAvailableProcessors();
        StringBuilder stringBuilder20 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder21 = this.indent($this$appendHostPlatformStats, 4).append("System Memory: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21, (String)"append(...)");
        stringBuilder3 = stringBuilder21;
        n = stats.getSystemMemory();
        StringBuilder stringBuilder22 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder23 = this.indent($this$appendHostPlatformStats, 4).append("System Speed: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23, (String)"append(...)");
        stringBuilder3 = stringBuilder23;
        n = stats.getSystemSpeed();
        StringBuilder stringBuilder24 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder25 = this.indent($this$appendHostPlatformStats, 4).append("GPU DX Name: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder25, (String)"append(...)");
        stringBuilder3 = stringBuilder25;
        StringBuilder stringBuilder26 = stringBuilder3.append(stats.getGpuDxName());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder26, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder26.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder27 = this.indent($this$appendHostPlatformStats, 4).append("GPU GL Name: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder27, (String)"append(...)");
        stringBuilder3 = stringBuilder27;
        StringBuilder stringBuilder28 = stringBuilder3.append(stats.getGpuGlName());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder28, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder28.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder29 = this.indent($this$appendHostPlatformStats, 4).append("GPU GL Version: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder29, (String)"append(...)");
        stringBuilder3 = stringBuilder29;
        StringBuilder stringBuilder30 = stringBuilder3.append(stats.getGpuGlVersion());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder30, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder30.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder31 = this.indent($this$appendHostPlatformStats, 4).append("GPU Driver Date: ").append(stats.getGpuDriverMonth()).append(".");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder31, (String)"append(...)");
        stringBuilder3 = stringBuilder31;
        n = stats.getGpuDriverYear();
        StringBuilder stringBuilder32 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder32, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder32.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder33 = this.indent($this$appendHostPlatformStats, 4).append("CPU Manufacturer: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder33, (String)"append(...)");
        stringBuilder3 = stringBuilder33;
        StringBuilder stringBuilder34 = stringBuilder3.append(stats.getCpuManufacturer());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder34, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder34.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder35 = this.indent($this$appendHostPlatformStats, 4).append("CPU Brand: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder35, (String)"append(...)");
        stringBuilder3 = stringBuilder35;
        StringBuilder stringBuilder36 = stringBuilder3.append(stats.getCpuBrand());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder36, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder36.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder37 = this.indent($this$appendHostPlatformStats, 4).append("CPU Counts: ").append(stats.getCpuCount1()).append(", ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder37, (String)"append(...)");
        stringBuilder3 = stringBuilder37;
        n = stats.getCpuCount2();
        StringBuilder stringBuilder38 = stringBuilder3.append(n);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder38, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder38.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder39 = this.indent($this$appendHostPlatformStats, 4).append("CPU Features: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder39, (String)"append(...)");
        stringBuilder3 = stringBuilder39;
        String string = Arrays.toString(stats.getCpuFeatures());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        StringBuilder stringBuilder40 = stringBuilder3.append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder40, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder40.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder41 = this.indent($this$appendHostPlatformStats, 4).append("CPU Signature: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder41, (String)"append(...)");
        stringBuilder3 = stringBuilder41;
        int n2 = stats.getCpuSignature();
        StringBuilder stringBuilder42 = stringBuilder3.append(n2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder42, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder42.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder43 = this.indent($this$appendHostPlatformStats, 4).append("Client Name: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder43, (String)"append(...)");
        stringBuilder3 = stringBuilder43;
        StringBuilder stringBuilder44 = stringBuilder3.append(stats.getClientName());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder44, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder44.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder45 = this.indent($this$appendHostPlatformStats, 4).append("Device Name: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder45, (String)"append(...)");
        stringBuilder3 = stringBuilder45;
        StringBuilder stringBuilder46 = stringBuilder3.append(stats.getDeviceName());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder46, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder46.append('\n'), (String)"append(...)");
    }

    private final void appendChannelMetrics(StringBuilder $this$appendChannelMetrics, ConcurrentChannelTrafficSnapshot<?, ?, ?> snapshot, String title) {
        StringBuilder stringBuilder = $this$appendChannelMetrics.append(title);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        StringBuilder stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder3 = stringBuilder2.append(" Channel Snapshot");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        String start2 = dateTimeFormatter.format(snapshot.getStartDateTime());
        String end = dateTimeFormatter.format(snapshot.getEndDateTime());
        StringBuilder stringBuilder4 = ConcurrentNetworkTrafficWriter.indent$default(this, $this$appendChannelMetrics, 0, 1, null).append(title).append(" snapshot started on: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        StringBuilder stringBuilder5 = stringBuilder4.append(start2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = ConcurrentNetworkTrafficWriter.indent$default(this, $this$appendChannelMetrics, 0, 1, null).append(title).append(" snapshot ended on: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        StringBuilder stringBuilder7 = stringBuilder6.append(end);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder8 = ConcurrentNetworkTrafficWriter.indent$default(this, $this$appendChannelMetrics, 0, 1, null).append(title).append(" elapsed duration: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        StringBuilder stringBuilder9 = stringBuilder8;
        StringBuilder stringBuilder10 = stringBuilder9.append(Duration.box-impl((long)snapshot.getElapsed-UwyO8pc()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        this.appendInetAddressMetrics($this$appendChannelMetrics, snapshot, title);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendInetAddressMetrics(StringBuilder $this$appendInetAddressMetrics, ConcurrentChannelTrafficSnapshot<?, ?, ?> channelSnapshot, String title) {
        InetAddress address;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        StringBuilder stringBuilder = ConcurrentNetworkTrafficWriter.indent$default(this, $this$appendInetAddressMetrics, 0, 1, null).append(title);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        StringBuilder stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder3 = stringBuilder2.append(" INet Address Metrics");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        Iterator iterator = channelSnapshot.getActiveConnectionsByAddress().entrySet();
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !channelSnapshot.getInetAddressSnapshots().containsKey(it.getKey());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List untrackedConnections = (List)destination$iv$iv;
        for (Map.Entry entry : untrackedConnections) {
            address = (InetAddress)entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            StringBuilder stringBuilder4 = this.indent($this$appendInetAddressMetrics, 2).append("INet Address: ");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            StringBuilder stringBuilder5 = stringBuilder4.append(address);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder6 = this.indent($this$appendInetAddressMetrics, 3).append("Active connections: ");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            StringBuilder stringBuilder7 = stringBuilder6.append(count);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        }
        for (Map.Entry entry : channelSnapshot.getInetAddressSnapshots().entrySet()) {
            address = (InetAddress)entry.getKey();
            InetAddressSnapshot ss = (InetAddressSnapshot)entry.getValue();
            StringBuilder stringBuilder8 = this.indent($this$appendInetAddressMetrics, 2).append("INet Address: ");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            StringBuilder stringBuilder9 = stringBuilder8.append(address);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
            Integer activeConnections = (Integer)channelSnapshot.getActiveConnectionsByAddress().get(address);
            if (activeConnections != null) {
                Intrinsics.checkNotNullExpressionValue((Object)this.indent($this$appendInetAddressMetrics, 3).append("Active connections: "), (String)"append(...)");
                int n = activeConnections;
                StringBuilder stringBuilder10 = ((StringBuilder)((Object)iterator2)).append(n);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
            }
            this.appendPacketSnapshots($this$appendInetAddressMetrics, "Incoming", ss.getIncomingPackets());
            this.appendPacketSnapshots($this$appendInetAddressMetrics, "Outgoing", ss.getOutgoingPackets());
            this.appendDisconnectionReasons($this$appendInetAddressMetrics, ss.getDisconnectionsByReason());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendPacketSnapshots(StringBuilder $this$appendPacketSnapshots, String prefix, Map<?, PacketSnapshot> map) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Map<?, PacketSnapshot> map2 = map;
        boolean $i$f$filterNot = false;
        void var7_7 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (((PacketSnapshot)it.getValue()).getCount() == 0L) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable iterable = destination$iv$iv.entrySet();
        Object object2 = new Function1[]{appendPacketSnapshots.incoming.2.INSTANCE, appendPacketSnapshots.incoming.3.INSTANCE};
        Comparator comparator = ComparisonsKt.compareBy((Function1[])object2).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        List incoming2 = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        for (Object object2 : incoming2) {
            StringBuilder stringBuilder;
            Object k = object2.getKey();
            PacketSnapshot v = (PacketSnapshot)object2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)this.indent($this$appendPacketSnapshots, 3).append(prefix).append(" packet: ").append(k).append(", count: ").append(this.format(v.getCount())).append(", payload sum: ").append(this.format(v.getCumulativePayloadSize())), (String)"append(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(v.getCumulativePayloadSize() == 1L ? " byte" : " bytes");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendDisconnectionReasons(StringBuilder $this$appendDisconnectionReasons, Map<?, Integer> map) {
        void $this$sortedByDescending$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Map<?, Integer> map2 = map;
        boolean $i$f$filterNot = false;
        void var6_6 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (((Number)it.getValue()).intValue() == 0) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filterNot$iv = destination$iv$iv.entrySet();
        boolean $i$f$sortedByDescending = false;
        List incoming2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
            }
        });
        for (Map.Entry entry : incoming2) {
            StringBuilder stringBuilder;
            Object k = entry.getKey();
            int v = ((Number)entry.getValue()).intValue();
            Intrinsics.checkNotNullExpressionValue((Object)this.indent($this$appendDisconnectionReasons, 3).append("Disconnection reason: ").append(k).append(", count: "), (String)"append(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(this.format(v));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        }
    }

    private final String format(int number) {
        String string = NumberFormat.getIntegerInstance().format((Object)number);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final String format(long number) {
        String string = NumberFormat.getIntegerInstance().format(number);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final StringBuilder indent(StringBuilder $this$indent, int count) {
        StringBuilder stringBuilder;
        StringBuilder $this$indent_u24lambda_u246 = stringBuilder = $this$indent;
        boolean bl = false;
        int n = 0;
        while (n < count) {
            int it = n++;
            boolean bl2 = false;
            $this$indent_u24lambda_u246.append(INDENT);
        }
        return stringBuilder;
    }

    static /* synthetic */ StringBuilder indent$default(ConcurrentNetworkTrafficWriter concurrentNetworkTrafficWriter, StringBuilder stringBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return concurrentNetworkTrafficWriter.indent(stringBuilder, n);
    }

    @NotNull
    public String toString() {
        return "ConcurrentNetworkTrafficWriter";
    }

    public int hashCode() {
        return -76251041;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConcurrentNetworkTrafficWriter)) {
            return false;
        }
        ConcurrentNetworkTrafficWriter cfr_ignored_0 = (ConcurrentNetworkTrafficWriter)other;
        return true;
    }
}

