/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.encoder;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.protocol.ServerProt;
import net.rsprot.protocol.api.handlers.OutgoingMessageSizeEstimator;
import net.rsprot.protocol.game.outgoing.misc.client.PacketGroupStart;
import net.rsprot.protocol.loginprot.outgoing.LoginResponse;
import net.rsprot.protocol.message.ByteBufHolderWrapperFooterMessage;
import net.rsprot.protocol.message.ByteBufHolderWrapperHeaderMessage;
import net.rsprot.protocol.message.OutgoingGameMessage;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.outgoing.MessageEncoderRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0014H\u0014J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J \u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0018H\u0002J \u0010#\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J3\u0010'\u001a\u00020\u001c\"\f\b\u0000\u0010(*\u00020\u001a*\u00020)2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u0002H(2\u0006\u0010%\u001a\u00020&H\u0002\u00a2\u0006\u0002\u0010*J+\u0010+\u001a\u00020\u001c\"\f\b\u0000\u0010(*\u00020)*\u00020\u001a2\u0006\u0010,\u001a\u0002H(2\u0006\u0010-\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010.J+\u0010/\u001a\u00020\u001c\"\f\b\u0000\u0010(*\u00020\u001a*\u00020)2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u0002H(H\u0002\u00a2\u0006\u0002\u00100J \u00101\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00063"}, d2={"Lnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder;", "Lio/netty/channel/ChannelOutboundHandlerAdapter;", "()V", "cipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "getCipher", "()Lnet/rsprot/crypto/cipher/StreamCipher;", "estimator", "Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;", "getEstimator", "()Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;", "repository", "Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "getRepository", "()Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "validate", "", "getValidate", "()Z", "allocateBuffer", "Lio/netty/buffer/ByteBuf;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "cap", "", "msg", "Lnet/rsprot/protocol/message/OutgoingMessage;", "encode", "", "out", "encodePayload", "onMessageWritten", "opcode", "payloadSize", "pSmart1Or2Enc", "write", "", "promise", "Lio/netty/channel/ChannelPromise;", "writeByteBufHolderMessage", "T", "Lio/netty/buffer/ByteBufHolder;", "(Lio/netty/channel/ChannelHandlerContext;Lnet/rsprot/protocol/message/OutgoingMessage;Lio/netty/channel/ChannelPromise;)V", "writeChildByteBufHolderMessage", "message", "buf", "(Lio/netty/buffer/ByteBufHolder;Lio/netty/buffer/ByteBuf;)V", "writePacketHeader", "(Lio/netty/channel/ChannelHandlerContext;Lnet/rsprot/protocol/message/OutgoingMessage;)V", "writeRegularMessage", "Companion", "osrs-227-api"})
@SourceDebugExtension(value={"SMAP\nOutgoingMessageEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutgoingMessageEncoder.kt\nnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,395:1\n104#2,4:396\n104#2,4:400\n104#2,4:404\n11#3,2:408\n*S KotlinDebug\n*F\n+ 1 OutgoingMessageEncoder.kt\nnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder\n*L\n242#1:396,4\n255#1:400,4\n270#1:404,4\n392#1:408,2\n*E\n"})
public abstract class OutgoingMessageEncoder
extends ChannelOutboundHandlerAdapter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final int MAX_OPCODE_VALUE_FOR_SINGLE_BYTE_OPCODE = 127;
    private static final int MAX_USHORT_PAYLOAD_SIZE = 40000;
    private static final int MAX_UBYTE_PAYLOAD_SIZE = 255;
    @NotNull
    private static final Logger logger;

    @NotNull
    protected abstract StreamCipher getCipher();

    @NotNull
    protected abstract MessageEncoderRepository<?> getRepository();

    protected abstract boolean getValidate();

    @NotNull
    protected abstract OutgoingMessageSizeEstimator getEstimator();

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        if (!(msg instanceof OutgoingMessage)) {
            ctx.write(msg, promise);
            return;
        }
        try {
            if (msg instanceof ByteBufHolder) {
                this.writeByteBufHolderMessage(ctx, (OutgoingMessage)msg, promise);
            } else {
                this.writeRegularMessage(ctx, (OutgoingMessage)msg, promise);
            }
        }
        catch (EncoderException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncoderException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeRegularMessage(ChannelHandlerContext ctx, OutgoingMessage msg, ChannelPromise promise) {
        ByteBuf buf = null;
        try {
            try {
                buf = this.allocateBuffer(ctx, msg);
                this.encode(ctx, msg, buf);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
            if (buf != null) {
                if (buf.isReadable()) {
                    ctx.write((Object)buf, promise);
                } else {
                    buf.release();
                    ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
                }
            }
            buf = null;
        }
        catch (Throwable throwable) {
            ByteBuf byteBuf = buf;
            if (byteBuf != null) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends OutgoingMessage & ByteBufHolder> void writeByteBufHolderMessage(ChannelHandlerContext ctx, T msg, ChannelPromise promise) {
        block10: {
            ByteBuf bufHolderContent;
            block9: {
                this.writePacketHeader(ctx, msg);
                bufHolderContent = ((ByteBufHolder)msg).content().slice();
                if (!(msg instanceof ByteBufHolderWrapperFooterMessage)) break block9;
                if (bufHolderContent.isReadable()) {
                    ctx.write((Object)bufHolderContent, ctx.voidPromise());
                } else {
                    bufHolderContent.release();
                    ctx.write((Object)Unpooled.EMPTY_BUFFER, ctx.voidPromise());
                }
                ByteBuf footer = null;
                try {
                    footer = this.allocateBuffer(ctx, ((ByteBufHolderWrapperFooterMessage)msg).nonByteBufHolderSize());
                    this.encodePayload(msg, footer);
                    if (footer.isReadable()) {
                        ctx.write((Object)footer, promise);
                    } else {
                        footer.release();
                        ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
                    }
                    footer = null;
                }
                catch (Throwable throwable) {
                    ByteBuf byteBuf = footer;
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                    throw throwable;
                }
                break block10;
            }
            if (bufHolderContent.isReadable()) {
                ctx.write((Object)bufHolderContent, promise);
            } else {
                bufHolderContent.release();
                ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends OutgoingMessage & ByteBufHolder> void writePacketHeader(ChannelHandlerContext ctx, T msg) {
        MessageEncoder encoder = this.getRepository().getEncoder(msg.getClass());
        ServerProt prot = encoder.getProt();
        int opcode = prot.getOpcode();
        int headerSize = opcode >= 128 ? 2 : 1;
        switch (prot.getSize()) {
            case -1: {
                ++headerSize;
                break;
            }
            case -2: {
                headerSize += 2;
            }
        }
        if (msg instanceof ByteBufHolderWrapperHeaderMessage) {
            headerSize += ((ByteBufHolderWrapperHeaderMessage)msg).nonByteBufHolderSize();
        }
        ByteBuf buf = null;
        try {
            buf = ctx.alloc().ioBuffer(headerSize);
            this.pSmart1Or2Enc(buf, opcode);
            int bytes = ((ByteBufHolder)msg).content().readableBytes();
            if (msg instanceof ByteBufHolderWrapperHeaderMessage) {
                bytes += ((ByteBufHolderWrapperHeaderMessage)msg).nonByteBufHolderSize();
            }
            if (msg instanceof ByteBufHolderWrapperFooterMessage) {
                bytes += ((ByteBufHolderWrapperFooterMessage)msg).nonByteBufHolderSize();
            }
            switch (prot.getSize()) {
                case -1: {
                    JagexByteBufExtensionsKt.p1((ByteBuf)buf, (int)bytes);
                    break;
                }
                case -2: {
                    JagexByteBufExtensionsKt.p2((ByteBuf)buf, (int)bytes);
                }
            }
            if (msg instanceof ByteBufHolderWrapperHeaderMessage) {
                this.encodePayload(msg, buf);
            }
            ctx.write((Object)buf, ctx.voidPromise());
            buf = null;
            this.onMessageWritten(ctx, opcode, bytes);
        }
        catch (Throwable throwable) {
            ByteBuf byteBuf = buf;
            if (byteBuf != null) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    private final void encodePayload(OutgoingMessage msg, ByteBuf out) {
        MessageEncoder encoder = this.getRepository().getEncoder(msg.getClass());
        encoder.encode-WFbGaZ8(this.getCipher(), JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)out), msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull OutgoingMessage msg, @NotNull ByteBuf out) {
        int length;
        int n;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int startMarker = out.writerIndex();
        MessageEncoder encoder = this.getRepository().getEncoder(msg.getClass());
        ServerProt prot = encoder.getProt();
        int opcode = prot.getOpcode();
        if (encoder.getEncryptedPayload()) {
            this.pSmart1Or2Enc(out, opcode);
        } else if (opcode < 128) {
            JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)0);
        } else {
            JagexByteBufExtensionsKt.p2((ByteBuf)out, (int)0);
        }
        switch (prot.getSize()) {
            case -1: {
                JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)0);
                n = out.writerIndex() - 1;
                break;
            }
            case -2: {
                JagexByteBufExtensionsKt.p2((ByteBuf)out, (int)0);
                n = out.writerIndex() - 2;
                break;
            }
            default: {
                n = -1;
            }
        }
        int sizeMarker = n;
        int payloadMarker = out.writerIndex();
        encoder.encode-WFbGaZ8(this.getCipher(), JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)out), msg);
        int endMarker = out.writerIndex();
        if (sizeMarker != -1) {
            length = 0;
            length = endMarker - payloadMarker;
            if (msg instanceof LoginResponse.Ok) {
                length += 3;
            }
            out.writerIndex(sizeMarker);
            switch (prot.getSize()) {
                case -1: {
                    if (this.getValidate()) {
                        if (!(0 <= length ? length < 256 : false)) {
                            out.writerIndex(startMarker);
                            Logger arg0$iv = logger;
                            boolean bl = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                Logger logger = arg0$iv;
                                boolean bl2 = false;
                                logger.warn(String.valueOf("Server prot " + prot + " length out of bounds; expected 0..255, received " + length + "; message: " + msg));
                            }
                            return;
                        }
                    }
                    JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)length);
                    break;
                }
                case -2: {
                    if (this.getValidate()) {
                        if (!(0 <= length ? length < 40001 : false)) {
                            out.writerIndex(startMarker);
                            Logger arg0$iv = logger;
                            boolean bl = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                Logger logger = arg0$iv;
                                boolean bl3 = false;
                                logger.warn(String.valueOf("Server prot " + prot + " length out of bounds; expected 0..40_000, received " + length + "; message: " + msg));
                            }
                            return;
                        }
                    }
                    JagexByteBufExtensionsKt.p2((ByteBuf)out, (int)length);
                }
            }
            out.writerIndex(endMarker);
        } else if (this.getValidate() && (length = endMarker - payloadMarker) != prot.getSize()) {
            out.writerIndex(startMarker);
            Logger arg0$iv = logger;
            boolean bl = false;
            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl4 = false;
                logger.warn(String.valueOf("Server prot " + prot + " length out of bounds; expected 0..40_000, received " + length + "; message: " + msg));
            }
            return;
        }
        this.onMessageWritten(ctx, opcode, endMarker - payloadMarker);
        if (!encoder.getEncryptedPayload()) {
            out.writerIndex(startMarker);
            this.pSmart1Or2Enc(out, opcode);
            out.writerIndex(endMarker);
        }
        if (msg instanceof PacketGroupStart) {
            for (OutgoingGameMessage sub : ((PacketGroupStart)msg).getMessages()) {
                try {
                    if (sub instanceof ByteBufHolder) {
                        this.writeChildByteBufHolderMessage((ByteBufHolder)sub, out);
                        continue;
                    }
                    this.encode(ctx, (OutgoingMessage)sub, out);
                }
                finally {
                    ReferenceCountUtil.release((Object)sub);
                }
            }
            int finalMarker = out.writerIndex();
            int written = finalMarker - payloadMarker;
            if (written > Short.MAX_VALUE) {
                throw new IllegalStateException("PacketGroupStart message too long: " + written + " bytes, " + ((PacketGroupStart)msg).getMessages().size() + " child messages.");
            }
            out.writerIndex(payloadMarker);
            JagexByteBufExtensionsKt.p2((ByteBuf)out, (int)written);
            out.writerIndex(finalMarker);
        }
    }

    private final <T extends ByteBufHolder & OutgoingMessage> void writeChildByteBufHolderMessage(T message, ByteBuf buf) {
        ByteBuf bufHolderContent;
        MessageEncoder encoder = this.getRepository().getEncoder(message.getClass());
        ServerProt prot = encoder.getProt();
        int opcode = prot.getOpcode();
        this.pSmart1Or2Enc(buf, opcode);
        int bytes = message.content().readableBytes();
        if (message instanceof ByteBufHolderWrapperHeaderMessage) {
            bytes += ((ByteBufHolderWrapperHeaderMessage)message).nonByteBufHolderSize();
        }
        if (message instanceof ByteBufHolderWrapperFooterMessage) {
            bytes += ((ByteBufHolderWrapperFooterMessage)message).nonByteBufHolderSize();
        }
        switch (prot.getSize()) {
            case -1: {
                JagexByteBufExtensionsKt.p1((ByteBuf)buf, (int)bytes);
                break;
            }
            case -2: {
                JagexByteBufExtensionsKt.p2((ByteBuf)buf, (int)bytes);
            }
        }
        if (message instanceof ByteBufHolderWrapperHeaderMessage) {
            this.encodePayload(message, buf);
        }
        if ((bufHolderContent = message.content().slice()).isReadable()) {
            buf.writeBytes(bufHolderContent);
        }
        if (message instanceof ByteBufHolderWrapperFooterMessage) {
            this.encodePayload(message, buf);
        }
    }

    public void onMessageWritten(@NotNull ChannelHandlerContext ctx, int opcode, int payloadSize) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    private final void pSmart1Or2Enc(ByteBuf out, int opcode) {
        if (opcode < 128) {
            JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)(opcode + this.getCipher().nextInt()));
        } else {
            JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)((opcode >>> 8 | 0x80) + this.getCipher().nextInt()));
            JagexByteBufExtensionsKt.p1((ByteBuf)out, (int)((opcode & 0xFF) + this.getCipher().nextInt()));
        }
    }

    @NotNull
    protected final ByteBuf allocateBuffer(@NotNull ChannelHandlerContext ctx, @NotNull OutgoingMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        int size = this.getEstimator().newHandle().size((Object)msg);
        ByteBuf byteBuf = ctx.alloc().ioBuffer(size);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"ioBuffer(...)");
        return byteBuf;
    }

    private final ByteBuf allocateBuffer(ChannelHandlerContext ctx, int cap) {
        ByteBuf byteBuf = ctx.alloc().ioBuffer(cap);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"ioBuffer(...)");
        return byteBuf;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\t\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\n"}, d2={"Lnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder$Companion;", "", "()V", "MAX_OPCODE_VALUE_FOR_SINGLE_BYTE_OPCODE", "", "MAX_UBYTE_PAYLOAD_SIZE", "MAX_USHORT_PAYLOAD_SIZE", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-227-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

