package net.rsprot.protocol.common.loginprot.outgoing.prot

import net.rsprot.protocol.Prot
import net.rsprot.protocol.ServerProt

public enum class LoginServerProt(
    override val opcode: Int,
    override val size: Int,
) : ServerProt {
    SUCCESSFUL(LoginServerProtId.SUCCESSFUL, 0),
    OK(LoginServerProtId.OK, Prot.VAR_BYTE),
    INVALID_USERNAME_OR_PASSWORD(LoginServerProtId.INVALID_USERNAME_OR_PASSWORD, 0),
    BANNED(LoginServerProtId.BANNED, 0),
    DUPLICATE(LoginServerProtId.DUPLICATE, 0),
    CLIENT_OUT_OF_DATE(LoginServerProtId.CLIENT_OUT_OF_DATE, 0),
    SERVER_FULL(LoginServerProtId.SERVER_FULL, 0),
    LOGINSERVER_OFFLINE(LoginServerProtId.LOGINSERVER_OFFLINE, 0),
    IP_LIMIT(LoginServerProtId.IP_LIMIT, 0),
    BAD_SESSION_ID(LoginServerProtId.BAD_SESSION_ID, 0),
    FORCE_PASSWORD_CHANGE(LoginServerProtId.FORCE_PASSWORD_CHANGE, 0),
    NEED_MEMBERS_ACCOUNT(LoginServerProtId.NEED_MEMBERS_ACCOUNT, 0),
    INVALID_SAVE(LoginServerProtId.INVALID_SAVE, 0),
    UPDATE_IN_PROGRESS(LoginServerProtId.UPDATE_IN_PROGRESS, 0),
    RECONNECT_OK(LoginServerProtId.RECONNECT_OK, Prot.VAR_SHORT),
    TOO_MANY_ATTEMPTS(LoginServerProtId.TOO_MANY_ATTEMPTS, 0),
    IN_MEMBERS_AREA(LoginServerProtId.IN_MEMBERS_AREA, 0),
    LOCKED(LoginServerProtId.LOCKED, 0),
    CLOSED_BETA_INVITED_ONLY(LoginServerProtId.CLOSED_BETA_INVITED_ONLY, 0),
    INVALID_LOGINSERVER(LoginServerProtId.INVALID_LOGINSERVER, 0),
    HOP_BLOCKED(LoginServerProtId.HOP_BLOCKED, 0),
    INVALID_LOGIN_PACKET(LoginServerProtId.INVALID_LOGIN_PACKET, 0),
    LOGINSERVER_NO_REPLY(LoginServerProtId.LOGINSERVER_NO_REPLY, 0),
    LOGINSERVER_LOAD_ERROR(LoginServerProtId.LOGINSERVER_LOAD_ERROR, 0),
    UNKNOWN_REPLY_FROM_LOGINSERVER(LoginServerProtId.UNKNOWN_REPLY_FROM_LOGINSERVER, 0),
    IP_BLOCKED(LoginServerProtId.IP_BLOCKED, 0),
    SERVICE_UNAVAILABLE(LoginServerProtId.SERVICE_UNAVAILABLE, 0),
    DISALLOWED_BY_SCRIPT(LoginServerProtId.DISALLOWED_BY_SCRIPT, Prot.VAR_SHORT),
    DISPLAYNAME_REQUIRED(LoginServerProtId.DISPLAYNAME_REQUIRED, 0),
    NEGATIVE_CREDIT(LoginServerProtId.NEGATIVE_CREDIT, 0),
    INVALID_SINGLE_SIGNON(LoginServerProtId.INVALID_SINGLE_SIGNON, 0),
    NO_REPLY_FROM_SINGLE_SIGNON(LoginServerProtId.NO_REPLY_FROM_SINGLE_SIGNON, 0),
    PROFILE_BEING_EDITED(LoginServerProtId.PROFILE_BEING_EDITED, 0),
    NO_BETA_ACCESS(LoginServerProtId.NO_BETA_ACCESS, 0),
    INSTANCE_INVALID(LoginServerProtId.INSTANCE_INVALID, 0),
    INSTANCE_NOT_SPECIFIED(LoginServerProtId.INSTANCE_NOT_SPECIFIED, 0),
    INSTANCE_FULL(LoginServerProtId.INSTANCE_FULL, 0),
    IN_QUEUE(LoginServerProtId.IN_QUEUE, 0),
    ALREADY_IN_QUEUE(LoginServerProtId.ALREADY_IN_QUEUE, 0),
    BILLING_TIMEOUT(LoginServerProtId.BILLING_TIMEOUT, 0),
    NOT_AGREED_TO_NDA(LoginServerProtId.NOT_AGREED_TO_NDA, 0),
    EMAIL_NOT_VALIDATED(LoginServerProtId.EMAIL_NOT_VALIDATED, 0),
    CONNECT_FAIL(LoginServerProtId.CONNECT_FAIL, 0),
    PRIVACY_POLICY(LoginServerProtId.PRIVACY_POLICY, 0),
    AUTHENTICATOR(LoginServerProtId.AUTHENTICATOR, 0),
    INVALID_AUTHENTICATOR_CODE(LoginServerProtId.INVALID_AUTHENTICATOR_CODE, 0),
    UPDATE_DOB(LoginServerProtId.UPDATE_DOB, 0),
    TIMEOUT(LoginServerProtId.TIMEOUT, 0),
    KICK(LoginServerProtId.KICK, 0),
    RETRY(LoginServerProtId.RETRY, 0),
    LOGIN_FAIL_1(LoginServerProtId.LOGIN_FAIL_1, 0),
    LOGIN_FAIL_2(LoginServerProtId.LOGIN_FAIL_2, 0),
    OUT_OF_DATE_RELOAD(LoginServerProtId.OUT_OF_DATE_RELOAD, 0),
    PROOF_OF_WORK(LoginServerProtId.PROOF_OF_WORK, Prot.VAR_SHORT),
    DOB_ERROR(LoginServerProtId.DOB_ERROR, 0),
    WEBSITE_DOB(LoginServerProtId.WEBSITE_DOB, 0),
    DOB_REVIEW(LoginServerProtId.DOB_REVIEW, 0),
    CLOSED_BETA(LoginServerProtId.CLOSED_BETA, 0),
}
