/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.worldentityinfo;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.protocol.common.RSProtThreadSafetyKt;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.common.game.outgoing.info.CoordFine;
import net.rsprot.protocol.common.game.outgoing.info.CoordGrid;
import net.rsprot.protocol.common.game.outgoing.info.util.ZoneIndexStorage;
import net.rsprot.protocol.game.outgoing.info.ByteBufRecycler;
import net.rsprot.protocol.game.outgoing.info.exceptions.InfoProcessException;
import net.rsprot.protocol.game.outgoing.info.util.BuildArea;
import net.rsprot.protocol.game.outgoing.info.util.ReferencePooledObject;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatar;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityAvatarRepository;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityInfoExtensionsKt;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityInfoV3Packet;
import net.rsprot.protocol.game.outgoing.info.worldentityinfo.WorldEntityProtocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0017\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 g2\u00020\u0001:\u0001gB9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00106\u001a\u00020\u0016H\u0002J\u0006\u00107\u001a\u00020\u0016J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0003J\b\u0010;\u001a\u000209H\u0002J\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030=J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030=J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00030=J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\b\u0010D\u001a\u00020AH\u0016J\u0010\u0010E\u001a\u00020A2\u0006\u0010F\u001a\u00020\u0003H\u0002J\u0010\u0010G\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J \u0010H\u001a\u0002092\u0006\u0010F\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010I\u001a\u00020AH\u0016J\b\u0010J\u001a\u000209H\u0016J\u0006\u0010K\u001a\u000209J\r\u0010L\u001a\u000209H\u0000\u00a2\u0006\u0002\bMJ\u001a\u0010N\u001a\u00020A2\u0006\u0010\u0015\u001a\u00020OH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bP\u0010QJ\u001a\u0010R\u001a\u0002092\u0006\u0010\u0015\u001a\u00020OH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bS\u0010TJ\u0006\u0010U\u001a\u000209J\u001e\u0010V\u001a\u0002092\u0006\u0010W\u001a\u00020\u00032\u0006\u0010X\u001a\u00020\u00032\u0006\u0010Y\u001a\u00020\u0003J\u0006\u0010Z\u001a\u00020-J,\u0010[\u001a\u0002092\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020\u00032\b\b\u0002\u0010^\u001a\u00020\u00032\b\b\u0002\u0010_\u001a\u00020\u0003H\u0007J\u0018\u0010[\u001a\u0002092\u0006\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00a2\u0006\u0004\b`\u0010aJ&\u0010b\u001a\u0002092\u0006\u0010:\u001a\u00020\u00032\u0006\u0010W\u001a\u00020\u00032\u0006\u0010X\u001a\u00020\u00032\u0006\u0010Y\u001a\u00020\u0003J\u000e\u0010c\u001a\u0002092\u0006\u0010d\u001a\u00020\u0003J\r\u0010e\u001a\u000209H\u0000\u00a2\u0006\u0002\bfR\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0010j\b\u0012\u0004\u0012\u00020\u0003`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0010j\b\u0012\u0004\u0012\u00020\u0003`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0010j\b\u0012\u0004\u0012\u00020\u0003`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\u00020\u001bX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u00104\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006h"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo;", "Lnet/rsprot/protocol/game/outgoing/info/util/ReferencePooledObject;", "localIndex", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "avatarRepository", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository;", "zoneIndexStorage", "Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;", "recycler", "Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;", "(ILio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/common/client/OldSchoolClientType;Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatarRepository;Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;)V", "addedWorldEntities", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "allWorldEntities", "getAllocator$osrs_226_model", "()Lio/netty/buffer/ByteBufAllocator;", "buffer", "Lio/netty/buffer/ByteBuf;", "buildArea", "Lnet/rsprot/protocol/game/outgoing/info/util/BuildArea;", "J", "currentCoord", "Lnet/rsprot/protocol/common/game/outgoing/info/CoordGrid;", "I", "currentWorldEntityId", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getException$osrs_226_model", "()Ljava/lang/Exception;", "setException$osrs_226_model", "(Ljava/lang/Exception;)V", "highResolutionIndices", "", "highResolutionIndicesCount", "getLocalIndex$osrs_226_model", "()I", "setLocalIndex$osrs_226_model", "(I)V", "previousPacket", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfoV3Packet;", "getPreviousPacket$osrs_226_model", "()Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfoV3Packet;", "setPreviousPacket$osrs_226_model", "(Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfoV3Packet;)V", "removedWorldEntities", "renderCoord", "renderDistance", "temporaryHighResolutionIndices", "allocBuffer", "backingBuffer", "clearEntities", "", "worldId", "defragmentIndices", "getAddedWorldEntityIndices", "", "getAllWorldEntityIndices", "getRemovedWorldEntityIndices", "inRange", "", "avatar", "Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityAvatar;", "isDestroyed", "isHighResolution", "index", "isReallocated", "onAlloc", "newInstance", "onDealloc", "onReconnect", "postUpdate", "postUpdate$osrs_226_model", "processHighResolution", "Lnet/rsprot/buffer/JagByteBuf;", "processHighResolution-lwEbYT4", "(Lio/netty/buffer/ByteBuf;)Z", "processLowResolution", "processLowResolution-lwEbYT4", "(Lio/netty/buffer/ByteBuf;)V", "resetRenderCoord", "setRenderCoord", "level", "x", "z", "toPacket", "updateBuildArea", "zoneX", "zoneZ", "widthInZones", "heightInZones", "updateBuildArea-4IFMqhs", "(J)V", "updateCoord", "updateRenderDistance", "distance", "updateWorldEntities", "updateWorldEntities$osrs_226_model", "Companion", "osrs-226-model"})
@SourceDebugExtension(value={"SMAP\nWorldEntityInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldEntityInfo.kt\nnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 JagByteBuf.kt\nnet/rsprot/buffer/JagByteBuf\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,557:1\n104#2,4:558\n158#3,2:562\n158#3,2:564\n210#3,2:566\n158#3,2:568\n158#3,2:570\n158#3,2:572\n11#4,2:574\n*S KotlinDebug\n*F\n+ 1 WorldEntityInfo.kt\nnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo\n*L\n298#1:558,4\n315#1:562,2\n324#1:564,2\n383#1:566,2\n384#1:568,2\n385#1:570,2\n386#1:572,2\n554#1:574,2\n*E\n"})
public final class WorldEntityInfo
implements ReferencePooledObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int localIndex;
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private OldSchoolClientType oldSchoolClientType;
    @NotNull
    private final WorldEntityAvatarRepository avatarRepository;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final ByteBufRecycler recycler;
    private int renderDistance;
    private int currentWorldEntityId;
    private int currentCoord;
    private long buildArea;
    private int highResolutionIndicesCount;
    @NotNull
    private short[] highResolutionIndices;
    @NotNull
    private short[] temporaryHighResolutionIndices;
    @NotNull
    private final ArrayList<Integer> allWorldEntities;
    @NotNull
    private final ArrayList<Integer> addedWorldEntities;
    @NotNull
    private final ArrayList<Integer> removedWorldEntities;
    @Nullable
    private ByteBuf buffer;
    @Nullable
    private WorldEntityInfoV3Packet previousPacket;
    @Nullable
    private volatile Exception exception;
    private int renderCoord;
    private static final short INDEX_TERMINATOR = -1;
    private static final int WORLDENTITY_LOOKUP_TERMINATOR = 65535;
    private static final int MAX_HIGH_RES_COUNT = 255;
    public static final int ROOT_WORLD = -1;
    private static final int DEFAULT_RENDER_DISTANCE = 15;
    private static final int BUF_CAPACITY = 2806;
    @NotNull
    private static final Logger logger;

    public WorldEntityInfo(int localIndex, @NotNull ByteBufAllocator allocator, @NotNull OldSchoolClientType oldSchoolClientType, @NotNull WorldEntityAvatarRepository avatarRepository, @NotNull ZoneIndexStorage zoneIndexStorage, @NotNull ByteBufRecycler recycler) {
        int n;
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        Intrinsics.checkNotNullParameter((Object)avatarRepository, (String)"avatarRepository");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        this.localIndex = localIndex;
        this.allocator = allocator;
        this.oldSchoolClientType = oldSchoolClientType;
        this.avatarRepository = avatarRepository;
        this.zoneIndexStorage = zoneIndexStorage;
        this.recycler = recycler;
        this.renderDistance = 15;
        this.currentWorldEntityId = -1;
        this.currentCoord = CoordGrid.Companion.getINVALID-9LJGAnM();
        this.buildArea = BuildArea.Companion.getINVALID-RDuwMps();
        int n2 = 0;
        short[] sArray = new short[2048];
        WorldEntityInfo worldEntityInfo = this;
        while (n2 < 2048) {
            n = n2++;
            sArray[n] = -1;
        }
        worldEntityInfo.highResolutionIndices = sArray;
        n2 = 0;
        sArray = new short[2048];
        worldEntityInfo = this;
        while (n2 < 2048) {
            n = n2++;
            sArray[n] = -1;
        }
        worldEntityInfo.temporaryHighResolutionIndices = sArray;
        this.allWorldEntities = new ArrayList();
        this.addedWorldEntities = new ArrayList();
        this.removedWorldEntities = new ArrayList();
        this.renderCoord = CoordGrid.Companion.getINVALID-9LJGAnM();
    }

    public /* synthetic */ WorldEntityInfo(int n, ByteBufAllocator byteBufAllocator, OldSchoolClientType oldSchoolClientType, WorldEntityAvatarRepository worldEntityAvatarRepository, ZoneIndexStorage zoneIndexStorage, ByteBufRecycler byteBufRecycler, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            byteBufRecycler = new ByteBufRecycler(0, 1, null);
        }
        this(n, byteBufAllocator, oldSchoolClientType, worldEntityAvatarRepository, zoneIndexStorage, byteBufRecycler);
    }

    public final int getLocalIndex$osrs_226_model() {
        return this.localIndex;
    }

    public final void setLocalIndex$osrs_226_model(int n) {
        this.localIndex = n;
    }

    @NotNull
    public final ByteBufAllocator getAllocator$osrs_226_model() {
        return this.allocator;
    }

    @Nullable
    public final WorldEntityInfoV3Packet getPreviousPacket$osrs_226_model() {
        return this.previousPacket;
    }

    public final void setPreviousPacket$osrs_226_model(@Nullable WorldEntityInfoV3Packet worldEntityInfoV3Packet) {
        this.previousPacket = worldEntityInfoV3Packet;
    }

    @Nullable
    public final Exception getException$osrs_226_model() {
        return this.exception;
    }

    public final void setException$osrs_226_model(@Nullable Exception exception) {
        this.exception = exception;
    }

    @Override
    public boolean isDestroyed() {
        return this.exception != null;
    }

    public final void updateRenderDistance(int distance) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.renderDistance = distance;
    }

    public final void updateBuildArea-4IFMqhs(long buildArea) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.buildArea = buildArea;
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ, int widthInZones, int heightInZones) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.buildArea = BuildArea.constructor-impl(zoneX, zoneZ, widthInZones, heightInZones);
    }

    public static /* synthetic */ void updateBuildArea$default(WorldEntityInfo worldEntityInfo, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n3 = 13;
        }
        if ((n5 & 8) != 0) {
            n4 = 13;
        }
        worldEntityInfo.updateBuildArea(n, n2, n3, n4);
    }

    @NotNull
    public final List<Integer> getAllWorldEntityIndices() {
        return this.allWorldEntities;
    }

    @NotNull
    public final List<Integer> getAddedWorldEntityIndices() {
        return this.addedWorldEntities;
    }

    @NotNull
    public final List<Integer> getRemovedWorldEntityIndices() {
        return this.removedWorldEntities;
    }

    public final void updateCoord(int worldId, int level, int x, int z) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.currentWorldEntityId = worldId;
        this.currentCoord = CoordGrid.constructor-impl((int)level, (int)x, (int)z);
    }

    public final void setRenderCoord(int level, int x, int z) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.renderCoord = CoordGrid.constructor-impl((int)level, (int)x, (int)z);
    }

    public final void resetRenderCoord() {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.renderCoord = CoordGrid.Companion.getINVALID-9LJGAnM();
    }

    @NotNull
    public final ByteBuf backingBuffer() throws IllegalStateException {
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return byteBuf;
    }

    @NotNull
    public final WorldEntityInfoV3Packet toPacket() {
        Exception exception = this.exception;
        if (exception != null) {
            throw new InfoProcessException("Exception occurred during player info processing for index " + this.localIndex, exception);
        }
        WorldEntityInfoV3Packet worldEntityInfoV3Packet = this.previousPacket;
        if (worldEntityInfoV3Packet == null) {
            boolean bl = false;
            String string = "Previous world entity info packet not calculated.";
            throw new IllegalStateException(string.toString());
        }
        return worldEntityInfoV3Packet;
    }

    private final ByteBuf allocBuffer() {
        ByteBuf buffer;
        this.buffer = buffer = this.allocator.buffer(2806, 2806);
        Intrinsics.checkNotNull((Object)buffer);
        this.recycler.plusAssign(buffer);
        this.addedWorldEntities.clear();
        this.removedWorldEntities.clear();
        return buffer;
    }

    private final void defragmentIndices() {
        int count = 0;
        int n = this.highResolutionIndices.length;
        for (int i = 0; i < n && count < this.highResolutionIndicesCount; ++i) {
            short index = this.highResolutionIndices[i];
            if (index == -1) continue;
            this.temporaryHighResolutionIndices[count++] = index;
        }
        short[] uncompressed = this.highResolutionIndices;
        this.highResolutionIndices = this.temporaryHighResolutionIndices;
        this.temporaryHighResolutionIndices = uncompressed;
    }

    public final void updateWorldEntities$osrs_226_model() {
        ByteBuf buffer = JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)this.allocBuffer());
        boolean fragmented = this.processHighResolution-lwEbYT4(buffer);
        if (fragmented) {
            this.defragmentIndices();
        }
        this.processLowResolution-lwEbYT4(buffer);
    }

    public final void postUpdate$osrs_226_model() {
        WorldEntityInfoV3Packet packet;
        WorldEntityInfoV3Packet worldEntityInfoV3Packet = this.previousPacket;
        boolean bl = worldEntityInfoV3Packet != null ? !worldEntityInfoV3Packet.isConsumed() : false;
        if (bl) {
            Logger arg0$iv = logger;
            boolean bl2 = false;
            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl3 = false;
                logger.warn(String.valueOf("Previous world entity info packet was calculated but not sent out to the client for player index " + this.localIndex + "!"));
            }
        }
        this.previousPacket = packet = new WorldEntityInfoV3Packet(this.backingBuffer());
    }

    private final boolean processHighResolution-lwEbYT4(ByteBuf buffer) {
        int count = this.highResolutionIndicesCount;
        boolean bl = false;
        JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)count);
        for (int i = 0; i < count; ++i) {
            ByteBuf precomputedBuffer;
            short index = this.highResolutionIndices[i];
            WorldEntityAvatar avatar = this.avatarRepository.getOrNull(index);
            if (avatar == null || !this.inRange(avatar) || this.isReallocated(avatar)) {
                this.highResolutionIndices[i] = -1;
                int n = this.highResolutionIndicesCount;
                this.highResolutionIndicesCount = n + -1;
                Integer n2 = index;
                ((Collection)this.removedWorldEntities).add(n2);
                n2 = index;
                ((Collection)this.allWorldEntities).remove(n2);
                int value$iv = 0;
                $i$f$p1-JhZ6y6I = false;
                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
                continue;
            }
            if (avatar.getHighResolutionBuffer$osrs_226_model() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            buffer.writeBytes(precomputedBuffer, precomputedBuffer.readerIndex(), precomputedBuffer.readableBytes());
        }
        return count != this.highResolutionIndicesCount;
    }

    private final void processLowResolution-lwEbYT4(ByteBuf buffer) {
        int n;
        if (this.highResolutionIndicesCount >= 255) {
            return;
        }
        int currentWorld = this.currentWorldEntityId;
        if (currentWorld == -1) {
            n = this.currentCoord;
        } else {
            WorldEntityAvatar worldEntityAvatar = this.avatarRepository.getOrNull(currentWorld);
            if (worldEntityAvatar == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            WorldEntityAvatar worldEntity = worldEntityAvatar;
            n = worldEntity.getCurrentCoordGrid-9LJGAnM$osrs_226_model();
        }
        int n2 = n;
        int level = CoordGrid.component1-impl((int)n2);
        int centerX = CoordGrid.component2-impl((int)n2);
        int centerZ = CoordGrid.component3-impl((int)n2);
        int startX = RangesKt.coerceAtLeast((int)(centerX - this.renderDistance >> 3), (int)0);
        int startZ = RangesKt.coerceAtLeast((int)(centerZ - this.renderDistance >> 3), (int)0);
        int endX = RangesKt.coerceAtMost((int)(centerX + this.renderDistance >> 3), (int)2047);
        int endZ = RangesKt.coerceAtMost((int)(centerZ + this.renderDistance >> 3), (int)2047);
        int x = startX;
        if (x <= endX) {
            while (true) {
                int z;
                if ((z = startZ) <= endZ) {
                    while (true) {
                        if (this.zoneIndexStorage.get(level, x, z) != null) {
                            int index;
                            short[] npcs;
                            int n3 = npcs.length;
                            for (int k = 0; k < n3 && (index = npcs[k] & 0xFFFF) != 65535; ++k) {
                                WorldEntityAvatar avatar;
                                if (this.isHighResolution(index)) continue;
                                if (this.highResolutionIndicesCount >= 255) break;
                                if (this.avatarRepository.getOrNull(index) == null || !this.inRange(avatar)) continue;
                                Integer n4 = index;
                                ((Collection)this.addedWorldEntities).add(n4);
                                n4 = index;
                                ((Collection)this.allWorldEntities).add(n4);
                                int n5 = this.highResolutionIndicesCount;
                                this.highResolutionIndicesCount = n5 + 1;
                                int i = n5;
                                this.highResolutionIndices[i] = (short)index;
                                int value$iv = avatar.getIndex$osrs_226_model();
                                boolean bl = false;
                                JagexByteBufExtensionsKt.p2((ByteBuf)buffer, (int)value$iv);
                                value$iv = avatar.getSizeX$osrs_226_model();
                                boolean bl2 = false;
                                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
                                value$iv = avatar.getSizeZ$osrs_226_model();
                                bl2 = false;
                                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
                                value$iv = avatar.getLevel$osrs_226_model();
                                bl2 = false;
                                JagexByteBufExtensionsKt.p1((ByteBuf)buffer, (int)value$iv);
                                int fineXOffset = BuildArea.getZoneX-impl(this.buildArea) << 10;
                                int fineZOffset = BuildArea.getZoneZ-impl(this.buildArea) << 10;
                                WorldEntityInfoExtensionsKt.encodeAngledCoordFine-Q2VTvpc(buffer, CoordFine.getX-impl((long)avatar.getCurrentCoordFine-v6-VNSI$osrs_226_model()) - fineXOffset, CoordFine.getY-impl((long)avatar.getCurrentCoordFine-v6-VNSI$osrs_226_model()), CoordFine.getZ-impl((long)avatar.getCurrentCoordFine-v6-VNSI$osrs_226_model()) - fineZOffset, avatar.getAngle$osrs_226_model());
                            }
                        }
                        if (z == endZ) break;
                        ++z;
                    }
                }
                if (x == endX) break;
                ++x;
            }
        }
    }

    private final boolean isHighResolution(int index) {
        int n = this.highResolutionIndicesCount;
        for (int i = 0; i < n; ++i) {
            if (this.highResolutionIndices[i] != index) continue;
            return true;
        }
        return false;
    }

    private final boolean inRange(WorldEntityAvatar avatar) {
        if (avatar.getIndex$osrs_226_model() == this.currentWorldEntityId) {
            return true;
        }
        if (!WorldEntityInfoExtensionsKt.contains-eQawg54(this.buildArea, avatar)) {
            return false;
        }
        int avatarCoordGrid = avatar.getCurrentCoordGrid-9LJGAnM$osrs_226_model();
        return CoordGrid.inDistance-YdbEnh8((int)avatarCoordGrid, (int)this.currentCoord, (int)this.renderDistance) || !CoordGrid.equals-impl0((int)this.renderCoord, (int)CoordGrid.Companion.getINVALID-9LJGAnM()) && CoordGrid.inDistance-YdbEnh8((int)avatarCoordGrid, (int)this.renderCoord, (int)this.renderDistance);
    }

    private final boolean isReallocated(WorldEntityAvatar avatar) {
        return avatar.getAllocateCycle$osrs_226_model() == WorldEntityProtocol.Companion.getCycleCount$osrs_226_model();
    }

    @Override
    public void onAlloc(int index, @NotNull OldSchoolClientType oldSchoolClientType, boolean newInstance) {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.localIndex = index;
        this.oldSchoolClientType = oldSchoolClientType;
        this.renderDistance = 15;
        this.currentWorldEntityId = -1;
        this.currentCoord = CoordGrid.Companion.getINVALID-9LJGAnM();
        this.buildArea = BuildArea.Companion.getINVALID-RDuwMps();
        this.renderCoord = CoordGrid.Companion.getINVALID-9LJGAnM();
        this.highResolutionIndicesCount = 0;
        ArraysKt.fill$default((short[])this.highResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((short[])this.temporaryHighResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        this.allWorldEntities.clear();
        this.addedWorldEntities.clear();
        this.removedWorldEntities.clear();
        this.buffer = null;
        this.exception = null;
        this.previousPacket = null;
    }

    public final void onReconnect() {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.buffer = null;
        this.exception = null;
        this.previousPacket = null;
        this.highResolutionIndicesCount = 0;
        ArraysKt.fill$default((short[])this.highResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((short[])this.temporaryHighResolutionIndices, (short)0, (int)0, (int)0, (int)6, null);
        this.allWorldEntities.clear();
        this.addedWorldEntities.clear();
        this.removedWorldEntities.clear();
    }

    @Override
    public void onDealloc() {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.buffer = null;
        this.previousPacket = null;
    }

    /*
     * Unable to fully structure code
     */
    public final void clearEntities(int worldId) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (worldId == -1) ** GOTO lbl-1000
        v0 = 0 <= worldId ? worldId < 2048 : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-WorldEntityInfo$clearEntities$1 = false;
            var2_3 = "World id must be -1 or in range of 0..<2048";
            throw new IllegalArgumentException(var2_3.toString());
        }
        if (worldId == -1) {
            this.onReconnect();
        }
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ, int widthInZones) {
        WorldEntityInfo.updateBuildArea$default(this, zoneX, zoneZ, widthInZones, 0, 8, null);
    }

    @JvmOverloads
    public final void updateBuildArea(int zoneX, int zoneZ) {
        WorldEntityInfo.updateBuildArea$default(this, zoneX, zoneZ, 0, 0, 12, null);
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\r\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000e"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/worldentityinfo/WorldEntityInfo$Companion;", "", "()V", "BUF_CAPACITY", "", "DEFAULT_RENDER_DISTANCE", "INDEX_TERMINATOR", "", "MAX_HIGH_RES_COUNT", "ROOT_WORLD", "WORLDENTITY_LOOKUP_TERMINATOR", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-226-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

