/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.playerinfo;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.common.RSProtThreadSafetyKt;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.game.outgoing.info.ByteBufRecycler;
import net.rsprot.protocol.game.outgoing.info.playerinfo.GlobalLowResolutionPositionRepository;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerAvatarFactory;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerInfo;
import net.rsprot.protocol.game.outgoing.info.playerinfo.PlayerInfoRepository;
import net.rsprot.protocol.game.outgoing.info.worker.DefaultProtocolWorker;
import net.rsprot.protocol.game.outgoing.info.worker.ProtocolWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 02\u00020\u0001:\u00010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00162\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0014J$\u0010 \u001a\u00020\f2\u0019\b\u0004\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\"\u00a2\u0006\u0002\b#H\u0082\bJ\u001d\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020\fH\u0002J\b\u0010+\u001a\u00020\fH\u0002J\b\u0010,\u001a\u00020\fH\u0002J\b\u0010-\u001a\u00020\fH\u0002J\b\u0010.\u001a\u00020\fH\u0002J\u0006\u0010/\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00061"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol;", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "worker", "Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;", "avatarFactory", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerAvatarFactory;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerAvatarFactory;)V", "callables", "", "Ljava/util/concurrent/Callable;", "", "lowResolutionPositionRepository", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/GlobalLowResolutionPositionRepository;", "playerInfoRepository", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoRepository;", "recycler", "Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;", "alloc", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfo;", "idx", "", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "catchException", "index", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "dealloc", "info", "execute", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getLowResolutionPosition", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/util/LowResolutionPosition;", "getLowResolutionPosition-EmiGOc0$osrs_226_model", "(I)I", "getPlayerInfo", "getPlayerInfo$osrs_226_model", "postUpdate", "prepare", "prepareExtendedInfo", "putBitcodes", "putExtendedInfo", "update", "Companion", "osrs-226-model"})
@SourceDebugExtension(value={"SMAP\nPlayerInfoProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerInfoProtocol.kt\nnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,299:1\n239#1,3:304\n255#1,3:307\n239#1,3:310\n255#1,3:313\n239#1,3:316\n255#1,3:319\n239#1,3:322\n255#1,3:325\n134#2,4:300\n11#3,2:328\n*S KotlinDebug\n*F\n+ 1 PlayerInfoProtocol.kt\nnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol\n*L\n186#1:304,3\n186#1:307,3\n201#1:310,3\n201#1:313,3\n214#1:316,3\n214#1:319,3\n224#1:322,3\n224#1:325,3\n173#1:300,4\n283#1:328,2\n*E\n"})
public final class PlayerInfoProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final ProtocolWorker worker;
    @NotNull
    private final PlayerAvatarFactory avatarFactory;
    @NotNull
    private final ByteBufRecycler recycler;
    @NotNull
    private final GlobalLowResolutionPositionRepository lowResolutionPositionRepository;
    @NotNull
    private final PlayerInfoRepository playerInfoRepository;
    @NotNull
    private final List<Callable<Unit>> callables;
    public static final int PROTOCOL_CAPACITY = 2048;
    @NotNull
    private static final Logger logger;
    private static int cycleCount;

    public PlayerInfoProtocol(@NotNull ByteBufAllocator allocator, @NotNull ProtocolWorker worker, @NotNull PlayerAvatarFactory avatarFactory) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        Intrinsics.checkNotNullParameter((Object)avatarFactory, (String)"avatarFactory");
        this.allocator = allocator;
        this.worker = worker;
        this.avatarFactory = avatarFactory;
        this.recycler = new ByteBufRecycler(0, 1, null);
        this.lowResolutionPositionRepository = new GlobalLowResolutionPositionRepository();
        this.playerInfoRepository = new PlayerInfoRepository((Function2<? super Integer, ? super OldSchoolClientType, PlayerInfo>)((Function2)new Function2<Integer, OldSchoolClientType, PlayerInfo>(this){
            final /* synthetic */ PlayerInfoProtocol this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final PlayerInfo invoke(int localIndex, @NotNull OldSchoolClientType clientType) {
                Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
                return new PlayerInfo(this.this$0, localIndex, PlayerInfoProtocol.access$getAllocator$p(this.this$0), clientType, PlayerInfoProtocol.access$getAvatarFactory$p(this.this$0).alloc$osrs_226_model(localIndex), PlayerInfoProtocol.access$getRecycler$p(this.this$0), PlayerInfoProtocol.access$getLowResolutionPositionRepository$p(this.this$0));
            }
        }));
        this.callables = new ArrayList(2048);
    }

    public /* synthetic */ PlayerInfoProtocol(ByteBufAllocator byteBufAllocator, ProtocolWorker protocolWorker, PlayerAvatarFactory playerAvatarFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            protocolWorker = new DefaultProtocolWorker();
        }
        this(byteBufAllocator, protocolWorker, playerAvatarFactory);
    }

    @Nullable
    public final PlayerInfo getPlayerInfo$osrs_226_model(int idx) throws ArrayIndexOutOfBoundsException {
        return (PlayerInfo)this.playerInfoRepository.getOrNull(idx);
    }

    @NotNull
    public final PlayerInfo alloc(int idx, @NotNull OldSchoolClientType oldSchoolClientType) throws ArrayIndexOutOfBoundsException, IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (idx == 0) {
            throw new ArrayIndexOutOfBoundsException("Index 0 is not valid for player info protocol.");
        }
        return (PlayerInfo)this.playerInfoRepository.alloc(idx, oldSchoolClientType);
    }

    public final void dealloc(@NotNull PlayerInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (info.isDestroyed()) {
            return;
        }
        int index = info.getLocalIndex$osrs_226_model();
        for (int i = 0; i < 2048; ++i) {
            PlayerInfo otherInfo;
            if ((PlayerInfo)this.playerInfoRepository.getOrNull(i) == null) continue;
            otherInfo.unsetHighPriority$osrs_226_model(index);
        }
        this.playerInfoRepository.dealloc(index);
    }

    public final int getLowResolutionPosition-EmiGOc0$osrs_226_model(int idx) {
        return this.lowResolutionPositionRepository.getCurrentLowResolutionPosition-EmiGOc0$osrs_226_model(idx);
    }

    public final void update() {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.prepare();
        this.putBitcodes();
        this.prepareExtendedInfo();
        this.putExtendedInfo();
        this.postUpdate();
        this.recycler.cycle();
        int n = cycleCount;
        cycleCount = n + 1;
    }

    private final void prepare() {
        int i;
        for (i = 1; i < 2048; ++i) {
            PlayerInfo info = (PlayerInfo)this.playerInfoRepository.getOrNull(i);
            if (info == null) {
                this.lowResolutionPositionRepository.markUnused$osrs_226_model(i);
            } else {
                this.lowResolutionPositionRepository.update-dp9Y9C8$osrs_226_model(i, info.getAvatar().getCurrentCoord-9LJGAnM());
            }
            this.lowResolutionPositionRepository.prepareLowResBuffer$osrs_226_model(i);
        }
        for (i = 1; i < 2048; ++i) {
            try {
                PlayerInfo playerInfo = (PlayerInfo)this.playerInfoRepository.getOrNull(i);
                if (playerInfo == null) continue;
                playerInfo.prepareBitcodes$osrs_226_model();
                continue;
            }
            catch (Exception e) {
                this.catchException(i, e);
                continue;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Error during player updating preparation"), t);
                }
                throw t;
            }
        }
    }

    private final void putBitcodes() {
        PlayerInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            PlayerInfo info$iv;
            if ((PlayerInfo)this_$iv.playerInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ PlayerInfo $info;
                final /* synthetic */ PlayerInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        PlayerInfo $this$putBitcodes_u24lambda_u241 = this.$info;
                        boolean bl = false;
                        $this$putBitcodes_u24lambda_u241.pBitcodes$osrs_226_model();
                    }
                    catch (Exception e) {
                        PlayerInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = PlayerInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during player updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void prepareExtendedInfo() {
        PlayerInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            PlayerInfo info$iv;
            if ((PlayerInfo)this_$iv.playerInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ PlayerInfo $info;
                final /* synthetic */ PlayerInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        PlayerInfo $this$prepareExtendedInfo_u24lambda_u242 = this.$info;
                        boolean bl = false;
                        $this$prepareExtendedInfo_u24lambda_u242.precomputeExtendedInfo$osrs_226_model();
                    }
                    catch (Exception e) {
                        PlayerInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = PlayerInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during player updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void putExtendedInfo() {
        PlayerInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            PlayerInfo info$iv;
            if ((PlayerInfo)this_$iv.playerInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ PlayerInfo $info;
                final /* synthetic */ PlayerInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        PlayerInfo $this$putExtendedInfo_u24lambda_u243 = this.$info;
                        boolean bl = false;
                        $this$putExtendedInfo_u24lambda_u243.putExtendedInfo$osrs_226_model();
                    }
                    catch (Exception e) {
                        PlayerInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = PlayerInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during player updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void postUpdate() {
        PlayerInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            PlayerInfo info$iv;
            if ((PlayerInfo)this_$iv.playerInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ PlayerInfo $info;
                final /* synthetic */ PlayerInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        PlayerInfo $this$postUpdate_u24lambda_u244 = this.$info;
                        boolean bl = false;
                        $this$postUpdate_u24lambda_u244.postUpdate$osrs_226_model();
                    }
                    catch (Exception e) {
                        PlayerInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = PlayerInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during player updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
        this.lowResolutionPositionRepository.postUpdate$osrs_226_model();
    }

    private final void execute(Function1<? super PlayerInfo, Unit> block) {
        boolean $i$f$execute = false;
        for (int i = 1; i < 2048; ++i) {
            PlayerInfo info;
            if ((PlayerInfo)this.playerInfoRepository.getOrNull(i) == null) continue;
            ((Collection)this.callables).add(new Callable(block, info, this, i){
                final /* synthetic */ Function1<PlayerInfo, Unit> $block;
                final /* synthetic */ PlayerInfo $info;
                final /* synthetic */ PlayerInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$block = $block;
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        this.$block.invoke((Object)this.$info);
                    }
                    catch (Exception e) {
                        PlayerInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = PlayerInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during player updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this.worker.execute(this.callables);
        this.callables.clear();
    }

    private final void catchException(int index, Exception exception) {
        PlayerInfo playerInfo = (PlayerInfo)this.playerInfoRepository.getOrNull(index);
        if (playerInfo == null) {
            return;
        }
        PlayerInfo info = playerInfo;
        this.playerInfoRepository.destroy(index);
        info.setException$osrs_226_model(exception);
    }

    public static final /* synthetic */ void access$catchException(PlayerInfoProtocol $this, int index, Exception exception) {
        $this.catchException(index, exception);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ByteBufAllocator access$getAllocator$p(PlayerInfoProtocol $this) {
        return $this.allocator;
    }

    public static final /* synthetic */ PlayerAvatarFactory access$getAvatarFactory$p(PlayerInfoProtocol $this) {
        return $this.avatarFactory;
    }

    public static final /* synthetic */ ByteBufRecycler access$getRecycler$p(PlayerInfoProtocol $this) {
        return $this.recycler;
    }

    public static final /* synthetic */ GlobalLowResolutionPositionRepository access$getLowResolutionPositionRepository$p(PlayerInfoProtocol $this) {
        return $this.lowResolutionPositionRepository;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/playerinfo/PlayerInfoProtocol$Companion;", "", "()V", "PROTOCOL_CAPACITY", "", "cycleCount", "getCycleCount$osrs_226_model", "()I", "setCycleCount$osrs_226_model", "(I)V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-226-model"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCycleCount$osrs_226_model() {
            return cycleCount;
        }

        public final void setCycleCount$osrs_226_model(int n) {
            cycleCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

