/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.npcinfo;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.common.RSProtThreadSafetyKt;
import net.rsprot.protocol.common.client.ClientTypeMap;
import net.rsprot.protocol.common.client.OldSchoolClientType;
import net.rsprot.protocol.common.game.outgoing.info.npcinfo.encoder.NpcResolutionChangeEncoder;
import net.rsprot.protocol.common.game.outgoing.info.util.ZoneIndexStorage;
import net.rsprot.protocol.game.outgoing.info.ByteBufRecycler;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatar;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarExceptionHandler;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarFactory;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarRepository;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfo;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoRepository;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoWorldDetails;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoWorldDetailsStorage;
import net.rsprot.protocol.game.outgoing.info.worker.DefaultProtocolWorker;
import net.rsprot.protocol.game.outgoing.info.worker.ProtocolWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 52\u00020\u0001:\u00015B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u001c\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u001f2\n\u0010$\u001a\u00060%j\u0002`&H\u0002J\u000e\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u001dJ$\u0010)\u001a\u00020\u00152\u0019\b\u0004\u0010*\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00150+\u00a2\u0006\u0002\b,H\u0082\bJ\u0011\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0086\u0002J\u0010\u0010.\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010/\u001a\u00020\u0015H\u0002J\b\u00100\u001a\u00020\u0015H\u0002J\b\u00101\u001a\u00020\u0015H\u0002J\b\u00102\u001a\u00020\u0015H\u0002J\b\u00103\u001a\u00020\u0015H\u0002J\u0006\u00104\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol;", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "resolutionChangeEncoders", "Lnet/rsprot/protocol/common/client/ClientTypeMap;", "Lnet/rsprot/protocol/common/game/outgoing/info/npcinfo/encoder/NpcResolutionChangeEncoder;", "avatarFactory", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFactory;", "exceptionHandler", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExceptionHandler;", "worker", "Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;", "zoneIndexStorage", "Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/common/client/ClientTypeMap;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarFactory;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExceptionHandler;Lnet/rsprot/protocol/game/outgoing/info/worker/ProtocolWorker;Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;)V", "avatarRepository", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository;", "callables", "", "Ljava/util/concurrent/Callable;", "", "detailsStorage", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoWorldDetailsStorage;", "npcInfoRepository", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoRepository;", "recycler", "Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;", "alloc", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfo;", "idx", "", "oldSchoolClientType", "Lnet/rsprot/protocol/common/client/OldSchoolClientType;", "catchException", "index", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "dealloc", "info", "execute", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "get", "getOrNull", "postUpdate", "prepareBitcodes", "prepareExtendedInfo", "putBitcodes", "putExtendedInfo", "update", "Companion", "osrs-226-model"})
@SourceDebugExtension(value={"SMAP\nNpcInfoProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpcInfoProtocol.kt\nnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,305:1\n245#1,3:314\n261#1,3:317\n245#1,3:320\n261#1,3:323\n245#1,3:326\n261#1,3:329\n134#2,4:306\n134#2,4:310\n134#2,4:332\n11#3,2:336\n*S KotlinDebug\n*F\n+ 1 NpcInfoProtocol.kt\nnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol\n*L\n189#1:314,3\n189#1:317,3\n204#1:320,3\n204#1:323,3\n218#1:326,3\n218#1:329,3\n148#1:306,4\n176#1:310,4\n228#1:332,4\n286#1:336,2\n*E\n"})
public final class NpcInfoProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final ClientTypeMap<NpcResolutionChangeEncoder> resolutionChangeEncoders;
    @NotNull
    private final NpcAvatarExceptionHandler exceptionHandler;
    @NotNull
    private final ProtocolWorker worker;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final NpcInfoWorldDetailsStorage detailsStorage;
    @NotNull
    private final ByteBufRecycler recycler;
    @NotNull
    private final NpcAvatarRepository avatarRepository;
    @NotNull
    private final NpcInfoRepository npcInfoRepository;
    @NotNull
    private final List<Callable<Unit>> callables;
    public static final int PROTOCOL_CAPACITY = 2048;
    @NotNull
    private static final Logger logger;
    private static int cycleCount;

    public NpcInfoProtocol(@NotNull ByteBufAllocator allocator, @NotNull ClientTypeMap<? extends NpcResolutionChangeEncoder> resolutionChangeEncoders, @NotNull NpcAvatarFactory avatarFactory, @NotNull NpcAvatarExceptionHandler exceptionHandler, @NotNull ProtocolWorker worker, @NotNull ZoneIndexStorage zoneIndexStorage) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter(resolutionChangeEncoders, (String)"resolutionChangeEncoders");
        Intrinsics.checkNotNullParameter((Object)avatarFactory, (String)"avatarFactory");
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        this.allocator = allocator;
        this.resolutionChangeEncoders = resolutionChangeEncoders;
        this.exceptionHandler = exceptionHandler;
        this.worker = worker;
        this.zoneIndexStorage = zoneIndexStorage;
        this.detailsStorage = new NpcInfoWorldDetailsStorage();
        this.recycler = new ByteBufRecycler(0, 1, null);
        this.avatarRepository = avatarFactory.getAvatarRepository$osrs_226_model();
        this.npcInfoRepository = new NpcInfoRepository((Function2<? super Integer, ? super OldSchoolClientType, NpcInfo>)((Function2)new Function2<Integer, OldSchoolClientType, NpcInfo>(this){
            final /* synthetic */ NpcInfoProtocol this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final NpcInfo invoke(int localIndex, @NotNull OldSchoolClientType clientType) {
                Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
                return new NpcInfo(NpcInfoProtocol.access$getAllocator$p(this.this$0), NpcInfoProtocol.access$getAvatarRepository$p(this.this$0), clientType, localIndex, NpcInfoProtocol.access$getZoneIndexStorage$p(this.this$0), (ClientTypeMap<? extends NpcResolutionChangeEncoder>)NpcInfoProtocol.access$getResolutionChangeEncoders$p(this.this$0), NpcInfoProtocol.access$getDetailsStorage$p(this.this$0), NpcInfoProtocol.access$getRecycler$p(this.this$0));
            }
        }));
        this.callables = new ArrayList(2048);
    }

    public /* synthetic */ NpcInfoProtocol(ByteBufAllocator byteBufAllocator, ClientTypeMap clientTypeMap, NpcAvatarFactory npcAvatarFactory, NpcAvatarExceptionHandler npcAvatarExceptionHandler, ProtocolWorker protocolWorker, ZoneIndexStorage zoneIndexStorage, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            protocolWorker = new DefaultProtocolWorker();
        }
        this(byteBufAllocator, (ClientTypeMap<? extends NpcResolutionChangeEncoder>)clientTypeMap, npcAvatarFactory, npcAvatarExceptionHandler, protocolWorker, zoneIndexStorage);
    }

    @NotNull
    public final NpcInfo alloc(int idx, @NotNull OldSchoolClientType oldSchoolClientType) {
        Intrinsics.checkNotNullParameter((Object)oldSchoolClientType, (String)"oldSchoolClientType");
        RSProtThreadSafetyKt.checkCommunicationThread();
        return (NpcInfo)this.npcInfoRepository.alloc(idx, oldSchoolClientType);
    }

    public final void dealloc(@NotNull NpcInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RSProtThreadSafetyKt.checkCommunicationThread();
        if (info.isDestroyed()) {
            return;
        }
        this.npcInfoRepository.dealloc(info.getLocalPlayerIndex$osrs_226_model());
    }

    @NotNull
    public final NpcInfo get(int idx) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        return (NpcInfo)this.npcInfoRepository.get(idx);
    }

    @Nullable
    public final NpcInfo getOrNull(int idx) {
        RSProtThreadSafetyKt.checkCommunicationThread();
        return (NpcInfo)this.npcInfoRepository.getOrNull(idx);
    }

    public final void update() {
        RSProtThreadSafetyKt.checkCommunicationThread();
        this.prepareBitcodes();
        this.putBitcodes();
        this.prepareExtendedInfo();
        this.putExtendedInfo();
        this.postUpdate();
        this.recycler.cycle();
        int n = cycleCount;
        cycleCount = n + 1;
    }

    private final void prepareBitcodes() {
        for (int i = 0; i < 65536; ++i) {
            NpcAvatar avatar;
            if (this.avatarRepository.getOrNull(i) == null || !avatar.isActive()) continue;
            try {
                avatar.prepareBitcodes$osrs_226_model();
                continue;
            }
            catch (Exception e) {
                this.exceptionHandler.exceptionCaught(i, e);
                continue;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Error during npc bitcode preparation"), t);
                }
                throw t;
            }
        }
    }

    private final void prepareExtendedInfo() {
        for (int i = 0; i < 65536; ++i) {
            if (this.avatarRepository.getOrNull(i) == null) continue;
            try {
                NpcAvatar avatar;
                if (!avatar.isActive()) {
                    avatar.getExtendedInfo().precomputeCached$osrs_226_model();
                    continue;
                }
                avatar.getExtendedInfo().precompute$osrs_226_model();
                continue;
            }
            catch (Exception e) {
                this.exceptionHandler.exceptionCaught(i, e);
                continue;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Error during npc extended info preparation"), t);
                }
                throw t;
            }
        }
    }

    private final void putBitcodes() {
        NpcInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            NpcInfo info$iv;
            if ((NpcInfo)this_$iv.npcInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ NpcInfo $info;
                final /* synthetic */ NpcInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        NpcInfo $this$putBitcodes_u24lambda_u242 = this.$info;
                        boolean bl = false;
                        for (NpcInfoWorldDetails details : $this$putBitcodes_u24lambda_u242.getDetails$osrs_226_model()) {
                            if (details == null) continue;
                            $this$putBitcodes_u24lambda_u242.compute$osrs_226_model(details);
                        }
                    }
                    catch (Exception e) {
                        NpcInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = NpcInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during npc updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void putExtendedInfo() {
        NpcInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            NpcInfo info$iv;
            if ((NpcInfo)this_$iv.npcInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ NpcInfo $info;
                final /* synthetic */ NpcInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        NpcInfo $this$putExtendedInfo_u24lambda_u243 = this.$info;
                        boolean bl = false;
                        for (NpcInfoWorldDetails details : $this$putExtendedInfo_u24lambda_u243.getDetails$osrs_226_model()) {
                            if (details == null) continue;
                            $this$putExtendedInfo_u24lambda_u243.putExtendedInfo$osrs_226_model(details);
                        }
                    }
                    catch (Exception e) {
                        NpcInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = NpcInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during npc updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
    }

    private final void postUpdate() {
        NpcInfoProtocol this_$iv = this;
        boolean $i$f$execute = false;
        for (int i$iv = 1; i$iv < 2048; ++i$iv) {
            NpcInfo info$iv;
            if ((NpcInfo)this_$iv.npcInfoRepository.getOrNull(i$iv) == null) continue;
            ((Collection)this_$iv.callables).add(new Callable(info$iv, this_$iv, i$iv){
                final /* synthetic */ NpcInfo $info;
                final /* synthetic */ NpcInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        NpcInfo $this$postUpdate_u24lambda_u244 = this.$info;
                        boolean bl = false;
                        $this$postUpdate_u24lambda_u244.afterUpdate$osrs_226_model();
                    }
                    catch (Exception e) {
                        NpcInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = NpcInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during npc updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this_$iv.worker.execute(this_$iv.callables);
        this_$iv.callables.clear();
        for (int i = 0; i < 65536; ++i) {
            if (this.avatarRepository.getOrNull(i) == null) continue;
            try {
                NpcAvatar avatar;
                avatar.postUpdate();
                continue;
            }
            catch (Exception e) {
                this.exceptionHandler.exceptionCaught(i, e);
                continue;
            }
            catch (Throwable t) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                    Logger logger = arg0$iv;
                    boolean bl2 = false;
                    logger.error(String.valueOf("Error during npc avatar post update"), t);
                }
                throw t;
            }
        }
    }

    private final void execute(Function1<? super NpcInfo, Unit> block) {
        boolean $i$f$execute = false;
        for (int i = 1; i < 2048; ++i) {
            NpcInfo info;
            if ((NpcInfo)this.npcInfoRepository.getOrNull(i) == null) continue;
            ((Collection)this.callables).add(new Callable(block, info, this, i){
                final /* synthetic */ Function1<NpcInfo, Unit> $block;
                final /* synthetic */ NpcInfo $info;
                final /* synthetic */ NpcInfoProtocol this$0;
                final /* synthetic */ int $i;
                {
                    this.$block = $block;
                    this.$info = $info;
                    this.this$0 = $receiver;
                    this.$i = $i;
                }

                public final void call() {
                    try {
                        this.$block.invoke((Object)this.$info);
                    }
                    catch (Exception e) {
                        NpcInfoProtocol.access$catchException(this.this$0, this.$i, e);
                    }
                    catch (Throwable t) {
                        Logger arg0$iv = NpcInfoProtocol.access$getLogger$cp();
                        boolean bl = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                            Logger logger = arg0$iv;
                            boolean bl2 = false;
                            logger.error(String.valueOf("Error during npc updating"), t);
                        }
                        throw t;
                    }
                }
            });
        }
        this.worker.execute(this.callables);
        this.callables.clear();
    }

    private final void catchException(int index, Exception exception) {
        NpcInfo npcInfo = (NpcInfo)this.npcInfoRepository.getOrNull(index);
        if (npcInfo == null) {
            return;
        }
        NpcInfo info = npcInfo;
        this.npcInfoRepository.destroy(index);
        info.setException$osrs_226_model(exception);
    }

    public static final /* synthetic */ void access$catchException(NpcInfoProtocol $this, int index, Exception exception) {
        $this.catchException(index, exception);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ByteBufAllocator access$getAllocator$p(NpcInfoProtocol $this) {
        return $this.allocator;
    }

    public static final /* synthetic */ NpcAvatarRepository access$getAvatarRepository$p(NpcInfoProtocol $this) {
        return $this.avatarRepository;
    }

    public static final /* synthetic */ ZoneIndexStorage access$getZoneIndexStorage$p(NpcInfoProtocol $this) {
        return $this.zoneIndexStorage;
    }

    public static final /* synthetic */ ClientTypeMap access$getResolutionChangeEncoders$p(NpcInfoProtocol $this) {
        return $this.resolutionChangeEncoders;
    }

    public static final /* synthetic */ NpcInfoWorldDetailsStorage access$getDetailsStorage$p(NpcInfoProtocol $this) {
        return $this.detailsStorage;
    }

    public static final /* synthetic */ ByteBufRecycler access$getRecycler$p(NpcInfoProtocol $this) {
        return $this.recycler;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\r"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcInfoProtocol$Companion;", "", "()V", "PROTOCOL_CAPACITY", "", "cycleCount", "getCycleCount$osrs_226_model", "()I", "setCycleCount$osrs_226_model", "(I)V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-226-model"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCycleCount$osrs_226_model() {
            return cycleCount;
        }

        public final void setCycleCount$osrs_226_model(int n) {
            cycleCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

