/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.buffer.extensions.JagexByteBufExtensionsKt;
import net.rsprot.crypto.cipher.NopStreamCipher;
import net.rsprot.crypto.cipher.StreamCipher;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.encoder.OutgoingMessageEncoder;
import net.rsprot.protocol.api.handlers.OutgoingMessageSizeEstimator;
import net.rsprot.protocol.channel.ChannelExtensions;
import net.rsprot.protocol.common.js5.outgoing.prot.Js5ServerProt;
import net.rsprot.protocol.js5.outgoing.Js5GroupResponse;
import net.rsprot.protocol.message.OutgoingMessage;
import net.rsprot.protocol.message.codec.MessageEncoder;
import net.rsprot.protocol.message.codec.outgoing.MessageEncoderRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J \u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lnet/rsprot/protocol/api/js5/Js5MessageEncoder;", "Lnet/rsprot/protocol/api/encoder/OutgoingMessageEncoder;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "cipher", "Lnet/rsprot/crypto/cipher/StreamCipher;", "getCipher", "()Lnet/rsprot/crypto/cipher/StreamCipher;", "estimator", "Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;", "getEstimator", "()Lnet/rsprot/protocol/api/handlers/OutgoingMessageSizeEstimator;", "getNetworkService", "()Lnet/rsprot/protocol/api/NetworkService;", "repository", "Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "getRepository", "()Lnet/rsprot/protocol/message/codec/outgoing/MessageEncoderRepository;", "validate", "", "getValidate", "()Z", "encode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "Lnet/rsprot/protocol/message/OutgoingMessage;", "out", "Lio/netty/buffer/ByteBuf;", "write", "", "promise", "Lio/netty/channel/ChannelPromise;", "osrs-226-api"})
public final class Js5MessageEncoder
extends OutgoingMessageEncoder {
    @NotNull
    private final NetworkService<?> networkService;
    @NotNull
    private final StreamCipher cipher;
    @NotNull
    private final MessageEncoderRepository<?> repository;
    private final boolean validate;
    @NotNull
    private final OutgoingMessageSizeEstimator estimator;

    public Js5MessageEncoder(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        this.networkService = networkService;
        this.cipher = (StreamCipher)NopStreamCipher.INSTANCE;
        this.repository = this.networkService.getEncoderRepositories().getJs5MessageEncoderRepository();
        this.estimator = this.networkService.getMessageSizeEstimator();
    }

    @NotNull
    public final NetworkService<?> getNetworkService() {
        return this.networkService;
    }

    @Override
    @NotNull
    protected StreamCipher getCipher() {
        return this.cipher;
    }

    @Override
    @NotNull
    protected MessageEncoderRepository<?> getRepository() {
        return this.repository;
    }

    @Override
    protected boolean getValidate() {
        return this.validate;
    }

    @Override
    @NotNull
    protected OutgoingMessageSizeEstimator getEstimator() {
        return this.estimator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        ByteBuf buf = null;
        try {
            if (msg instanceof Js5GroupResponse) {
                if (((Js5GroupResponse)msg).getKey() != 0) {
                    buf = this.allocateBuffer(ctx, (OutgoingMessage)msg);
                    try {
                        this.encode(ctx, (OutgoingMessage)msg, buf);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)msg);
                    }
                    if (buf.isReadable()) {
                        ctx.write((Object)buf, promise);
                        return;
                    } else {
                        buf.release();
                        ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
                    }
                    return;
                }
                buf = ((Js5GroupResponse)msg).content();
                this.encode(ctx, (OutgoingMessage)msg, buf);
                ByteBuf byteBuf = buf;
                Intrinsics.checkNotNull((Object)byteBuf);
                if (byteBuf.isReadable()) {
                    ctx.write((Object)buf, promise);
                    return;
                } else {
                    buf.release();
                    ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
                }
                return;
            }
            ctx.write(msg, promise);
            return;
        }
        catch (EncoderException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new EncoderException(t);
                }
            }
            catch (Throwable throwable) {
                ByteBuf byteBuf = buf;
                if (byteBuf == null) throw throwable;
                byteBuf.release();
                throw throwable;
            }
        }
    }

    @Override
    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull OutgoingMessage msg, @NotNull ByteBuf out) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        MessageEncoder encoder = this.getRepository().getEncoder(msg.getClass());
        encoder.encode-WFbGaZ8(this.getCipher(), JagexByteBufExtensionsKt.toJagByteBuf((ByteBuf)out), msg);
        int writtenBytes = out.readableBytes();
        this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor().incrementOutgoingPacketPayload(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), Js5ServerProt.JS5_GROUP_RESPONSE.getOpcode(), writtenBytes);
    }
}

