/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.timeout.IdleStateHandler;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.login.LoginChannelHandler;
import net.rsprot.protocol.api.login.LoginMessageDecoder;
import net.rsprot.protocol.api.login.LoginMessageEncoder;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u000fB\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/rsprot/protocol/api/LoginChannelInitializer;", "R", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/Channel;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "exceptionCaught", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "cause", "", "initChannel", "ch", "Companion", "osrs-226-api"})
@SourceDebugExtension(value={"SMAP\nLoginChannelInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginChannelInitializer.kt\nnet/rsprot/protocol/api/LoginChannelInitializer\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,60:1\n20#2:61\n44#2,6:62\n52#2:72\n55#2:77\n58#2:82\n61#2:87\n64#2:92\n21#2:93\n32#3,4:68\n56#3,4:73\n80#3,4:78\n104#3,4:83\n128#3,4:88\n11#4,2:94\n*S KotlinDebug\n*F\n+ 1 LoginChannelInitializer.kt\nnet/rsprot/protocol/api/LoginChannelInitializer\n*L\n23#1:61\n23#1:62,6\n23#1:72\n23#1:77\n23#1:82\n23#1:87\n23#1:92\n23#1:93\n23#1:68,4\n23#1:73,4\n23#1:78,4\n23#1:83,4\n23#1:88,4\n57#1:94,2\n*E\n"})
public final class LoginChannelInitializer<R>
extends ChannelInitializer<Channel> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<R> networkService;
    @NotNull
    private static final Logger logger;

    public LoginChannelInitializer(@NotNull NetworkService<R> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        this.networkService = networkService;
    }

    protected void initChannel(@NotNull Channel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Channel initialized: " + ch));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Channel initialized: " + ch));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Channel initialized: " + ch));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Channel initialized: " + ch));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Channel initialized: " + ch));
                }
                break;
            }
        }
        this.networkService.getTrafficMonitor().incrementConnections();
        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new IdleStateHandler(true, 30L, 30L, 30L, TimeUnit.SECONDS), new LoginMessageDecoder(this.networkService), new LoginMessageEncoder(this.networkService), new LoginChannelHandler(this.networkService)};
        ch.pipeline().addLast(channelHandlerArray);
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_226_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/LoginChannelInitializer$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-226-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

