/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.channel.ChannelExtensionsKt;
import net.rsprot.protocol.api.js5.Js5Configuration;
import net.rsprot.protocol.api.js5.Js5GroupProvider;
import net.rsprot.protocol.api.js5.Js5Service;
import net.rsprot.protocol.api.js5.util.IntArrayDeque;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.common.js5.outgoing.prot.Js5ServerProt;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.js5.incoming.Js5GroupRequest;
import net.rsprot.protocol.js5.incoming.UrgentRequest;
import net.rsprot.protocol.js5.outgoing.Js5GroupResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 82\u00020\u0001:\u0003789B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\b\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020!J\u0006\u0010#\u001a\u00020!J\u0006\u0010$\u001a\u00020!J\u0016\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\fJ\b\u0010(\u001a\u00020\fH\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020*J\u0006\u0010.\u001a\u00020*J\u0006\u0010/\u001a\u00020*J\u000e\u00100\u001a\u00020*2\u0006\u00101\u001a\u00020\fJ\b\u00102\u001a\u00020*H\u0002J\u001d\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b6R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Client;", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "(Lio/netty/channel/ChannelHandlerContext;)V", "awaitingPrefetch", "Lnet/rsprot/protocol/api/js5/util/IntArrayDeque;", "getCtx", "()Lio/netty/channel/ChannelHandlerContext;", "currentRequest", "Lnet/rsprot/protocol/api/js5/Js5Client$PartialJs5GroupRequest;", "lowPriorityChangeCount", "", "prefetch", "<set-?>", "Lnet/rsprot/protocol/api/js5/Js5Client$ClientPriority;", "priority", "getPriority", "()Lnet/rsprot/protocol/api/js5/Js5Client$ClientPriority;", "urgent", "writtenByteCount", "writtenGroupCount", "xorKey", "getNextBlock", "Lnet/rsprot/protocol/js5/outgoing/Js5GroupResponse;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "behaviour", "Lnet/rsprot/protocol/api/js5/Js5Configuration$Js5MissingGroupBehaviour;", "provider", "Lnet/rsprot/protocol/api/js5/Js5GroupProvider;", "blockLength", "isEmpty", "", "isNotEmpty", "isNotFull", "isReady", "needsFlushing", "flushThresholdInBytes", "flushThresholdInGroups", "pop", "push", "", "request", "Lnet/rsprot/protocol/js5/incoming/Js5GroupRequest;", "resetTracker", "setHighPriority", "setLowPriority", "setXorKey", "key", "transferAllPrefetch", "transferPrefetch", "groupProvider", "threshold", "transferPrefetch$osrs_226_api", "ClientPriority", "Companion", "PartialJs5GroupRequest", "osrs-226-api"})
@SourceDebugExtension(value={"SMAP\nJs5Client.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Js5Client.kt\nnet/rsprot/protocol/api/js5/Js5Client\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 IntArrayDeque.kt\nnet/rsprot/protocol/api/js5/util/IntArrayDeque\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,400:1\n36#2,14:401\n52#2:419\n55#2:424\n58#2:429\n61#2:434\n64#2:439\n32#3,4:415\n56#3,4:420\n80#3,4:425\n104#3,4:430\n128#3,4:435\n104#3,4:440\n104#3,4:444\n104#3,4:448\n94#4:452\n94#4:453\n11#5,2:454\n*S KotlinDebug\n*F\n+ 1 Js5Client.kt\nnet/rsprot/protocol/api/js5/Js5Client\n*L\n72#1:401,14\n72#1:419\n72#1:424\n72#1:429\n72#1:434\n72#1:439\n72#1:415,4\n72#1:420,4\n72#1:425,4\n72#1:430,4\n72#1:435,4\n85#1:440,4\n99#1:444,4\n110#1:448,4\n186#1:452\n187#1:453\n378#1:454,2\n*E\n"})
public final class Js5Client {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelHandlerContext ctx;
    @NotNull
    private final IntArrayDeque urgent;
    @NotNull
    private final IntArrayDeque prefetch;
    @NotNull
    private final IntArrayDeque awaitingPrefetch;
    @NotNull
    private final PartialJs5GroupRequest currentRequest;
    private int lowPriorityChangeCount;
    @NotNull
    private ClientPriority priority;
    private int writtenByteCount;
    private int writtenGroupCount;
    private int xorKey;
    @NotNull
    private static final Logger logger;
    private static final int MAX_QUEUE_SIZE = 200;
    private static int remainingInvalidGroupLogs;
    private static boolean bufferSlicingValidated;

    public Js5Client(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        this.urgent = new IntArrayDeque(200);
        this.prefetch = new IntArrayDeque(200);
        this.awaitingPrefetch = new IntArrayDeque(200);
        this.currentRequest = new PartialJs5GroupRequest();
        this.priority = ClientPriority.LOW;
    }

    @NotNull
    public final ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public final ClientPriority getPriority() {
        return this.priority;
    }

    @Nullable
    public final Js5GroupResponse getNextBlock(@NotNull NetworkService<?> networkService, @NotNull Js5Configuration.Js5MissingGroupBehaviour behaviour, @NotNull Js5GroupProvider provider, int blockLength) {
        ByteBuf block;
        block29: {
            Logger logger;
            Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
            Intrinsics.checkNotNullParameter((Object)((Object)behaviour), (String)"behaviour");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            block = this.currentRequest.getBlock();
            if (block != null && !this.currentRequest.isComplete()) break block29;
            int request = this.pop();
            if (request == -1) {
                return null;
            }
            int archiveId = request >>> 16;
            int groupId = request & 0xFFFF;
            Logger logger$iv = Js5Client.logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("Assigned next request block: " + archiveId + ":" + groupId));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("Assigned next request block: " + archiveId + ":" + groupId));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("Assigned next request block: " + archiveId + ":" + groupId));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("Assigned next request block: " + archiveId + ":" + groupId));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("Assigned next request block: " + archiveId + ":" + groupId));
                    }
                    break;
                }
            }
            try {
                block = provider.provide(archiveId, groupId);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to respond to request " + archiveId + ":" + groupId, t);
            }
            if (block == null) {
                switch (WhenMappings.$EnumSwitchMapping$0[behaviour.ordinal()]) {
                    case 1: {
                        boolean bl13;
                        Logger arg0$iv;
                        if (remainingInvalidGroupLogs > 0) {
                            remainingInvalidGroupLogs += -1;
                            arg0$iv = Js5Client.logger;
                            bl13 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                logger = arg0$iv;
                                boolean bl14 = false;
                                logger.warn(String.valueOf("Invalid JS5 group request received: " + archiveId + ":" + groupId));
                            }
                        }
                        return this.getNextBlock(networkService, behaviour, provider, blockLength);
                    }
                    case 2: {
                        boolean bl13;
                        Logger arg0$iv;
                        if (remainingInvalidGroupLogs > 0) {
                            remainingInvalidGroupLogs += -1;
                            arg0$iv = Js5Client.logger;
                            bl13 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                                logger = arg0$iv;
                                boolean bl15 = false;
                                logger.warn(String.valueOf("Invalid JS5 group request received: " + archiveId + ":" + groupId));
                            }
                        }
                        throw new NullPointerException("Group " + archiveId + ":" + groupId + " does not exist.");
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            if (!bufferSlicingValidated && block.readableBytes() > 512) {
                bufferSlicingValidated = true;
                boolean isValid = Js5Service.Companion.ensureCorrectlySliced$osrs_226_api(block);
                if (!isValid) {
                    Logger arg0$iv = Js5Client.logger;
                    boolean bl16 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                        logger = arg0$iv;
                        boolean bl17 = false;
                        logger.warn(String.valueOf("JS5 buffer for " + archiveId + ":" + groupId + " has not been correctly sliced up! Byte buffers given to RSProt must be prepared via Js5Service.prepareJs5Buffer()."));
                    }
                }
            }
            this.currentRequest.set(block);
            networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor().incrementOutgoingPacketOpcode(ChannelExtensionsKt.inetAddress(this.ctx), Js5ServerProt.JS5_GROUP_RESPONSE.getOpcode());
        }
        int progress = this.currentRequest.getProgress();
        int length = this.currentRequest.getNextBlockLengthAndIncrementProgress(blockLength);
        this.writtenByteCount += length;
        if (this.currentRequest.isComplete()) {
            int n = this.writtenGroupCount;
            this.writtenGroupCount = n + 1;
        }
        ByteBuf byteBuf = block.slice(progress, length);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"slice(...)");
        return new Js5GroupResponse(byteBuf, this.xorKey);
    }

    public final void push(@NotNull Js5GroupRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        int bitpacked = request.getBitpacked();
        if (request instanceof UrgentRequest) {
            this.prefetch.remove(bitpacked);
            this.awaitingPrefetch.remove(bitpacked);
            this.urgent.addLast(bitpacked);
        } else if (this.lowPriorityChangeCount >= 2 && this.priority == ClientPriority.LOW) {
            this.prefetch.addLast(bitpacked);
        } else {
            this.awaitingPrefetch.addLast(bitpacked);
        }
    }

    private final int pop() {
        int urgent = this.urgent.removeFirstOrDefault(-1);
        if (urgent != -1) {
            return urgent;
        }
        return this.prefetch.removeFirstOrDefault(-1);
    }

    public final boolean transferPrefetch$osrs_226_api(@NotNull Js5GroupProvider groupProvider, int threshold) {
        int next;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)groupProvider, (String)"groupProvider");
                if (this.awaitingPrefetch.isEmpty()) break block3;
                IntArrayDeque this_$iv = this.urgent;
                boolean $i$f$isNotEmpty = false;
                if (!this_$iv.isEmpty()) break block3;
                this_$iv = this.prefetch;
                $i$f$isNotEmpty = false;
                if (!(!this_$iv.isEmpty()) && this.currentRequest.isComplete() && this.ctx.channel().isActive() && this.ctx.channel().isWritable()) break block4;
            }
            return false;
        }
        int transferredBytes = 0;
        while ((next = this.awaitingPrefetch.removeFirstOrDefault(-1)) != -1) {
            int archiveId = next >>> 16;
            int groupId = next & 0xFFFF;
            ByteBuf byteBuf = groupProvider.provide(archiveId, groupId);
            int size = byteBuf != null ? byteBuf.readableBytes() : 0;
            this.prefetch.addLast(next);
            transferredBytes += size;
            if (size < threshold) continue;
        }
        return transferredBytes > 0;
    }

    private final void transferAllPrefetch() {
        int next;
        while ((next = this.awaitingPrefetch.removeFirstOrDefault(-1)) != -1) {
            this.prefetch.addLast(next);
        }
    }

    public final void setLowPriority() {
        this.priority = ClientPriority.LOW;
        ++this.lowPriorityChangeCount;
        if (this.lowPriorityChangeCount >= 2) {
            this.transferAllPrefetch();
        }
    }

    public final void setHighPriority() {
        this.priority = ClientPriority.HIGH;
    }

    public final void setXorKey(int key) {
        this.xorKey = key;
    }

    public final boolean isNotFull() {
        return this.urgent.getSize() < 200 && this.prefetch.getSize() + this.awaitingPrefetch.getSize() < 201;
    }

    private final boolean isEmpty() {
        return this.currentRequest.isComplete() && this.urgent.isEmpty() && this.prefetch.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final boolean isReady() {
        return this.ctx.channel().isWritable() && this.isNotEmpty();
    }

    public final boolean needsFlushing(int flushThresholdInBytes, int flushThresholdInGroups) {
        return this.writtenGroupCount >= flushThresholdInGroups || this.writtenGroupCount > 0 && this.writtenByteCount >= flushThresholdInBytes || this.writtenByteCount > 0 && this.isEmpty() || !this.ctx.channel().isWritable();
    }

    public final void resetTracker() {
        this.writtenByteCount = 0;
        this.writtenGroupCount = 0;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
        remainingInvalidGroupLogs = 100;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Client$ClientPriority;", "", "(Ljava/lang/String;I)V", "LOW", "HIGH", "osrs-226-api"})
    public static final class ClientPriority
    extends Enum<ClientPriority> {
        public static final /* enum */ ClientPriority LOW = new ClientPriority();
        public static final /* enum */ ClientPriority HIGH = new ClientPriority();
        private static final /* synthetic */ ClientPriority[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ClientPriority[] values() {
            return (ClientPriority[])$VALUES.clone();
        }

        public static ClientPriority valueOf(String value) {
            return Enum.valueOf(ClientPriority.class, value);
        }

        @NotNull
        public static EnumEntries<ClientPriority> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = clientPriorityArray = new ClientPriority[]{ClientPriority.LOW, ClientPriority.HIGH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000b"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Client$Companion;", "", "()V", "MAX_QUEUE_SIZE", "", "bufferSlicingValidated", "", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "remainingInvalidGroupLogs", "osrs-226-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0004R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lnet/rsprot/protocol/api/js5/Js5Client$PartialJs5GroupRequest;", "", "()V", "<set-?>", "Lio/netty/buffer/ByteBuf;", "block", "getBlock", "()Lio/netty/buffer/ByteBuf;", "length", "", "progress", "getProgress", "()I", "getNextBlockLengthAndIncrementProgress", "blockLength", "isComplete", "", "set", "", "osrs-226-api"})
    public static final class PartialJs5GroupRequest {
        @Nullable
        private ByteBuf block;
        private int progress;
        private int length;

        @Nullable
        public final ByteBuf getBlock() {
            return this.block;
        }

        public final int getProgress() {
            return this.progress;
        }

        public final boolean isComplete() {
            return this.progress >= this.length;
        }

        public final int getNextBlockLengthAndIncrementProgress(int blockLength) {
            int progress = this.progress;
            this.progress = Math.min(this.length, this.progress + blockLength);
            return this.progress - progress;
        }

        public final void set(@NotNull ByteBuf block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.block = block;
            this.progress = 0;
            this.length = block.readableBytes();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Js5Configuration.Js5MissingGroupBehaviour.values().length];
            try {
                nArray[Js5Configuration.Js5MissingGroupBehaviour.DROP_REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Js5Configuration.Js5MissingGroupBehaviour.DROP_CONNECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

