/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.playerinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.internal.game.outgoing.info.playerinfo.extendedinfo.Chat;
import net.rsprot.protocol.internal.game.outgoing.info.shared.extendedinfo.Say;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013J\u001d\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/playerinfo/ObservedChatStorage;", "", "captureChat", "", "captureSay", "(ZZ)V", "count", "", "limit", "getLimit", "()I", "messages", "", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/ObservedChatStorage$ChatMessage;", "[Lnet/rsprot/protocol/game/outgoing/info/playerinfo/ObservedChatStorage$ChatMessage;", "reset", "", "reset$osrs_225_model", "snapshot", "", "trackChat", "index", "chat", "Lnet/rsprot/protocol/internal/game/outgoing/info/playerinfo/extendedinfo/Chat;", "trackChat$osrs_225_model", "trackSay", "say", "Lnet/rsprot/protocol/internal/game/outgoing/info/shared/extendedinfo/Say;", "trackSay$osrs_225_model", "ChatMessage", "ChatMessageType", "osrs-225-model"})
public final class ObservedChatStorage {
    private final boolean captureChat;
    private final boolean captureSay;
    private int count;
    @NotNull
    private final ChatMessage[] messages;

    public ObservedChatStorage(boolean captureChat, boolean captureSay) {
        this.captureChat = captureChat;
        this.captureSay = captureSay;
        this.messages = new ChatMessage[this.getLimit()];
    }

    private final int getLimit() {
        return (this.captureChat ? 2048 : 0) + (this.captureSay ? 2048 : 0);
    }

    @NotNull
    public final List<ChatMessage> snapshot() {
        if (this.count == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<ChatMessage> list = new ArrayList<ChatMessage>(this.count);
        int n = this.count;
        for (int i = 0; i < n; ++i) {
            ChatMessage chatMessage = this.messages[i];
            if (chatMessage == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            list.add(chatMessage);
        }
        return list;
    }

    public final void reset$osrs_225_model() {
        this.count = 0;
        ArraysKt.fill$default((Object[])this.messages, null, (int)0, (int)0, (int)6, null);
    }

    public final void trackChat$osrs_225_model(int index, @NotNull Chat chat) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        if (!this.captureChat) {
            return;
        }
        int n = this.count;
        this.count = n + 1;
        byte by = chat.getColour-w2LRezQ();
        byte by2 = chat.getEffects-w2LRezQ();
        byte by3 = chat.getModicon-w2LRezQ();
        ChatMessageType chatMessageType = chat.getAutotyper() ? ChatMessageType.Autotyper : ChatMessageType.Regular;
        String string = chat.getText();
        if (string == null) {
            string = "";
        }
        this.messages[n] = new ChatMessage(index, by, by2, by3, chatMessageType, string, chat.getPattern(), null);
    }

    public final void trackSay$osrs_225_model(int index, @NotNull Say say) {
        Intrinsics.checkNotNullParameter((Object)say, (String)"say");
        if (!this.captureSay) {
            return;
        }
        int n = this.count;
        this.count = n + 1;
        String string = say.getText();
        if (string == null) {
            string = "";
        }
        this.messages[n] = new ChatMessage(index, 0, 0, 0, ChatMessageType.Say, string, null, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016R\u0016\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006#"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/playerinfo/ObservedChatStorage$ChatMessage;", "", "index", "", "_colour", "Lkotlin/UByte;", "_effects", "_modicon", "type", "Lnet/rsprot/protocol/game/outgoing/info/playerinfo/ObservedChatStorage$ChatMessageType;", "text", "", "pattern", "", "(IBBBLnet/rsprot/protocol/game/outgoing/info/playerinfo/ObservedChatStorage$ChatMessageType;Ljava/lang/String;[BLkotlin/jvm/internal/DefaultConstructorMarker;)V", "B", "colour", "getColour", "()I", "effects", "getEffects", "getIndex", "modicon", "getModicon", "getPattern", "()[B", "getText", "()Ljava/lang/String;", "getType", "()Lnet/rsprot/protocol/game/outgoing/info/playerinfo/ObservedChatStorage$ChatMessageType;", "equals", "", "other", "hashCode", "toString", "osrs-225-model"})
    public static final class ChatMessage {
        private final int index;
        private final byte _colour;
        private final byte _effects;
        private final byte _modicon;
        @NotNull
        private final ChatMessageType type;
        @NotNull
        private final String text;
        @Nullable
        private final byte[] pattern;

        private ChatMessage(int index, byte _colour, byte _effects, byte _modicon, ChatMessageType type, String text, byte[] pattern) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.index = index;
            this._colour = _colour;
            this._effects = _effects;
            this._modicon = _modicon;
            this.type = type;
            this.text = text;
            this.pattern = pattern;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final ChatMessageType getType() {
            return this.type;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final byte[] getPattern() {
            return this.pattern;
        }

        public final int getColour() {
            return this._colour & 0xFF;
        }

        public final int getEffects() {
            return this._effects & 0xFF;
        }

        public final int getModicon() {
            return this._modicon & 0xFF;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type net.rsprot.protocol.game.outgoing.info.playerinfo.ObservedChatStorage.ChatMessage");
            ChatMessage cfr_ignored_0 = (ChatMessage)other;
            if (this.index != ((ChatMessage)other).index) {
                return false;
            }
            if (this._colour != ((ChatMessage)other)._colour) {
                return false;
            }
            if (this._effects != ((ChatMessage)other)._effects) {
                return false;
            }
            if (this._modicon != ((ChatMessage)other)._modicon) {
                return false;
            }
            if (this.type != ((ChatMessage)other).type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)((ChatMessage)other).text)) {
                return false;
            }
            if (this.pattern != null) {
                if (((ChatMessage)other).pattern == null) {
                    return false;
                }
                if (!Arrays.equals(this.pattern, ((ChatMessage)other).pattern)) {
                    return false;
                }
            } else if (((ChatMessage)other).pattern != null) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.index;
            result = 31 * result + UByte.hashCode-impl((byte)this._colour);
            result = 31 * result + UByte.hashCode-impl((byte)this._effects);
            result = 31 * result + UByte.hashCode-impl((byte)this._modicon);
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.text.hashCode();
            result = 31 * result + (this.pattern != null ? Arrays.hashCode(this.pattern) : 0);
            return result;
        }

        @NotNull
        public String toString() {
            String string;
            if (this.pattern != null) {
                String string2 = Arrays.toString(this.pattern);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            } else {
                string = null;
            }
            return "ChatMessage(index=" + this.index + ", type=" + this.type + ", text='" + this.text + "', pattern=" + string + ", colour=" + this.getColour() + ", effects=" + this.getEffects() + ", modicon=" + this.getModicon() + ")";
        }

        public /* synthetic */ ChatMessage(int index, byte _colour, byte _effects, byte _modicon, ChatMessageType type, String text, byte[] pattern, DefaultConstructorMarker $constructor_marker) {
            this(index, _colour, _effects, _modicon, type, text, pattern);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/playerinfo/ObservedChatStorage$ChatMessageType;", "", "(Ljava/lang/String;I)V", "Autotyper", "Regular", "Say", "osrs-225-model"})
    public static final class ChatMessageType
    extends Enum<ChatMessageType> {
        public static final /* enum */ ChatMessageType Autotyper = new ChatMessageType();
        public static final /* enum */ ChatMessageType Regular = new ChatMessageType();
        public static final /* enum */ ChatMessageType Say = new ChatMessageType();
        private static final /* synthetic */ ChatMessageType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChatMessageType[] values() {
            return (ChatMessageType[])$VALUES.clone();
        }

        public static ChatMessageType valueOf(String value) {
            return Enum.valueOf(ChatMessageType.class, value);
        }

        @NotNull
        public static EnumEntries<ChatMessageType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = chatMessageTypeArray = new ChatMessageType[]{ChatMessageType.Autotyper, ChatMessageType.Regular, ChatMessageType.Say};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

