/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.protocol.internal.RSProtFlags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nJ\u0011\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler;", "", "forceReleaseThreshold", "", "(I)V", "buffers", "Ljava/util/Queue;", "Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler$RecycledByteBuf;", "cycleCount", "add", "", "buffer", "Lio/netty/buffer/ByteBuf;", "cycle", "plusAssign", "RecycledByteBuf", "osrs-225-model"})
public final class ByteBufRecycler {
    private final int forceReleaseThreshold;
    private int cycleCount;
    @NotNull
    private final Queue<RecycledByteBuf> buffers;

    public ByteBufRecycler(int forceReleaseThreshold) {
        this.forceReleaseThreshold = forceReleaseThreshold;
        this.buffers = new ConcurrentLinkedQueue();
    }

    public /* synthetic */ ByteBufRecycler(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = RSProtFlags.getByteBufRecyclerCycleThreshold();
        }
        this(n);
    }

    public final void add(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.refCnt() <= 0) {
            return;
        }
        ByteBuf byteBuf = buffer.retain();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"retain(...)");
        this.buffers.add(new RecycledByteBuf(this.cycleCount, byteBuf));
    }

    public final void plusAssign(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.add(buffer);
    }

    public final void cycle() {
        int n = this.cycleCount;
        this.cycleCount = n + 1;
        int cycle = n;
        Iterator iterator = this.buffers.iterator();
        while (iterator.hasNext()) {
            RecycledByteBuf next = (RecycledByteBuf)iterator.next();
            int elapsed = cycle - next.getCycle();
            int refCount = next.refCnt();
            if (refCount > 1 && elapsed < this.forceReleaseThreshold) continue;
            ReferenceCountUtil.safeRelease((Object)next, (int)refCount);
            iterator.remove();
        }
    }

    public ByteBufRecycler() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u0096\u0001J\t\u0010\u0014\u001a\u00020\u000fH\u0096\u0001J\u0011\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0096\u0001J\u0011\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\u00010\u0001H\u0096\u0001J\u0019\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u0003H\u0096\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0011\u0010\u001a\u001a\n \u0017*\u0004\u0018\u00010\u00010\u0001H\u0096\u0001J!\u0010\u001a\u001a\n \u0017*\u0004\u0018\u00010\u00010\u00012\u000e\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00110\u0011H\u0096\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/ByteBufRecycler$RecycledByteBuf;", "Lio/netty/util/ReferenceCounted;", "cycle", "", "buffer", "Lio/netty/buffer/ByteBuf;", "(ILio/netty/buffer/ByteBuf;)V", "getBuffer", "()Lio/netty/buffer/ByteBuf;", "getCycle", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "refCnt", "release", "p0", "retain", "kotlin.jvm.PlatformType", "toString", "", "touch", "osrs-225-model"})
    private static final class RecycledByteBuf
    implements ReferenceCounted {
        private final int cycle;
        @NotNull
        private final ByteBuf buffer;

        public RecycledByteBuf(int cycle, @NotNull ByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.cycle = cycle;
            this.buffer = buffer;
        }

        public final int getCycle() {
            return this.cycle;
        }

        @NotNull
        public final ByteBuf getBuffer() {
            return this.buffer;
        }

        public int refCnt() {
            return this.buffer.refCnt();
        }

        public boolean release() {
            return this.buffer.release();
        }

        public boolean release(int p0) {
            return this.buffer.release(p0);
        }

        public ReferenceCounted retain() {
            return (ReferenceCounted)this.buffer.retain();
        }

        public ReferenceCounted retain(int p0) {
            return (ReferenceCounted)this.buffer.retain(p0);
        }

        public ReferenceCounted touch() {
            return (ReferenceCounted)this.buffer.touch();
        }

        public ReferenceCounted touch(Object p0) {
            return (ReferenceCounted)this.buffer.touch(p0);
        }

        public final int component1() {
            return this.cycle;
        }

        @NotNull
        public final ByteBuf component2() {
            return this.buffer;
        }

        @NotNull
        public final RecycledByteBuf copy(int cycle, @NotNull ByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return new RecycledByteBuf(cycle, buffer);
        }

        public static /* synthetic */ RecycledByteBuf copy$default(RecycledByteBuf recycledByteBuf, int n, ByteBuf byteBuf, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = recycledByteBuf.cycle;
            }
            if ((n2 & 2) != 0) {
                byteBuf = recycledByteBuf.buffer;
            }
            return recycledByteBuf.copy(n, byteBuf);
        }

        @NotNull
        public String toString() {
            return "RecycledByteBuf(cycle=" + this.cycle + ", buffer=" + this.buffer + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.cycle);
            result = result * 31 + this.buffer.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecycledByteBuf)) {
                return false;
            }
            RecycledByteBuf recycledByteBuf = (RecycledByteBuf)other;
            if (this.cycle != recycledByteBuf.cycle) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.buffer, (Object)recycledByteBuf.buffer);
        }
    }
}

