/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.game.outgoing.info.npcinfo;

import io.netty.buffer.ByteBufAllocator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.compression.provider.HuffmanCodecProvider;
import net.rsprot.protocol.common.game.outgoing.info.CoordGrid;
import net.rsprot.protocol.common.game.outgoing.info.npcinfo.NpcAvatarDetails;
import net.rsprot.protocol.common.game.outgoing.info.npcinfo.encoder.NpcExtendedInfoEncoders;
import net.rsprot.protocol.common.game.outgoing.info.util.ZoneIndexStorage;
import net.rsprot.protocol.game.outgoing.info.AvatarExtendedInfoWriter;
import net.rsprot.protocol.game.outgoing.info.AvatarPriority;
import net.rsprot.protocol.game.outgoing.info.filter.ExtendedInfoFilter;
import net.rsprot.protocol.game.outgoing.info.npcinfo.DeferredNpcInfoProtocolSupplier;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatar;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarExtendedInfo;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcAvatarExtendedInfoBlocks;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfo;
import net.rsprot.protocol.game.outgoing.info.npcinfo.NpcInfoProtocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012JV\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\b\b\u0002\u0010 \u001a\u00020\u001b2\b\b\u0002\u0010!\u001a\u00020\u001b2\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010'\u001a\u00020\u001bJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0015J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository;", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "extendedInfoFilter", "Lnet/rsprot/protocol/game/outgoing/info/filter/ExtendedInfoFilter;", "extendedInfoWriter", "", "Lnet/rsprot/protocol/game/outgoing/info/AvatarExtendedInfoWriter;", "Lnet/rsprot/protocol/common/game/outgoing/info/npcinfo/encoder/NpcExtendedInfoEncoders;", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExtendedInfoBlocks;", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarExtendedInfoWriter;", "huffmanCodec", "Lnet/rsprot/compression/provider/HuffmanCodecProvider;", "zoneIndexStorage", "Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;", "npcInfoProtocolSupplier", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/DeferredNpcInfoProtocolSupplier;", "(Lio/netty/buffer/ByteBufAllocator;Lnet/rsprot/protocol/game/outgoing/info/filter/ExtendedInfoFilter;Ljava/util/List;Lnet/rsprot/compression/provider/HuffmanCodecProvider;Lnet/rsprot/protocol/common/game/outgoing/info/util/ZoneIndexStorage;Lnet/rsprot/protocol/game/outgoing/info/npcinfo/DeferredNpcInfoProtocolSupplier;)V", "elements", "", "Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatar;", "[Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatar;", "queue", "Ljava/lang/ref/ReferenceQueue;", "getOrAlloc", "index", "", "id", "level", "x", "z", "spawnCycle", "direction", "priority", "Lnet/rsprot/protocol/game/outgoing/info/AvatarPriority;", "specific", "", "getOrNull", "idx", "release", "", "avatar", "resetTransientDetails", "details", "Lnet/rsprot/protocol/common/game/outgoing/info/npcinfo/NpcAvatarDetails;", "Companion", "osrs-225-model"})
public final class NpcAvatarRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBufAllocator allocator;
    @NotNull
    private final ExtendedInfoFilter extendedInfoFilter;
    @NotNull
    private final List<AvatarExtendedInfoWriter<NpcExtendedInfoEncoders, NpcAvatarExtendedInfoBlocks>> extendedInfoWriter;
    @NotNull
    private final HuffmanCodecProvider huffmanCodec;
    @NotNull
    private final ZoneIndexStorage zoneIndexStorage;
    @NotNull
    private final DeferredNpcInfoProtocolSupplier npcInfoProtocolSupplier;
    @NotNull
    private final NpcAvatar[] elements;
    @NotNull
    private final ReferenceQueue<NpcAvatar> queue;
    public static final int AVATAR_CAPACITY = 65536;

    public NpcAvatarRepository(@NotNull ByteBufAllocator allocator, @NotNull ExtendedInfoFilter extendedInfoFilter, @NotNull List<? extends AvatarExtendedInfoWriter<NpcExtendedInfoEncoders, NpcAvatarExtendedInfoBlocks>> extendedInfoWriter, @NotNull HuffmanCodecProvider huffmanCodec, @NotNull ZoneIndexStorage zoneIndexStorage, @NotNull DeferredNpcInfoProtocolSupplier npcInfoProtocolSupplier) {
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter((Object)extendedInfoFilter, (String)"extendedInfoFilter");
        Intrinsics.checkNotNullParameter(extendedInfoWriter, (String)"extendedInfoWriter");
        Intrinsics.checkNotNullParameter((Object)huffmanCodec, (String)"huffmanCodec");
        Intrinsics.checkNotNullParameter((Object)zoneIndexStorage, (String)"zoneIndexStorage");
        Intrinsics.checkNotNullParameter((Object)npcInfoProtocolSupplier, (String)"npcInfoProtocolSupplier");
        this.allocator = allocator;
        this.extendedInfoFilter = extendedInfoFilter;
        this.extendedInfoWriter = extendedInfoWriter;
        this.huffmanCodec = huffmanCodec;
        this.zoneIndexStorage = zoneIndexStorage;
        this.npcInfoProtocolSupplier = npcInfoProtocolSupplier;
        this.elements = new NpcAvatar[65536];
        this.queue = new ReferenceQueue();
    }

    @Nullable
    public final NpcAvatar getOrNull(int idx) {
        return this.elements[idx];
    }

    @NotNull
    public final NpcAvatar getOrAlloc(int index, int id, int level, int x, int z, int spawnCycle, int direction, @NotNull AvatarPriority priority, boolean specific) {
        NpcAvatar existing;
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        if (!(this.elements[index] == null)) {
            boolean $i$a$-require-NpcAvatarRepository$getOrAlloc$22 = false;
            String $i$a$-require-NpcAvatarRepository$getOrAlloc$22 = "NPC Avatar with index " + index + " is already allocated!";
            throw new IllegalArgumentException($i$a$-require-NpcAvatarRepository$getOrAlloc$22.toString());
        }
        Reference<NpcAvatar> reference = this.queue.poll();
        NpcAvatar npcAvatar = existing = reference != null ? reference.get() : null;
        if (existing != null) {
            existing.resetObservers$osrs_225_model();
            NpcAvatarDetails details = existing.getDetails$osrs_225_model();
            this.resetTransientDetails(details);
            details.setIndex(index);
            details.setId(id);
            details.setCurrentCoord-ah1LTL0(CoordGrid.constructor-impl((int)level, (int)x, (int)z));
            details.setSpawnCycle(spawnCycle);
            details.setDirection(direction);
            details.setAllocateCycle(NpcInfoProtocol.Companion.getCycleCount$osrs_225_model());
            details.setPriorityBitcode(priority.getBitcode());
            details.setSpecific(specific);
            this.zoneIndexStorage.add-dp9Y9C8(index, details.getCurrentCoord-9LJGAnM());
            this.elements[index] = existing;
            if (id > 16383) {
                existing.getExtendedInfo().setTransmogrification(id);
            }
            return existing;
        }
        NpcAvatarExtendedInfo extendedInfo = new NpcAvatarExtendedInfo(index, this.extendedInfoFilter, this.extendedInfoWriter, this.allocator, this.huffmanCodec);
        NpcAvatar avatar = new NpcAvatar(index, id, level, x, z, spawnCycle, direction, priority, specific, NpcInfoProtocol.Companion.getCycleCount$osrs_225_model(), extendedInfo, this.zoneIndexStorage);
        if (id > 16383) {
            extendedInfo.setTransmogrification(id);
        }
        this.zoneIndexStorage.add-dp9Y9C8(index, avatar.getDetails$osrs_225_model().getCurrentCoord-9LJGAnM());
        this.elements[index] = avatar;
        return avatar;
    }

    public static /* synthetic */ NpcAvatar getOrAlloc$default(NpcAvatarRepository npcAvatarRepository, int n, int n2, int n3, int n4, int n5, int n6, int n7, AvatarPriority avatarPriority, boolean bl, int n8, Object object) {
        if ((n8 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x40) != 0) {
            n7 = 0;
        }
        if ((n8 & 0x80) != 0) {
            avatarPriority = AvatarPriority.NORMAL;
        }
        if ((n8 & 0x100) != 0) {
            bl = false;
        }
        return npcAvatarRepository.getOrAlloc(n, n2, n3, n4, n5, n6, n7, avatarPriority, bl);
    }

    public final void release(@NotNull NpcAvatar avatar) {
        Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
        int index = avatar.getDetails$osrs_225_model().getIndex();
        if (!(this.elements[index] == avatar)) {
            boolean $i$a$-require-NpcAvatarRepository$release$22 = false;
            String $i$a$-require-NpcAvatarRepository$release$22 = "Attempting to release an invalid NPC avatar: " + avatar + ", " + this.elements[index];
            throw new IllegalArgumentException($i$a$-require-NpcAvatarRepository$release$22.toString());
        }
        if (avatar.getDetails$osrs_225_model().getSpecific()) {
            NpcInfoProtocol protocol = this.npcInfoProtocolSupplier.get();
            for (int i = 0; i < 2048; ++i) {
                NpcInfo info;
                if (protocol.getOrNull(i) == null) continue;
                info.unsetSpecific$osrs_225_model(index);
            }
        }
        this.zoneIndexStorage.remove-dp9Y9C8(index, avatar.getDetails$osrs_225_model().getCurrentCoord-9LJGAnM());
        this.elements[index] = null;
        avatar.getExtendedInfo().reset$osrs_225_model();
        SoftReference<NpcAvatar> reference = new SoftReference<NpcAvatar>(avatar, this.queue);
        reference.enqueue();
    }

    private final void resetTransientDetails(NpcAvatarDetails details) {
        details.setStepCount(0);
        details.setFirstStep(-1);
        details.setSecondStep(-1);
        details.setMovementType(0);
        details.setInaccessible(false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/rsprot/protocol/game/outgoing/info/npcinfo/NpcAvatarRepository$Companion;", "", "()V", "AVATAR_CAPACITY", "", "osrs-225-model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

