/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.internal;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.util.internal.SystemPropertyUtil;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.rsprot.protocol.internal.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u000bH\u0002J\u0018\u00109\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0006H\u0002J\u0018\u0010:\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0002J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u000eR\u0016\u0010\u0015\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\u0002R\u001c\u0010\u0017\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u000eR\u001c\u0010\u001a\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u000eR\u001c\u0010\u001d\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u000eR\u001c\u0010 \u001a\u00020!8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\"\u0010\u0002\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\u00020'X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010(R\u001c\u0010)\u001a\u00020!8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u0002\u001a\u0004\b+\u0010$R\u000e\u0010,\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b.\u0010\u0002\u001a\u0004\b/\u0010\tR\u001c\u00100\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b1\u0010\u0002\u001a\u0004\b2\u0010\u000eR\u001c\u00103\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b4\u0010\u0002\u001a\u0004\b5\u0010\t\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006?"}, d2={"Lnet/rsprot/protocol/internal/RSProtFlags;", "", "()V", "PREFIX", "", "byteBufRecyclerCycleThreshold", "", "getByteBufRecyclerCycleThreshold$annotations", "getByteBufRecyclerCycleThreshold", "()I", "captureChat", "", "getCaptureChat$annotations", "getCaptureChat", "()Z", "captureSay", "getCaptureSay$annotations", "getCaptureSay", "clientscriptVerification", "getClientscriptVerification$annotations", "getClientscriptVerification", "development", "getDevelopment$annotations", "extendedInfoInputVerification", "getExtendedInfoInputVerification$annotations", "getExtendedInfoInputVerification", "filterMissingPacketsInClient", "getFilterMissingPacketsInClient$annotations", "getFilterMissingPacketsInClient", "inventoryObjCheck", "getInventoryObjCheck$annotations", "getInventoryObjCheck", "js5Logging", "Lnet/rsprot/protocol/internal/LogLevel;", "getJs5Logging$annotations", "getJs5Logging", "()Lnet/rsprot/protocol/internal/LogLevel;", "js5LoggingString", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "networkLogging", "getNetworkLogging$annotations", "getNetworkLogging", "networkLoggingString", "npcAvatarMaxId", "getNpcAvatarMaxId$annotations", "getNpcAvatarMaxId", "npcPlayerAvatarTracking", "getNpcPlayerAvatarTracking$annotations", "getNpcPlayerAvatarTracking", "spotanimListCapacity", "getSpotanimListCapacity$annotations", "getSpotanimListCapacity", "getBoolean", "propertyName", "defaultValue", "getInt", "getString", "log", "", "name", "value", "osrs-225-internal"})
@SourceDebugExtension(value={"SMAP\nRSProtFlags.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RSProtFlags.kt\nnet/rsprot/protocol/internal/RSProtFlags\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,211:1\n56#2,4:212\n104#2,4:218\n104#2,4:222\n11#3,2:216\n*S KotlinDebug\n*F\n+ 1 RSProtFlags.kt\nnet/rsprot/protocol/internal/RSProtFlags\n*L\n206#1:212,4\n129#1:218,4\n147#1:222,4\n13#1:216,2\n*E\n"})
public final class RSProtFlags {
    @NotNull
    public static final RSProtFlags INSTANCE;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String PREFIX = "net.rsprot.protocol.internal.";
    private static final boolean development;
    private static final boolean inventoryObjCheck;
    private static final boolean extendedInfoInputVerification;
    private static final boolean clientscriptVerification;
    @NotNull
    private static final String networkLoggingString;
    @NotNull
    private static final String js5LoggingString;
    private static final int byteBufRecyclerCycleThreshold;
    private static final boolean npcPlayerAvatarTracking;
    private static final boolean filterMissingPacketsInClient;
    private static final int npcAvatarMaxId;
    private static final int spotanimListCapacity;
    private static final boolean captureChat;
    private static final boolean captureSay;
    @NotNull
    private static final LogLevel networkLogging;
    @NotNull
    private static final LogLevel js5Logging;

    private RSProtFlags() {
    }

    @JvmStatic
    private static /* synthetic */ void getDevelopment$annotations() {
    }

    public static final boolean getInventoryObjCheck() {
        return inventoryObjCheck;
    }

    @JvmStatic
    public static /* synthetic */ void getInventoryObjCheck$annotations() {
    }

    public static final boolean getExtendedInfoInputVerification() {
        return extendedInfoInputVerification;
    }

    @JvmStatic
    public static /* synthetic */ void getExtendedInfoInputVerification$annotations() {
    }

    public static final boolean getClientscriptVerification() {
        return clientscriptVerification;
    }

    @JvmStatic
    public static /* synthetic */ void getClientscriptVerification$annotations() {
    }

    public static final int getByteBufRecyclerCycleThreshold() {
        return byteBufRecyclerCycleThreshold;
    }

    @JvmStatic
    public static /* synthetic */ void getByteBufRecyclerCycleThreshold$annotations() {
    }

    public static final boolean getNpcPlayerAvatarTracking() {
        return npcPlayerAvatarTracking;
    }

    @JvmStatic
    public static /* synthetic */ void getNpcPlayerAvatarTracking$annotations() {
    }

    public static final boolean getFilterMissingPacketsInClient() {
        return filterMissingPacketsInClient;
    }

    @JvmStatic
    public static /* synthetic */ void getFilterMissingPacketsInClient$annotations() {
    }

    public static final int getNpcAvatarMaxId() {
        return npcAvatarMaxId;
    }

    @JvmStatic
    public static /* synthetic */ void getNpcAvatarMaxId$annotations() {
    }

    public static final int getSpotanimListCapacity() {
        return spotanimListCapacity;
    }

    @JvmStatic
    public static /* synthetic */ void getSpotanimListCapacity$annotations() {
    }

    public static final boolean getCaptureChat() {
        return captureChat;
    }

    @JvmStatic
    public static /* synthetic */ void getCaptureChat$annotations() {
    }

    public static final boolean getCaptureSay() {
        return captureSay;
    }

    @JvmStatic
    public static /* synthetic */ void getCaptureSay$annotations() {
    }

    @NotNull
    public static final LogLevel getNetworkLogging() {
        return networkLogging;
    }

    @JvmStatic
    public static /* synthetic */ void getNetworkLogging$annotations() {
    }

    @NotNull
    public static final LogLevel getJs5Logging() {
        return js5Logging;
    }

    @JvmStatic
    public static /* synthetic */ void getJs5Logging$annotations() {
    }

    private final boolean getBoolean(String propertyName, boolean defaultValue) {
        return SystemPropertyUtil.getBoolean((String)(PREFIX + propertyName), (boolean)defaultValue);
    }

    private final String getString(String propertyName, String defaultValue) {
        String string = SystemPropertyUtil.get((String)(PREFIX + propertyName), (String)defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    private final int getInt(String propertyName, int defaultValue) {
        Integer n;
        String string = SystemPropertyUtil.get((String)(PREFIX + propertyName), (String)String.valueOf(defaultValue));
        return string != null && (n = StringsKt.toIntOrNull((String)string)) != null ? n : defaultValue;
    }

    private final void log(String name, Object value) {
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.debug(String.valueOf("-Dnet.rsprot.protocol.internal." + name + ": " + value));
        }
    }

    static {
        String string;
        LogLevel logLevel;
        Logger logger;
        boolean bl;
        Logger arg0$iv;
        LogLevel logLevel2;
        INSTANCE = new RSProtFlags();
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        RSProtFlags.logger = InlineLogger.constructor-impl((Logger)delegate$iv);
        development = INSTANCE.getBoolean("development", true);
        inventoryObjCheck = INSTANCE.getBoolean("inventoryObjCheck", development);
        extendedInfoInputVerification = INSTANCE.getBoolean("extendedInfoInputVerification", development);
        clientscriptVerification = INSTANCE.getBoolean("clientscriptVerification", development);
        networkLoggingString = INSTANCE.getString("networkLogging", "off");
        js5LoggingString = INSTANCE.getString("js5Logging", "off");
        byteBufRecyclerCycleThreshold = INSTANCE.getInt("recyclerCycleThreshold", 50);
        npcPlayerAvatarTracking = INSTANCE.getBoolean("npcPlayerAvatarTracking", true);
        filterMissingPacketsInClient = INSTANCE.getBoolean("filterMissingPacketsInClient", true);
        npcAvatarMaxId = INSTANCE.getInt("npcAvatarMaxId", 16383);
        spotanimListCapacity = INSTANCE.getInt("spotanimListCapacity", 256);
        captureChat = INSTANCE.getBoolean("captureChat", false);
        captureSay = INSTANCE.getBoolean("captureSay", false);
        switch (networkLoggingString) {
            case "off": {
                logLevel2 = LogLevel.OFF;
                break;
            }
            case "trace": {
                logLevel2 = LogLevel.TRACE;
                break;
            }
            case "debug": {
                logLevel2 = LogLevel.DEBUG;
                break;
            }
            case "info": {
                logLevel2 = LogLevel.INFO;
                break;
            }
            case "warn": {
                logLevel2 = LogLevel.WARN;
                break;
            }
            case "error": {
                logLevel2 = LogLevel.ERROR;
                break;
            }
            default: {
                arg0$iv = RSProtFlags.logger;
                bl = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                    logger = arg0$iv;
                    boolean bl2 = false;
                    logger.warn(String.valueOf("Unknown network logging option: " + networkLoggingString + ", expected values: [off, trace, debug, info, warn, error]"));
                }
                logLevel2 = LogLevel.OFF;
            }
        }
        networkLogging = logLevel2;
        switch (js5LoggingString) {
            case "off": {
                logLevel = LogLevel.OFF;
                break;
            }
            case "trace": {
                logLevel = LogLevel.TRACE;
                break;
            }
            case "debug": {
                logLevel = LogLevel.DEBUG;
                break;
            }
            case "info": {
                logLevel = LogLevel.INFO;
                break;
            }
            case "warn": {
                logLevel = LogLevel.WARN;
                break;
            }
            case "error": {
                logLevel = LogLevel.ERROR;
                break;
            }
            default: {
                arg0$iv = RSProtFlags.logger;
                bl = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv)) {
                    logger = arg0$iv;
                    boolean bl3 = false;
                    logger.warn(String.valueOf("Unknown js5 logging option: " + networkLoggingString + ", expected values: [off, trace, debug, info, warn, error]"));
                }
                logLevel = LogLevel.OFF;
            }
        }
        js5Logging = logLevel;
        INSTANCE.log("development", development);
        INSTANCE.log("inventoryObjCheck", inventoryObjCheck);
        INSTANCE.log("extendedInfoInputVerification", extendedInfoInputVerification);
        INSTANCE.log("clientscriptVerification", clientscriptVerification);
        INSTANCE.log("networkLogging", networkLoggingString);
        INSTANCE.log("js5Logging", js5LoggingString);
        INSTANCE.log("npcPlayerAvatarTracking", npcPlayerAvatarTracking);
        INSTANCE.log("filterMissingPacketsInClient", filterMissingPacketsInClient);
        INSTANCE.log("npcAvatarMaxId", npcAvatarMaxId);
        INSTANCE.log("spotanimListCapacity", spotanimListCapacity);
        INSTANCE.log("captureChat", captureChat);
        INSTANCE.log("captureSay", captureSay);
        if (!(npcAvatarMaxId == -1 || npcAvatarMaxId <= 65534)) {
            string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n = spotanimListCapacity;
        if (!(0 <= n ? n < 257 : false)) {
            string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

