/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.NetworkService;
import net.rsprot.protocol.api.js5.Js5Client;
import net.rsprot.protocol.api.js5.Js5DisconnectionReason;
import net.rsprot.protocol.api.js5.Js5Service;
import net.rsprot.protocol.api.logging.LoggingExtKt;
import net.rsprot.protocol.api.metrics.ChannelTrafficHandlerExtensionsKt;
import net.rsprot.protocol.channel.ChannelExtensions;
import net.rsprot.protocol.internal.LogLevel;
import net.rsprot.protocol.internal.RSProtFlags;
import net.rsprot.protocol.js5.incoming.Js5GroupRequest;
import net.rsprot.protocol.js5.incoming.PriorityChangeHigh;
import net.rsprot.protocol.js5.incoming.PriorityChangeLow;
import net.rsprot.protocol.js5.incoming.XorChange;
import net.rsprot.protocol.message.IncomingJs5Message;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lnet/rsprot/protocol/api/js5/Js5ChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/rsprot/protocol/message/IncomingJs5Message;", "networkService", "Lnet/rsprot/protocol/api/NetworkService;", "(Lnet/rsprot/protocol/api/NetworkService;)V", "client", "Lnet/rsprot/protocol/api/js5/Js5Client;", "service", "Lnet/rsprot/protocol/api/js5/Js5Service;", "getService", "()Lnet/rsprot/protocol/api/js5/Js5Service;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "channelReadComplete", "channelWritabilityChanged", "exceptionCaught", "cause", "", "handlerAdded", "handlerRemoved", "userEventTriggered", "evt", "", "Companion", "osrs-225-api"})
@SourceDebugExtension(value={"SMAP\nJs5ChannelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Js5ChannelHandler.kt\nnet/rsprot/protocol/api/js5/Js5ChannelHandler\n+ 2 LoggingExt.kt\nnet/rsprot/protocol/api/logging/LoggingExtKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 Js5Service.kt\nnet/rsprot/protocol/api/js5/Js5Service\n+ 5 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,169:1\n20#2:170\n44#2,6:171\n52#2:181\n55#2:186\n58#2:191\n61#2:196\n64#2:201\n21#2:202\n20#2:203\n44#2,6:204\n52#2:214\n55#2:219\n58#2:224\n61#2:229\n64#2:234\n21#2:235\n36#2,14:236\n52#2:254\n55#2:259\n58#2:264\n61#2:269\n64#2:274\n37#2:275\n36#2,14:276\n52#2:294\n55#2:299\n58#2:304\n61#2:309\n64#2:314\n37#2:315\n36#2,14:316\n52#2:334\n55#2:339\n58#2:344\n61#2:349\n64#2:354\n37#2:355\n36#2,14:356\n52#2:374\n55#2:379\n58#2:384\n61#2:389\n64#2:394\n37#2:395\n20#2:400\n44#2,6:401\n52#2:411\n55#2:416\n58#2:421\n61#2:426\n64#2:431\n21#2:432\n32#3,4:177\n56#3,4:182\n80#3,4:187\n104#3,4:192\n128#3,4:197\n32#3,4:210\n56#3,4:215\n80#3,4:220\n104#3,4:225\n128#3,4:230\n32#3,4:250\n56#3,4:255\n80#3,4:260\n104#3,4:265\n128#3,4:270\n32#3,4:290\n56#3,4:295\n80#3,4:300\n104#3,4:305\n128#3,4:310\n32#3,4:330\n56#3,4:335\n80#3,4:340\n104#3,4:345\n128#3,4:350\n32#3,4:370\n56#3,4:375\n80#3,4:380\n104#3,4:385\n128#3,4:390\n32#3,4:407\n56#3,4:412\n80#3,4:417\n104#3,4:422\n128#3,4:427\n253#4,4:396\n11#5,2:433\n*S KotlinDebug\n*F\n+ 1 Js5ChannelHandler.kt\nnet/rsprot/protocol/api/js5/Js5ChannelHandler\n*L\n33#1:170\n33#1:171,6\n33#1:181\n33#1:186\n33#1:191\n33#1:196\n33#1:201\n33#1:202\n43#1:203\n43#1:204,6\n43#1:214\n43#1:219\n43#1:224\n43#1:229\n43#1:234\n43#1:235\n74#1:236,14\n74#1:254\n74#1:259\n74#1:264\n74#1:269\n74#1:274\n74#1:275\n80#1:276,14\n80#1:294\n80#1:299\n80#1:304\n80#1:309\n80#1:314\n80#1:315\n89#1:316,14\n89#1:334\n89#1:339\n89#1:344\n89#1:349\n89#1:354\n89#1:355\n96#1:356,14\n96#1:374\n96#1:379\n96#1:384\n96#1:389\n96#1:394\n96#1:395\n151#1:400\n151#1:401,6\n151#1:411\n151#1:416\n151#1:421\n151#1:426\n151#1:431\n151#1:432\n33#1:177,4\n33#1:182,4\n33#1:187,4\n33#1:192,4\n33#1:197,4\n43#1:210,4\n43#1:215,4\n43#1:220,4\n43#1:225,4\n43#1:230,4\n74#1:250,4\n74#1:255,4\n74#1:260,4\n74#1:265,4\n74#1:270,4\n80#1:290,4\n80#1:295,4\n80#1:300,4\n80#1:305,4\n80#1:310,4\n89#1:330,4\n89#1:335,4\n89#1:340,4\n89#1:345,4\n89#1:350,4\n96#1:370,4\n96#1:375,4\n96#1:380,4\n96#1:385,4\n96#1:390,4\n151#1:407,4\n151#1:412,4\n151#1:417,4\n151#1:422,4\n151#1:427,4\n99#1:396,4\n166#1:433,2\n*E\n"})
public final class Js5ChannelHandler
extends SimpleChannelInboundHandler<IncomingJs5Message> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NetworkService<?> networkService;
    private Js5Client client;
    @NotNull
    private static final Logger logger;

    public Js5ChannelHandler(@NotNull NetworkService<?> networkService) {
        Intrinsics.checkNotNullParameter(networkService, (String)"networkService");
        super(IncomingJs5Message.class);
        this.networkService = networkService;
    }

    private final Js5Service getService() {
        return this.networkService.getJs5Service();
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_225_api().getJs5InetAddressTracker().register(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Js5 channel '" + ctx.channel() + "' is now active"));
                }
                break;
            }
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.networkService.getINetAddressHandlers$osrs_225_api().getJs5InetAddressTracker().deregister(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
        Logger logger$iv = logger;
        boolean bl = false;
        LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
        boolean bl2 = false;
        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                boolean bl3 = false;
                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl4 = false;
                    logger.trace(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
            case 3: {
                boolean bl5 = false;
                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl6 = false;
                    logger.debug(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
            case 4: {
                boolean bl7 = false;
                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl8 = false;
                    logger.info(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
            case 5: {
                boolean bl9 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl10 = false;
                    logger.warn(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
            case 6: {
                boolean bl11 = false;
                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                    Logger logger = logger$iv;
                    boolean bl12 = false;
                    logger.error(String.valueOf("Js5 channel '" + ctx.channel() + "' is now inactive"));
                }
                break;
            }
        }
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ChannelHandlerContext channelHandlerContext = ctx.read();
        Intrinsics.checkNotNullExpressionValue((Object)channelHandlerContext, (String)"read(...)");
        this.client = new Js5Client(channelHandlerContext);
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.onClientConnected$osrs_225_api(js5Client);
        this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor().incrementConnections(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
    }

    public void handlerRemoved(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.onClientDisconnected$osrs_225_api(js5Client);
        this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor().decrementConnections(ChannelExtensions.hostAddress((ChannelHandlerContext)ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull IncomingJs5Message msg) {
        block65: {
            block70: {
                IncomingJs5Message incomingJs5Message;
                block68: {
                    Js5Client js5Client;
                    block66: {
                        Js5Client js5Client2;
                        block63: {
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                            incomingJs5Message = msg;
                            if (!(incomingJs5Message instanceof Js5GroupRequest)) break block63;
                            Logger logger$iv = logger;
                            boolean bl = false;
                            LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                            boolean bl2 = false;
                            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    boolean bl3 = false;
                                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl4 = false;
                                        logger.trace(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                                case 3: {
                                    boolean bl5 = false;
                                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl6 = false;
                                        logger.debug(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                                case 4: {
                                    boolean bl7 = false;
                                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl8 = false;
                                        logger.info(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                                case 5: {
                                    boolean bl9 = false;
                                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl10 = false;
                                        logger.warn(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                                case 6: {
                                    boolean bl11 = false;
                                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                        Logger logger = logger$iv;
                                        boolean bl12 = false;
                                        logger.error(String.valueOf("JS5 group request from channel '" + ctx.channel() + "' received: " + msg));
                                    }
                                    break;
                                }
                            }
                            Js5Service js5Service = this.getService();
                            Js5Client js5Client3 = this.client;
                            if (js5Client3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                                js5Client3 = null;
                            }
                            js5Service.push(js5Client3, (Js5GroupRequest)msg);
                            break block65;
                        }
                        if (!Intrinsics.areEqual((Object)incomingJs5Message, (Object)PriorityChangeLow.INSTANCE)) break block66;
                        Logger logger$iv = logger;
                        boolean bl = false;
                        LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                        boolean bl13 = false;
                        switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                boolean bl14 = false;
                                if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl15 = false;
                                    logger.trace(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                            case 3: {
                                boolean bl16 = false;
                                if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl17 = false;
                                    logger.debug(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                            case 4: {
                                boolean bl18 = false;
                                if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl19 = false;
                                    logger.info(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                            case 5: {
                                boolean bl20 = false;
                                if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl21 = false;
                                    logger.warn(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                            case 6: {
                                boolean bl22 = false;
                                if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                    Logger logger = logger$iv;
                                    boolean bl23 = false;
                                    logger.error(String.valueOf("Priority changed to low in channel " + ctx.channel()));
                                }
                                break;
                            }
                        }
                        if ((js5Client2 = this.client) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            js5Client2 = null;
                        }
                        js5Client2.setLowPriority();
                        Js5Service js5Service = this.getService();
                        Js5Client js5Client4 = this.client;
                        if (js5Client4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            js5Client4 = null;
                        }
                        js5Service.readIfNotFull(js5Client4);
                        Js5Service js5Service2 = this.getService();
                        Js5Client js5Client5 = this.client;
                        if (js5Client5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            js5Client5 = null;
                        }
                        js5Service2.notifyIfNotEmpty(js5Client5);
                        break block65;
                    }
                    if (!Intrinsics.areEqual((Object)incomingJs5Message, (Object)PriorityChangeHigh.INSTANCE)) break block68;
                    Logger logger$iv = logger;
                    boolean bl = false;
                    LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                    boolean bl24 = false;
                    switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            boolean bl25 = false;
                            if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl26 = false;
                                logger.trace(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 3: {
                            boolean bl27 = false;
                            if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl28 = false;
                                logger.debug(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 4: {
                            boolean bl29 = false;
                            if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl30 = false;
                                logger.info(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 5: {
                            boolean bl31 = false;
                            if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl32 = false;
                                logger.warn(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                        case 6: {
                            boolean bl33 = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                                Logger logger = logger$iv;
                                boolean bl34 = false;
                                logger.error(String.valueOf("Priority changed to high in channel " + ctx.channel()));
                            }
                            break;
                        }
                    }
                    if ((js5Client = this.client) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        js5Client = null;
                    }
                    js5Client.setHighPriority();
                    Js5Service js5Service = this.getService();
                    Js5Client js5Client6 = this.client;
                    if (js5Client6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        js5Client6 = null;
                    }
                    js5Service.readIfNotFull(js5Client6);
                    break block65;
                }
                if (!(incomingJs5Message instanceof XorChange)) break block70;
                Logger logger$iv = logger;
                boolean bl = false;
                LogLevel level$iv$iv = RSProtFlags.getJs5Logging();
                boolean bl35 = false;
                switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        boolean bl36 = false;
                        if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl37 = false;
                            logger.trace(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                    case 3: {
                        boolean bl38 = false;
                        if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl39 = false;
                            logger.debug(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                    case 4: {
                        boolean bl40 = false;
                        if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl41 = false;
                            logger.info(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                    case 5: {
                        boolean bl42 = false;
                        if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl43 = false;
                            logger.warn(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                    case 6: {
                        boolean bl44 = false;
                        if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                            Logger logger = logger$iv;
                            boolean bl45 = false;
                            logger.error(String.valueOf("Encryption key received from channel '" + ctx.channel() + "': " + msg));
                        }
                        break;
                    }
                }
                Js5Service this_$iv = this.getService();
                boolean $i$f$use = false;
                Object object = this_$iv.getLock();
                synchronized (object) {
                    boolean bl46 = false;
                    boolean bl47 = false;
                    Js5Client js5Client = this.client;
                    if (js5Client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        js5Client = null;
                    }
                    js5Client.setXorKey(((XorChange)msg).getKey());
                    Js5Service js5Service = this.getService();
                    Js5Client js5Client7 = this.client;
                    if (js5Client7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        js5Client7 = null;
                    }
                    js5Service.readIfNotFull(js5Client7);
                    Unit unit = Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("Unknown JS5 message: " + msg);
        }
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Js5Service js5Service = this.getService();
        Js5Client js5Client = this.client;
        if (js5Client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            js5Client = null;
        }
        js5Service.readIfNotFull(js5Client);
    }

    public void channelWritabilityChanged(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.channel().isWritable()) {
            Js5Service js5Service = this.getService();
            Js5Client js5Client = this.client;
            if (js5Client == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                js5Client = null;
            }
            js5Service.notifyIfNotEmpty(js5Client);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.networkService.getExceptionHandlers$osrs_225_api().getChannelExceptionHandler().exceptionCaught(ctx, cause);
        ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), Js5DisconnectionReason.EXCEPTION);
        Channel channel = ctx.channel();
        if (channel.isOpen()) {
            channel.close();
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!(evt instanceof IdleStateEvent)) break block13;
            Logger logger$iv = logger;
            boolean bl = false;
            LogLevel level$iv$iv = RSProtFlags.getNetworkLogging();
            boolean bl2 = false;
            switch (LoggingExtKt.WhenMappings.$EnumSwitchMapping$0[level$iv$iv.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl3 = false;
                    if (InlineLogger.isTraceEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl4 = false;
                        logger.trace(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 3: {
                    boolean bl5 = false;
                    if (InlineLogger.isDebugEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl6 = false;
                        logger.debug(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 4: {
                    boolean bl7 = false;
                    if (InlineLogger.isInfoEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl8 = false;
                        logger.info(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 5: {
                    boolean bl9 = false;
                    if (InlineLogger.isWarnEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl10 = false;
                        logger.warn(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
                case 6: {
                    boolean bl11 = false;
                    if (InlineLogger.isErrorEnabled-impl((Logger)logger$iv)) {
                        Logger logger = logger$iv;
                        boolean bl12 = false;
                        logger.error(String.valueOf("JS5 channel has gone idle, closing channel " + ctx.channel()));
                    }
                    break;
                }
            }
            ChannelTrafficHandlerExtensionsKt.addDisconnectionReason(this.networkService.getTrafficMonitor().getJs5ChannelTrafficMonitor(), ChannelExtensions.hostAddress((ChannelHandlerContext)ctx), Js5DisconnectionReason.IDLE);
            ctx.close();
        }
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/protocol/api/js5/Js5ChannelHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-225-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

