/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.protocol.api.js5;

import com.github.michaelbull.logging.InlineLogger;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.protocol.api.js5.ConcurrentJs5Authorizer;
import net.rsprot.protocol.api.js5.Js5Authorizer;
import net.rsprot.protocol.loginprot.incoming.RemainingBetaArchives;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\tH\u0082\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0011\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0082\bJ\b\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/rsprot/protocol/api/js5/ConcurrentJs5Authorizer;", "Lnet/rsprot/protocol/api/js5/Js5Authorizer;", "()V", "protectedArchives", "", "", "(Ljava/util/List;)V", "counts", "Ljava/util/concurrent/ConcurrentHashMap;", "", "protectedArchivesBitMask", "", "authorize", "", "address", "buildProtectedArchivesBitMask", "isAuthorized", "", "archive", "isProtected", "toString", "unauthorize", "Companion", "osrs-225-api"})
@SourceDebugExtension(value={"SMAP\nConcurrentJs5Authorizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentJs5Authorizer.kt\nnet/rsprot/protocol/api/js5/ConcurrentJs5Authorizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,110:1\n33#1:122\n93#1,2:123\n1789#2,3:111\n134#3,4:114\n134#3,4:118\n134#3,4:125\n11#4,2:129\n*S KotlinDebug\n*F\n+ 1 ConcurrentJs5Authorizer.kt\nnet/rsprot/protocol/api/js5/ConcurrentJs5Authorizer\n*L\n82#1:122\n82#1:123,2\n26#1:111,3\n56#1:114,4\n71#1:118,4\n84#1:125,4\n107#1:129,2\n*E\n"})
public final class ConcurrentJs5Authorizer
implements Js5Authorizer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, Integer> counts;
    private final long protectedArchivesBitMask;
    private static final int MAXIMUM_CAPACITY = 1000000;
    private static final int DEFAULT_CAPACITY = 2048;
    @NotNull
    private static final Logger logger;

    public ConcurrentJs5Authorizer(@NotNull List<Integer> protectedArchives) {
        Intrinsics.checkNotNullParameter(protectedArchives, (String)"protectedArchives");
        this.counts = new ConcurrentHashMap(2048);
        this.protectedArchivesBitMask = this.buildProtectedArchivesBitMask(protectedArchives);
    }

    public ConcurrentJs5Authorizer() {
        this(RemainingBetaArchives.Companion.getProtectedArchives());
    }

    /*
     * WARNING - void declaration
     */
    private final long buildProtectedArchivesBitMask(List<Integer> protectedArchives) {
        void $this$fold$iv;
        Iterable iterable = protectedArchives;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void value;
            int n = ((Number)element$iv).intValue();
            long acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc | 1L << value;
        }
        return accumulator$iv;
    }

    private final boolean isProtected(int archive) {
        boolean $i$f$isProtected = false;
        return (this.protectedArchivesBitMask & 1L << archive) != 0L;
    }

    @Override
    public void authorize(@NotNull String address) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            try {
                this.counts.compute(address, (arg_0, arg_1) -> ConcurrentJs5Authorizer.authorize$lambda$1((Function2)new Function2<String, Integer, Integer>(this){
                    final /* synthetic */ ConcurrentJs5Authorizer this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @Nullable
                    public final Integer invoke(@NotNull String string, @Nullable Integer old) {
                        Integer n;
                        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                        if (old != null) {
                            n = old + 1;
                        } else if (ConcurrentJs5Authorizer.access$getCounts$p(this.this$0).size() >= 1000000) {
                            Logger arg0$iv = ConcurrentJs5Authorizer.access$getLogger$cp();
                            boolean bl = false;
                            if (InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) {
                                Logger logger = arg0$iv;
                                boolean bl2 = false;
                                logger.error(String.valueOf("Authorized JS5 addresses has reached 1000000 entries - possible memory leak?"));
                            }
                            n = null;
                        } else {
                            n = 1;
                        }
                        return n;
                    }
                }, arg_0, arg_1));
            }
            catch (Exception e) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (!InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) break block2;
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.error(String.valueOf("Unable to authorize " + address), (Throwable)e);
            }
        }
    }

    @Override
    public void unauthorize(@NotNull String address) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            try {
                this.counts.compute(address, (arg_0, arg_1) -> ConcurrentJs5Authorizer.unauthorize$lambda$3(unauthorize.1.INSTANCE, arg_0, arg_1));
            }
            catch (Exception e) {
                Logger arg0$iv = logger;
                boolean bl = false;
                if (!InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) break block2;
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.error(String.valueOf("Unable to unauthorize " + address), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAuthorized(@NotNull String address, int archive) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        try {
            ConcurrentJs5Authorizer this_$iv = this;
            boolean $i$f$isProtected = false;
            if ((this_$iv.protectedArchivesBitMask & 1L << archive) == 0L) return true;
            boolean bl = true;
            if (!bl) return true;
            this_$iv = this;
            boolean $i$f$isAuthorized = false;
            Integer count$iv = this_$iv.counts.get(address);
            if (count$iv == null) return false;
            if (count$iv <= 0) return false;
            return true;
        }
        catch (Exception e) {
            Logger arg0$iv = logger;
            boolean bl = false;
            if (!InlineLogger.isErrorEnabled-impl((Logger)arg0$iv)) return false;
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.error(String.valueOf("Unable to check for authorization: " + archive + " @ " + address), (Throwable)e);
            return false;
        }
    }

    private final boolean isAuthorized(String address) {
        boolean $i$f$isAuthorized = false;
        Integer count = this.counts.get(address);
        return count != null && count > 0;
    }

    @NotNull
    public String toString() {
        return "ConcurrentJs5Authorizer(protectedArchivesBitMask=" + this.protectedArchivesBitMask + ", counts=" + this.counts + ")";
    }

    private static final Integer authorize$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer unauthorize$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCounts$p(ConcurrentJs5Authorizer $this) {
        return $this.counts;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\t"}, d2={"Lnet/rsprot/protocol/api/js5/ConcurrentJs5Authorizer$Companion;", "", "()V", "DEFAULT_CAPACITY", "", "MAXIMUM_CAPACITY", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "osrs-225-api"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

